// CompletionWindow.h
// (c) 2003-2005 exeal

#ifndef _COMPLETION_WINDOW_H_
#define _COMPLETION_WINDOW_H_
#include "AscensionCommon.h"
#include "EditPoint.h"
#include "../../Manah/Listbox.h"
#include <set>


namespace Ascension {
	class CEditView;
	class CSynchronizablePoint;

	/// ͕⊮EBhE
	class CCompletionWindow : public Manah::Windows::Controls::CListBox {
		// RXgN^
	public:
		CCompletionWindow(CEditView& view);
		virtual ~CCompletionWindow();

		// \bh
	public:
		void		Abort();
		void		Complete();
		bool		Create();
		CTextRange	GetContextRange() const throw(std::logic_error);
		bool		IsRunning() const;
		void		SetFont(const HFONT hFont);
		void		Start(const std::set<string_t>& candidateWords);
		bool		UpdateListCursel() throw(std::logic_error);

		// bZ[Wnh
	protected:
		virtual LRESULT	DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam);

	private:
		void	_UpdateDefaultFont();

		// f[^o
	protected:
		CEditView&	m_view;
	private:
		HFONT			m_hDefaultFont;
		bool			m_bRunning;
		CCharPos		m_contextStart;	// ⊮JnʒȗO̒P擪
		CVisualPoint&	m_contextEnd;	// ⊮Jnʒǔ̒PI[
	};


	/// ⊮͈͂Ԃ (Lbg͈̔͂Oƕ⊮͒~)
	inline CTextRange CCompletionWindow::GetContextRange() const throw(std::logic_error) {
		AssertValid();
		if(!IsRunning())
			throw std::logic_error("Completion is not running.");
		return CTextRange(m_contextStart, m_contextEnd);
	}

	/// ⊮ł邩Ԃ
	inline bool CCompletionWindow::IsRunning() const {
		AssertValid();
		return m_bRunning;
	}

} // namespace Ascension

#endif /* _COMPLETION_WINDOW_H_ */

/* [EOF] */