// EditDoc.h
// (c) 2003-2005 exeal

#ifndef _EDIT_DOC_H_
#define _EDIT_DOC_H_

#include <stack>
#include <list>
#include <map>
#include <set>
#include "EditPoint.h"
#include "Encodings\Encoder.h"
#include "../../Manah/SmallObject.h"
#include "../../Manah/DocumentView.h"
#include "../../Manah/File.h"


namespace Ascension {

class CEditDoc;

namespace Private {
	class CInsertOperation;
	class CDeleteOperation;

	/**
	 *	炩̕ҏW
	 *	@see	CDeleteOperation, CInsertOperation
	 */
	interface IOperation {
		/// fXgN^
		virtual ~IOperation() {}
		/// 삪s\Ԃ
		virtual bool CanExecute(CEditDoc& document) const = 0;
		///  <var>postOperation</var> Ɍł邩Ԃ (㑱̑͑})
		virtual bool IsConcatenatable(CInsertOperation& postOperation, const CEditDoc& document) const = 0;
		///  <var>postOperation</var> Ɍł邩Ԃ (㑱͍̑폜)
		virtual bool IsConcatenatable(CDeleteOperation& postOperation, const CEditDoc& document) const = 0;
		/// s
		virtual CCharPos Execute(CEditDoc& document) = 0;
	};

	/// 1̑}
	class CInsertOperation : virtual public IOperation,
			public Manah::CSelfAssertable, public Manah::CUseMemoryPool<CInsertOperation> {
		// RXgN^
	public:
		CInsertOperation(const CCharPos& pos, const string_t& strText);

		// \bh
	public:
		bool		CanExecute(CEditDoc& document) const;
		bool		IsConcatenatable(CInsertOperation& postOperation, const CEditDoc& document) const;
		bool		IsConcatenatable(CDeleteOperation& postOperation, const CEditDoc& document) const;
		CCharPos	Execute(CEditDoc& document);

		// f[^o
	private:
		CCharPos	m_position;	// }ʒu
		string_t	m_strText;	// }
		friend class CDeleteOperation;
	};

	/// 1̍폜
	class CDeleteOperation : virtual public IOperation,
			public Manah::CSelfAssertable, public Manah::CUseMemoryPool<CDeleteOperation> {
		// RXgN^
	public:
		CDeleteOperation(const CTextRange& range);

		// \bh
	public:
		bool		CanExecute(CEditDoc& document) const;
		bool		IsConcatenatable(CInsertOperation& postOperation, const CEditDoc& document) const;
		bool		IsConcatenatable(CDeleteOperation& postOperation, const CEditDoc& document) const;
		CCharPos	Execute(CEditDoc& document);

		// f[^o
	private:
		CTextRange	m_range;	// 폜͈
		friend class CInsertOperation;
	};

	/// ܂Ƃ߂ăAhD/hD\ȈȂ
	class COperationUnit : public Manah::CSelfAssertable, public Manah::CUseMemoryPool<COperationUnit> {
		// RXgN^
	public:
		virtual ~COperationUnit();

		// \bh
	public:
		bool		Execute(CEditDoc& document, CCharPos& posResult);
		IOperation&	Pop();
		void		Push(CInsertOperation& operation, const CEditDoc& document);
		void		Push(CDeleteOperation& operation, const CEditDoc& document);
		IOperation&	Top() const;

		// f[^o
	private:
		std::stack<IOperation*>	m_operations;	// ̒PʂɊ܂܂Ȃ
	};
} // namespace Private


// CEditDoc class definition
/////////////////////////////////////////////////////////////////////////////

/// sR[h
enum LineBreak {
	LB_AUTO,	///< ϊAw薳Ȃ
	LB_LF,		///< sBUnix W (Lf, U+000A)
	LB_CR,		///< BMacintosh W (Cr, U+000D)
	LB_CRLF,	///< +sBWindows W (CrLf, U+000D U+000A)
	LB_NEL,		///< Vs (U+0085)
	LB_LS,		///< s؂ (U+2028)
	LB_PS		///< i؂ (U+2029)
};

/// CEditDoc ̍XV
struct TDocumentUpdate {
	enum Summary {
		INSERT_OPERATION,		///< }
		DELETE_OPERATION,		///< 폜
		BEGIN_UNDO_OPERATION,	///< AhD/hD̊Jn
		END_UNDO_OPERATION,		///< AhD/hD̏I (ۂɃAhDsȂꍇ posResult  CCharPos(-1, -1))
		BEGIN_EDIT_COLLECTION,	///< CEditDoc::BeginEditCollection Ăяoꂽ (summary ȊÕo͖)
		END_EDIT_COLLECTION,	///< CEditDoc::EndEditCollection Ăяoꂽ (summary ȊÕo͖)
		SAVED,					///< hLgۑ (summary ȊÕo͖)
		CLOSED,					///< hLgꂽ (summary ȊÕo͖)
		CHANGED_NARROWING		///< i[CȌԂω (summary ȊÕo͖)
	} summary;	///< Tv
	CCharPos	posBegin;	///< ΏۊJnʒu
	CCharPos	posEnd;		///< ΏۏIʒu (posBegin &lt;= posEnd)
	CCharPos	posResult;	///< I̐Lbgʒu

	/// RXgN^
	/// @param updateSummary	XV̊Tv
	TDocumentUpdate(Summary updateSummary) : summary(updateSummary) {}
};

/// hLgǂݎp̂ƂҏW悤ƂƃX[
class EDocumentIsReadOnly : public std::logic_error {
public:
	EDocumentIsReadOnly()
			: std::logic_error("Document is readonly. Any edit process is denied.") {
	}
};

/// CEditDoc::LoadDocument ACEditDoc::SaveDocument ŎgR[obN
interface IFileIoCallback : virtual public Encodings::IUnconvertableCharCallback {
	/// fXgN^
	virtual ~IFileIoCallback() {}
};

/// hLg̒ʒm󂯎Cxgnh
interface IEditDocEventListener {
	/// fXgN^
	virtual ~IEditDocEventListener() {}
	/// hLg̓ǂݍ݂
	virtual void OnDocumentLoaded() = 0;
	/// hLgύXꂽ
	virtual void OnDocumentModified() = 0;
	/**
	 *	t@COvZXŕύXꂽ
	 *	@param pDocument	hLg
	 */
	virtual void OnDocumentOverwrittenByOtherProcess(CEditDoc& document) = 0;
};

/// IEditDocEventListener ̋
class CEditDocEventAdapter : virtual public IEditDocEventListener {
public:
	virtual ~CEditDocEventAdapter() {}
	virtual void	OnDocumentLoaded() {}
	virtual void	OnDocumentModified() {}
	virtual void	OnDocumentOverwrittenByOtherProcess(CEditDoc& document) {}
};


/**
 *	@brief	Ascension eLXgGfB^̃hLg
 *
 *	SĂ̍s̓eA엚AR[hy[WAsR[hȂǂB
 *	t@Cs
 *
 *	<h3>AhDO[v̊TO</h3>
 *
 *	Ascension GfB^ɂ́Ȃ܂Ƃ߂ăAhD/hDł悤
 *	AhDO[vƂTOB^CsOɂA͂̈ꊇ
 *	쑤̎dłBCEditView ACEditPoint ͂Ƃɂ̑Ă邽߁A
 *	̃NXgăhLgҏWꍇA[U̓^CsOɂꊇ
 *	̂߂̃R[hKv͖
 *
 *	̑AhDO[vƂɂ͈Ȃ̑O
 *	CEditDoc::BeginEditCollection 1xĂяoBđ삪I
 *	CEditDoc::EndEditCollection Ăяo
 *
 *	@see	CEditView, CEditPoint
 */
class CEditDoc : public Manah::Windows::CDocument<TDocumentUpdate> {
	// ^
public:
	/// LoadDocument ASaveDocument ŕԂl
	enum FileIoResult {
		FIR_OK							= 0x00,	///< t@C͐Ƀ[h/Z[uꂽ
		FIR_ACCESS_DENIED				= 0x01,	///< t@C̓ǂݎ/݂ۂꂽ
		FIR_LOCK_DENIED					= 0x02,	///< t@C̃bNۂꂽ
		FIR_INVALID_CODEPAGE			= 0x03,	///< w肳ꂽR[hy[WȂ
		FIR_ABORTED_FOR_UNCONVERTABLE	= 0x04,	///< ϊłȂ߁AĂяo𒆎~
		FIR_UNKNOWN_ERROR				= 0x05,	///< s̃G[
		FIR_READ_READONLY				= 0x11,	///< t@CǂݎpĂ߂ɁAǂݎp[hŊJ
		FIR_READ_USED_BY_OTHER_PROCESS	= 0x12,	///< ̃vZXt@CgĂ̂ŁAǂݎp[hŊJ
		FIR_READ_HUGE_FILE				= 0x13,	///< ǂݍރt@C傫
		FIR_READ_NOT_EXIST				= 0x14,	///< w肳ꂽt@C݂Ȃ
		FIR_WRITE_FULL_DISK				= 0x21,	///< L}̂ɏނ߂̗̈悪
		FIR_WRITE_READONLY				= 0x22,	///< ǂݎp[hA܂͓ǂݎp̃t@CɏƂ
		FIR_WRITE_INVALID_LINEBREAK		= 0x23,	///< R[hy[W Unicode x[XłȂꍇ Unicode ̉sR[hŕۑ悤Ƃ
	};

	/// CopyCurrentFile ADeleteCurrentFile AMoveCurrentFile ŕԂl
	enum FileOperationResult {
		FOR_OK,						///< t@C͐ɏI
		FOR_ABORTED,				///< [U𒆒f (ݔֈړ ̂ݗL)
		FOR_FILE_IS_READONLY,		///< ǂݎp[hŊJĂ̂ŏłȂ
		FOR_ALREADY_EXISTS,			///< Rs[Aړɓ̃t@C݂
		FOR_REOPENED_AS_READONLY,	///< t@CJƂɓǂݎpŊJ
		FOR_CANNOT_REOPEN,			///< t@CĴɎs
		FOR_HAS_NO_INSTANCE,		///< \bhsɃt@CJĂȂ
		FOR_UNKNOWN_ERROR,			///< m̃G[ (G[bZ[W GetLastError 擾\)
	};

	/// t@C̃I[v[h
	enum FileOpenMode {
		FOM_DENY_NONE,	///< bNȂ
		FOM_DENY_WRITE,	///< ̏ݖړĨt@CI[v
		FOM_DENY_READ,	///< ̓ǂݍݖړĨt@CI[v
		FOM_AS_READONLY	///< ǂݎpƂĊJ (bN͖)
	};

	/// CEditDoc::SaveDocument ŎgۑIvV
	typedef uchar	SaveDocumentOption;
	static const SaveDocumentOption
		SDO_WRITE_BOM			= 0x01,	///< UTF-8A16A32 ŕۑƂ BOM 
		SDO_CREATE_BACKUP		= 0x02;	///< ۑÕt@C̃obNAbvݔɍ쐬

	/// s̓e
	class CLine : public Manah::CUseMemoryPool<CLine> {
	private:
		/// RXgN^
		explicit CLine(string_t& strLine = string_t(L""), LineBreak lineBreak = LB_AUTO, bool bModified = false)
				: m_strLine(strLine), m_lineBreak(lineBreak), m_cOperationHistory(bModified ? 1 : 0) {}
	public:
		/// s̃eLXgԂ
		const string_t& GetLine() const {return m_strLine;}
		/// sI[Ԃ
		LineBreak GetLineBreak() const {return m_lineBreak;}
		/// ̍sύXĂ邩
		bool IsModified() const {return m_cOperationHistory != 0;}
	private:
		string_t	m_strLine;				// s
		LineBreak	m_lineBreak;			// s̎
		ulong		m_cOperationHistory;	// AhDJE^ (0ŕύX̏)
		friend class CEditDoc;
	};
	typedef std::list<CLine>			LineList;		///< s̃Xg
	typedef LineList::const_iterator	LineIterator;	///< s̔q
	typedef void(CEditDoc::*EditPointReleaser)(const CEditPoint& point);
private:
	typedef LineList::iterator	_LineIterator;

	// RXgN^
public:
	CEditDoc();
	virtual ~CEditDoc();

	// \bh
public:
	// CxgXi
	void	AddEventListener(IEditDocEventListener& eventListener);
	void	RemoveEventListener(IEditDocEventListener& eventListener);

	// r[ (񉼑z֐̃I[o[Ch)
	CEditView&	GetActiveView() const throw(std::logic_error);
	CEditView&	GetView(std::size_t iView) const throw(std::out_of_range);

	// R[hAsR[h
	Encodings::CodePage	GetCodePage() const;
	LineBreak			GetLineBreak() const;
	static string_t		GetLineBreakString(LineBreak lineBreak);
	void				SetCodePage(Encodings::CodePage cp) throw(std::invalid_argument);
	static void			SetDefaultCode(Encodings::CodePage cp, LineBreak lineBreak) throw(std::invalid_argument);
	void				SetLineBreak(LineBreak lineBreak) throw(std::invalid_argument);

	// 
	FileOpenMode	GetShareMode() const;
	ulong			GetUndoHistoryLength(bool bRedo = false) const;
	bool			IsReadOnly() const;
	void			SetReadOnly(bool bReadOnly = true);

	// hLgANZX
	void			ClearUndoBuffer();
	void			GetAllLines(std::basic_ostream<char_t>& os) const;
	length_t		GetDocumentLength() const;
	CCharPos		GetEndPoint() const;
	const string_t&	GetLine(length_t iLine) const throw(std::out_of_range);
	length_t		GetLineCount() const;
	length_t		GetLineIndex(length_t iLine,
						bool bIncludeBreak) const throw(std::out_of_range);
	const CLine&	GetLineInfo(length_t iLine) const throw(std::out_of_range);
	LineIterator	GetLineIterator(length_t iLine) const throw(std::out_of_range);
	length_t		GetLineLength(length_t iLine) const throw(std::out_of_range);
	CCharPos		GetStartPoint() const;
	void			Initiate();

	// ҏW
	void		BeginEditCollection();
	CCharPos	DeleteText(const CTextRange& range) throw(EDocumentIsReadOnly);
	CCharPos	DeleteText(const CCharPos& pos1, const CCharPos& pos2) throw(EDocumentIsReadOnly);
	void		EndEditCollection();
	CCharPos	InsertText(const CCharPos& pos, const string_t& text) throw(EDocumentIsReadOnly);
	CCharPos	InsertText(const CCharPos& pos, const char_t* first, const char_t* last) throw(EDocumentIsReadOnly, std::invalid_argument);
	bool		IsCollectingEdit() const;
	bool		IsRecordingOperation() const;
	void		RecordOperations(bool bRecord);
	bool		Redo() throw(EDocumentIsReadOnly);
	bool		Undo() throw(EDocumentIsReadOnly);

	// i[CO
	bool	IsNarrowed() const;
	void	Narrow(const CTextRange& range);
	void	Widen();

	// ҏW_
	CVisualPoint*			CopyEditPoint(const CVisualPoint& point);
	CSynchronizablePoint*	CopySynchronizablePoint(const CSynchronizablePoint& point);
	CVisualPoint*			CreateEditPoint(CEditPoint::IEventListener* pEventListener = 0);
	CSynchronizablePoint*	CreateSynchronizablePoint();

	// t@C <-> hLg
	void			Close(bool bReinitialize = false);
	FileIoResult	Load(const std::wstring& strPathName,
						FileOpenMode fileOpenMode, Encodings::CodePage codePage, IFileIoCallback* pCallback);
	FileIoResult	Save(const std::wstring& strPathName, SaveDocumentOption options,
						LineBreak lineBreak, Encodings::CodePage codePage, IFileIoCallback* pCallback);

	// ɊJĂt@Cɑ΂鏈
	FileOperationResult	Copy(const wchar_t* pwszDestination);
	FileOperationResult	Delete() throw(EDocumentIsReadOnly);
	bool				Lock(FileOpenMode fileOpenMode);
	FileOperationResult	Move(const wchar_t* pwszDestination);
	bool				Send(bool bAsAttachment, bool bShowDialog = true);

	// [eBeB
protected:
	static LineBreak	EatLineBreak(const char_t* pwsz, length_t cch);
private:
	void						_CheckTimeStamp();
	_LineIterator				_GetLineIterator(length_t iLine) const throw(std::out_of_range);
	static void					_ReleaseEditPoint(CEditDoc& document, CSynchronizablePoint& point);
	static void CALLBACK		_TimerProc(HWND hWnd, UINT nMsg, timerid_t idEvent, DWORD dwTime);
	static Encodings::CodePage	_TranslateSpecialCodePage(Encodings::CodePage cp);

	// f[^o
public:
	static const char_t	m_wszBreakChars[6];		// s̏W
private:
	/// AhDAhDǗ
	class _CUndoManager {
		// RXgN^
	public:
		_CUndoManager(CEditDoc& document);
		virtual ~_CUndoManager();

		// \bh
	public:
		void		Clear();
		std::size_t	GetRedoBufferLength() const;
		std::size_t	GetUndoBufferLength() const;
		bool		IsModifiedSinceLastSave() const;
		void		OnSave();
		template<class Operation>
		void		PushUndoBuffer(Operation& operation, bool bConcatPrev);
		bool		Redo(CCharPos& posResult);
		bool		Undo(CCharPos& posResult);

		// f[^o
	private:
		CEditDoc&								m_document;			// ΏۃhLg
		std::stack<Private::COperationUnit*>	m_undoStack;		// AhDX^bN
		std::stack<Private::COperationUnit*>	m_redoStack;		// hDX^bN
		bool									m_bVirtual;			// ẑƂ^
		Private::COperationUnit*				m_pVirtualUnit;		// zǉ鑀P
		Private::COperationUnit*				m_pLastUnit;		// ŌɒǉꂽP
		Private::IOperation*					m_pSavedOperation;	// ۑɖɂȂĂ
	};

	/// AhDO[v̏
	enum _UndoGroupingState {
		UGS_NONE,					///< O[sO͍sĂȂ
		UGS_WAIT_FOR_FIRST_EDIT,	///< O[sOJnҏW1xsĂȂ
		UGS_WAIT_FOR_CONTINUE_EDIT	///< O[sOJn1xȏҏWsꂽ
	};

	// f[^o
	bool							m_bIgnoreViews;	// OnUpdate ĂяoKvƂ true (t@CǂݍݓrȂ)
	bool							m_bReadOnly;	// ǂݎp[h (ǂݍݎɐݒ肳s)
	FileOpenMode					m_fileOpenMode;	// t@C̋L[h (FOM_ASREADONLY ͖Ӗ)
	Encodings::CodePage				m_codePage;		// R[hy[W
	LineBreak						m_lineBreak;	// sR[h (L[{[h͂ɂsɎgp)
	LineList						m_lines;		// s
	std::set<CSynchronizablePoint*>	m_points;		// 쐬ҏW_
	Manah::Windows::IO::CFile<true>	m_file;			// ݊JĂt@C
	_CUndoManager*					m_pUndoManager;	// AhD/hD̊Ǘ
	_UndoGroupingState				m_groupingState;			// AhDO[v̎W
	bool							m_bOnceUndoBufferCleared;	// 1xȏAhDobt@NA
	bool							m_bRecordingOperations;		// AhD/hD̂߂ɑL^Ă邩

	bool							m_bVirtualOperating;	// AhD/hDɂ DeleteText AInsertText
															// \bhĂяôƂ true B
															// true ̊Ԃ͗\bhŃhDX^bNNAȂ

	std::pair<CCharPos, CSynchronizablePoint*>*	m_pAccessibleArea;	// ANZX\̈ (i[COĂȂƂ null)

	std::set<IEditDocEventListener*>	m_eventListeners;	// CxgXi
	FILETIME							m_lastWriteTime;	// t@C̍ŏIXV
	timerid_t								m_nTimerId;		// ^C} ID
	static std::map<timerid_t, CEditDoc*>	m_documents;	// ^C} ID -> hLg̃}bv

	static Encodings::CodePage	m_defaultCodePage;	// ̃R[hy[W
	static LineBreak			m_defaultLineBreak;	// ̉sR[h

	mutable length_t		m_iLineCache_;	// _GetLineIterator LbVpf[^
	mutable _LineIterator	m_itCache_;
	mutable length_t		m_iLineCache;	// GetLineIterator LbVpf[^
	mutable LineIterator	m_itCache;
};


/**
 *	CxgXi̒ǉ
 *	@param eventListener	VCxgXi
 */
inline void CEditDoc::AddEventListener(IEditDocEventListener& eventListener) {
	AssertValid();
	m_eventListeners.insert(&eventListener);
}

/// AhDO[v̎WJnB
/// ݎWł΁AxIAVWJn
inline void CEditDoc::BeginEditCollection() {
	AssertValid();
	if(m_groupingState != UGS_NONE)
		EndEditCollection();
	m_groupingState = UGS_WAIT_FOR_FIRST_EDIT;
	UpdateAllViews(TDocumentUpdate(TDocumentUpdate::BEGIN_EDIT_COLLECTION));
}

/// AhD/hDX^bNɂė
inline void CEditDoc::ClearUndoBuffer() {
	AssertValid();
	m_pUndoManager->Clear();
	m_bOnceUndoBufferCleared = true;
}

/// @see	CEditDoc::DeleteText
inline CCharPos CEditDoc::DeleteText(const CCharPos& pos1, const CCharPos& pos2) {
	AssertValid();
	return DeleteText(CTextRange(pos1, pos2));
}

/// @see	s𔻒肷
inline LineBreak CEditDoc::EatLineBreak(const char_t* pwsz, length_t cch) {
	assert(pwsz != 0 && cch > 0);
	switch(*pwsz) {
	case L'\n':		return LB_LF;
	case L'\r':		return (cch > 1 && pwsz[1] == L'\n') ? LB_CRLF : LB_CR;
	case 0x0085:	return LB_NEL;
	case L'\x2028':	return LB_LS;
	case L'\x2029':	return LB_PS;
	default:		return LB_AUTO;
	}
}

/// AhDO[v̎WI
inline void CEditDoc::EndEditCollection() {
	AssertValid();
	if(m_groupingState != UGS_NONE) {
		m_groupingState = UGS_NONE;
		UpdateAllViews(TDocumentUpdate(TDocumentUpdate::END_EDIT_COLLECTION));
	}
}

/// @see	CDocument::GetActiveView
inline CEditView& CEditDoc::GetActiveView() const throw(std::logic_error) {
	return reinterpret_cast<CEditView&>(Manah::Windows::CDocument<TDocumentUpdate>::GetActiveView());
}

/// ݎgpĂR[hy[W擾
inline Encodings::CodePage CEditDoc::GetCodePage() const {
	AssertValid();
	return m_codePage;
}

/// ANZX\̈̏I[Ԃ
inline CCharPos CEditDoc::GetEndPoint() const {
	AssertValid();
	return (m_pAccessibleArea != 0) ? *m_pAccessibleArea->second
		: CCharPos(m_lines.size() - 1, GetLineLength(m_lines.size() - 1));
}

/**
 *	w肵s̃eLXg擾B
 *	s݂Ȃ <code>out_of_range</code> 𓊂
 */
inline const string_t& CEditDoc::GetLine(length_t iLine) const throw(std::out_of_range) {
	AssertValid();
	try {
		return GetLineInfo(iLine).m_strLine;
	} catch(std::out_of_range& e) {
		throw e;
	}
}

/// sR[h̉sԂ
inline string_t CEditDoc::GetLineBreakString(LineBreak lineBreak) {
	switch(lineBreak) {
	case LB_AUTO:	return L"";
	case LB_LF:		return L"\n";
	case LB_CR:		return L"\r";
	case LB_CRLF:	return L"\r\n";
	case LB_NEL:	return std::wstring(1, 0x0085);	// VC6
	case LB_LS:		return L"\x2028";
	case LB_PS:		return L"\x2029";
	default:		assert(false);
	}
	return L"";	// ɂ͗Ȃ
}

/// ݎgpĂsR[h擾
inline LineBreak CEditDoc::GetLineBreak() const {
	AssertValid();
	return m_lineBreak;
}

/// s擾
inline length_t CEditDoc::GetLineCount() const {
	AssertValid();
	return m_lines.size();
}

/// sꊇĎ擾
inline const CEditDoc::CLine& CEditDoc::GetLineInfo(length_t iLine) const throw(std::out_of_range) {
	AssertValid();
	try {
		return *GetLineIterator(iLine);
	} catch(std::out_of_range& e) {
		throw e;
	}
}

/// w肵s̒擾Bs݂Ȃ <code>out_of_range</code> 𓊂
inline length_t CEditDoc::GetLineLength(length_t iLine) const throw(std::out_of_range) {
	AssertValid();
	try {
		return GetLine(iLine).length();
	} catch(std::out_of_range& e) {
		throw e;
	}
}

/// t@C̔r[h擾
inline CEditDoc::FileOpenMode CEditDoc::GetShareMode() const {
	AssertValid();
	return m_fileOpenMode;
}

/// ANZX\̈̐擪Ԃ
inline CCharPos CEditDoc::GetStartPoint() const {
	AssertValid();
	return (m_pAccessibleArea != 0) ? m_pAccessibleArea->first : CCharPos(0, 0);
}

/// AhDAhD\ȉ񐔂擾
inline ulong CEditDoc::GetUndoHistoryLength(bool bRedo /* = false */) const {
	AssertValid();
	return bRedo ? m_pUndoManager->GetRedoBufferLength() : m_pUndoManager->GetUndoBufferLength();
}

/// @see	CDocument::GetView
inline CEditView& CEditDoc::GetView(std::size_t iView) const throw(std::out_of_range) {
	return reinterpret_cast<CEditView&>(Manah::Windows::CDocument<TDocumentUpdate>::GetView(iView));
}

/// AhDO[v̎WԂ
/// @see	CEditDoc::BeginEditCollection, CEditDoc::EndEditCollection
inline bool CEditDoc::IsCollectingEdit() const {
	AssertValid();
	return m_groupingState != UGS_NONE;
}

/// i[COĂ邩Ԃ
/// @see	CEditDoc::Narrow, CEditDoc::Widen
inline bool CEditDoc::IsNarrowed() const {
	AssertValid();
	return m_pAccessibleArea != 0;
}

/// ǂݎp[hǂԂ
/// @see	EDocumentIsReadOnly, CEditDoc::SetReadOnly
inline bool CEditDoc::IsReadOnly() const {
	AssertValid();
	return m_bReadOnly;
}

/// AhDAhD̂߂ɕҏWL^Ă邩Ԃ
/// @see	CEditDoc::RecordOperations, CEditDoc::GetUndoHistoryLength
inline bool CEditDoc::IsRecordingOperation() const {
	AssertValid();
	return m_bRecordingOperations;
}

/**
 *	CxgXi̍폜
 *	@param eventListener	폜CxgXi
 */
inline void CEditDoc::RemoveEventListener(IEditDocEventListener& eventListener) {
	AssertValid();
	m_eventListeners.erase(&eventListener);
}

/**
 *	R[hy[W̐ݒ
 *	@param cp				Vݒ肷R[hy[Wԍ
 *	@throw invalid_argument	R[hy[WpłȂƂX[
 */
inline void CEditDoc::SetCodePage(Encodings::CodePage cp) throw(std::invalid_argument) {
	AssertValid();
	cp = _TranslateSpecialCodePage(cp);
	if(!Encodings::CEncoderFactory::GetInstance().IsValidCodePage(cp)
			|| Encodings::CEncoderFactory::GetInstance().IsCodePageForAutoDetection(cp))
		throw std::invalid_argument("Specified code page is not available.");
	m_codePage = cp;
}

/**
 *	sR[h̐ݒ
 *	@param lineBreak				Vݒ肷sR[h
 *	@throw std::invalid_argument	sR[hȂƂX[
 */
inline void CEditDoc::SetLineBreak(LineBreak lineBreak) throw(std::invalid_argument) {
	AssertValid();
	switch(lineBreak) {
	case LB_LF:		case LB_CR:
	case LB_CRLF:	case LB_NEL:
	case LB_LS:		case LB_PS:
		m_lineBreak = lineBreak;
		break;
	default:
		throw std::invalid_argument("Specified line break type is invalid.");
	}
}

/// ǂݎp[h̐ݒ
/// @see	EDocumentIsReadOnly, CEditDoc::IsReadOnly
inline void CEditDoc::SetReadOnly(bool bReadOnly /* = true */) {
	AssertValid();
	m_bReadOnly = bReadOnly;
	for(std::set<IEditDocEventListener*>::iterator it
			= m_eventListeners.begin(); it != m_eventListeners.end(); ++it)
		(*it)->OnDocumentModified();
}

///  Win32 R[hy[WR[hy[Wɕϊ
inline Encodings::CodePage CEditDoc::_TranslateSpecialCodePage(Encodings::CodePage cp) {
	if(cp == CP_ACP)
		return ::GetACP();
	else if(cp == CP_OEMCP)
		return ::GetOEMCP();
	else if(cp == CP_MACCP) {
		wchar_t	wsz[7];
		::GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_IDEFAULTMACCODEPAGE, wsz, 6);
		return (wcscmp(wsz, L"2") != 0) ? wcstoul(wsz, 0, 10) : 0;
	} else if(cp == CP_THREAD_ACP) {
		wchar_t	wsz[7];
		::GetLocaleInfoW(::GetThreadLocale(), LOCALE_IDEFAULTANSICODEPAGE, wsz, 6);
		return (wcscmp(wsz, L"3") != 0) ? wcstoul(wsz, 0, 10) : 0;
	}
	return cp;
}

} // namespace Ascension


#endif /* _EDIT_DOC_H_ */

/* [EOF] */