// Iso8859.cpp
// (c) 2004-2005 exeal

#include "StdAfx.h"
#include "Encoder.h"

using namespace Ascension::Encodings;
using namespace std;


BEGIN_ENCODER_DEFINITION()
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_1, Iso8859_1, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_2, Iso8859_2, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_3, Iso8859_3, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_4, Iso8859_4, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_5, Iso8859_5, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_6, Iso8859_6, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_7, Iso8859_7, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_8, Iso8859_8, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_9, Iso8859_9, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_10, Iso8859_10, 1, 1)
//	DEFINE_ENCODER_CLASS(CPEX_ISO8859_11, Iso8859_11, 1, 1)	// Thai.cpp Ŏ
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_13, Iso8859_13, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_14, Iso8859_14, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_15, Iso8859_15, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_16, Iso8859_16, 1, 1)
END_ENCODER_DEFINITION()


#define IMPLEMENT_ISO8859_TO_UNICODE(tableName)			\
	CTU_CHECKARGS();									\
	const size_t	cch = min(cchSrc, cchDest);			\
	for(size_t i = 0; i < cch; ++i) {					\
		if(pszSrc[i] < 0xA0)							\
			pwszDest[i] = pszSrc[i];					\
		else if(pszSrc[i] - 0xA0 < _countof(tableName)	\
				&& tableName[pszSrc[i] - 0xA0] != __NA)	\
			pwszDest[i] = tableName[pszSrc[i] - 0xA0];	\
		else											\
			pwszDest[i] = __REPLACEMENT_CHARACTER;		\
		if(pwszDest[i] == __REPLACEMENT_CHARACTER)		\
			CONFIRM_ILLEGAL_CHAR(pwszDest[i]);			\
	}													\
	return cch

#define IMPLEMENT_UNICODE_TO_ISO8859_BEGIN()	\
	CFU_CHECKARGS();							\
	const size_t	cch = min(cchSrc, cchDest);	\
	for(size_t i = 0; i < cch; ++i) {			\
		if(pwszSrc[i] < 0x00A0)					\
			pszDest[i] = static_cast<char>(pwszSrc[i])

#define ENTRY_UNICODE_TO_ISO8859_MAP(baseTableName, offset)												\
		else if(pwszSrc[i] >= 0x##offset && pwszSrc[i] < 0x##offset + _countof(baseTableName##offset))	\
			pszDest[i] = baseTableName##offset[pwszSrc[i] - 0x##offset]

#define IMPLEMENT_UNICODE_TO_ISO8859_END()		\
		else									\
			pszDest[i] = __NA;					\
		if(pszDest[i] == __NA)					\
			CONFIRM_ILLEGAL_CHAR(pszDest[i]);	\
	}											\
	return cch


namespace {
	const wchar_t	ISO88592toUCS_A0[] = {
	/* 0xA0 */	0x00A0, 0x0104, 0x02D8, 0x0141, 0x00A4, 0x013D, 0x015A, 0x00A7,
				0x00A8, 0x0160, 0x015E, 0x0164, 0x0179, 0x00AD, 0x017D, 0x017B,
	/* 0xB0 */	0x00B0, 0x0105, 0x02DB, 0x0142, 0x00B4, 0x013E, 0x015B, 0x02C7,
				0x00B8, 0x0161, 0x015F, 0x0165, 0x017A, 0x02DD, 0x017E, 0x017C,
	/* 0xC0 */	0x0154, 0x00C1, 0x00C2, 0x0102, 0x00C4, 0x0139, 0x0106, 0x00C7,
				0x010C, 0x00C9, 0x0118, 0x00CB, 0x011A, 0x00CD, 0x00CE, 0x010E,
	/* 0xD0 */	0x0110, 0x0143, 0x0147, 0x00D3, 0x00D4, 0x0150, 0x00D6, 0x00D7,
				0x0158, 0x016E, 0x00DA, 0x0170, 0x00DC, 0x00DD, 0x0162, 0x00DF,
	/* 0xE0 */	0x0155, 0x00E1, 0x00E2, 0x0103, 0x00E4, 0x013A, 0x0107, 0x00E7,
				0x010D, 0x00E9, 0x0119, 0x00EB, 0x011B, 0x00ED, 0x00EE, 0x010F,
	/* 0xF0 */	0x0111, 0x0144, 0x0148, 0x00F3, 0x00F4, 0x0151, 0x00F6, 0x00F7,
				0x0159, 0x016F, 0x00FA, 0x0171, 0x00FC, 0x00FD, 0x0163, 0x02D9
	};
	const uchar		UCStoISO88592_00A0[] = {
		0xA0, __NA, __NA, __NA, 0xA4, __NA, __NA, 0xA7, 0xA8, __NA, __NA, __NA, __NA, 0xAD, __NA, __NA,
		0xB0, __NA, __NA, __NA, 0xB4, __NA, __NA, __NA, 0xB8, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		__NA, 0xC1, 0xC2, __NA, 0xC4, __NA, __NA, 0xC7, __NA, 0xC9, __NA, 0xCB, __NA, 0xCD, 0xCE, __NA,
		__NA, __NA, __NA, 0xD3, 0xD4, __NA, 0xD6, 0xD7, __NA, __NA, 0xDA, __NA, 0xDC, 0xDD, __NA, 0xDF,
		__NA, 0xE1, 0xE2, __NA, 0xE4, __NA, __NA, 0xE7, __NA, 0xE9, __NA, 0xEB, __NA, 0xED, 0xEE, __NA,
		__NA, __NA, __NA, 0xF3, 0xF4, __NA, 0xF6, 0xF7, __NA, __NA, 0xFA, __NA, 0xFC, 0xFD, __NA, __NA,
		__NA, __NA, 0xC3, 0xE3, 0xA1, 0xB1, 0xC6, 0xE6, __NA, __NA, __NA, __NA, 0xC8, 0xE8, 0xCF, 0xEF,
		0xD0, 0xF0, __NA, __NA, __NA, __NA, __NA, __NA, 0xCA, 0xEA, 0xCC, 0xEC, __NA, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xC5, 0xE5, __NA, __NA, 0xA5, 0xB5, __NA,
		__NA, 0xA3, 0xB3, 0xD1, 0xF1, __NA, __NA, 0xD2, 0xF2, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		0xD5, 0xF5, __NA, __NA, 0xC0, 0xE0, __NA, __NA, 0xD8, 0xF8, 0xA6, 0xB6, __NA, __NA, 0xAA, 0xBA,
		0xA9, 0xB9, 0xDE, 0xFE, 0xAB, 0xBB, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xD9, 0xF9,
		0xDB, 0xFB, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xAC, 0xBC, 0xAF, 0xBF, 0xAE, 0xBE
	};
	const uchar		UCStoISO88592_02C7[] = {
												  0xB7, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xA2, 0xFF, __NA, 0xB2, __NA, 0xBD
	};
	const wchar_t	ISO88593toUCS_A0[] = {
	/* 0xA0 */	0x00A0, 0x0126, 0x02D8, 0x00A3, 0x00A4, __RPCH, 0x0124, 0x00A7,
				0x00A8, 0x0130, 0x015E, 0x011E, 0x0134, 0x00AD, __RPCH, 0x017B,
	/* 0xB0 */	0x00B0, 0x0127, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x0125, 0x00B7,
				0x00B8, 0x0131, 0x015F, 0x011F, 0x0135, 0x00BD, __RPCH, 0x017C,
	/* 0xC0 */	0x00C0, 0x00C1, 0x00C2, __RPCH, 0x00C4, 0x010A, 0x0108, 0x00C7,
				0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
	/* 0xD0 */	__RPCH, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x0120, 0x00D6, 0x00D7,
				0x011C, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x016C, 0x015C, 0x00DF,
	/* 0xE0 */	0x00E0, 0x00E1, 0x00E2, __RPCH, 0x00E4, 0x010B, 0x0109, 0x00E7,
				0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
	/* 0xF0 */	__RPCH, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x0121, 0x00F6, 0x00F7,
				0x011D, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x016D, 0x015D, 0x02D9
	};
	const uchar		UCStoISO88593_00A0[] = {
		0xA0, __NA, __NA, 0xA3, 0xA4, __NA, __NA, 0xA7, 0xA8, __NA, __NA, __NA, __NA, 0xAD, __NA, __NA,
		0xB0, __NA, 0xB2, 0xB3, 0xB4, 0xB5, __NA, 0xB7, 0xB8, __NA, __NA, __NA, __NA, 0xBD, __NA, __NA,
		0xC0, 0xC1, 0xC2, __NA, 0xC4, __NA, __NA, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
		__NA, 0xD1, 0xD2, 0xD3, 0xD4, __NA, 0xD6, 0xD7, __NA, 0xD9, 0xDA, 0xDB, 0xDC, __NA, __NA, 0xDF,
		0xE0, 0xE1, 0xE2, __NA, 0xE4, __NA, __NA, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
		__NA, 0xF1, 0xF2, 0xF3, 0xF4, __NA, 0xF6, 0xF7, __NA, 0xF9, 0xFA, 0xFB, 0xFC, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xC6, 0xE6, 0xC5, 0xE5, __NA, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xD8, 0xF8, 0xAB, 0xBB,
		0xD5, 0xF5, __NA, __NA, 0xA6, 0xB6, 0xA1, 0xB1, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		0xA9, 0xB9, __NA, __NA, 0xAC, 0xBC
	};
	const uchar		UCStoISO88593_015C[] = {
																				0xDE, 0xFE, 0xAA, 0xBA,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xDD, 0xFD, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xAF, 0xBF
	};
	const uchar		UCStoISO88593_02D8[] = {
		0xA2, 0xFF
	};
	const wchar_t	ISO88594toUCS_A0[] = {
		0x00A0, 0x0104, 0x0138, 0x0156, 0x00A4, 0x0128, 0x013B, 0x00A7,
		0x00A8, 0x0160, 0x0112, 0x0122, 0x0166, 0x00AD, 0x017D, 0x00AF,
		0x00B0, 0x0105, 0x02DB, 0x0157, 0x00B4, 0x0129, 0x013C, 0x02C7,
		0x00B8, 0x0161, 0x0113, 0x0123, 0x0167, 0x014A, 0x017E, 0x014B,
		0x0100, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x012E,
		0x010C, 0x00C9, 0x0118, 0x00CB, 0x0116, 0x00CD, 0x00CE, 0x012A,
		0x0110, 0x0145, 0x014C, 0x0136, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
		0x00D8, 0x0172, 0x00DA, 0x00DB, 0x00DC, 0x0168, 0x016A, 0x00DF,
		0x0101, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x012F,
		0x010D, 0x00E9, 0x0119, 0x00EB, 0x0117, 0x00ED, 0x00EE, 0x012B,
		0x0111, 0x0146, 0x014D, 0x0137, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
		0x00F8, 0x0173, 0x00FA, 0x00FB, 0x00FC, 0x0169, 0x016B, 0x02D9
	};
	const uchar		UCStoISO88594_00A0[] = {
		0xA0, __NA, __NA, __NA, 0xA4, __NA, __NA, 0xA7, 0xA8, __NA, __NA, __NA, __NA, 0xAD, __NA, 0xAF, 
		0xB0, __NA, __NA, __NA, 0xB4, __NA, __NA, __NA, 0xB8, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		__NA, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, __NA, __NA, 0xC9, __NA, 0xCB, __NA, 0xCD, 0xCE, __NA,
		__NA, __NA, __NA, __NA, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, __NA, 0xDA, 0xDB, 0xDC, __NA, __NA, 0xDF,
		__NA, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, __NA, __NA, 0xE9, __NA, 0xEB, __NA, 0xED, 0xEE, __NA,
		__NA, __NA, __NA, __NA, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, __NA, 0xFA, 0xFB, 0xFC, __NA, __NA, __NA,
		0xC0, 0xE0, __NA, __NA, 0xA1, 0xB1, __NA, __NA, __NA, __NA, __NA, __NA, 0xC8, 0xE8, __NA, __NA,
		0xD0, 0xF0, 0xAA, 0xBA, __NA, __NA, 0xCC, 0xEC, 0xCA, 0xEA, __NA, __NA, __NA, __NA, __NA, __NA,
		__NA, __NA, 0xAB, 0xBB, __NA, __NA, __NA, __NA, 0xA5, 0xB5, 0xCF, 0xEF, __NA, __NA, 0xC7, 0xE7,
		__NA, __NA, __NA, __NA, __NA, __NA, 0xD3, 0xF3, 0xA2, __NA, __NA, 0xA6, 0xB6, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, 0xD1, 0xF1, __NA, __NA, __NA, 0xBD, 0xBF, 0xD2, 0xF2, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, 0xA3, 0xB3, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		0xA9, 0xB9, __NA, __NA, __NA, __NA, 0xAC, 0xBC, 0xDD, 0xFD, 0xDE, 0xFE, __NA, __NA, __NA, __NA,
		__NA, __NA, 0xD9, 0xF9, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xAE, 0xBE
	};
	const uchar		UCStoISO88594_02C7[] = {
												  0xB7, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xFF, __NA, 0xB2
	};
	const wchar_t	ISO88595toUCS_A0[] = {
		0x00A0, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 0x0407,
		0x0408, 0x0409, 0x040A, 0x040B, 0x040C, 0x00AD, 0x040E, 0x040F, 
		0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
		0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F, 
		0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
		0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F, 
		0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
		0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F, 
		0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
		0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 
		0x2116, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457,
		0x0458, 0x0459, 0x045A, 0x045B, 0x045C, 0x00A7, 0x045E, 0x045F,
	};
	const uchar		UCStoISO88595_00A0[] = {
		0xA0, __NA, __NA, __NA, __NA, __NA, __NA, 0xFD, __NA, __NA, __NA, __NA, __NA, 0xAD
	};
	const uchar		UCStoISO88595_0401[] = {
			  0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, __NA, 0xAE, 0xAF,
		0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
		0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
		0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
		0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
		__NA, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, __NA, 0xFE, 0xFF
	};
	const uchar		UCStoISO88595_2116[] = {
											0xF0
	};
	const wchar_t	ISO88596toUCS_A0[] = {
		0x00A0, __RPCH, __RPCH, __RPCH, 0x00A4, __RPCH, __RPCH, __RPCH,
		__RPCH, __RPCH, __RPCH, __RPCH, 0x060C, 0x00AD, __RPCH, __RPCH, 
		__RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH,
		__RPCH, __RPCH, __RPCH, 0x061B, __RPCH, __RPCH, __RPCH, 0x061F, 
		__RPCH, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627,
		0x0628, 0x0629, 0x062A, 0x062B, 0x062C, 0x062D, 0x062E, 0x062F, 
		0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637,
		0x0638, 0x0639, 0x063A, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, 
		0x0640, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0647,
		0x0648, 0x0649, 0x064A, 0x064B, 0x064C, 0x064D, 0x064E, 0x064F, 
		0x0650, 0x0651, 0x0652
	};
	const uchar		UCStoISO88596_00A0[] = {
		0xA0, __NA, __NA, __NA, 0xA4, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xAD
	};
	const uchar		UCStoISO88596_060C[] = {
																				0xAC, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xBB, __NA, __NA, __NA, 0xBF,
		__NA, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
		0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, __NA, __NA, __NA, __NA, __NA,
		0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
		0xF0, 0xF1, 0xF2
	};
	const wchar_t	ISO88597toUCS_A0[] = {
		0x00A0, 0x2018, 0x2019, 0x00A3, 0x20AC, 0x20AF, 0x00A6, 0x00A7,
		0x00A8, 0x00A9, 0x037A, 0x00AB, 0x00AC, 0x00AD, __RPCH, 0x2015,
		0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x0384, 0x0385, 0x0386, 0x00B7,
		0x0388, 0x0389, 0x038A, 0x00BB, 0x038C, 0x00BD, 0x038E, 0x038F,
		0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397,
		0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F,
		0x03A0, 0x03A1, __RPCH, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7,
		0x03A8, 0x03A9, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF,
		0x03B0, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7,
		0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF,
		0x03C0, 0x03C1, 0x03C2, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7,
		0x03C8, 0x03C9, 0x03CA, 0x03CB, 0x03CC, 0x03CD, 0x03CE
	};
	const uchar		UCStoISO88597_00A0[] = {
		0xA0, __NA, __NA, 0xA3, __NA, __NA, 0xA6, 0xA7, 0xA8, 0xA9, __NA, 0xAB, 0xAC, 0xAD, __NA, __NA,
		0xB0, 0xB1, 0xB2, 0xB3, __NA, __NA, __NA, 0xB7, __NA, __NA, __NA, 0xBB, __NA, 0xBD
	};
	const uchar		UCStoISO88597_037A[] = {
																	0xAA, __NA, __NA, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, 0xB4, 0xB5, 0xB6, __NA, 0xB8, 0xB9, 0xBA, __NA, 0xBC, __NA, 0xBE, 0xBF,
		0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
		0xD0, 0xD1, __NA, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
		0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
		0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 
	};
	const uchar		UCStoISO88597_2015[] = {
									  0xAF, __NA, __NA, 0xA1, 0xA2
	};
	const uchar		UCStoISO88597_20AC[] = {
																				0xA4, __NA, __NA, 0xA5
	};
	const wchar_t	ISO88598toUCS_A0[] = {
		0x00A0, __RPCH, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
		0x00A8, 0x00A9, 0x00D7, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF, 
		0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
		0x00B8, 0x00B9, 0x00F7, 0x00BB, 0x00BC, 0x00BD, 0x00BE, __RPCH, 
		__RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH,
		__RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, 
		__RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH,
		__RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, __RPCH, 0x2017, 
		0x05D0, 0x05D1, 0x05D2, 0x05D3, 0x05D4, 0x05D5, 0x05D6, 0x05D7,
		0x05D8, 0x05D9, 0x05DA, 0x05DB, 0x05DC, 0x05DD, 0x05DE, 0x05DF, 
		0x05E0, 0x05E1, 0x05E2, 0x05E3, 0x05E4, 0x05E5, 0x05E6, 0x05E7,
		0x05E8, 0x05E9, 0x05EA, __RPCH, __RPCH, 0x200E, 0x200F
	};
	const uchar		UCStoISO88598_00A0[] = {
		0xA0, __NA, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, __NA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
		0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, __NA, 0xBB, 0xBC, 0xBD, 0xBE
	};
	const uchar		UCStoISO88598_00D7[] = {
												  0xAA
	};
	const uchar		UCStoISO88598_00F7[] = {
												  0xBA
	};
	const uchar		UCStoISO88598_05D0[] = {
		0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
		0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA
	};
	const uchar		UCStoISO88598_200E[] = {
																							0xFD, 0xFE,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xDF
	};
	const wchar_t	ISO88599toUCS_A0[] = {
		0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
		0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF, 
		0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
		0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF, 
		0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
		0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF, 
		0x011E, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
		0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x0130, 0x015E, 0x00DF, 
		0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
		0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 
		0x011F, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
		0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x0131, 0x015F, 0x00FF
	};
	const uchar		UCStoISO88599_00A0[] = {
		0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
		0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
		0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
		__NA, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, __NA, __NA, 0xDF,
		0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
		__NA, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, __NA, __NA, 0xFF
	};
	const uchar		UCStoISO88599_011E[] = {
																							0xD0, 0xF0
	};
	const uchar		UCStoISO88599_0130[] = {
		0xDD, 0xFD
	};
	const uchar		UCStoISO88599_015E[] = {
																							0xDE, 0xFE
	};
	const wchar_t	ISO885910toUCS_A0[] = {
		0x00A0, 0x0104, 0x0112, 0x0122, 0x012A, 0x0128, 0x0136, 0x00A7, 0x013B, 0x0110, 0x0160, 0x0166, 0x017D, 0x00AD, 0x016A, 0x014A,
		0x00B0, 0x0105, 0x0113, 0x0123, 0x012B, 0x0129, 0x0137, 0x00B7, 0x013C, 0x0111, 0x0161, 0x0167, 0x017E, 0x2015, 0x016B, 0x014B,
		0x0100, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x012E, 0x010C, 0x00C9, 0x0118, 0x00CB, 0x0116, 0x00CD, 0x00CE, 0x00CF,
		0x00D0, 0x0145, 0x014C, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x0168, 0x00D8, 0x0172, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
		0x0101, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x012F, 0x010D, 0x00E9, 0x0119, 0x00EB, 0x0117, 0x00ED, 0x00EE, 0x00EF,
		0x00F0, 0x0146, 0x014D, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x0169, 0x00F8, 0x0173, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x0138
	};
	const uchar		UCStoISO885910_00A0[] = {
		0xA0, __NA, __NA, __NA, __NA, __NA, __NA, 0xA7, __NA, __NA, __NA, __NA, __NA, 0xAD, __NA, __NA,
		0xB0, __NA, __NA, __NA, __NA, __NA, __NA, 0xB7, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		__NA, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, __NA, __NA, 0xC9, __NA, 0xCB, __NA, 0xCD, 0xCE, 0xCF,
		0xD0, __NA, __NA, 0xD3, 0xD4, 0xD5, 0xD6, __NA, 0xD8, __NA, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
		__NA, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, __NA, __NA, 0xE9, __NA, 0xEB, __NA, 0xED, 0xEE, 0xEF,
		0xF0, __NA, __NA, 0xF3, 0xF4, 0xF5, 0xF6, __NA, 0xF8, __NA, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, __NA,
		0xC0, 0xE0, __NA, __NA, 0xA1, 0xB1, __NA, __NA, __NA, __NA, __NA, __NA, 0xC8, 0xE8, __NA, __NA,
		0xA9, 0xB9, 0xA2, 0xB2, __NA, __NA, 0xCC, 0xEC, 0xCA, 0xEA, __NA, __NA, __NA, __NA, __NA, __NA,
		__NA, __NA, 0xA3, 0xB3, __NA, __NA, __NA, __NA, 0xA5, 0xB5, 0xA4, 0xB4, __NA, __NA, 0xC7, 0xE7,
		__NA, __NA, __NA, __NA, __NA, __NA, 0xA6, 0xB6, 0xFF, __NA, __NA, 0xA8, 0xB8, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, 0xD1, 0xF1, __NA, __NA, __NA, 0xAF, 0xBF, 0xD2, 0xF2, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		0xAA, 0xBA, __NA, __NA, __NA, __NA, 0xAB, 0xBB, 0xD7, 0xF7, 0xAE, 0xBE, __NA, __NA, __NA, __NA,
		__NA, __NA, 0xD9, 0xF9, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xAC, 0xBC
	};
	const uchar		UCStoISO885910_2015[] = {
									  0xBD
	};
	const wchar_t	ISO885913toUCS_A0[] = {
		0x00A0, 0x201D, 0x00A2, 0x00A3, 0x00A4, 0x201E, 0x00A6, 0x00A7, 0x00D8, 0x00A9, 0x0156, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00C6,
		0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x201C, 0x00B5, 0x00B6, 0x00B7, 0x00F8, 0x00B9, 0x0157, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00E6,
		0x0104, 0x012E, 0x0100, 0x0106, 0x00C4, 0x00C5, 0x0118, 0x0112, 0x010C, 0x00C9, 0x0179, 0x0116, 0x0122, 0x0136, 0x012A, 0x013B,
		0x0160, 0x0143, 0x0145, 0x00D3, 0x014C, 0x00D5, 0x00D6, 0x00D7, 0x0172, 0x0141, 0x015A, 0x016A, 0x00DC, 0x017B, 0x017D, 0x00DF,
		0x0105, 0x012F, 0x0101, 0x0107, 0x00E4, 0x00E5, 0x0119, 0x0113, 0x010D, 0x00E9, 0x017A, 0x0117, 0x0123, 0x0137, 0x012B, 0x013C,
		0x0161, 0x0144, 0x0146, 0x00F3, 0x014D, 0x00F5, 0x00F6, 0x00F7, 0x0173, 0x0142, 0x015B, 0x016B, 0x00FC, 0x017C, 0x017E, 0x2019
	};
	const uchar		UCStoISO885913_00A0[] = {
		0xA0, __NA, 0xA2, 0xA3, 0xA4, __NA, 0xA6, 0xA7, __NA, 0xA9, __NA, 0xAB, 0xAC, 0xAD, 0xAE, __NA,
		0xB0, 0xB1, 0xB2, 0xB3, __NA, 0xB5, 0xB6, 0xB7, __NA, 0xB9, __NA, 0xBB, 0xBC, 0xBD, 0xBE, __NA,
		__NA, __NA, __NA, __NA, 0xC4, 0xC5, 0xAF, __NA, __NA, 0xC9, __NA, __NA, __NA, __NA, __NA, __NA,
		__NA, __NA, __NA, 0xD3, __NA, 0xD5, 0xD6, 0xD7, 0xA8, __NA, __NA, __NA, 0xDC, __NA, __NA, 0xDF,
		__NA, __NA, __NA, __NA, 0xE4, 0xE5, 0xBF, __NA, __NA, 0xE9, __NA, __NA, __NA, __NA, __NA, __NA,
		__NA, __NA, __NA, 0xF3, __NA, 0xF5, 0xF6, 0xF7, 0xB8, __NA, __NA, __NA, 0xFC, __NA, __NA, __NA,
		0xC2, 0xE2, __NA, __NA, 0xC0, 0xE0, 0xC3, 0xE3, __NA, __NA, __NA, __NA, 0xC8, 0xE8, __NA, __NA,
		__NA, __NA, 0xC7, 0xE7, __NA, __NA, 0xCB, 0xEB, 0xC6, 0xE6, __NA, __NA, __NA, __NA, __NA, __NA,
		__NA, __NA, 0xCC, 0xEC, __NA, __NA, __NA, __NA, __NA, __NA, 0xCE, 0xEE, __NA, __NA, 0xC1, 0xE1,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xCD, 0xED, __NA, __NA, __NA, 0xCF, 0xEF, __NA, __NA,
		__NA, 0xD9, 0xF9, 0xD1, 0xF1, 0xD2, 0xF2, __NA, __NA, __NA, __NA, __NA, 0xD4, 0xF4, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, 0xAA, 0xBA, __NA, __NA, 0xDA, 0xFA, __NA, __NA, __NA, __NA,
		0xD0, 0xF0, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xDB, 0xFB, __NA, __NA, __NA, __NA,
		__NA, __NA, 0xD8, 0xF8, __NA, __NA, __NA, __NA, __NA, 0xCA, 0xEA, 0xDD, 0xFD, 0xDE, 0xFE
	};
	const uchar		UCStoISO885913_2019[] = {
															  0xFF, __NA, __NA, 0xB4, 0xA1, 0xA5
	};
	const wchar_t	ISO885914toUCS_A0[] = {
		0x00A0, 0x1E02, 0x1E03, 0x00A3, 0x010A, 0x010B, 0x1E0A, 0x00A7, 0x1E80, 0x00A9, 0x1E82, 0x1E0B, 0x1EF2, 0x00AD, 0x00AE, 0x0178,
		0x1E1E, 0x1E1F, 0x0120, 0x0121, 0x1E40, 0x1E41, 0x00B6, 0x1E56, 0x1E81, 0x1E57, 0x1E83, 0x1E60, 0x1EF3, 0x1E84, 0x1E85, 0x1E61,
		0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
		0x0174, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x1E6A, 0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x0176, 0x00DF,
		0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
		0x0175, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x1E6B, 0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x0177, 0x00FF
	};
	const uchar		UCStoISO885914_00A0[] = {
		0xA0, __NA, __NA, 0xA3, __NA, __NA, __NA, 0xA7, __NA, 0xA9, __NA, __NA, __NA, 0xAD, 0xAE, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, 0xB6, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
		__NA, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, __NA, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, __NA, 0xDF,
		0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
		__NA, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, __NA, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, __NA, 0xFF,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xA4, 0xA5, __NA, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		0xB2, 0xB3
	};
	const uchar		UCStoISO885914_0174[] = {
								0xD0, 0xF0, 0xDE, 0xFE, 0xAF
	};
	const uchar		UCStoISO885914_1E02[] = {
					0xA1, 0xA2, __NA, __NA, __NA, __NA, __NA, __NA, 0xA6, 0xAB, __NA, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xB0, 0xB1
	};
	const uchar		UCStoISO885914_1E40[] = {
		0xB4, 0xB5, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, 0xB7, 0xB9, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		0xBB, 0xBF, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xD7, 0xF7, __NA, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		0xA8, 0xB8, 0xAA, 0xBA, 0xBD, 0xBE
	};
	const uchar		UCStoISO885914_1EF2[] = {
		__NA, __NA, 0xAC, 0xBC
	};
	const wchar_t	ISO885915toUCS_A0[] = {
		0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x20AC, 0x00A5, 0x0160, 0x00A7, 0x0161, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
		0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x017D, 0x00B5, 0x00B6, 0x00B7, 0x017E, 0x00B9, 0x00BA, 0x00BB, 0x0152, 0x0153, 0x0178, 0x00BF,
		0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
		0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7, 0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
		0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
		0x00F0, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF
	};
	const uchar		UCStoISO885915_00A0[] = {
		0xA0, 0xA1, 0xA2, 0xA3, __NA, 0xA5, __NA, 0xA7, __NA, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
		0xB0, 0xB1, 0xB2, 0xB3, __NA, 0xB5, 0xB6, 0xB7, __NA, 0xB9, 0xBA, 0xBB, __NA, __NA, __NA, 0xBF,
		0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
		0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
		0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
		0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF
	};
	const uchar		UCStoISO885915_0152[] = {
					0xBC, 0xBD, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		0xA6, 0xA8, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xBE, __NA, __NA, __NA, __NA, 0xB4, 0xB8
	};
	const uchar		UCStoISO885915_20AC[] = {
																				0xA4
	};
	const wchar_t	ISO885916toUCS_A0[] = {
		0x00A0, 0x0104, 0x0105, 0x0141, 0x20AC, 0x201E, 0x0160, 0x00A7, 0x0161, 0x00A9, 0x0218, 0x00AB, 0x0179, 0x00AD, 0x017A, 0x017B,
		0x00B0, 0x00B1, 0x010C, 0x0142, 0x017D, 0x201D, 0x00B6, 0x00B7, 0x017E, 0x010D, 0x0219, 0x00BB, 0x0152, 0x0153, 0x0178, 0x017C,
		0x00C0, 0x00C1, 0x00C2, 0x0102, 0x00C4, 0x0106, 0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
		0x0110, 0x0143, 0x00D2, 0x00D3, 0x00D4, 0x0150, 0x00D6, 0x015A, 0x0170, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x0118, 0x021A, 0x00DF,
		0x00E0, 0x00E1, 0x00E2, 0x0103, 0x00E4, 0x0107, 0x00E6, 0x00E7, 0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
		0x0111, 0x0144, 0x00F2, 0x00F3, 0x00F4, 0x0151, 0x00F6, 0x015B, 0x0171, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x0119, 0x021B, 0x00FF
	};
	const uchar		UCStoISO885916_00A0[] = {
		0xA0, __NA, __NA, __NA, __NA, __NA, __NA, 0xA7, __NA, 0xA9, __NA, 0xAB, __NA, 0xAD, __NA, __NA,
		0xB0, 0xB1, __NA, __NA, __NA, __NA, 0xB6, 0xB7, __NA, __NA, __NA, 0xBB, __NA, __NA, __NA, __NA,
		0xC0, 0xC1, 0xC2, __NA, 0xC4, __NA, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
		__NA, __NA, 0xD2, 0xD3, 0xD4, __NA, 0xD6, __NA, __NA, 0xD9, 0xDA, 0xDB, 0xDC, __NA, __NA, 0xDF,
		0xE0, 0xE1, 0xE2, __NA, 0xE4, __NA, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
		__NA, __NA, 0xF2, 0xF3, 0xF4, __NA, 0xF6, __NA, __NA, 0xF9, 0xFA, 0xFB, 0xFC, __NA, __NA, 0xFF,
		__NA, __NA, 0xC3, 0xE3, 0xA1, 0xA2, 0xC5, 0xE5, __NA, __NA, __NA, __NA, 0xB2, 0xB9, __NA, __NA,
		0xD0, 0xF0, __NA, __NA, __NA, __NA, __NA, __NA, 0xDD, 0xFD
	};
	const uchar		UCStoISO885916_0141[] = {
			  0xA3, 0xB3, 0xD1, 0xF1, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		0xD5, 0xF5, 0xBC, 0xBD, __NA, __NA, __NA, __NA, __NA, __NA, 0xD7, 0xF7, __NA, __NA, __NA, __NA,
		0xA6, 0xA8, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
		0xD8, 0xF8, __NA, __NA, __NA, __NA, __NA, __NA, 0xBE, 0xAC, 0xAE, 0xAF, 0xBF, 0xB4, 0xB8
	};
	const uchar		UCStoISO885916_0218[] = {
														0xAA, 0xBA, 0xDE, 0xFE
	};
	const uchar		UCStoISO885916_201D[] = {
																					  0xB5, 0xA5
	};
	const uchar		UCStoISO885916_20AC[] = {
																				0xA4
	};
} // namespace `anonymous'


// [bp (ISO-8859-1) //////////////////////////////////////////////////////

size_t CEncoder_Iso8859_1::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();

	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cch; ++i) {
		if(pwszSrc[i] > 0x00FF)
			CONFIRM_ILLEGAL_CHAR(pszDest[i])
		else
			pszDest[i] = static_cast<char>(pwszSrc[i]);
	}
	return cch;
}

size_t CEncoder_Iso8859_1::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();

	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cch; ++i)
		pwszDest[i] = pszSrc[i];
	return cch;
}


// [bp (ISO-8859-2) //////////////////////////////////////////////

size_t CEncoder_Iso8859_2::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN();
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88592_, 00A0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88592_, 02C7);
	IMPLEMENT_UNICODE_TO_ISO8859_END();
}

size_t CEncoder_Iso8859_2::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_ISO8859_TO_UNICODE(ISO88592toUCS_A0);
}


// 새[bp (ISO-8859-3) ////////////////////////////////////////////////

size_t CEncoder_Iso8859_3::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN();
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88593_, 00A0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88593_, 015C);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88593_, 02D8);
	IMPLEMENT_UNICODE_TO_ISO8859_END();
}

size_t CEncoder_Iso8859_3::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_ISO8859_TO_UNICODE(ISO88593toUCS_A0);
}


// og (ISO-8859-4) //////////////////////////////////////////////////

size_t CEncoder_Iso8859_4::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN();
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88594_, 00A0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88594_, 02C7);
	IMPLEMENT_UNICODE_TO_ISO8859_END();
}

size_t CEncoder_Iso8859_4::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_ISO8859_TO_UNICODE(ISO88594toUCS_A0);
}


// L (ISO-8859-5) //////////////////////////////////////////////////

size_t CEncoder_Iso8859_5::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN();
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88595_, 00A0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88595_, 0401);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88595_, 2116);
	IMPLEMENT_UNICODE_TO_ISO8859_END();
}

size_t CEncoder_Iso8859_5::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_ISO8859_TO_UNICODE(ISO88595toUCS_A0);
}


// ArA (ISO-8859-6) //////////////////////////////////////////////////

size_t CEncoder_Iso8859_6::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN();
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88596_, 00A0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88596_, 060C);
	IMPLEMENT_UNICODE_TO_ISO8859_END();
}

size_t CEncoder_Iso8859_6::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_ISO8859_TO_UNICODE(ISO88596toUCS_A0);
}


// MV (ISO-8859-7) //////////////////////////////////////////////////

size_t CEncoder_Iso8859_7::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN();
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88597_, 00A0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88597_, 037A);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88597_, 2015);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88597_, 20AC);
	IMPLEMENT_UNICODE_TO_ISO8859_END();
}

size_t CEncoder_Iso8859_7::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_ISO8859_TO_UNICODE(ISO88597toUCS_A0);
}


// wuC (ISO-8859-8, o) //////////////////////////////////////////

size_t CEncoder_Iso8859_8::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN();
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88598_, 00A0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88598_, 00D7);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88598_, 00F7);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88598_, 05D0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88598_, 200E);
	IMPLEMENT_UNICODE_TO_ISO8859_END();
}

size_t CEncoder_Iso8859_8::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_ISO8859_TO_UNICODE(ISO88598toUCS_A0);
}


// gR (ISO-8859-9) ////////////////////////////////////////////////////

size_t CEncoder_Iso8859_9::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN();
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88599_, 00A0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88599_, 011E);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88599_, 0130);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO88599_, 015E);
	IMPLEMENT_UNICODE_TO_ISO8859_END();
}

size_t CEncoder_Iso8859_9::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_ISO8859_TO_UNICODE(ISO88599toUCS_A0);
}

// k (ISO-8859-10) ///////////////////////////////////////////////////////

size_t CEncoder_Iso8859_10::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN();
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885910_, 00A0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885910_, 2015);
	IMPLEMENT_UNICODE_TO_ISO8859_END();
}

size_t CEncoder_Iso8859_10::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_ISO8859_TO_UNICODE(ISO885910toUCS_A0);
}

// og (ISO-8859-13) /////////////////////////////////////////////////

size_t CEncoder_Iso8859_13::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN();
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885913_, 00A0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885913_, 2019);
	IMPLEMENT_UNICODE_TO_ISO8859_END();
}

size_t CEncoder_Iso8859_13::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_ISO8859_TO_UNICODE(ISO885913toUCS_A0);
}

// Pg (ISO-8859-14) ///////////////////////////////////////////////////

size_t CEncoder_Iso8859_14::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN();
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885914_, 00A0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885914_, 0174);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885914_, 1E02);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885914_, 1E40);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885914_, 1EF2);
	IMPLEMENT_UNICODE_TO_ISO8859_END();
}

size_t CEncoder_Iso8859_14::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_ISO8859_TO_UNICODE(ISO885914toUCS_A0);
}

// [bp (ISO-8859-15) ///////////////////////////////////////////////

size_t CEncoder_Iso8859_15::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN();
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885915_, 00A0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885915_, 0152);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885915_, 20AC);
	IMPLEMENT_UNICODE_TO_ISO8859_END();
}

size_t CEncoder_Iso8859_15::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_ISO8859_TO_UNICODE(ISO885915toUCS_A0);
}

// [bp (ISO-8859-16) /////////////////////////////////////////////

size_t CEncoder_Iso8859_16::ConvertFromUnicode(CFU_ARGLIST) {
	IMPLEMENT_UNICODE_TO_ISO8859_BEGIN();
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885916_, 00A0);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885916_, 0141);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885916_, 0218);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885916_, 201D);
		ENTRY_UNICODE_TO_ISO8859_MAP(UCStoISO885916_, 20AC);
	IMPLEMENT_UNICODE_TO_ISO8859_END();
}

size_t CEncoder_Iso8859_16::ConvertToUnicode(CTU_ARGLIST) {
	IMPLEMENT_ISO8859_TO_UNICODE(ISO885916toUCS_A0);
}

#undef IMPLEMENT_ISO8859_TO_UNICODE
#undef IMPLEMENT_UNICODE_TO_ISO8859_BEGIN
#undef ENTRY_UNICODE_TO_ISO8859_MAP
#undef IMPLEMENT_UNICODE_TO_ISO8859_END

/* [EOF] */