// Thai.cpp
// (c) 2004-2005 exeal

#include "StdAfx.h"
#include "Encoder.h"

using namespace Ascension::Encodings;
using namespace std;


BEGIN_ENCODER_DEFINITION()
	DEFINE_ENCODER_CLASS(CPEX_THAI_TIS620, Thai_Tis620, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_ISO8859_11, Iso8859_11, 1, 1)
END_ENCODER_DEFINITION()

namespace {
	template<bool bIso8859>
	inline wchar_t ThaiNativeCharToUcs(uchar ch) {
		if(ch < 0x80)						return ch;
		else if(ch == 0xA0)					return bIso8859 ? 0x00A0 : __REPLACEMENT_CHARACTER;
		else if(ch >= 0xA1 && ch <= 0xDA)	return ch + 0x0D60;
		else if(ch >= 0xDF && ch <= 0xFB)	return ch + 0x0D60;
		else								return __REPLACEMENT_CHARACTER;
	}
	template<bool bIso8859>
	inline uchar UcsToThaiNativeChar(wchar_t wch) {
		assert(wch != 0);
		if(wch < 0x0080)						return static_cast<uchar>(wch);
		else if(wch == 0x00A0)					return bIso8859 ? 0xA0 : __NA;
		else if(wch >= 0x0E01 && wch <= 0x0E3A)	return static_cast<uchar>(wch - 0x0D60);
		else if(wch >= 0x0E3F && wch <= 0x0E5B)	return static_cast<uchar>(wch - 0x0D60);
		else									return __NA;
	}
	template<bool bIso8859>
	inline size_t UnicodeToThaiNative(uchar* pszDest, size_t cchDest,
			const wchar_t* pwszSrc, size_t cchSrc, IUnconvertableCharCallback* pCallback) {
		for(size_t i = 0; i < cchSrc && i < cchDest; ++i) {
			pszDest[i] = UcsToThaiNativeChar<bIso8859>(pwszSrc[i]);
			if(pszDest[i] == __NA)
				CONFIRM_ILLEGAL_CHAR(pszDest[i]);
		}
		return min(cchSrc, cchDest);
	}
	template<bool bIso8859>
	inline size_t ThaiNativeToUnicode(wchar_t* pwszDest, size_t cchDest,
			const uchar* pszSrc, size_t cchSrc, IUnconvertableCharCallback* pCallback) {
		for(size_t i = 0; i < cchSrc && i < cchDest; ++i) {
			pwszDest[i] = ThaiNativeCharToUcs<false>(pszSrc[i]);
			if(pwszDest[i] == __REPLACEMENT_CHARACTER)
				CONFIRM_ILLEGAL_CHAR(pwszDest[i]);
		}
		return min(cchSrc, cchDest);
	}
}


// ^C (TIS 620-2533:1990) ///////////////////////////////////////////////

size_t CEncoder_Thai_Tis620::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();
	return UnicodeToThaiNative<false>(reinterpret_cast<uchar*>(pszDest), cchDest, pwszSrc, cchSrc, pCallback);
}

size_t CEncoder_Thai_Tis620::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();
	return ThaiNativeToUnicode<false>(pwszDest, cchDest, pszSrc, cchSrc, pCallback);
}


// ^C (ISO-8859-11) /////////////////////////////////////////////////////

size_t CEncoder_Iso8859_11::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();
	return UnicodeToThaiNative<true>(reinterpret_cast<uchar*>(pszDest), cchDest, pwszSrc, cchSrc, pCallback);
}

size_t CEncoder_Iso8859_11::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();
	return ThaiNativeToUnicode<true>(pwszDest, cchDest, pszSrc, cchSrc, pCallback);
}

/* [EOF] */