#!/usr/local/bin/perl

# blocks.pl (c) 2004 exeal
# _CAscensionRegExpTraits::m_blocks[] νΤ
# Blocks.txt ֥åΥꥹȤϤ롣
#
# blocks.pl [-d:directory]
#
# ɸ

# show usage and abort
sub usage($) {
	die("\n" . shift() . "\nUsage: blocks.pl [-d:directory]\n\n");
}


my $fileName = 'Blocks.txt';

if($#ARGV == 0) {
	usage("Parameter is illegal.") unless($ARGV[0] =~ /\-d\:(.+)/);
	my $path = $1;
	$path =~ tr/\"//;
	$fileName = $path . "\\" . $fileName;
} elsif($#ARGV != -1) {
	usage("Bad parameter number.");
}

if(!open(FH, $fileName)) {
	die("\nCannot open $fileName.\nIf Blocks.txt is not current directory, you can use -d:<directory> switch to specify where the file is.\n");
}

my $line;
while($line = <FH>) {
	if($line =~ m/^([0-9A-F]+)\.\.([0-9A-F]+);\s(.+)$/) {
		my $startCode = $1;
		my $endCode = $2;
		my $blockName = $3;

		$blockName =~ tr/ /-/;
		printf('{L"%s",0x%s,0x%s},', lc($blockName), $startCode, $endCode);
		printf("\n");
	}
}

close(FH);

__END__