// CommandManager.cpp
// (c) 2004-2005 exeal

#include "StdAfx.h"
#include "resource.h"
#include "CommandManager.h"
#include "Alpha.h"
#include "MRUManager.h"
#include "AbbreviationsDlg.h"
#include "AboutDlg.h"
#include "BookmarkDlg.h"
#include "FilePropertyDlg.h"
#include "FindDlg.h"
#include "GotoLineDlg.h"

using namespace Alpha;
using namespace Ascension;
using namespace Ascension::StandardCommands;
using namespace Manah::Windows::Controls;
using namespace std;


#define CHECK_REBAR_BAND_VISIBILITY(index)						\
	AutoZeroCB<REBARBANDINFOW>	rbbi;	\
	rbbi.fMask = RBBIM_STYLE;									\
	m_app.m_rebar.GetBandInfo(index, rbbi);						\
	const bool	bVisible = !toBoolean(rbbi.fStyle & RBBS_HIDDEN);

namespace {
	HBITMAP _CreateFilteredBitmap(HDC hDC, const BITMAPINFO& bi, RGBQUAD(*filterFunction)(const RGBQUAD&)) {
		assert(bi.bmiHeader.biBitCount == 32 || bi.bmiHeader.biBitCount == 24);

		const uchar*	pSrcPixels = reinterpret_cast<const uchar*>(bi.bmiColors);
		uchar*			pDestPixels;
		HBITMAP			hBitmap = ::CreateDIBSection(hDC, &bi,
							DIB_RGB_COLORS, reinterpret_cast<void**>(&pDestPixels), 0, 0);

		for(long y = 0; y < bi.bmiHeader.biHeight; ++y) {
			for(long x = 0; x < bi.bmiHeader.biWidth; ++x) {
				const long	i = y * bi.bmiHeader.biWidth + x;
				const int	offset = i * bi.bmiHeader.biBitCount / 8;

				if(bi.bmiHeader.biBitCount == 32)	// 32rbg: BITMAPINFO::bmiColors  RGBQUAD[]
					*reinterpret_cast<RGBQUAD*>(&pDestPixels[offset]) = (*filterFunction)(bi.bmiColors[i]);
				else {	// 24rbg: BITMAPINFO::bmiColors  24rbg1sNZ̐Fz
					if(memcmp(pSrcPixels + offset, pSrcPixels + 16 * 15 * 3, 3) == 0)
						memcpy(pDestPixels + offset, pSrcPixels + offset, 3);
					else {
						const RGBQUAD	src = {pSrcPixels[offset + 0],
												pSrcPixels[offset + 1], pSrcPixels[offset + 2], 0x00};
						const RGBQUAD	dest = (*filterFunction)(src);
						pDestPixels[offset + 0] = dest.rgbBlue;
						pDestPixels[offset + 1] = dest.rgbGreen;
						pDestPixels[offset + 2] = dest.rgbRed;
					}
				}
			}
		}
		return hBitmap;
	}
	pair<HBITMAP, COLORREF> _CreateFilteredBitmap(HDC hDC, HBITMAP hSrcBitmap, RGBQUAD(*filterFunction)(const RGBQUAD&)) {
		BITMAP		bitmap;
		::GetObject(hSrcBitmap, sizeof(BITMAP), &bitmap);
		HDC			hCompDC = ::CreateCompatibleDC(0);
		HBITMAP		hDestBitmap = ::CreateCompatibleBitmap(hDC, bitmap.bmHeight, bitmap.bmWidth);
		HBITMAP		hOldBitmap = static_cast<HBITMAP>(::SelectObject(hCompDC, hSrcBitmap));
		COLORREF*	pixels = new COLORREF[bitmap.bmHeight * bitmap.bmWidth];
		RGBQUAD		color = {0, 0, 0, 0};

		assert(bitmap.bmBitsPixel < 32);
		for(int y = 0; y < bitmap.bmHeight; ++y)
			for(int x = 0; x < bitmap.bmWidth; ++x)
				pixels[y * bitmap.bmWidth + x] = ::GetPixel(hCompDC, x, y);
		::SelectObject(hCompDC, hDestBitmap);
		const COLORREF	maskColor = pixels[0];
		for(int y = 0; y < bitmap.bmHeight; ++y) {
			for(int x = 0; x < bitmap.bmWidth; ++x) {
				if(pixels[y * bitmap.bmWidth + x] != pixels[0]) {
					color.rgbRed = GetRValue(pixels[y * bitmap.bmWidth + x]);
					color.rgbGreen = GetGValue(pixels[y * bitmap.bmWidth + x]);
					color.rgbBlue = GetBValue(pixels[y * bitmap.bmWidth + x]);
					color = (*filterFunction)(color);
					::SetPixel(hCompDC, x, y, RGB(color.rgbRed, color.rgbGreen, color.rgbBlue));
				} else
					::SetPixel(hCompDC, x, y, pixels[0]);
			}
		}
		::SelectObject(hCompDC, hOldBitmap);
		::DeleteDC(hCompDC);
		delete[] pixels;
		return make_pair(hDestBitmap, maskColor);
	}
	inline BYTE _ApplyGamma(double src, double nGamma) {
		return static_cast<BYTE>(pow(src / 255.0, nGamma) * 255.0);
	}
	RGBQUAD _GrayscaleFilter(const RGBQUAD& src) {
		static const double	nRedFact = 0.299, nGreenFact = 0.587, nBlueFact = 0.114;
		static const double	nGamma = 0.5;

		const double	nGray = src.rgbRed * nRedFact + src.rgbGreen * nGreenFact + src.rgbBlue * nBlueFact;
		const BYTE		nValue = _ApplyGamma(nGray, nGamma);
		RGBQUAD			dest = {nValue, nValue, nValue, src.rgbReserved};

		return dest;
	}
	RGBQUAD _SaturationFilter(const RGBQUAD& src) {
		static const double	nGamma = 1.4;
		RGBQUAD	dest = {_ApplyGamma(src.rgbBlue, nGamma),
			_ApplyGamma(src.rgbGreen, nGamma), _ApplyGamma(src.rgbRed, nGamma), src.rgbReserved};
		return dest;
	}
	RGBQUAD _SepiaFilter(const RGBQUAD& src) {
		RGBQUAD	dest = _GrayscaleFilter(src);
		dest.rgbRed = (dest.rgbRed + 10 > 0xFF) ? 0xFF : (dest.rgbRed + 10);
		dest.rgbGreen = (dest.rgbGreen > 10) ? (dest.rgbGreen - 10) : 0;
		dest.rgbBlue = (dest.rgbBlue > 20) ? (dest.rgbBlue - 20) : 0;
		return dest;
	}
} // namespace `anonymous'


// CCommandManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CCommandManager::CCommandManager(CAlphaApp& app) : m_app(app), m_nLastCommandId(0) {
	m_hIcons[ICONSTATE_NORMAL] = m_hIcons[ICONSTATE_DISABLED] = m_hIcons[ICONSTATE_HOT] = 0;
}

///	fXgN^
CCommandManager::~CCommandManager() {
	if(m_hIcons[ICONSTATE_NORMAL] != 0)		::ImageList_Destroy(m_hIcons[ICONSTATE_NORMAL]);
	if(m_hIcons[ICONSTATE_DISABLED] != 0)	::ImageList_Destroy(m_hIcons[ICONSTATE_DISABLED]);
	if(m_hIcons[ICONSTATE_HOT] != 0)		::ImageList_Destroy(m_hIcons[ICONSTATE_HOT]);
}

/**
 *	ACR[hăC[WXg쐬BȑÕC[WXg͔j
 *	@param strDirectory	ACRۑĂfBNg
 *	@return				
 */
bool CCommandManager::CreateImageList(const wstring& strDirectory) {
	if(m_hIcons[ICONSTATE_NORMAL] != 0) {
		::ImageList_Destroy(m_hIcons[ICONSTATE_NORMAL]);
		::ImageList_Destroy(m_hIcons[ICONSTATE_DISABLED]);
		::ImageList_Destroy(m_hIcons[ICONSTATE_HOT]);
	}
	m_iconIndices.clear();

	m_hIcons[ICONSTATE_NORMAL] = ::ImageList_Create(16, 16, ILC_COLOR32 | ILC_MASK, 0, 0);
	m_hIcons[ICONSTATE_DISABLED] = ::ImageList_Create(16, 16, ILC_COLOR32 | ILC_MASK, 0, 0);
	m_hIcons[ICONSTATE_HOT] = ::ImageList_Create(16, 16, ILC_COLOR32 | ILC_MASK, 0, 0);
	if(m_hIcons[ICONSTATE_NORMAL] == 0 || m_hIcons[ICONSTATE_DISABLED] == 0 || m_hIcons[ICONSTATE_HOT] == 0)
		return false;

	wchar_t				wszPath[MAX_PATH];
	WIN32_FIND_DATAW	wfd;
	HANDLE				hFind;

	wcscpy(wszPath, strDirectory.c_str());
	::PathAppendW(wszPath, L"*.*");
	hFind = ::FindFirstFileW(wszPath, &wfd);

	if(hFind == INVALID_HANDLE_VALUE)
		return 0;

	do {
		const wchar_t*	pwszExtension = ::PathFindExtensionW(wfd.cFileName);
		bool			bImageIsBmp;

		if(wcslen(pwszExtension) != 4)
			continue;
		else if(::StrCmpNIW(pwszExtension + 1, L"bmp", 3) == 0)
			bImageIsBmp = true;
		else if(::StrCmpNIW(pwszExtension + 1, L"ico", 3) == 0)
			bImageIsBmp = false;
		else
			continue;

		wchar_t	wszFileTitle[MAX_PATH];
		wcscpy(wszFileTitle, ::PathFindFileNameW(wfd.cFileName));
		::PathFindExtensionW(wszFileTitle)[0] = 0;

		const CommandId	id = static_cast<CommandId>(wcstoul(wszFileTitle, 0, 10));
		if(id < COMMAND_START || id > COMMAND_END)
			continue;
		wcscpy(wszFileTitle, strDirectory.c_str());
		::PathAppendW(wszFileTitle, wfd.cFileName);

		HBITMAP	hBitmap = 0;
		HICON	hIcon = 0;

		// C[Wǂݍ
		if(bImageIsBmp)
			hBitmap = static_cast<HBITMAP>(::LoadImage(m_app.m_hInstance,
					wszFileTitle, IMAGE_BITMAP, 16, 16, LR_CREATEDIBSECTION | LR_LOADFROMFILE));
		else {
			ICONINFO	iconInfo;
			hIcon = static_cast<HICON>(::LoadImage(m_app.m_hInstance,
					wszFileTitle, IMAGE_ICON, 16, 16, LR_CREATEDIBSECTION | LR_LOADFROMFILE));
			::GetIconInfo(hIcon, &iconInfo);
			hBitmap = iconInfo.hbmColor;
		}

		// tB^KpăC[WXgɒǉ
		if(hBitmap != 0 || hIcon != 0) {
			BITMAP	bitmap;

			m_iconIndices.insert(make_pair(id, ::ImageList_GetImageCount(m_hIcons[ICONSTATE_NORMAL])));
			::GetObject(hBitmap, sizeof(BITMAP), &bitmap);
			if(bitmap.bmBitsPixel == 32 || bitmap.bmBitsPixel == 24) {
				HDC			hDC = ::GetDC(0);
				BITMAPINFO*	pbi;
				HBITMAP		hDisabledBmp = 0, hHotBmp = 0;

				pbi = get_temporary_buffer<BITMAPINFO>(
					sizeof(BITMAPINFOHEADER) + (bitmap.bmBitsPixel / 8 + 1) * 16 * 16).first;
				memset(&pbi->bmiHeader, 0, sizeof(BITMAPINFOHEADER));
				pbi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
				::GetDIBits(hDC, hBitmap, 0, bitmap.bmHeight, 0, pbi, DIB_RGB_COLORS);
				::GetDIBits(hDC, hBitmap, 0, bitmap.bmHeight, pbi->bmiColors, pbi, DIB_RGB_COLORS);

				if(bImageIsBmp || bitmap.bmBitsPixel == 32) {
					// rbg}bv 32rbgACȐꍇAwȉ:
					// 32rbg -> At@`lA24rbg -> ̐FF

					if(bitmap.bmBitsPixel == 32) {
						::ImageList_Add(m_hIcons[ICONSTATE_NORMAL], hBitmap, 0);
						hDisabledBmp = _CreateFilteredBitmap(hDC, *pbi, _SepiaFilter);
						::ImageList_Add(m_hIcons[ICONSTATE_DISABLED], hDisabledBmp, 0);
						hHotBmp = _CreateFilteredBitmap(hDC, *pbi, _SaturationFilter);
						::ImageList_Add(m_hIcons[ICONSTATE_HOT], hHotBmp, 0);
					} else {
						const COLORREF	maskColor =
							RGB(pbi->bmiColors[0].rgbRed, pbi->bmiColors[0].rgbGreen, pbi->bmiColors[0].rgbBlue);
						::ImageList_AddMasked(m_hIcons[ICONSTATE_NORMAL], hBitmap, maskColor);
						hDisabledBmp = _CreateFilteredBitmap(hDC, *pbi, _SepiaFilter);
						::ImageList_AddMasked(m_hIcons[ICONSTATE_DISABLED], hDisabledBmp, maskColor);
						hHotBmp = _CreateFilteredBitmap(hDC, *pbi, _SaturationFilter);
						::ImageList_AddMasked(m_hIcons[ICONSTATE_HOT], hHotBmp, maskColor);
					}
				} else {
					// 24rbgACȐꍇAwȉ: ACR̃}XN
					ICONINFO	iconInfo;

					::GetIconInfo(hIcon, &iconInfo);
					::ImageList_AddIcon(m_hIcons[ICONSTATE_NORMAL], hIcon);
					hDisabledBmp = iconInfo.hbmColor = _CreateFilteredBitmap(hDC, *pbi, _SepiaFilter);
					HICON	hDisabledIcon = ::CreateIconIndirect(&iconInfo);
					::ImageList_AddIcon(m_hIcons[ICONSTATE_DISABLED], hDisabledIcon);
					hHotBmp = iconInfo.hbmColor = _CreateFilteredBitmap(hDC, *pbi, _SaturationFilter);
					HICON	hHotIcon = ::CreateIconIndirect(&iconInfo);
					::ImageList_AddIcon(m_hIcons[ICONSTATE_HOT], hHotIcon);
					::DestroyIcon(hDisabledIcon);
					::DestroyIcon(hHotIcon);
				}

				::DeleteObject(hDisabledBmp);
				::DeleteObject(hHotBmp);
				return_temporary_buffer(pbi);
				::ReleaseDC(0, hDC);
			} else {	// 24rbg
				HDC						hDC = ::GetDC(0);
				pair<HBITMAP, COLORREF>	result = _CreateFilteredBitmap(hDC, hBitmap, _SepiaFilter);
				ICONINFO				iconInfo;

				if(bImageIsBmp) {
					::ImageList_AddMasked(m_hIcons[ICONSTATE_NORMAL], hBitmap, result.second);
					::ImageList_AddMasked(m_hIcons[ICONSTATE_DISABLED], result.first, result.second);
				} else {
					::GetIconInfo(hIcon, &iconInfo);
					iconInfo.hbmColor = result.first;
					::ImageList_AddIcon(m_hIcons[ICONSTATE_NORMAL], hIcon);
					HICON	hDisabledIcon = ::CreateIconIndirect(&iconInfo);
					::ImageList_AddIcon(m_hIcons[ICONSTATE_DISABLED], hDisabledIcon);
					::DestroyIcon(hDisabledIcon);
				}
				::DeleteObject(result.first);
				result = _CreateFilteredBitmap(hDC, hBitmap, _SaturationFilter);
				if(bImageIsBmp)
					::ImageList_AddMasked(m_hIcons[ICONSTATE_HOT], result.first, result.second);
				else {
					iconInfo.hbmColor = result.first;
					HICON	hHotIcon = ::CreateIconIndirect(&iconInfo);
					::ImageList_AddIcon(m_hIcons[ICONSTATE_HOT], hHotIcon);
					::DestroyIcon(hHotIcon);
				}

				::DeleteObject(result.first);
				::ReleaseDC(0, hDC);
			}

			if(bImageIsBmp)
				::DeleteObject(hBitmap);
			else
				::DestroyIcon(hIcon);
		}
	} while(toBoolean(::FindNextFileW(hFind, &wfd)));
	::FindClose(hFind);

	::ImageList_SetBkColor(m_hIcons[ICONSTATE_NORMAL], CLR_NONE);
	::ImageList_SetBkColor(m_hIcons[ICONSTATE_DISABLED], CLR_NONE);
	::ImageList_SetBkColor(m_hIcons[ICONSTATE_HOT], CLR_NONE);

	return true;
}

/**
 *	R}hs
 *	@param id			R}h ID
 *	@param bUserContext	R}h̃ReLXg
 */
void CCommandManager::ExecuteCommand(CommandId id, bool bUserContext) {
	if(!IsEnabled(id, bUserContext))
		return;

	CAlphaView&		view = m_app.GetActiveView();
	CAlphaDoc&		buffer = view.GetDocument();

	switch(id) {
	case CMD_FILE_NEW:				m_app.NewBuffer();										break;
	case CMD_FILE_NEWWITHFORMAT:	m_app.NewBufferWithFormat();							break;
	case CMD_FILE_OPEN:				m_app.OpenFile();										break;
	case CMD_FILE_CLOSE:			m_app.CloseBuffer(m_app.GetActiveBufferIndex(), true);	break;
	case CMD_FILE_CLOSEALL:			m_app.CloseAllBuffers(true, false);						break;
	case CMD_FILE_SAVE:				m_app.SaveBuffer(m_app.GetActiveBufferIndex());			break;
	case CMD_FILE_SAVEAS:
		if(m_app.SaveBufferWithName(m_app.GetActiveBufferIndex()))
			m_app.ApplyDocumentType(m_app.GetActiveBufferIndex());
		break;
	case CMD_FILE_SAVEALL:				m_app.SaveAllBuffers();									break;
	case CMD_FILE_REOPEN:				m_app.ReopenFile(m_app.GetActiveBufferIndex(), false);	break;
	case CMD_FILE_REOPENWITHCODEPAGE:	m_app.ReopenFile(m_app.GetActiveBufferIndex(), true);	break;
	case CMD_FILE_EXIT:					m_app.GetMainWindow().PostMessage(WM_CLOSE);			break;
	case CMD_FILE_PROPERTY: {
		CFilePropertyDlg	dlg(buffer);
		dlg.Create(m_app.m_hInstance, m_app.GetMainWindow());
		dlg.DoModal();
		break;
	}
	case CMD_FILE_RENAME:
	case CMD_FILE_MOVE:
	case CMD_FILE_COPY:
	case CMD_FILE_DELETE:				m_app.OperateActiveFile(id);	break;
	case CMD_FILE_SENDMAIL:				
		buffer.Send(toBoolean(m_app.GetProfileInt(L"File", L"sendMailAsAttachment", 1)));
		break;
	case CMD_FILE_CLOSEOTHERS:			m_app.CloseAllBuffers(true, true);	break;

	case CMD_EDIT_DELETE:					CDeletionCommand(view, CDeletionCommand::NEXT_CHARACTER).Execute();		break;
	case CMD_EDIT_BACKSPACE:				CDeletionCommand(view, CDeletionCommand::PREVIOUS_CHARACTER).Execute();	break;
	case CMD_EDIT_DELETETONEXTWORD:			CDeletionCommand(view, CDeletionCommand::NEXT_WORD).Execute();			break;
	case CMD_EDIT_DELETETOPREVWORD:			CDeletionCommand(view, CDeletionCommand::PREVIOUS_WORD).Execute();		break;
	case CMD_EDIT_DELETELINE:				CDeletionCommand(view, CDeletionCommand::WHOLE_LINE).Execute();			break;
	case CMD_EDIT_INSERTPREVLINE:			CLineBreakCommand(view, true).Execute();	break;
	case CMD_EDIT_BREAK:					CLineBreakCommand(view, false).Execute();	break;
	case CMD_EDIT_UNDO:						CUndoCommand(view, true).Execute();		break;
	case CMD_EDIT_REDO:						CUndoCommand(view, false).Execute();	break;
	case CMD_EDIT_CUT:						CClipboardCommand(view, CClipboardCommand::CUT, true).Execute();	break;
	case CMD_EDIT_COPY:						CClipboardCommand(view, CClipboardCommand::COPY, true).Execute();	break;
	case CMD_EDIT_PASTE:					CClipboardCommand(view, CClipboardCommand::PASTE, false).Execute();	break;
	case CMD_EDIT_PASTEFROMCLIPBOARDRING:	CClipboardCommand(view, CClipboardCommand::PASTE, true).Execute();	break;
	case CMD_EDIT_INSERTTAB:				StandardCommands::CCharacterInputCommand(view, L'\t').Execute();	break;
	case CMD_EDIT_DELETETAB:				CIndentationCommand(view, false, true, 1).Execute();	break;
	case CMD_EDIT_TABIFY:					CTabifyCommand(view, true).Execute();	break;
	case CMD_EDIT_UNTABIFY:					CTabifyCommand(view, false).Execute();	break;
	case CMD_EDIT_CHARTOCODEPOINT:			CCharacterCodePointConversionCommand(view, true).Execute();		break;
	case CMD_EDIT_CODEPOINTTOCHAR:			CCharacterCodePointConversionCommand(view, false).Execute();	break;
	case CMD_EDIT_MAKENEXTGRAVE:		CNextInputVariationCommand(view, NCV_GRAVE).Execute();			break;
	case CMD_EDIT_MAKENEXTACUTE:		CNextInputVariationCommand(view, NCV_ACUTE).Execute();			break;
	case CMD_EDIT_MAKENEXTCIRCUMFLEX:	CNextInputVariationCommand(view, NCV_CIRCUMFLEX).Execute();		break;
	case CMD_EDIT_MAKENEXTTILDE:		CNextInputVariationCommand(view, NCV_TILDE).Execute();			break;
	case CMD_EDIT_MAKENEXTMACRON:		CNextInputVariationCommand(view, NCV_MACRON).Execute();			break;
	case CMD_EDIT_MAKENEXTBREVE:		CNextInputVariationCommand(view, NCV_BREVE).Execute();			break;
	case CMD_EDIT_MAKENEXTDIAERESIS:	CNextInputVariationCommand(view, NCV_DIAERESIS).Execute();		break;
	case CMD_EDIT_MAKENEXTCARON:		CNextInputVariationCommand(view, NCV_CARON).Execute();			break;
	case CMD_EDIT_MAKENEXTCEDILLA:		CNextInputVariationCommand(view, NCV_CEDILLA).Execute();		break;
	case CMD_EDIT_MAKENEXTSUPER:		CNextInputVariationCommand(view, NCV_SUPERSCRIPT).Execute();	break;
	case CMD_EDIT_MAKENEXTSUB:			CNextInputVariationCommand(view, NCV_SUBSCRIPT).Execute();		break;
	case CMD_EDIT_RECOMPOSE:			CReconversionCommand(view).Execute();	break;
	case CMD_EDIT_TOGGLEOVERTYPEMODE:
		CInputStatusToggleCommand(view, CInputStatusToggleCommand::OVERTYPE_MODE).Execute();
		m_app._UpdateStatusBar(SBP_OVERTYPEMODE);
		break;
	case CMD_EDIT_OPENCANDIDATEWINDOW:	COpenCompletionWindowCommand(view).Execute();	break;
	case CMD_EDIT_HOME:			CCaretMovementCommand(view, CCaretMovementCommand::START_OF_DOCUMENT, false).Execute();		break;
	case CMD_EDIT_END:			CCaretMovementCommand(view, CCaretMovementCommand::END_OF_DOCUMENT, false).Execute();		break;
	case CMD_EDIT_LINEHOME:		CCaretMovementCommand(view, CCaretMovementCommand::START_OF_LINE, false).Execute();			break;
	case CMD_EDIT_LINEEND:		CCaretMovementCommand(view, CCaretMovementCommand::END_OF_LINE, false).Execute();			break;
	case CMD_EDIT_FIRSTCHAR:	CCaretMovementCommand(view, CCaretMovementCommand::FIRST_CHAR_OF_LINE, false).Execute();	break;
	case CMD_EDIT_LASTCHAR:		CCaretMovementCommand(view, CCaretMovementCommand::LAST_CHAR_OF_LINE, false).Execute();		break;
	case CMD_EDIT_FIRSTCHARORLINEHOME:	CCaretMovementCommand(view, CCaretMovementCommand::START_OR_FIRST_OF_LINE, false).Execute();	break;
	case CMD_EDIT_LASTCHARORLINEEND:	CCaretMovementCommand(view, CCaretMovementCommand::END_OR_LAST_OF_LINE, false).Execute();		break;
	case CMD_EDIT_CHARNEXT:		CCaretMovementCommand(view, CCaretMovementCommand::RIGHT_CHARACTER, false).Execute();	break;
	case CMD_EDIT_CHARPREV:		CCaretMovementCommand(view, CCaretMovementCommand::LEFT_CHARACTER, false).Execute();	break;
	case CMD_EDIT_WORDENDNEXT:	CCaretMovementCommand(view, CCaretMovementCommand::RIGHT_WORDEND, false).Execute();		break;
	case CMD_EDIT_WORDENDPREV:	CCaretMovementCommand(view, CCaretMovementCommand::LEFT_WORDEND, false).Execute();		break;
	case CMD_EDIT_WORDNEXT:		CCaretMovementCommand(view, CCaretMovementCommand::RIGHT_WORD, false).Execute();		break;
	case CMD_EDIT_WORDPREV:		CCaretMovementCommand(view, CCaretMovementCommand::LEFT_WORD, false).Execute();			break;
	case CMD_EDIT_LINEDOWN:		CCaretMovementCommand(view, CCaretMovementCommand::NEXT_LINE, false).Execute();				break;
	case CMD_EDIT_LINEUP:		CCaretMovementCommand(view, CCaretMovementCommand::PREVIOUS_LINE, false).Execute();			break;
	case CMD_EDIT_PAGEDOWN:		CCaretMovementCommand(view, CCaretMovementCommand::NEXT_PAGE, false).Execute();				break;
	case CMD_EDIT_PAGEUP:		CCaretMovementCommand(view, CCaretMovementCommand::PREVIOUS_PAGE, false).Execute();			break;
	case CMD_EDIT_HOMEEXTEND:			CCaretMovementCommand(view, CCaretMovementCommand::START_OF_DOCUMENT, true).Execute();	break;
	case CMD_EDIT_ENDEXTEND:			CCaretMovementCommand(view, CCaretMovementCommand::END_OF_DOCUMENT, true).Execute();	break;
	case CMD_EDIT_LINEHOMEEXTEND:		CCaretMovementCommand(view, CCaretMovementCommand::START_OF_LINE, true).Execute();		break;
	case CMD_EDIT_LINEENDEXTEND:		CCaretMovementCommand(view, CCaretMovementCommand::END_OF_LINE, true).Execute();		break;
	case CMD_EDIT_FIRSTCHAREXTEND:		CCaretMovementCommand(view, CCaretMovementCommand::FIRST_CHAR_OF_LINE, true).Execute();	break;
	case CMD_EDIT_LASTCHAREXTEND:		CCaretMovementCommand(view, CCaretMovementCommand::LAST_CHAR_OF_LINE, true).Execute();		break;
	case CMD_EDIT_FIRSTCHARORLINEHOMEEXTEND:	CCaretMovementCommand(view, CCaretMovementCommand::START_OR_FIRST_OF_LINE, true).Execute();	break;
	case CMD_EDIT_LASTCHARORLINEENDEXTEND:		CCaretMovementCommand(view, CCaretMovementCommand::END_OR_LAST_OF_LINE, true).Execute();	break;
	case CMD_EDIT_CHARNEXTEXTEND:		CCaretMovementCommand(view, CCaretMovementCommand::RIGHT_CHARACTER, true).Execute();		break;
	case CMD_EDIT_CHARPREVEXTEND:		CCaretMovementCommand(view, CCaretMovementCommand::LEFT_CHARACTER, true).Execute();	break;
	case CMD_EDIT_WORDENDNEXTEXTEND:	CCaretMovementCommand(view, CCaretMovementCommand::RIGHT_WORDEND, true).Execute();	break;
	case CMD_EDIT_WORDENDPREVEXTEND:	CCaretMovementCommand(view, CCaretMovementCommand::LEFT_WORDEND, true).Execute();	break;
	case CMD_EDIT_WORDNEXTEXTEND:		CCaretMovementCommand(view, CCaretMovementCommand::RIGHT_WORD, true).Execute();		break;
	case CMD_EDIT_WORDPREVEXTEND:		CCaretMovementCommand(view, CCaretMovementCommand::LEFT_WORD, true).Execute();		break;
	case CMD_EDIT_LINEDOWNEXTEND:		CCaretMovementCommand(view, CCaretMovementCommand::NEXT_LINE, true).Execute();		break;
	case CMD_EDIT_LINEUPEXTEND:			CCaretMovementCommand(view, CCaretMovementCommand::PREVIOUS_LINE, true).Execute();	break;
	case CMD_EDIT_PAGEDOWNEXTEND:		CCaretMovementCommand(view, CCaretMovementCommand::NEXT_PAGE, true).Execute();		break;
	case CMD_EDIT_PAGEUPEXTEND:			CCaretMovementCommand(view, CCaretMovementCommand::PREVIOUS_PAGE, true).Execute();	break;
	case CMD_EDIT_SELECTALL:			CSelectionCreationCommand(view, CSelectionCreationCommand::ALL).Execute();			break;
	case CMD_EDIT_SELECTCURRENTWORD:	CSelectionCreationCommand(view, CSelectionCreationCommand::CURRENT_WORD).Execute();	break;
	case CMD_EDIT_CANCELSELECTION:		CCancelCommand(view).Execute();	break;
	case CMD_EDIT_SCROLLHOME:			view.SendMessage(WM_VSCROLL, SB_TOP);		break;
	case CMD_EDIT_SCROLLEND:			view.SendMessage(WM_VSCROLL, SB_BOTTOM);	break;
	case CMD_EDIT_SCROLLLINEDOWN:		view.SendMessage(WM_VSCROLL, SB_LINEDOWN);	break;
	case CMD_EDIT_SCROLLLINEUP:			view.SendMessage(WM_VSCROLL, SB_LINEUP);	break;
	case CMD_EDIT_SCROLLPAGEDOWN:		view.SendMessage(WM_VSCROLL, SB_PAGEDOWN);	break;
	case CMD_EDIT_SCROLLPAGEUP:			view.SendMessage(WM_VSCROLL, SB_PAGEUP);	break;
	case CMD_EDIT_SCROLLCOLUMNNEXT:		view.SendMessage(WM_HSCROLL, SB_RIGHT);		break;
	case CMD_EDIT_SCROLLCOLUMNPREV:		view.SendMessage(WM_HSCROLL, SB_LEFT);		break;
	case CMD_EDIT_ENSURECARETCENTER:	view.GetSelection().GetActivePoint().Center(view);	break;
	case CMD_EDIT_ENSURECARETVISIBLE:	view.GetSelection().GetActivePoint().Reveal(view);	break;
	case CMD_EDIT_ROWCHARNEXT:			CRowSelectionExtensionCommand(view, CRowSelectionExtensionCommand::RIGHT_CHARACTER).Execute();	break;
	case CMD_EDIT_ROWCHARPREV:			CRowSelectionExtensionCommand(view, CRowSelectionExtensionCommand::LEFT_CHARACTER).Execute();	break;
	case CMD_EDIT_ROWLINEDOWN:			CRowSelectionExtensionCommand(view, CRowSelectionExtensionCommand::NEXT_LINE).Execute();	break;
	case CMD_EDIT_ROWLINEEND:			CRowSelectionExtensionCommand(view, CRowSelectionExtensionCommand::END_OF_LINE).Execute();	break;
	case CMD_EDIT_ROWLINEHOME:			CRowSelectionExtensionCommand(view, CRowSelectionExtensionCommand::START_OF_LINE).Execute();	break;
	case CMD_EDIT_ROWLINEUP:			CRowSelectionExtensionCommand(view, CRowSelectionExtensionCommand::PREVIOUS_LINE).Execute();	break;
	case CMD_EDIT_ROWWORDENDNEXT:		CRowSelectionExtensionCommand(view, CRowSelectionExtensionCommand::RIGHT_WORDEND).Execute();	break;
	case CMD_EDIT_ROWWORDENDPREV:		CRowSelectionExtensionCommand(view, CRowSelectionExtensionCommand::LEFT_WORDEND).Execute();	break;
	case CMD_EDIT_ROWWORDNEXT:			CRowSelectionExtensionCommand(view, CRowSelectionExtensionCommand::RIGHT_WORD).Execute();	break;
	case CMD_EDIT_ROWWORDPREV:			CRowSelectionExtensionCommand(view, CRowSelectionExtensionCommand::LEFT_WORD).Execute();	break;
	case CMD_EDIT_CHARFROMABOVELINE:	CCharacterInputFromNextLineCommand(view, false).Execute();	break;
	case CMD_EDIT_CHARFROMBELOWLINE:	CCharacterInputFromNextLineCommand(view, true).Execute();	break;
	case CMD_EDIT_TRANSPOSELINES:		CTranspositionCommand(view, CTranspositionCommand::LINES).Execute();		break;
	case CMD_EDIT_TRANSPOSECHARS:		CTranspositionCommand(view, CTranspositionCommand::CHARACTERS).Execute();	break;
	case CMD_EDIT_TRANSPOSEWORDS:		CTranspositionCommand(view, CTranspositionCommand::WORDS).Execute();		break;
	case CMD_EDIT_SHOWABBREVIATIONDLG:	{
		CAbbreviationsDlg	dlg;
		dlg.Create(reinterpret_cast<HINSTANCE>(m_app.GetMainWindow().GetWindowLong(GWL_HINSTANCE)), m_app.GetMainWindow());
		dlg.DoModal();
		break;
	}
	case CMD_EDIT_NARROWTOSELECTION:
		buffer.Narrow(view.GetSelection().GetRange());
		m_app._UpdateStatusBar(SBP_NARROWING);
		break;
	case CMD_EDIT_WIDEN:
		buffer.Widen();
		m_app._UpdateStatusBar(SBP_NARROWING);
		break;

	case CMD_SEARCH_FIND:			m_app.ShowSearchDialog();								break;
	case CMD_SEARCH_FINDNEXT:		m_app.SearchNext(true, m_app.m_bShowMessageBoxOnFind);	break;
	case CMD_SEARCH_FINDPREV:		m_app.SearchNext(false, m_app.m_bShowMessageBoxOnFind);	break;
	case CMD_SEARCH_REPLACEANDNEXT:	m_app.ReplaceAndSearchNext();							break;
	case CMD_SEARCH_REPLACEALL:		m_app.ReplaceAll();										break;
	case CMD_SEARCH_BOOKMARKALL:	m_app.SearchAndBookmarkAll();							break;
	case CMD_SEARCH_REVOKEMARK:		view.HighlightMatchTexts(false);						break;
	case CMD_SEARCH_GOTOLINE:
		if(!m_app.m_pdlgGotoLine->IsWindow()) {
			m_app.m_pdlgGotoLine->DoModeless();
			m_app.PushModelessDialog(*m_app.m_pdlgGotoLine);
		} else {
			m_app.m_pdlgGotoLine->EndDialog(IDCANCEL);
			m_app.PopModelessDialog(*m_app.m_pdlgGotoLine);
		}
		break;
	case CMD_SEARCH_TOGGLEBOOKMARK:		CBookmarkCommand(view, CBookmarkCommand::TOGGLE_CURRENT_LINE).Execute();	break;
	case CMD_SEARCH_NEXTBOOKMARK:		CCaretMovementCommand(view, CCaretMovementCommand::NEXT_BOOKMARK).Execute();		break;
	case CMD_SEARCH_PREVBOOKMARK:		CCaretMovementCommand(view, CCaretMovementCommand::PREVIOUS_BOOKMARK).Execute();	break;
	case CMD_SEARCH_CLEARBOOKMARKS:		CBookmarkCommand(view, CBookmarkCommand::CLEAR_ALL).Execute();				break;
	case CMD_SEARCH_MANAGEBOOKMARKS:
		if(!m_app.m_pdlgBookmark->IsWindow()) {
			m_app.m_pdlgBookmark->DoModeless();
			m_app.PushModelessDialog(*m_app.m_pdlgBookmark);
			if(toBoolean(GetProfileInt(L"View", L"applyMainFontToSomeControls", 1)))
				m_app.m_pdlgBookmark->SendDlgItemMessage(IDC_LIST_BOOKMARKS,
					WM_SETFONT, reinterpret_cast<WPARAM>(m_app.m_hCommonFont), true);
		} else {
			m_app.m_pdlgBookmark->EndDialog(IDCANCEL);
			m_app.PopModelessDialog(*m_app.m_pdlgBookmark);
		}
		break;
	case CMD_SEARCH_GOTOMATCHBRACKET:		CCaretMovementCommand(view, CCaretMovementCommand::MATCH_BRACKET, false).Execute();	break;
	case CMD_SEARCH_EXTENDTOMATCHBRACKET:	CCaretMovementCommand(view, CCaretMovementCommand::MATCH_BRACKET, true).Execute();	break;
	case CMD_SEARCH_INCREMENTALSEARCH:		CIncrementalSearchCommand(view, CIncrementalSearcher::LITERAL_FORWARD, &m_app).Execute();	break;
	case CMD_SEARCH_INCREMENTALSEARCHR:		CIncrementalSearchCommand(view, CIncrementalSearcher::LITERAL_BACKWARD, &m_app).Execute();	break;
	case CMD_SEARCH_INCREMENTALSEARCHRF:	CIncrementalSearchCommand(view, CIncrementalSearcher::REGEXP_FORWARD, &m_app).Execute();	break;
	case CMD_SEARCH_INCREMENTALSEARCHRR:	CIncrementalSearchCommand(view, CIncrementalSearcher::REGEXP_BACKWARD, &m_app).Execute();	break;
	case CMD_SEARCH_INCREMENTALSEARCHMF:	CIncrementalSearchCommand(view, CIncrementalSearcher::MIGEMO_FORWARD, &m_app).Execute();	break;
	case CMD_SEARCH_INCREMENTALSEARCHMR:	CIncrementalSearchCommand(view, CIncrementalSearcher::MIGEMO_BACKWARD, &m_app).Execute();	break;

	case CMD_VIEW_TOOLBAR: {
		CHECK_REBAR_BAND_VISIBILITY(0);
		m_app.m_rebar.ShowBand(0, !bVisible);
		}
		break;
	case CMD_VIEW_STATUSBAR:
		m_app.m_statusBar.ShowWindow(m_app.m_statusBar.IsWindowVisible() ? SW_HIDE : SW_SHOW);
		m_app.OnSize(SIZE_RESTORED, -1, -1);
		break;
	case CMD_VIEW_BUFFERBAR: {
		CHECK_REBAR_BAND_VISIBILITY(1);
		m_app.m_rebar.ShowBand(1, !bVisible);
		}
		break;
/*	case CMD_VIEW_NOWRAP:				pView->SetWrapMode(WPM_NONE);				break;
	case CMD_VIEW_WRAPBYSPECIFIEDWIDTH:	pView->SetWrapMode(WPM_SPECIFIED);			break;
	case CMD_VIEW_WRAPBYWINDOWWIDTH:	pView->SetWrapMode(WPM_WINDOW);				break;*/
//	case CMD_VIEW_REFRESH:				m_app.GetDocumentManager().GetActiveDocument()->RefreshWindow();	break;
	case CMD_VIEW_SPLITNS: {
		CEditorPane&	activePane = m_app.GetEditorPane().GetActivePane();
		m_app.GetEditorPane().SplitNS(activePane, *(new CEditorPane(activePane)));
		}
		break;
	case CMD_VIEW_SPLITWE: {
		CEditorPane&	activePane = m_app.GetEditorPane().GetActivePane();
		m_app.GetEditorPane().SplitWE(activePane, *(new CEditorPane(activePane)));
		}
		break;
	case CMD_VIEW_UNSPLITOTHERS:	m_app.GetEditorPane().RemoveInactivePanes();	break;
	case CMD_VIEW_UNSPLITACTIVE:	m_app.GetEditorPane().RemoveActivePane();		break;
	case CMD_VIEW_NEXTPANE:			m_app.GetEditorPane().ActivateNextPane();		break;
	case CMD_VIEW_PREVPANE:			m_app.GetEditorPane().ActivatePreviousPane();	break;
	case CMD_VIEW_NEXTBUFFER:
		if(m_app.GetBufferList().GetCount() > 1) {
			size_t	iBuffer = m_app.GetActiveBufferIndex();
			iBuffer = (iBuffer + 1 != m_app.GetBufferList().GetCount()) ? iBuffer + 1 : 0;
			m_app.SetActiveBuffer(iBuffer);
		}
		break;
	case CMD_VIEW_PREVBUFFER:
		if(m_app.GetBufferList().GetCount() > 1) {
			size_t	iBuffer = m_app.GetActiveBufferIndex();
			iBuffer = (iBuffer != 0) ? iBuffer - 1 : m_app.GetBufferList().GetCount() - 1;
			m_app.SetActiveBuffer(iBuffer);
		}
		break;
	case CMD_VIEW_TOPMOSTALWAYS:
		m_app.m_pMainWindow->SetWindowPos(
			toBoolean(m_app.m_pMainWindow->GetExStyle() & WS_EX_TOPMOST) ? HWND_NOTOPMOST : HWND_TOPMOST,
			0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
		break;

//	case CMD_MACRO_RECORD:			view.GetKeyboardMacro().StartRecording();	break;
//	case CMD_MACRO_PLAY:			view.GetKeyboardMacro().Run();				break;
//	case CMD_MACRO_STOP:			view.GetKeyboardMacro().StopRecording();	break;
//	case CMD_MACRO_ABORT:			view.GetKeyboardMacro().Cancel();			break;
//	case CMD_MACRO_PAUSERESTART:	view.GetKeyboardMacro().Pause();			break;
//	case CMD_MACRO_SAVEAS:			view.CmdKeymacroSave(IDS_KEYMACROFILENAME);	break;	// TODO: L[}N̕ۑ
//	case CMD_MACRO_LIST:			break;
//	case CMD_MACRO_INTERRUPT:		m_app.m_pScriptMacroManager->Interrupt();		break;

	case CMD_TOOL_COMMONOPTION:		break;
	case CMD_TOOL_DOCTYPEOPTION:	break;
	case CMD_TOOL_FONT:				m_app._ChangeFont();			break;
	case CMD_TOOL_EXECUTE:			m_app.OnToolExecute();			break;
	case CMD_TOOL_EXECUTECOMMAND:	m_app.OnToolExecuteCommand();	break;

	case CMD_HELP_ABOUT: {
		CAboutDlg	dlg;
		dlg.Create(m_app.m_hInstance, m_app.GetMainWindow());
		dlg.DoModal();
	}

	default:
		if(id >= CMD_FILE_MRULIST_START && id < CMD_FILE_MRULIST_END) {	// [ŋߎgt@C]
			const TMRU&	file = m_app.m_pMRUManager->GetFileInfoAt(id - CMD_FILE_MRULIST_START);
			if(m_app.OpenFile(file.strFileName, file.nCodePage) == OPENFILERESULT_FAILED)
				m_app.m_pMRUManager->Remove(id - CMD_FILE_MRULIST_START);
		} else if(id >= CMD_FILE_DOCTYPELIST_START && id < CMD_FILE_DOCTYPELIST_END) {	// [VK]
			m_app.NewBuffer();
			m_app.ApplyDocumentType(m_app.GetActiveBufferIndex(),
				m_app.GetBufferList().GetDocumentTypeManager().GetAt(id - CMD_FILE_DOCTYPELIST_START).strName);
		} else if(id >= CMD_TOOL_DOCTYPELIST_START && id < CMD_TOOL_DOCTYPELIST_END)	// [Kp^Cv]
			m_app.ApplyDocumentType(m_app.GetActiveBufferIndex(),
				m_app.GetBufferList().GetDocumentTypeManager().GetAt(id - CMD_TOOL_DOCTYPELIST_START).strName);
		else if(id >= CMD_EDIT_PLUGINLIST_START && id < CMD_EDIT_PLUGINLIST_END) {	// [XNvg]
			try {
				m_app.m_pScriptMacroManager->Execute(id - CMD_EDIT_PLUGINLIST_START);
			} catch(out_of_range&) {
				// 
			} catch(CScriptMacroManager::EFailedToOpenScript& e) {
				m_app.MessageBox(MSG_FAILED_TO_OPEN_MACRO_SCRIPT, MB_ICONHAND, __MARGS__ % e.m_strFileName);
			} catch(CScriptMacroManager::EInvalidLanguage& e) {
				m_app.MessageBox(MSG_ILLEGAL_SCRIPT_LANGUAGE_NAME, MB_ICONEXCLAMATION, __MARGS__ % e.m_strLanguage);
			}
//			m_app.GetDocumentManager().GetActiveDocument()->RefreshWindow();
		}
		m_nLastCommandId = 0;	// 芸...
		m_app.m_bufferBar.RedrawWindow();
	}
	m_nLastCommandId = id;
}

/**
 *	R}h̖OԂ
 *	@param id	R}h ID
 *	@return		ǐ̍O
 */
wstring CCommandManager::GetCaption(CommandId id) const {
	wchar_t		wsz[100];
	wchar_t*	pwsz = 0;

	m_app.LoadString(id, wsz, 100);
	pwsz = wcschr(wsz, L'\n');
	if(pwsz != 0)
		*pwsz = 0;
	return wsz;
}

/**
 *	R}h̐Ԃ
 *	@param id	R}h ID
 *	@return		
 */
wstring CCommandManager::GetDescription(CommandId id) const {
	wchar_t		wsz[100];
	wchar_t*	pwsz = 0;

	m_app.LoadString(id, wsz, 100);
	pwsz = wcschr(wsz, L'\n');
	if(pwsz == 0)
		return L"";
	return pwsz + 1;
}

/**
 *	R}h`FbNԂɂ邩Ԃ
 *	@param id	R}h ID
 *	@return		`FbNĂ true
 */
bool CCommandManager::IsChecked(CommandId id) const {
	const CAlphaDoc&			buffer = m_app.GetActiveBuffer();
	const CAlphaView&			view = m_app.GetActiveView();
	const bool					bModified = buffer.IsModified();
	const bool					bReadOnly = buffer.IsReadOnly();
	const bool					bHasSelection = !view.GetSelection().IsEmpty();
//	const KeyboardMacroState	kms = view.GetKeyboardMacro().GetState();

	if(id >= CMD_VIEW_BUFFERLIST_START && id < CMD_VIEW_BUFFERLIST_END)
		return id - CMD_VIEW_BUFFERLIST_START == m_app.GetActiveBufferIndex();

	switch(id) {
	case CMD_SEARCH_FIND:
		return m_app.m_pdlgSearch->IsWindowVisible();
//	case CMD_SEARCH_REPLACE:
//		return m_app.m_pdlgSearch->IsWindowVisible() && !m_app.m_dlgFind.m_bType;
	case CMD_SEARCH_GOTOLINE:
		return m_app.m_pdlgGotoLine->IsWindowVisible();
	case CMD_SEARCH_MANAGEBOOKMARKS:
		return m_app.m_pdlgBookmark->IsWindowVisible();

	case CMD_VIEW_TOOLBAR: {
		CHECK_REBAR_BAND_VISIBILITY(0);
		return bVisible;
	}
	case CMD_VIEW_BUFFERBAR: {
		CHECK_REBAR_BAND_VISIBILITY(1);
		return bVisible;
	}
	case CMD_VIEW_STATUSBAR:
		return m_app.m_statusBar.IsWindowVisible();
	case CMD_VIEW_WRAPNO:
		return view.GetLayoutSettings().GetSettings().wrapMode == WPM_NONE;
	case CMD_VIEW_WRAPBYSPECIFIEDWIDTH:
		return view.GetLayoutSettings().GetSettings().wrapMode == WPM_SPECIFIED;
	case CMD_VIEW_WRAPBYWINDOWWIDTH:
		return view.GetLayoutSettings().GetSettings().wrapMode == WPM_WINDOW;
//	case CMD_VIEW_SPLIT:
//		return pDoc->GetController()->IsSplit();
	case CMD_VIEW_TOPMOSTALWAYS:
		return toBoolean(m_app.m_pMainWindow->GetExStyle() & WS_EX_TOPMOST);

//	case CMD_MACRO_RECORD:
//		return kms == KMS_PAUSING || kms == KMS_RECORDING;
//	case CMD_MACRO_PLAY:
//		return kms == KMS_PLAYING;
//	case CMD_MACRO_PAUSERESTART:
//		return kms == KMS_PAUSING;

	default:
		return false;
	}
}

/**
 *	R}hL (gp\) Ԃ
 *	@param id			R}h ID
 *	@param bUserContext	R}h̃ReLXg
 *	@return				Lł true
 */
bool CCommandManager::IsEnabled(CommandId id, bool bUserContext) const {
	if(id == CMD_MACRO_INTERRUPT) {
		if(!m_app.m_pScriptMacroManager->IsExecuting())
			return false;
	} else if(m_app.m_pScriptMacroManager->IsExecuting()
			&& (bUserContext || (id >= CMD_MACRO_RECORD && id < CMD_MACRO_RECORD + 1000)))
		return false;

	const CAlphaDoc&			buffer = m_app.GetActiveBuffer();
	const CAlphaView& 			view = m_app.GetActiveView();
	const bool					bModified = buffer.IsModified();
	const bool					bReadOnly = buffer.IsReadOnly();
	const bool					bHasSelection = !view.GetSelection().IsEmpty();
//	const KeyboardMacroState	kms = view.GetKeyboardMacro().GetState();

	switch(id) {
		// t@C
	case CMD_FILE_SAVE:
		return bModified && !bReadOnly;
	case CMD_FILE_SAVEALL:
		for(size_t i = 0; i < m_app.GetBufferList().GetCount(); ++i) {
			if(m_app.GetBufferList().GetAt(i).IsModified())
				return true;
		}
		return false;
	case CMD_FILE_REOPEN:
	case CMD_FILE_REOPENWITHCODEPAGE:
		return buffer.GetPathName() != 0;
	case CMD_FILE_RENAME:
		return !bReadOnly && buffer.GetPathName() != 0;
	case CMD_FILE_COPY:
		return buffer.GetPathName() != 0;
	case CMD_FILE_MOVE:
	case CMD_FILE_DELETE:
		return !bReadOnly && buffer.GetPathName() != 0;
	case CMD_FILE_SENDMAIL:
		return buffer.GetPathName() != 0
			|| !toBoolean(GetProfileInt(L"File", L"sendMailAsAttachment", 1));
	case CMD_FILE_CLOSEOTHERS:
		return m_app.GetBufferList().GetCount() > 1;

		// ҏW
	case CMD_EDIT_DELETE:
	case CMD_EDIT_BACKSPACE:
	case CMD_EDIT_DELETETONEXTWORD:
	case CMD_EDIT_DELETETOPREVWORD:
	case CMD_EDIT_DELETELINE:
	case CMD_EDIT_INSERTPREVLINE:
	case CMD_EDIT_BREAK:
		return !bReadOnly;
	case CMD_EDIT_UNDO:
		return !bReadOnly && buffer.GetUndoHistoryLength() != 0;
	case CMD_EDIT_REDO:
		return !bReadOnly && buffer.GetUndoHistoryLength(true) != 0;
	case CMD_EDIT_CUT:
		return !bReadOnly && bHasSelection;
	case CMD_EDIT_COPY:
		return bHasSelection;
	case CMD_EDIT_PASTE:
		return !bReadOnly && view.CanPaste() != 0;
	case CMD_EDIT_PASTEFROMCLIPBOARDRING:
		return !bReadOnly && view.GetClipboardRing().GetCount() != 0;
	case CMD_EDIT_INSERTTAB:
	case CMD_EDIT_DELETETAB:
		return !bReadOnly;
	case CMD_EDIT_TABIFY:
	case CMD_EDIT_UNTABIFY:
		return !bReadOnly && bHasSelection;
	case CMD_EDIT_CHARTOCODEPOINT:
	case CMD_EDIT_CODEPOINTTOCHAR:
	case CMD_EDIT_MAKENEXTGRAVE:
	case CMD_EDIT_MAKENEXTACUTE:
	case CMD_EDIT_MAKENEXTCIRCUMFLEX:
	case CMD_EDIT_MAKENEXTTILDE:
	case CMD_EDIT_MAKENEXTDIAERESIS:
	case CMD_EDIT_MAKENEXTCEDILLA:
		return !bReadOnly;
	case CMD_EDIT_RECOMPOSE:
		return !bReadOnly && bHasSelection;
	case CMD_EDIT_OPENCANDIDATEWINDOW:
	case CMD_EDIT_MAKENEXTSUPER:
	case CMD_EDIT_MAKENEXTSUB:
	case CMD_EDIT_TRANSPOSELINES:
	case CMD_EDIT_TRANSPOSECHARS:
	case CMD_EDIT_TRANSPOSEWORDS:
	case CMD_EDIT_MAKENEXTMACRON:
	case CMD_EDIT_MAKENEXTBREVE:
	case CMD_EDIT_MAKENEXTCARON:
		return !bReadOnly;
	case CMD_EDIT_NARROWTOSELECTION:
		return !view.GetSelection().IsEmpty();
	case CMD_EDIT_WIDEN:
		return buffer.IsNarrowed();

		// 
	case CMD_SEARCH_FINDNEXT:
	case CMD_SEARCH_FINDPREV:
		return view.GetIncrementalSearcher().GetState() != CIncrementalSearcher::NOT_RUNNING
			|| (m_app.m_pdlgSearch->IsWindow() &&
				::GetWindowTextLengthW(m_app.m_pdlgSearch->GetDlgItem(IDC_COMBO_FINDWHAT)) != 0);
	case CMD_SEARCH_REPLACEANDNEXT:
	case CMD_SEARCH_REPLACEALL:
		return !bReadOnly && m_app.m_pdlgSearch->IsWindow() &&
			(::GetWindowTextLengthW(m_app.m_pdlgSearch->GetDlgItem(IDC_COMBO_FINDWHAT)) != 0);
	case CMD_SEARCH_REVOKEMARK:
		return false;
//	case CMD_SEARCH_INCREMENTALSEARCHRF:
//	case CMD_SEARCH_INCREMENTALSEARCHRR:
//		return CTextSearcher::IsRegExpAvailable();
//	case CMD_SEARCH_INCREMENTALSEARCHMF:
//	case CMD_SEARCH_INCREMENTALSEARCHMR:
//		return CTextSearcher::IsMigemoAvailable();

		// \
	case CMD_VIEW_WRAPNO:
	case CMD_VIEW_WRAPBYSPECIFIEDWIDTH:
	case CMD_VIEW_WRAPBYWINDOWWIDTH:
		return false;
	case CMD_VIEW_NEXTBUFFER:
	case CMD_VIEW_PREVBUFFER:
		return m_app.GetBufferList().GetCount() > 1;
	case CMD_VIEW_UNSPLITACTIVE:
	case CMD_VIEW_UNSPLITOTHERS:
	case CMD_VIEW_NEXTPANE:
	case CMD_VIEW_PREVPANE:
		return m_app.GetEditorPane().IsSplit(m_app.GetEditorPane().GetActivePane());

		// }N
	case CMD_MACRO_RECORD:
//		return !bReadOnly && kms == KMS_NONE;
	case CMD_MACRO_PLAY:
//		return !bReadOnly && kms == KMS_NONE;
	case CMD_MACRO_STOP:
	case CMD_MACRO_ABORT:
//		return kms == KMS_RECORDING;
	case CMD_MACRO_PAUSERESTART:
//		return kms == KMS_PAUSING || kms == KMS_RECORDING;
	case CMD_MACRO_SAVEAS:
//		return kms == KMS_NONE;

		// c[
	case CMD_TOOL_COMMONOPTION:
	case CMD_TOOL_DOCTYPEOPTION:
		return false;

	default:
		return true;
	}
}

#undef CHECK_REBAR_BAND_VISIBILITY

/* [EOF] */