// CommandManager.h
// (c) 2004-2005 exeal

#ifndef _COMMAND_MANAGER_H_
#define _COMMAND_MANAGER_H_

#include "Alpha.h"
#include "AlphaScriptHost.h"
#include "AlphaInterfaces.h"
#include <map>


namespace Alpha {
	class CAlphaApp;

	///	Alpha ̑SR}hǗ
	class CCommandManager {
		// RXgN^
	public:
		CCommandManager(CAlphaApp& app);
		~CCommandManager();

		// 
	public:
		enum IconState {ICONSTATE_NORMAL, ICONSTATE_DISABLED, ICONSTATE_HOT};

		// \bh
	public:
		bool			CreateImageList(const std::wstring& strDirectory);
		void			ExecuteCommand(CommandId id, bool bUserContext);
		std::wstring	GetCaption(CommandId id) const;
		std::wstring	GetDescription(CommandId id) const;
		std::size_t		GetIconIndex(CommandId id) const;
		HIMAGELIST		GetImageList(IconState state) const;
		CommandId		GetLastCommand() const;
		bool			IsChecked(CommandId id) const;
		bool			IsEnabled(CommandId id, bool bUserContext) const;

		// f[^o
	private:
		CAlphaApp&							m_app;
		HIMAGELIST							m_hIcons[3];
		std::map<CommandId, std::size_t>	m_iconIndices;
		CommandId							m_nLastCommandId;
		static const COLORREF				m_iconMaskColor = RGB(0xFF, 0x00, 0xFF);
	};

	/// Alpha ̃R}h
	class CCommand : Manah::CNoncopyable {
	public:
		/// fXgN^
		virtual ~CCommand() {}
	public:
		/// 
		virtual CCommand* Copy() const = 0;
		/// R}hs
		virtual bool Execute() = 0;
		/// gݍ݃R}h̎ʎqԂ
		virtual CommandId GetId() const throw(std::logic_error) = 0;
		/// gݍ݃R}h𒲂ׂ
		virtual bool IsBuiltIn() const = 0;
	};

	/// L[蓖ĉ\R}h
	class CKeyAssignableCommand : virtual public CCommand {
	public:
		virtual ~CKeyAssignableCommand() {}
	public:
		virtual CKeyAssignableCommand* CopyAsKeyAssignableCommand() const = 0;
	};

	/// gݍ݃R}h
	class CBuiltInCommand : virtual public CKeyAssignableCommand {
	public:
		explicit CBuiltInCommand(CommandId id) : m_id(id) {}
	public:
		CCommand* Copy() const {return CopyAsKeyAssignableCommand();}
		CKeyAssignableCommand* CopyAsKeyAssignableCommand() const {return new CBuiltInCommand(m_id);}
		bool Execute() {
			if(CAlphaApp::GetInstance().m_pCommandManager->IsEnabled(m_id, true)) {
				CAlphaApp::GetInstance().m_pCommandManager->ExecuteCommand(m_id, true);
				return true;
			} else
				return false;
		}
		CommandId GetId() const {return m_id;}
		bool IsBuiltIn() const {return true;}
	private:
		CommandId	m_id;
	};

	/// XNvgR}h
	class CScriptletCommand : virtual public CKeyAssignableCommand {
	public:
		explicit CScriptletCommand(IDispatch* pFunction) : m_pFunction(pFunction) {
			assert(pFunction != 0);
			m_pFunction->AddRef();
		}
		~CScriptletCommand() {m_pFunction->Release();}
	public:
		CCommand* Copy() const {return CopyAsKeyAssignableCommand();}
		CKeyAssignableCommand* CopyAsKeyAssignableCommand() const {return new CScriptletCommand(m_pFunction);}
		bool Execute() {return SUCCEEDED(CAlphaScriptHost::CallFunction(*m_pFunction));}
		CommandId GetId() const {throw std::logic_error("This command is not built-in.");}
		bool IsBuiltIn() const {return false;}
	private:
		IDispatch*	m_pFunction;
	};

	/// ̓R}h
	class CCharacterInputCommand : virtual public CCommand {
	public:
		explicit CCharacterInputCommand(Ascension::CodePoint cp) : m_cp(cp) {}
	public:
		CCommand* Copy() const {return new CCharacterInputCommand(m_cp);}
		bool Execute() {return CAlphaApp::GetInstance().GetActiveView().InputCharacter(m_cp);}
		CommandId GetId() const {throw std::logic_error("This command is not built-in.");}
		bool IsBuiltIn() const {return false;}
	private:
		Ascension::CodePoint	m_cp;
	};

	/// eLXg̓R}h
	class CTextInputCommand : virtual public CCommand {
	public:
		explicit CTextInputCommand(const Ascension::string_t& text, bool bAsRectangle) : m_text(text), m_bAsRectangle(bAsRectangle) {}
	public:
		CCommand* Copy() const {return new CTextInputCommand(m_text, m_bAsRectangle);}
		bool Execute() {return CAlphaApp::GetInstance().GetActiveView().InsertText(m_text, m_bAsRectangle);}
		CommandId GetId() const {throw std::logic_error("This command is not built-in.");}
		bool IsBuiltIn() const {return false;}
	private:
		Ascension::string_t	m_text;
		bool				m_bAsRectangle;
	};

	/**
	 *	R}hɑΉACR̃C[WXg̈ʒuԂ
	 *	@param id	R}h ID
	 *	@return		CfbNXBACRꍇ -1
	 */
	inline std::size_t CCommandManager::GetIconIndex(CommandId id) const {
		std::map<CommandId, std::size_t>::const_iterator	it;
		return (m_iconIndices.end() == (it = m_iconIndices.find(id))) ? -1 : it->second;
	}

	/**
	 *	C[WXgԂBԂꂽC[WXgjҏWĂ͂ȂȂ
	 *	@param state	ACȐ
	 *	@return			C[WXg
	 */
	inline HIMAGELIST CCommandManager::GetImageList(CCommandManager::IconState state) const {
		return m_hIcons[state];
	}

	///	ŌɎsR}h̎ʒlԂ
	inline CommandId CCommandManager::GetLastCommand() const {
		return m_nLastCommandId;
	}
} // namespace Alpha

#endif /* _COMMAND_MANAGER_H_ */

/* [EOF] */