// ConfirmUnsavedDocumentDlg.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "Alpha.h"
#include "ConfirmUnsavedDocumentDlg.h"
using Alpha::CAlphaApp;
using Alpha::CConfirmUnsavedDocumentDlg;
using namespace std;


///	@see	CDialog::OnCommand
bool CConfirmUnsavedDocumentDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_LINK_SELECTALL)
		SendDlgItemMessage(IDC_LIST_DOCUMENTS, LB_SELITEMRANGEEX, 0, m_files.size() - 1);
	else if(wID == IDC_LINK_CLEARALL)
		SendDlgItemMessage(IDC_LIST_DOCUMENTS, LB_SELITEMRANGEEX, m_files.size() - 1, 0);

	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CConfirmUnsavedDocumentDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	HICON	hIcon = ::LoadIcon(0, IDI_WARNING);
	SendDlgItemMessage(IDC_STATIC_1, STM_SETICON, reinterpret_cast<WPARAM>(hIcon), 0);
	::DestroyIcon(hIcon);
	m_selectAllLink.Create(m_hWnd, ::GetModuleHandle(0), IDC_LINK_SELECTALL);
	m_selectAllLink.MoveWindow(106, 200, 0, 0);
	m_selectAllLink.SetWindowText(CAlphaApp::GetInstance().LoadString(MSG_SELECTALL).c_str());
	m_clearAllLink.Create(m_hWnd, ::GetModuleHandle(0), IDC_LINK_CLEARALL);
	m_clearAllLink.MoveWindow(186, 200, 0, 0);
	m_clearAllLink.SetWindowText(CAlphaApp::GetInstance().LoadString(MSG_UNSELECT_ALL).c_str());

	for(vector<TDirtyFile>::const_iterator it = m_files.begin(); it != m_files.end(); ++it)
		SendDlgItemMessage(IDC_LIST_DOCUMENTS, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(it->strFileName.c_str()));
	SendDlgItemMessage(IDC_LIST_DOCUMENTS, LB_SELITEMRANGEEX, 0, m_files.size() - 1);
	::MessageBeep(MB_ICONEXCLAMATION);

	return true;
}

///	@see	CDialog::OnOK
void CConfirmUnsavedDocumentDlg::OnOK() {
	const int	cSels = SendDlgItemMessage(IDC_LIST_DOCUMENTS, LB_GETSELCOUNT, 0, 0L);
	int*		pSels = new int[cSels];

	SendDlgItemMessage(IDC_LIST_DOCUMENTS, LB_GETSELITEMS, cSels, reinterpret_cast<LPARAM>(pSels));
	for(vector<TDirtyFile>::iterator it = m_files.begin(); it != m_files.end(); ++it)
		it->bSave = false;
	for(int iSel = 0; iSel < cSels; ++iSel)
		m_files[iSel].bSave = true;
	delete[] pSels;

	CDialog::OnOK();
}

/* [EOF] */