// FileOperationDlg.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "Alpha.h"
#include "FileOperationDlg.h"
using Alpha::CAlphaApp;
using Alpha::CFileOperationDlg;
using namespace std;


///	RXgN^
CFileOperationDlg::CFileOperationDlg(UINT nCommandId,
		const wstring& strFilePath) : m_nCommandId(nCommandId), m_strFilePath(strFilePath) {
}

///	@see	CDialog::OnCommand
bool CFileOperationDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wNotifyCode == EN_CHANGE) {
		::EnableWindow(GetDlgItem(IDOK),
			::GetWindowTextLength(GetDlgItem(IDC_EDIT_FILENAME)) != 0 && ::GetWindowTextLength(GetDlgItem(IDC_EDIT_DESTPATH)) != 0);
		return true;
	} else if(wID == IDC_BTN_BROWSE) {
		wchar_t			wszPath[MAX_PATH];
		const wstring	strCaption = CAlphaApp::GetInstance().LoadString(MSG_SELECT_DIRECTORY);
		BROWSEINFOW		bi = {m_hWnd, 0, wszPath, strCaption.c_str(), BIF_RETURNONLYFSDIRS, 0, 0L, 0};

		if(LPITEMIDLIST lpidl = ::SHBrowseForFolderW(&bi)) {
			::SHGetPathFromIDListW(lpidl, wszPath);
			::SetWindowTextW(GetDlgItem(IDC_EDIT_DESTPATH), wszPath);
		}
		return true;
	}
	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CFileOperationDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	HWND	hwndFileNameEdit = GetDlgItem(IDC_EDIT_FILENAME);
	HWND	hwndDestPathEdit = GetDlgItem(IDC_EDIT_DESTPATH);
	HWND	hwndBrowseButton = GetDlgItem(IDC_BTN_BROWSE);

	const CAlphaApp&	app = CAlphaApp::GetInstance();
	wostringstream		ssTitle;
	wstring::size_type	i = m_strFilePath.rfind(L'\\');

	::SetWindowText(hwndFileNameEdit, m_strFilePath.substr(i + 1).c_str());
	::SetWindowText(hwndDestPathEdit, m_strFilePath.substr(0, i).c_str());

	switch(m_nCommandId) {
	case CMD_FILE_RENAME:
		::EnableWindow(hwndBrowseButton, false);
		ssTitle << app.LoadString(MSG_RENAME_FILE);
		break;
	case CMD_FILE_COPY:	ssTitle << app.LoadString(MSG_COPY_FILE);	break;
	case CMD_FILE_MOVE:	ssTitle << app.LoadString(MSG_MOVE_FILE);	break;
	}
	ssTitle << L" - " << app.LoadString(MSG_FILE_OPERATION);

	return true;
}

///	@see	CDialog::OnOK
void CFileOperationDlg::OnOK() {
	wchar_t	wszNewName[MAX_PATH];
	wchar_t	wszToPath[MAX_PATH + 1];

	GetDlgItemText(IDC_EDIT_FILENAME, wszNewName, MAX_PATH);
	GetDlgItemText(IDC_EDIT_DESTPATH, wszToPath, MAX_PATH);
	::PathAppend(wszToPath, wszNewName);
	m_strFilePath = wszToPath;

	CDialog::OnOK();
}

/* [EOF] */