// FindDlg.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "FindDlg.h"
#include "Alpha.h"
#include <algorithm>	// std::find
#include "../Manah/ComboBox.h"
using Alpha::CAlphaApp;
using Alpha::CFindDlg;
using namespace Ascension;
using namespace std;
using Manah::Windows::Controls::CMenu;


/**
 *	RXgN^
 *	@param app	AvP[V
 */
CFindDlg::CFindDlg(const CAlphaApp& app) : m_app(app), m_optionMenu(app.LoadMenu(IDR_MENU_SEARCHOPTION)) {
	m_bUpdateHistoryOnNextActivation[0] = m_bUpdateHistoryOnNextActivation[1] = false;
}

/**
 *	ɕǉ
 *	@param strText		ǉ镶
 *	@param bIsReplace	ûƂ^
 */
void CFindDlg::AddToHistory(const string_t& strText, bool bIsReplace) {
	AssertValid();

	list<string_t>&				target = bIsReplace ? m_replaceWiths : m_findWhats;
	list<string_t>::iterator	it = find(target.begin(), target.end(), strText);

	if(it != target.end())
		target.erase(it);
	target.push_front(strText);

	if(IsWindowVisible()) {
		_UpdateHistory(bIsReplace);
		SendDlgItemMessage(bIsReplace ? IDC_COMBO_REPLACEWITH : IDC_COMBO_FINDWHAT, CB_SETCURSEL, 0, 0L);
	} else
		m_bUpdateHistoryOnNextActivation[bIsReplace ? 1 : 0] = true;
}

/**
 *	폜
 *	@param bIsReplace	ûƂ^
 */
void CFindDlg::ClearHistory(bool bIsReplace) {
	AssertValid();
	(bIsReplace ? m_replaceWiths : m_findWhats).clear();
	if(IsWindowVisible())
		_UpdateHistory(bIsReplace);
	else
		m_bUpdateHistoryOnNextActivation[bIsReplace ? 1 : 0] = true;
}

///	擾
void CFindDlg::GetHistory(list<string_t>& findWhats, list<string_t>& replaceWiths) const {
	AssertValid();
	findWhats = m_findWhats;
	replaceWiths = m_replaceWiths;
}

///	ݒ
void CFindDlg::SetHistory(const list<string_t>& findWhats, const list<string_t>& replaceWiths) {
	AssertValid();

	// d`FbNȂRs[ (sort -> unique_copy ł)
	m_findWhats.clear();
	for(list<string_t>::const_iterator it = findWhats.begin(); it != findWhats.end(); ++it) {
		if(m_findWhats.end() == find(m_findWhats.begin(), m_findWhats.end(), *it))
			m_findWhats.push_back(*it);
	}
	m_replaceWiths.clear();
	for(list<string_t>::const_iterator it = replaceWiths.begin(); it != replaceWiths.end(); ++it) {
		if(m_replaceWiths.end() == find(m_replaceWiths.begin(), m_replaceWiths.end(), *it))
			m_replaceWiths.push_back(*it);
	}

	if(IsWindowVisible()) {
		_UpdateHistory(false);
		_UpdateHistory(true);
	} else
		m_bUpdateHistoryOnNextActivation[0] = m_bUpdateHistoryOnNextActivation[1] = true;
}

/**	
 *	XgR{{bNXɔf
 *	@param	bIsReplace	ûƂ^
 */
void CFindDlg::_UpdateHistory(bool bIsReplace) {
	AssertValidAsWindow();

	const list<string_t>&				history = bIsReplace ? m_replaceWiths : m_findWhats;
	Manah::Windows::Controls::CComboBox	combobox;
	combobox.Attach(GetDlgItem(bIsReplace ? IDC_COMBO_REPLACEWITH : IDC_COMBO_FINDWHAT));
	const int		iSel = combobox.GetCurSel();
	wchar_t* const	pwszActive = (iSel == CB_ERR) ? new wchar_t[combobox.GetWindowTextLength() + 1] : 0;

	if(iSel == CB_ERR)
		combobox.GetWindowText(pwszActive, combobox.GetWindowTextLength() + 1);
	combobox.ResetContent();
	for(list<string_t>::const_iterator it = history.begin(); it != history.end(); ++it)
		combobox.AddString(it->c_str());
	if(iSel == CB_ERR) {
		combobox.SetWindowText(pwszActive);
		delete[] pwszActive;
	} else
		combobox.SetCurSel(iSel);
}

///	̍XV
void CFindDlg::UpdateOptions() {
	AssertValidAsWindow();

	CAlphaView&					activeView = m_app.GetActiveView();
	Ascension::TSearchOptions	options = activeView.GetTextSearcher().GetOptions();

//	if(IsDlgButtonChecked(IDC_CHK_ONLYIDENTIFIERS) == BST_CHECKED)
//		options.generalOptions |= SO_ONLY_IDENTIFIERS;
	options.bWholeWord = IsDlgButtonChecked(IDC_CHK_WHOLEWORD) == BST_CHECKED;
	switch(SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_GETCURSEL, 0, 0L)) {
	case 0:	options.type = ST_LITERAL;	break;
	case 1:	options.type = ST_REGEXP;	break;
	case 2:	options.type = ST_MIGEMO;	break;
	}
	switch(SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_GETCURSEL, 0, 0L)) {
	case 0:	options.caseSensitivity = CS_NONE;		break;
	case 1:	options.caseSensitivity = CS_ASCII;		break;
	case 2:	options.caseSensitivity = CS_SIMPLE;	break;
	case 3:	options.caseSensitivity = CS_FULL;		break;
	}

#define IS_OPTION_CHECKED(id, option)	\
	(toBoolean(menu.GetMenuItemState(id) & MFS_CHECKED) ? option : 0)
	{
		CMenu	menu = m_optionMenu.GetSubMenu(0).GetSubMenu(0);
		options.characterSkipOptions =
			IS_OPTION_CHECKED(IDC_CHK_IGNOREPUNCTUATIONS, CSO_PUNCTUATIONS)
			| IS_OPTION_CHECKED(IDC_CHK_IGNORESYMBOLS, CSO_SYMBOLS)
			| IS_OPTION_CHECKED(IDC_CHK_IGNORESYMBOLS, CSO_SYMBOLS)
			| IS_OPTION_CHECKED(IDC_CHK_IGNOREWHITESPACES, CSO_WHITESPACES)
			| IS_OPTION_CHECKED(IDC_CHK_IGNOREDIACRITICS, CSO_DIACRITICS)
			| IS_OPTION_CHECKED(IDC_CHK_IGNOREVOWELS, CSO_VOWELS)
			| IS_OPTION_CHECKED(IDC_CHK_IGNOREKASHIDA, CSO_KASHIDA)
			| IS_OPTION_CHECKED(IDC_CHK_IGNORECONTROLS, CSO_CONTROLS);
	}{
		CMenu	menu = m_optionMenu.GetSubMenu(0).GetSubMenu(1);
		options.foldingOptions =
			IS_OPTION_CHECKED(IDC_CHK_ACCENTREMOVAL, FO_ACCENT_REMOVAL)
			| IS_OPTION_CHECKED(IDC_CHK_ACCENTREMOVAL, FO_ACCENT_REMOVAL)
			| IS_OPTION_CHECKED(IDC_CHK_CANONICALDUPLICATESFOLDING, FO_CANONICAL_DUPLICATES)
			| IS_OPTION_CHECKED(IDC_CHK_DASHESFOLDING, FO_DASHES)
			| IS_OPTION_CHECKED(IDC_CHK_GREEKLETTERFORMSFOLDING, FO_GREEK_LETTERFORMS)
			| IS_OPTION_CHECKED(IDC_CHK_HEBREWALTERNATESFOLDING, FO_HEBREW_ALTERNATES)
			| IS_OPTION_CHECKED(IDC_CHK_JAMOFOLDING, FO_JAMO)
			| IS_OPTION_CHECKED(IDC_CHK_MATHSYMBOLFOLDING, FO_MATH_SYMBOL)
			| IS_OPTION_CHECKED(IDC_CHK_NATIVEDIGITFOLDING, FO_NATIVE_DIGIT)
			| IS_OPTION_CHECKED(IDC_CHK_NOBREAKFOLDING, FO_NOBREAK)
			| IS_OPTION_CHECKED(IDC_CHK_OVERLINEFOLDING, FO_OVERLINE)
			| IS_OPTION_CHECKED(IDC_CHK_POSITIONALFORMSFOLDING, FO_POSITIONAL_FORMS)
			| IS_OPTION_CHECKED(IDC_CHK_SMALLFORMSFOLDING, FO_SMALL_FORMS)
			| IS_OPTION_CHECKED(IDC_CHK_SPACEFOLDING, FO_SPACE)
			| IS_OPTION_CHECKED(IDC_CHK_SPACINGACCENTS, FO_SPACING_ACCENTS)
			| IS_OPTION_CHECKED(IDC_CHK_SUBSCRIPTFOLDING, FO_SUBSCRIPT)
			| IS_OPTION_CHECKED(IDC_CHK_SYMBOLFOLDING, FO_SYMBOL)
			| IS_OPTION_CHECKED(IDC_CHK_UNDERLINEFOLDING, FO_UNDERLINE)
			| IS_OPTION_CHECKED(IDC_CHK_VERTICALFORMSFOLDING, FO_VERTICAL_FORMS);
		options.provisionalFoldingOptions =
			IS_OPTION_CHECKED(IDC_CHK_DIACRITICREMOVAL, PFO_DIACRITIC_REMOVAL)
			| IS_OPTION_CHECKED(IDC_CHK_HANRADICALFOLDING, PFO_HAN_RADICAL)
			| IS_OPTION_CHECKED(IDC_CHK_KANAFOLDING, PFO_KANA)
			| IS_OPTION_CHECKED(IDC_CHK_LETTERFORMSFOLDING, PFO_LETTER_FORMS)
			| IS_OPTION_CHECKED(IDC_CHK_SIMPLIFIEDHANFOLDING, PFO_SIMPLIFIED_HAN)
			| IS_OPTION_CHECKED(IDC_CHK_SUPERSCRIPTFOLDING, PFO_SUPERSCRIPT)
			| IS_OPTION_CHECKED(IDC_CHK_SUZHOUNUMERALFOLDING, PFO_SUZHOU_NUMERAL)
			| IS_OPTION_CHECKED(IDC_CHK_WIDTHFOLDING, PFO_WIDTH);
	}{
		CMenu	menu = m_optionMenu.GetSubMenu(0).GetSubMenu(2);
		options.multigraphExpansionOptions =
			IS_OPTION_CHECKED(IDC_CHK_CIRCLEDSYMBOLSEXPANSION, MEO_CIRCLED_SYMBOLS)
			| IS_OPTION_CHECKED(IDC_CHK_DOTTED, MEO_DOTTED)
			| IS_OPTION_CHECKED(IDC_CHK_ELLIPSISEXPANSION, MEO_ELLIPSIS)
			| IS_OPTION_CHECKED(IDC_CHK_FRACTIONEXPANSION, MEO_FRACTION)
			| IS_OPTION_CHECKED(IDC_CHK_INTEGRALEXPANSION, MEO_INTEGRAL)
			| IS_OPTION_CHECKED(IDC_CHK_LIGATUREEXPANSIONMISC, MEO_LIGATURE)
			| IS_OPTION_CHECKED(IDC_CHK_PARENTHESIZED, MEO_PARENTHESIZED)
			| IS_OPTION_CHECKED(IDC_CHK_PRIMESEXPANSION, MEO_PRIMES)
			| IS_OPTION_CHECKED(IDC_CHK_ROMANNUMERALS, MEO_ROMAN_NUMERALS)
			| IS_OPTION_CHECKED(IDC_CHK_SQUARED, MEO_SQUARED)
			| IS_OPTION_CHECKED(IDC_CHK_SQUAREDUNMARKED, MEO_SQUARED_UNMARKED)
			| IS_OPTION_CHECKED(IDC_CHK_DIGRAPHS, MEO_DIGRAPH)
			| IS_OPTION_CHECKED(IDC_CHK_OTHERMULTIGRAPHS, MEO_OTHER_MULTIGRAPHS);
	}
	activeView.GetTextSearcher().SetOptions(options);
}

///	@see	CDialog::OnActivate
void CFindDlg::OnActivate(UINT nState, HWND hwndPrevious, bool bMinimize) {
	if(nState == WA_INACTIVE)
		UpdateOptions();
	else {
		const CAlphaView&		activeView = m_app.GetActiveView();
		const bool				bHasFindText = ::GetWindowTextLengthW(GetDlgItem(IDC_COMBO_FINDWHAT)) != 0;
		const bool				bHasSelection = !activeView.GetSelection().IsEmpty();
		const bool				bReadOnly = activeView.GetDocument().IsReadOnly();
		const bool				bOnlySelection = IsDlgButtonChecked(IDC_RADIO_SELECTION) == BST_CHECKED;
		const TSearchOptions&	options = activeView.GetTextSearcher().GetOptions();

		if(m_bUpdateHistoryOnNextActivation[0]) {
			_UpdateHistory(false);
			m_bUpdateHistoryOnNextActivation[0] = false;
		}
		if(m_bUpdateHistoryOnNextActivation[1]) {
			_UpdateHistory(true);
			m_bUpdateHistoryOnNextActivation[1] = false;
		}

		if(!bHasSelection)
			CheckRadioButton(IDC_RADIO_SELECTION, IDC_RADIO_WHOLEFILE, IDC_RADIO_WHOLEFILE);
		::EnableWindow(GetDlgItem(CMD_SEARCH_FINDNEXT), bHasFindText && !bOnlySelection);
		::EnableWindow(GetDlgItem(CMD_SEARCH_FINDPREV), bHasFindText && !bOnlySelection);
		::EnableWindow(GetDlgItem(CMD_SEARCH_BOOKMARKALL), bHasFindText);
		::EnableWindow(GetDlgItem(CMD_SEARCH_REPLACEANDNEXT), bHasFindText && !bOnlySelection && !bReadOnly);
		::EnableWindow(GetDlgItem(CMD_SEARCH_REPLACEALL), bHasFindText && !bReadOnly);
		::EnableWindow(GetDlgItem(IDC_RADIO_SELECTION), bHasSelection);
		CheckDlg2StateButton(IDC_CHK_WHOLEWORD, options.bWholeWord);

		if(options.type == ST_LITERAL)
			SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_SETCURSEL, 0, 0L);
		else if(options.type == ST_REGEXP)
			SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_SETCURSEL, 1, 0L);
		else if(options.type == ST_MIGEMO)
			SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_SETCURSEL, 2, 0L);

		if(options.caseSensitivity == CS_ASCII)
			SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_SETCURSEL, 1, 0L);
		else if(options.caseSensitivity == CS_SIMPLE)
			SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_SETCURSEL, 2, 0L);
		else if(options.caseSensitivity == CS_FULL)
			SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_SETCURSEL, 3, 0L);
		else
			SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_SETCURSEL, 0, 0L);

#define CHECK_IGNORANCE_OPTION(id, option)	\
	ignoranceMenu.CheckMenuItem(id, toBoolean(options.characterSkipOptions & option))
#define CHECK_FOLDING_OPTION(id, option)	\
	foldingMenu.CheckMenuItem(id, toBoolean(options.foldingOptions & option))
#define CHECK_PROVISIONAL_FOLDING_OPTION(id, option)	\
	foldingMenu.CheckMenuItem(id, toBoolean(options.provisionalFoldingOptions & option))
#define CHECK_EXPANSION_OPTION(id, option)	\
	expansionMenu.CheckMenuItem(id, toBoolean(options.multigraphExpansionOptions & option))
		CMenu	ignoranceMenu = m_optionMenu.GetSubMenu(0).GetSubMenu(0);
		CMenu	foldingMenu = m_optionMenu.GetSubMenu(0).GetSubMenu(1);
		CMenu	expansionMenu = m_optionMenu.GetSubMenu(0).GetSubMenu(2);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNOREPUNCTUATIONS, CSO_PUNCTUATIONS);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNOREPUNCTUATIONS, CSO_SYMBOLS);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNOREPUNCTUATIONS, CSO_WHITESPACES);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNOREPUNCTUATIONS, CSO_DIACRITICS);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNOREPUNCTUATIONS, CSO_VOWELS);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNOREPUNCTUATIONS, CSO_KASHIDA);
		CHECK_IGNORANCE_OPTION(IDC_CHK_IGNOREPUNCTUATIONS, CSO_CONTROLS);
		CHECK_FOLDING_OPTION(IDC_CHK_ACCENTREMOVAL, FO_ACCENT_REMOVAL);
		CHECK_FOLDING_OPTION(IDC_CHK_CANONICALDUPLICATESFOLDING, FO_CANONICAL_DUPLICATES);
		CHECK_FOLDING_OPTION(IDC_CHK_DASHESFOLDING, FO_DASHES);
		CHECK_FOLDING_OPTION(IDC_CHK_GREEKLETTERFORMSFOLDING, FO_GREEK_LETTERFORMS);
		CHECK_FOLDING_OPTION(IDC_CHK_HEBREWALTERNATESFOLDING, FO_HEBREW_ALTERNATES);
		CHECK_FOLDING_OPTION(IDC_CHK_JAMOFOLDING, FO_JAMO);
		CHECK_FOLDING_OPTION(IDC_CHK_MATHSYMBOLFOLDING, FO_MATH_SYMBOL);
		CHECK_FOLDING_OPTION(IDC_CHK_NATIVEDIGITFOLDING, FO_NATIVE_DIGIT);
		CHECK_FOLDING_OPTION(IDC_CHK_NOBREAKFOLDING, FO_NOBREAK);
		CHECK_FOLDING_OPTION(IDC_CHK_OVERLINEFOLDING, FO_OVERLINE);
		CHECK_FOLDING_OPTION(IDC_CHK_POSITIONALFORMSFOLDING, FO_POSITIONAL_FORMS);
		CHECK_FOLDING_OPTION(IDC_CHK_SMALLFORMSFOLDING, FO_SMALL_FORMS);
		CHECK_FOLDING_OPTION(IDC_CHK_SPACEFOLDING, FO_SPACE);
		CHECK_FOLDING_OPTION(IDC_CHK_SPACINGACCENTS, FO_SPACING_ACCENTS);
		CHECK_FOLDING_OPTION(IDC_CHK_SUBSCRIPTFOLDING, FO_SUBSCRIPT);
		CHECK_FOLDING_OPTION(IDC_CHK_SYMBOLFOLDING, FO_SYMBOL);
		CHECK_FOLDING_OPTION(IDC_CHK_UNDERLINEFOLDING, FO_UNDERLINE);
		CHECK_FOLDING_OPTION(IDC_CHK_VERTICALFORMSFOLDING, FO_VERTICAL_FORMS);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_DIACRITICREMOVAL, PFO_DIACRITIC_REMOVAL);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_HANRADICALFOLDING, PFO_HAN_RADICAL);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_KANAFOLDING, PFO_KANA);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_LETTERFORMSFOLDING, PFO_LETTER_FORMS);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_SIMPLIFIEDHANFOLDING, PFO_SIMPLIFIED_HAN);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_SUPERSCRIPTFOLDING, PFO_SUPERSCRIPT);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_SUZHOUNUMERALFOLDING, PFO_SUZHOU_NUMERAL);
		CHECK_PROVISIONAL_FOLDING_OPTION(IDC_CHK_WIDTHFOLDING, PFO_WIDTH);
		CHECK_EXPANSION_OPTION(IDC_CHK_CIRCLEDSYMBOLSEXPANSION, MEO_CIRCLED_SYMBOLS);
		CHECK_EXPANSION_OPTION(IDC_CHK_DOTTED, MEO_DOTTED);
		CHECK_EXPANSION_OPTION(IDC_CHK_ELLIPSISEXPANSION, MEO_ELLIPSIS);
		CHECK_EXPANSION_OPTION(IDC_CHK_FRACTIONEXPANSION, MEO_FRACTION);
		CHECK_EXPANSION_OPTION(IDC_CHK_INTEGRALEXPANSION, MEO_INTEGRAL);
		CHECK_EXPANSION_OPTION(IDC_CHK_LIGATUREEXPANSIONMISC, MEO_LIGATURE);
		CHECK_EXPANSION_OPTION(IDC_CHK_PARENTHESIZED, MEO_PARENTHESIZED);
		CHECK_EXPANSION_OPTION(IDC_CHK_PRIMESEXPANSION, MEO_PRIMES);
		CHECK_EXPANSION_OPTION(IDC_CHK_ROMANNUMERALS, MEO_ROMAN_NUMERALS);
		CHECK_EXPANSION_OPTION(IDC_CHK_SQUARED, MEO_SQUARED);
		CHECK_EXPANSION_OPTION(IDC_CHK_SQUAREDUNMARKED, MEO_SQUARED_UNMARKED);
		CHECK_EXPANSION_OPTION(IDC_CHK_DIGRAPHS, MEO_DIGRAPH);
		CHECK_EXPANSION_OPTION(IDC_CHK_OTHERMULTIGRAPHS, MEO_OTHER_MULTIGRAPHS);
#undef CHECK_IGNORANCE_OPTION
#undef CHECK_FOLDING_OPTION
#undef CHECK_PROVISIONAL_FOLDING_OPTION
#undef CHECK_EXPANSION_OPTION
	}
}

///	@see	CDialog::OnCancel
void CFindDlg::OnCancel() {
	OnClose();
}

///	@see	CDialog::OnClose
void CFindDlg::OnClose() {
	::SendMessageW(GetParent(), WM_COMMAND, CMD_SEARCH_FIND, reinterpret_cast<LPARAM>(this));
//	CDialog::OnClose();
}

///	@see	CDialog::OnCommand
bool CFindDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	bool	bEnableCommandsAsOnlySelection = true;

	switch(wID) {
	case CMD_SEARCH_FINDNEXT:		// []
	case CMD_SEARCH_FINDPREV:		// [O]
	case CMD_SEARCH_BOOKMARKALL:	// [ׂă}[N]
	case CMD_SEARCH_REPLACEALL:		// [ׂĒu]
	case CMD_SEARCH_REPLACEANDNEXT:	// [u]
		::SendMessageW(GetParent(), WM_COMMAND,
			MAKEWPARAM(wID, wNotifyCode), reinterpret_cast<LPARAM>(hwndCtrl));
		return true;
	case IDC_COMBO_FINDWHAT:	// [镶]
		if(wNotifyCode != CBN_EDITCHANGE && wNotifyCode != CBN_SELCHANGE)
			break;
		if(wNotifyCode == CBN_EDITCHANGE)
			bEnableCommandsAsOnlySelection = ::GetWindowTextLength(GetDlgItem(IDC_COMBO_FINDWHAT)) != 0;
		::EnableWindow(GetDlgItem(CMD_SEARCH_BOOKMARKALL), bEnableCommandsAsOnlySelection);
		::EnableWindow(GetDlgItem(CMD_SEARCH_REPLACEALL), bEnableCommandsAsOnlySelection && !m_app.GetActiveBuffer().IsReadOnly());
		/* fall-through */
	case IDC_RADIO_WHOLEFILE:	// [t@CS]
	case IDC_RADIO_SELECTION:	// [I͈]
		if(IsDlgButtonChecked(IDC_RADIO_SELECTION))
			bEnableCommandsAsOnlySelection = false;
		::EnableWindow(GetDlgItem(CMD_SEARCH_FINDNEXT), bEnableCommandsAsOnlySelection);
		::EnableWindow(GetDlgItem(CMD_SEARCH_FINDPREV), bEnableCommandsAsOnlySelection);
		::EnableWindow(GetDlgItem(CMD_SEARCH_REPLACEANDNEXT), bEnableCommandsAsOnlySelection && !m_app.GetActiveBuffer().IsReadOnly());
		break;
	case IDC_BTN_BROWSE: {	// [gIvV]
			RECT	rc;
			::GetWindowRect(GetDlgItem(IDC_BTN_BROWSE), &rc);
			m_optionMenu.GetSubMenu(0).TrackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN, rc.left, rc.bottom, *this);
		}
		break;
	default:
		if(wID >= IDC_CHK_IGNOREPUNCTUATIONS && wID <= IDC_CHK_IGNORECONTROLS) {
			CMenu	ignoranceOptionMenu = m_optionMenu.GetSubMenu(0).GetSubMenu(0);
			ignoranceOptionMenu.CheckMenuItem(wID, !toBoolean(ignoranceOptionMenu.GetMenuItemState(wID) & MFS_CHECKED));
		} else if(wID >= IDC_CHK_ACCENTREMOVAL && wID <= IDC_CHK_VERTICALFORMSFOLDING) {
			CMenu	foldingOptionMenu = m_optionMenu.GetSubMenu(0).GetSubMenu(1);
			foldingOptionMenu.CheckMenuItem(wID, !toBoolean(foldingOptionMenu.GetMenuItemState(wID) & MFS_CHECKED));
		} else if(wID >= IDC_CHK_CIRCLEDSYMBOLSEXPANSION && wID <= IDC_CHK_OTHERMULTIGRAPHS) {
			CMenu	expansionOptionMenu = m_optionMenu.GetSubMenu(0).GetSubMenu(2);
			expansionOptionMenu.CheckMenuItem(wID, !toBoolean(expansionOptionMenu.GetMenuItemState(wID) & MFS_CHECKED));
		} else if(wID >= IDC_CHK_DIACRITICREMOVAL && wID <= IDC_CHK_WIDTHFOLDING) {
			CMenu	provisionalFoldingOptionMenu = m_optionMenu.GetSubMenu(0).GetSubMenu(1);
			provisionalFoldingOptionMenu.CheckMenuItem(wID, !toBoolean(provisionalFoldingOptionMenu.GetMenuItemState(wID) & MFS_CHECKED));
		}
		break;
	}
	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CFindDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	ModifyStyleEx(0, WS_EX_LAYERED);
	SetLayeredWindowAttributes(0, 220, LWA_ALPHA);

	SendDlgItemMessage(IDC_COMBO_FINDWHAT, CB_LIMITTEXT, 255, 0L);
	SendDlgItemMessage(IDC_COMBO_REPLACEWITH, CB_LIMITTEXT, 255, 0L);

	SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_LITERAL_SEARCH).c_str()));
	SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_REGEXP_SEARCH).c_str()));
	SendDlgItemMessage(IDC_COMBO_SEARCHTYPE, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_MIGEMO_SEARCH).c_str()));

	SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_MATCH_CASE).c_str()));
	SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_IGNORE_ASCII_CASE).c_str()));
	SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_CASEFOLDING_SIMPLE).c_str()));
//	SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_ADDSTRING, 0,
//		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_CASEFOLDING_FULL).c_str()));
	CheckRadioButton(IDC_RADIO_SELECTION, IDC_RADIO_WHOLEFILE, IDC_RADIO_WHOLEFILE);

	OnCommand(IDC_COMBO_FINDWHAT, CBN_EDITCHANGE, GetDlgItem(IDC_COMBO_FINDWHAT));

	return true;
}

/* [EOF] */