// FindDlg.h
// (c) 2003-2005 exeal

#ifndef _FIND_DLG_H_
#define _FIND_DLG_H_
#include "resource.h"
#include "../Manah/Dialog.h"
#include "../Manah/Menu.h"
#include "Ascension\TextSearcher.h"
#include <list>


namespace Alpha {
	class CAlphaApp;
	class CAlphaView;

	///	[ƒu] _CAO
	class CFindDlg : public Manah::Windows::Controls::CLayered<
			Manah::Windows::Controls::CFixedIdDialog<IDD_DLG_SEARCH> > {
		// RXgN^
	public:
		CFindDlg(const CAlphaApp& app);

		// \bh
	public:
		void				AddToHistory(const Ascension::string_t& strText, bool bIsReplace);
		void				ClearHistory(bool bIsReplace);
		Ascension::string_t	GetFindText() const;
		void				GetHistory(
								std::list<Ascension::string_t>& findWhats,
								std::list<Ascension::string_t>& replaceWiths) const;
		Ascension::string_t	GetReplaceText() const;
		void				SetHistory(
								const std::list<Ascension::string_t>& findWhats,
								const std::list<Ascension::string_t>& replaceWiths);
		void				UpdateOptions();
	protected:
		void	_UpdateHistory(bool bIsReplace);

		// bZ[Wnh
	protected:
		void	OnActivate(UINT nState, HWND hwndPrevious, bool bMinimized);	// WM_ACTIVATE
		void	OnCancel();														// IDCANCEL
		void	OnClose();														// WM_CLOSE
		bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);			// WM_COMMAND
		bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);				// WM_INITDIALOG

		//f[^o
	private:
		const CAlphaApp&				m_app;
		std::list<Ascension::string_t>	m_findWhats;
		std::list<Ascension::string_t>	m_replaceWiths;
		bool							m_bUpdateHistoryOnNextActivation[2];
		Manah::Windows::Controls::CMenu	m_optionMenu;
	};


	///	Ԃ
	inline Ascension::string_t CFindDlg::GetFindText() const {
		AssertValidAsWindow();
		Ascension::char_t	wsz[256];
		GetDlgItemText(IDC_COMBO_FINDWHAT, wsz, 256);
		return wsz;
	}

	///	uԂ
	inline Ascension::string_t CFindDlg::GetReplaceText() const {
		AssertValidAsWindow();
		Ascension::char_t	wsz[256];
		GetDlgItemText(IDC_COMBO_REPLACEWITH, wsz, 256);
		return wsz;
	}
} // namespace Alpha

#endif /* _FIND_DLG_H_ */

/* [EOF] */