// GotoLineDlg.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "GotoLineDlg.h"
#include "Alpha.h"

using Alpha::CGotoLineDlg;
using Alpha::CAlphaApp;
using namespace Ascension;
using namespace std;


///	RXgN^
CGotoLineDlg::CGotoLineDlg(const CAlphaApp& app)
		: m_bLineUnit(true), m_bSaveSelection(false), m_bAutoClose(true), m_iLineNumber(1), m_app(app) {
}

///	@see	CDialog::OnActivate
void CGotoLineDlg::OnActivate(UINT nState, HWND hwndPrevious, bool bMinimized) {
	if(nState != WA_INACTIVE) {
		const CAlphaDoc&	buffer = m_app.GetActiveBuffer();
		const length_t		iTopLine = buffer.GetStartPoint().m_iLine;
		const length_t		iBottomLine = buffer.GetEndPoint().m_iLine;
		const length_t		nLineOffset = buffer.GetActiveView().GetLayoutSettings().GetSettings().lineNumberLayout.iStartLine;
		const wstring		str = m_app.LoadString(MSG_LINE_NUMBER_RANGE,
								__MARGS__ % (iTopLine + nLineOffset) % (iBottomLine + nLineOffset));
		const length_t		iLine = SendDlgItemMessage(IDC_SPIN_LINENUMBER, UDM_GETPOS, 0, 0L) - nLineOffset;

		SetDlgItemText(IDC_STATIC_1, str.c_str());
		if(iLine < iTopLine)
			SendDlgItemMessage(IDC_SPIN_LINENUMBER, UDM_SETPOS32, 0, iTopLine + nLineOffset);
		if(iLine > iBottomLine)
			SendDlgItemMessage(IDC_SPIN_LINENUMBER, UDM_SETPOS32, 0, iBottomLine + nLineOffset);
		SendDlgItemMessage(IDC_SPIN_LINENUMBER, UDM_SETRANGE32, iTopLine + nLineOffset, iBottomLine + nLineOffset);
		::InvalidateRect(GetDlgItem(IDC_SPIN_LINENUMBER), 0, true);
	}
}

///	@see	CDialog::OnClose
void CGotoLineDlg::OnClose() {
	m_iLineNumber = SendDlgItemMessage(IDC_SPIN_LINENUMBER, UDM_GETPOS, 0, 0L);
	m_bLineUnit = IsDlgButtonChecked(IDC_RADIO_LOGICALLINE) == BST_CHECKED;
	m_bSaveSelection = IsDlgButtonChecked(IDC_CHK_SAVESELECTION) == BST_CHECKED;
	m_bAutoClose = IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED;

	CDialog::OnClose();
}

///	@see	CDialog::OnInitDialog
bool CGotoLineDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	ModifyStyleEx(0, WS_EX_LAYERED);
	SetLayeredWindowAttributes(0, 220, LWA_ALPHA);

	SendDlgItemMessage(IDC_SPIN_LINENUMBER, UDM_SETRANGE32, 1, m_iLineNumber);
	SendDlgItemMessage(IDC_SPIN_LINENUMBER, UDM_SETPOS32, 0, m_iLineNumber);

	CheckRadioButton(IDC_RADIO_LOGICALLINE,
		IDC_RADIO_PHYSICALLINE, m_bLineUnit ? IDC_RADIO_LOGICALLINE : IDC_RADIO_PHYSICALLINE);
	CheckDlgButton(IDC_CHK_SAVESELECTION, m_bSaveSelection ? BST_CHECKED : BST_UNCHECKED);
	CheckDlgButton(IDC_CHK_AUTOCLOSE, m_bAutoClose ? BST_CHECKED : BST_UNCHECKED);

	return true;
}

///	@see	CDialog::OnOK()
void CGotoLineDlg::OnOK() {
	Alpha::CAlphaView&	activeView = m_app.GetActiveView();
	length_t			iLine = SendDlgItemMessage(IDC_SPIN_LINENUMBER, UDM_GETPOS, 0, 0L) - 1;

	// ړ̌
	if(IsDlgButtonChecked(IDC_RADIO_PHYSICALLINE) == BST_CHECKED)	// [\s]
		iLine = activeView.LogicalCharFromDisplayChar(CCharPos(iLine, 0)).m_iLine;

	// ړ
	if(IsDlgButtonChecked(IDC_CHK_SAVESELECTION) == BST_CHECKED)	// [Iێ]
		activeView.GetSelection().GetActivePoint().MoveTo(CCharPos(iLine, 0));
	else
		activeView.GetSelection().MoveTo(CCharPos(iLine, 0), true);

	// ㏈
	activeView.SetFocus();
	if(IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [IɃ_CAO]
		CDialog::OnOK();
}

/* [EOF] */