// KeyboardMacro.h
// (c) 2003-2005 exeal

#ifndef _KEYBOARD_MACRO_H_
#define _KEYBOARD_MACRO_H_

#include "../Manah/Object.h"
#include <list>


namespace Alpha {

	enum CommandIdentifier;

	/// L[}N̏
	enum KeyboardMacroState {
		KMS_NONE,			///< 
		KMS_PLAYING,		///< Đ
		KMS_RECORDING,		///< L^
		KMS_QUERYINGUSER,	///< ͑҂
		KMS_PAUSING,		///< L^ꎞ~
	};

	/// L[}ÑR}hP
	struct TKeyboardMacroCommand {
		CommandId	id;		///< R}h ID
	};

	/// L[}NR}h̃Xg
	typedef std::list<TKeyboardMacroCommand>	KeyboardMacroCommandList;


	/**
	 *	@brief	L[{[h}N̊Ǘ
	 *
	 *	L[{[h}N͋L^AsȂǂ̏ԂB
	 *	̃Xg KeyboardMacroState Œ`B
	 *	NCAg상\bhĂяoƂɂ̏Ԃ͕ς邪A
	 *	ԊԂ̑Jڂɂ͋KAԈŌĂяosƗO
	 *
	 *	Ԃ KMS_NONE ŁA͓ɉsĂȂԂłB
	 *	̏ԂŃ}N̋L^Jnɂ StartRecording ĂяoB
	 *	܂AL^Ă}Nsɂ Run Ăяo
	 *
	 *	}NL^̏ (KMS_RECORDING) ł
	 *	CEditView::ExecuteCommand ŎsꂽR}h̋L^sB
	 *	L^Iɂ StopRecording AL^𒆎~ċL^̓ejꍇ
	 *	CancelRecording ĂяoBԂ KMS_NONE ɑJڂB
	 *	܂A[U̓͑҂}ɂ QueryUser ĂяoB͑҂ɂĂ͌q
	 *
	 *	ꎞIɋL^𒆒fꍇ Pause Ăяo KMS_PAUSING ɑJڂB
	 *	̏Ԃł̓R}h̋L^͍sȂBL^ĊJɂ Resume ĂяoB
	 *	܂AfĂԂ CancelRecording AStopRecording ĂяoƂł
	 *
	 *	KMS_NONE ̏Ԃ RunAndAppend ĂяoƁAL^ĂesꂽA
	 *	KMS_RECORDING ɑJڂA}N̋L^JnBŋL^e͊̃}N̖ɒǉ
	 *
	 *	KMS_QUERYINGUSER ̓[U̓͑҂̏Ԃ\BL^ QueryUser ĂяoƁA
	 *	}Nsɂ̌ĂяoӏŃ}N̎sfA
	 *	ꎞIɃ[Uobt@ҏW\ȏԂɂȂ (KMS_QUERYINGUSER)B
	 *	̏Ԃ}N̎s𑱍sɂ Resume Ăяo KMS_PLAYING ɑJڂB
	 *	܂ACancel Ăяoă}N̎sI邱Ƃł
	 */
	class CKeyboardMacro : public Manah::CSelfAssertable, public Manah::CNonCopyable {
		// RXgN^
	protected:
		CKeyboardMacro(CEditView& view);

		// \bh
	public:
		/*  */
		virtual void	Cancel() throw(std::logic_error);
		virtual bool	IsRecording() const;
		virtual void	Pause() throw(std::logic_error);
		virtual void	QueryUser() throw(std::logic_error);
		virtual void	Resume() throw(std::logic_error);
		virtual void	Run() throw(std::logic_error);
		virtual void	RunAndAppendLast() throw(std::logic_error);
		virtual void	StartRecording() throw(std::logic_error);
		virtual void	StopRecording() throw(std::logic_error);
		/*  */
		KeyboardMacroState	GetState() const;
		/* iL */
		void	Export(KeyboardMacroCommandList& commands) const throw(std::logic_error);
		void	Import(const KeyboardMacroCommandList& commands) throw(std::logic_error);

		// f[^o
	protected:
		CEditView&					m_view;					// L^/sΏۂ̃r[
		KeyboardMacroCommandList	m_recordingCommands;	// L^̃R}h̃Xg
	private:
		KeyboardMacroState			m_state;				// L[}N̏
		KeyboardMacroCommandList	m_commands;				// L^ĂR}h̃Xg
		bool						m_bCanceledDuringQuery;	// ͑҂̏ԂŎs~ꂽ

		friend class CEditView;
	};


	// inline implementation
	////////////////////////////////////////////////////////////////////////////

	///	RXgN^
	inline CKeyboardMacro::CKeyboardMacro(CEditView& view) : m_view(view), m_state(KMS_NONE) {
	}

	///	L[}N̋L^As𒆎~
	/// @throw std::logic_error	L^͑҂ԂłȂ΃X[
	inline void CKeyboardMacro::Cancel() throw(std::logic_error) {
		AssertValid();
		if(m_state == KMS_RECORDING || m_state == KMS_PAUSING) {
			m_recordingCommands.clear();
			StopRecording();
		} else if(m_state == KMS_QUERYINGUSER)
			m_bCanceledDuringQuery = true;
		else
			throw std::logic_error("Key macro is not in recording.");
	}

	/// L^Ă}N (R}hXg) Ԃ
	/// @throw std::logic_error	sAL^ł΃X[
	inline void CKeyboardMacro::Export(KeyboardMacroCommandList& commands) const throw(std::logic_error) {
		AssertValid();
		if(m_state == KMS_NONE)	commands = m_commands;
		else					throw std::logic_error("Recorder is not ready to export.");
	}

	/// L[}N̏ԂԂ
	inline KeyboardMacroState CKeyboardMacro::GetState() const {
		AssertValid();	return m_state;
	}

	/// }N̓e
	/// @throw std::logic_error	sAL^ł΃X[
	inline void CKeyboardMacro::Import(const KeyboardMacroCommandList& commands) throw(std::logic_error) {
		AssertValid();
		if(m_state == KMS_NONE)	m_commands = commands;
		else					throw std::logic_error("Recorder is not ready to import.");
	}

	/// L^ł邩Ԃ
	inline bool CKeyboardMacro::IsRecording() const {
		AssertValid();
		return m_state == KMS_RECORDING || m_state == KMS_PAUSING;
	}

	///	L^̈ꎞ~AĊJ
	/// @throw std::logic_error	L^łȂ΃X[
	inline void CKeyboardMacro::Pause() {
		AssertValid();
		if(m_state == KMS_RECORDING)	m_state = KMS_PAUSING;
		else							throw std::logic_error("Key macro is not in recording.");
	}
	/// L^ꎞ~A͑҂Ԃ畜A
	/// @throw std::logic_error	L^ꎞ~A͑҂ԂłȂ΃X[
	inline void CKeyboardMacro::Resume() throw(std::logic_error) {
		AssertValid();
		if(m_state == KMS_PAUSING)				m_state = KMS_RECORDING;
		else if(m_state == KMS_QUERYINGUSER)	;	// TODO: ͑҂Ԃ̕A
		else									throw std::logic_error("Key macro is not reduced.");
	}

} // namespace Ascension

#endif /* _KEYBOARD_MACRO_H_ */

/* [EOF] */