// TextDataObject.h
// (c) 2002-2005 exeal

#ifndef _TEXT_DATA_OBJECT_H_
#define _TEXT_DATA_OBJECT_H_
#include "UnknownImpl.h"
#include "../Manah/Window.h"
#include <set>


namespace Armaiti {
namespace OLE {

// CTextDataObject class definition
/////////////////////////////////////////////////////////////////////////////

/// eLXgf[^̃hbOAhhbvɎgp IDataObject B
/// ANSI AUnicode ̗ɑΉ
class CTextDataObject : public virtual IDataObject {
	// RXgN^
public:
	CTextDataObject(IDropSource* pDropSource);
	virtual ~CTextDataObject();

	// \bh
public:
	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN_SINGLE_THREADED()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IDataObject)
	END_INTERFACE_TABLE()

	// IDataObject C^[tFCX
	STDMETHODIMP	GetData(LPFORMATETC pformatetcIn, LPSTGMEDIUM pmedium);
	STDMETHODIMP	GetDataHere(LPFORMATETC pformatetc, LPSTGMEDIUM pmedium);
	STDMETHODIMP	QueryGetData(LPFORMATETC pformatetc);
	STDMETHODIMP	GetCanonicalFormatEtc(LPFORMATETC pformatectIn, LPFORMATETC pformatetcOut);
	STDMETHODIMP	SetData(LPFORMATETC pformatetc, LPSTGMEDIUM pmedium, BOOL fRelease);
	STDMETHODIMP	EnumFormatEtc(DWORD dwDirection, LPENUMFORMATETC* ppenumFormatEtc);
	STDMETHODIMP	DAdvise(LPFORMATETC pformatetc, DWORD advf, LPADVISESINK pAdvSink, LPDWORD pdwConnection);
	STDMETHODIMP	DUnadvise(DWORD dwConnection);
	STDMETHODIMP	EnumDAdvise(LPENUMSTATDATA* ppenumAdvise);

	DWORD	DoDragDrop(DWORD dwEffect);
	void	SetTextData(const char* lpszText);
	void	SetTextData(const wchar_t* lpszText);
	void	SetAvailableFormatSet(const std::set<CLIPFORMAT>& clipFormats);

	// f[^o
private:
	IDropSource*			m_pDropSource;
	std::set<CLIPFORMAT>	m_clipFormats;
	HGLOBAL					m_hAnsiData;
	HGLOBAL					m_hUnicodeData;

	/// IDataObject::EnumFormatEtc ̖߂l
	class CAvailableFormatsEnumerator : virtual public IEnumFORMATETC {
		// RXgN^
	public:
		CAvailableFormatsEnumerator(const std::set<CLIPFORMAT>& formats);

		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN_SINGLE_THREADED()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IEnumFORMATETC)
		END_INTERFACE_TABLE()

		// IEnumFORMATETC C^[tFCX
        STDMETHODIMP	Next(ULONG celt, FORMATETC *rgelt, ULONG *pceltFetched);
        STDMETHODIMP	Skip(ULONG celt);
        STDMETHODIMP	Reset();
        STDMETHODIMP	Clone(IEnumFORMATETC** ppenum);

		// f[^o
	private:
		const std::set<CLIPFORMAT>*				m_pClipFormats;
		std::set<CLIPFORMAT>::const_iterator	m_it;
	};
};


// CTextDataObject class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param pDropSource	hbO
 */
inline CTextDataObject::CTextDataObject(IDropSource* pDropSource) : m_pDropSource(0), m_hAnsiData(0), m_hUnicodeData(0) {
	assert(pDropSource != 0);
	const HRESULT	hr = pDropSource->QueryInterface(IID_IDropSource, reinterpret_cast<void**>(&m_pDropSource));
	assert(SUCCEEDED(hr));
}

/// fXgN^
inline CTextDataObject::~CTextDataObject() {
	m_pDropSource->Release();
	if(m_hAnsiData != 0)	::GlobalFree(m_hAnsiData);
	if(m_hUnicodeData != 0)	::GlobalFree(m_hUnicodeData);
}

/// @see	IDataObject::DAdvise
inline STDMETHODIMP CTextDataObject::DAdvise(LPFORMATETC pformatetc, DWORD advf, LPADVISESINK pAdvSink, LPDWORD pdwConnection) {
	return OLE_E_ADVISENOTSUPPORTED;
}

/**
 *	hbOAhhbvJn
 *	@param dwEffect	DoDragDrop Q
 *	@return			
 */
inline DWORD CTextDataObject::DoDragDrop(DWORD dwEffect) {
	DWORD			dwEffectOwn;
	const HRESULT	hr = ::DoDragDrop(static_cast<IDataObject*>(this), m_pDropSource, dwEffect, &dwEffectOwn);
	return SUCCEEDED(hr) ? dwEffectOwn : DROPEFFECT_NONE;
}

/// @see	IDataObject::DUnadvise
inline STDMETHODIMP CTextDataObject::DUnadvise(DWORD dwConnection) {
	return OLE_E_ADVISENOTSUPPORTED;
}

/// @see	IDataObject::EnumDAdvise
inline STDMETHODIMP CTextDataObject::EnumDAdvise(LPENUMSTATDATA* ppenumAdvise) {
	return OLE_E_ADVISENOTSUPPORTED;
}

/// @see	IDataObject::EnumFormatEtc
inline STDMETHODIMP CTextDataObject::EnumFormatEtc(DWORD dwDirection, LPENUMFORMATETC* ppenumFormatEtc) {
	if(dwDirection == DATADIR_SET)
		return E_NOTIMPL;
	else if(ppenumFormatEtc == 0)
		return E_INVALIDARG;

	*ppenumFormatEtc = new CAvailableFormatsEnumerator(m_clipFormats);
	if(*ppenumFormatEtc == 0)
		return E_OUTOFMEMORY;
	(*ppenumFormatEtc)->AddRef();
	return S_OK;
}

/// @see	IDataObject::GetCanonicalFormatEtc
inline STDMETHODIMP CTextDataObject::GetCanonicalFormatEtc(LPFORMATETC pformatectIn, LPFORMATETC pformatetcOut) {
	return DATA_S_SAMEFORMATETC;
}

/// @see	IDataObject::GetData
inline STDMETHODIMP CTextDataObject::GetData(LPFORMATETC pformatetcIn, LPSTGMEDIUM pmedium) {
	if(pformatetcIn == 0 || pmedium == 0)
		return E_INVALIDARG;
	if(m_hAnsiData == 0 && m_hUnicodeData == 0)
		return OLE_E_NOTRUNNING;
	if((pformatetcIn->cfFormat != CF_TEXT && pformatetcIn->cfFormat != CF_UNICODETEXT)
			|| pformatetcIn->dwAspect != DVASPECT_CONTENT
			|| pformatetcIn->lindex != -1
			|| !toBoolean(pformatetcIn->tymed & TYMED_HGLOBAL))
		return DV_E_FORMATETC;

	// vꂽ`̃f[^܂ꍇ
	if(pformatetcIn->cfFormat == CF_TEXT && m_hAnsiData == 0) {
		const wchar_t*	pwsz = static_cast<const wchar_t*>(::GlobalLock(m_hUnicodeData));
		const int		cch = ::WideCharToMultiByte(CP_ACP, 0, pwsz, -1, 0, 0, 0, 0);
		m_hAnsiData = ::GlobalAlloc(GHND | GMEM_SHARE, sizeof(char) * cch);
		::WideCharToMultiByte(CP_ACP, 0, pwsz, -1, static_cast<char*>(::GlobalLock(m_hAnsiData)), cch, 0, 0);
		::GlobalUnlock(m_hAnsiData);
	} else if(pformatetcIn->cfFormat == CF_UNICODETEXT && m_hUnicodeData == 0) {
		const char*	psz = static_cast<const char*>(::GlobalLock(m_hAnsiData));
		const int	cch = ::MultiByteToWideChar(CP_ACP, 0, psz, -1, 0, 0);
		m_hUnicodeData = ::GlobalAlloc(GHND | GMEM_SHARE, sizeof(wchar_t) * cch);
		::MultiByteToWideChar(CP_ACP, 0, psz, -1, static_cast<wchar_t*>(::GlobalLock(m_hUnicodeData)), cch);
		::GlobalUnlock(m_hUnicodeData);
	}

	pmedium->tymed = TYMED_HGLOBAL;
	pmedium->hGlobal = (pformatetcIn->cfFormat == CF_TEXT) ? m_hAnsiData : m_hUnicodeData;
	pmedium->pUnkForRelease = 0;

	return S_OK;
}

/// @see	IDataObject::GetDataHere
inline STDMETHODIMP CTextDataObject::GetDataHere(LPFORMATETC pformatetc, LPSTGMEDIUM pmedium) {
	return E_NOTIMPL;
}

/// @see	IDataObject::QueryGetData
inline STDMETHODIMP CTextDataObject::QueryGetData(LPFORMATETC pformatetc) {
	if(pformatetc == 0)
		return E_INVALIDARG;
	if(m_clipFormats.find(pformatetc->cfFormat) == m_clipFormats.end())
		return DV_E_FORMATETC;
	if(m_hAnsiData == 0 && m_hUnicodeData == 0)
		return OLE_E_NOTRUNNING;
	if(pformatetc->lindex != -1)
		return DV_E_LINDEX;
	if(!toBoolean(pformatetc->tymed & TYMED_HGLOBAL))
		return DV_E_TYMED;
	if(pformatetc->dwAspect != DVASPECT_CONTENT)
		return DV_E_DVASPECT;

	return S_OK;
}

/**
 *	݃ZbgĂ镶擾̂ɗp\ȃNbv{[h`̐ݒ
 *	@param clipFormats	Nbv{[h`̏W
 */
inline void CTextDataObject::SetAvailableFormatSet(const std::set<CLIPFORMAT>& clipFormats) {
	m_clipFormats = clipFormats;
}

/// @see	IDataObject::SetData
inline STDMETHODIMP CTextDataObject::SetData(LPFORMATETC pformatetc, LPSTGMEDIUM pmedium, BOOL fRelease) {
	return E_NOTIMPL;
}

/**
 *	ANSI ݒ
 *	@param lpszText	Zbgݒ肷eLXg
 */
inline void CTextDataObject::SetTextData(const char* lpszText) {
	assert(lpszText != 0);

	if(m_hAnsiData != 0) {
		::GlobalFree(m_hAnsiData);
		m_hAnsiData = 0;
	}
	if(m_hUnicodeData != 0) {
		::GlobalFree(m_hUnicodeData);
		m_hUnicodeData = 0;
	}

	m_hAnsiData = ::GlobalAlloc(GHND | GMEM_SHARE, sizeof(char) * (strlen(lpszText) + 1));
	strcpy(static_cast<char*>(::GlobalLock(m_hAnsiData)), lpszText);
	::GlobalUnlock(m_hAnsiData);
	m_clipFormats.insert(CF_TEXT);
	m_clipFormats.insert(CF_UNICODETEXT);
}

/**
 *	Unicode ݒ
 *	@param lpszText	ݒ肷eLXg
 */
inline void CTextDataObject::SetTextData(const wchar_t* lpszText) {
	assert(lpszText != 0);

	if(m_hAnsiData != 0) {
		::GlobalFree(m_hAnsiData);
		m_hAnsiData = 0;
	}
	if(m_hUnicodeData != 0) {
		::GlobalFree(m_hUnicodeData);
		m_hUnicodeData = 0;
	}

	m_hUnicodeData = ::GlobalAlloc(GHND | GMEM_SHARE, sizeof(wchar_t) * (wcslen(lpszText) + 1));
	wcscpy(static_cast<wchar_t*>(::GlobalLock(m_hUnicodeData)), lpszText);
	::GlobalUnlock(m_hUnicodeData);
	m_clipFormats.insert(CF_TEXT);
	m_clipFormats.insert(CF_UNICODETEXT);
}


// CAvailableFormatsEnumerator class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
inline CTextDataObject::CAvailableFormatsEnumerator::CAvailableFormatsEnumerator(
		const std::set<CLIPFORMAT>& formats) : m_pClipFormats(&formats) {
	Reset();
}

/// @see	IEnumFORMATETC::Clone
inline STDMETHODIMP CTextDataObject::CAvailableFormatsEnumerator::Clone(IEnumFORMATETC** ppenum) {
	return E_NOTIMPL;
}

/// @see	IEnumFORMATETC::Next
inline STDMETHODIMP CTextDataObject::CAvailableFormatsEnumerator::Next(ULONG celt, FORMATETC* rgelt, ULONG* pceltFetched) {
	if(celt > 1 && pceltFetched == 0)
		return E_INVALIDARG;

	ULONG	cFetched = 0;
	while(cFetched < celt && m_it != m_pClipFormats->end()) {
		rgelt[cFetched].cfFormat = *m_it;
		rgelt[cFetched].ptd = 0;
		rgelt[cFetched].dwAspect = DVASPECT_CONTENT;
		rgelt[cFetched].lindex = -1;
		rgelt[cFetched].tymed = TYMED_HGLOBAL;
		++cFetched;
		++m_it;
	}
	if(pceltFetched != 0)
		*pceltFetched = cFetched;

	return (cFetched == celt) ? S_OK : S_FALSE;
}

/// @see	IEnumFORMATETC::Reset
inline STDMETHODIMP CTextDataObject::CAvailableFormatsEnumerator::Reset() {
	m_it = m_pClipFormats->begin();
	return S_OK;
}

/// @see	IEnumFORMATETC::Skip
inline STDMETHODIMP CTextDataObject::CAvailableFormatsEnumerator::Skip(ULONG celt) {
	while(celt != 0 && m_it != m_pClipFormats->end())
		--celt, ++m_it;
	return (celt == 0) ? S_OK : S_FALSE;
}

} /* namespace OLE */
} /* namespace Armaiti */

#endif /* _DATA_OBJECT_H_ */

/* [EOF] */