// StatusBar.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _STATUS_BAR_H_
#define _STATUS_BAR_H_

#include "Window.h"


namespace Manah {
namespace Windows {
namespace Controls {

class CStatusBar : public CCommonControl<CStatusBar> {
	DEFINE_CLASS_NAME(STATUSCLASSNAME)

	// \bh
public:
	/*  */
	bool		GetBorders(int pBorders[]) const;
	bool		GetBorders(int& nHorz, int& nVert, int& nSpacing) const;
	HICON		GetIcon(int iPane) const;
	int			GetParts(int cParts, int* pParts) const;
	bool		GetRect(int iPane, RECT& rect) const;
	int			GetText(int iPane, TCHAR* lpszText, int* pType = 0) const;
	int			GetTextLength(int iPane, int* pType = 0) const;
	void		GetTipText(int iPane, TCHAR* lpszText, int cch) const;
	bool		GetUnicodeFormat() const;
	bool		IsSimple() const;
	COLORREF	SetBkColor(COLORREF clr);
	bool		SetIcon(int iPane, HICON hIcon);
	void		SetMinHeight(int nHeight);
	bool		SetParts(int cParts, int pParts[]);
	bool		SetSimple(bool bSimple = true);
	bool		SetText(int iPane, const TCHAR* lpszText, int nType = 0);
	void		SetTipText(int iPane, const TCHAR* lpszText);
	bool		SetUnicodeFormat(bool bUnicode = true);
};


#define UNCONST_THIS	const_cast<CStatusBar*>(this)

inline bool CStatusBar::GetBorders(int pBorders[]) const {
	assert(pBorders != 0);
	return toBoolean(UNCONST_THIS->SendMessage(SB_GETBORDERS, 0, reinterpret_cast<LPARAM>(pBorders)));
}

inline bool CStatusBar::GetBorders(int& nHorz, int& nVert, int& nSpacing) const {
	int	borders[3];
	if(GetBorders(borders)) {
		nHorz = borders[0];
		nVert = borders[1];
		nSpacing = borders[2];
		return true;
	}
	return false;
}

inline HICON CStatusBar::GetIcon(int iPane) const {
	return reinterpret_cast<HICON>(UNCONST_THIS->SendMessage(SB_GETICON, iPane));
}

inline int CStatusBar::GetParts(int cParts, int* pParts) const {
	assert(pParts != 0);
	return static_cast<int>(UNCONST_THIS->SendMessage(SB_GETPARTS, cParts, reinterpret_cast<LPARAM>(pParts)));
}

inline bool CStatusBar::GetRect(int iPane, RECT& rect) const {
	return toBoolean(UNCONST_THIS->SendMessage(SB_GETRECT, iPane, reinterpret_cast<LPARAM>(&rect)));
}

inline int CStatusBar::GetText(int iPane, TCHAR* lpszText, int* pType /* = 0 */) const {
	const DWORD	dw = UNCONST_THIS->SendMessage(SB_GETTEXT, iPane, reinterpret_cast<LPARAM>(lpszText));
	if(pType != 0)
		*pType = HIWORD(dw);
	return LOWORD(dw);
}

inline int CStatusBar::GetTextLength(int iPane, int* pType /* = 0 */) const {
	const DWORD	dw = UNCONST_THIS->SendMessage(SB_GETTEXT, iPane);
	if(pType != 0)
		*pType = HIWORD(dw);
	return LOWORD(dw);
}

inline void CStatusBar::GetTipText(int iPane, TCHAR* lpszText, int cch) const {
	UNCONST_THIS->SendMessage(SB_GETTIPTEXT, MAKEWPARAM(iPane, cch), reinterpret_cast<LPARAM>(lpszText));
}

inline bool CStatusBar::GetUnicodeFormat() const {
	return toBoolean(UNCONST_THIS->SendMessage(SB_GETUNICODEFORMAT));
}

inline bool CStatusBar::IsSimple() const {
	return toBoolean(UNCONST_THIS->SendMessage(SB_ISSIMPLE));
}

inline COLORREF CStatusBar::SetBkColor(COLORREF clr) {
	return SendMessage(SB_SETBKCOLOR, clr);
}

inline bool CStatusBar::SetIcon(int iPane, HICON hIcon) {
	return toBoolean(SendMessage(SB_SETICON, iPane, reinterpret_cast<LPARAM>(hIcon)));
}

inline void CStatusBar::SetMinHeight(int nHeight) {
	SendMessage(SB_SETMINHEIGHT, nHeight);
}

inline bool CStatusBar::SetParts(int cParts, int pParts[]) {
	return toBoolean(SendMessage(SB_SETPARTS, cParts, reinterpret_cast<LPARAM>(pParts)));
}

inline bool CStatusBar::SetSimple(bool bSimple /* = true */) {
	return toBoolean(SendMessage(SB_SIMPLE, bSimple));
}

inline bool CStatusBar::SetText(int iPane, const TCHAR* lpszText, int nType /* = 0 */) {
	return toBoolean(SendMessage(SB_SETTEXT, iPane | nType, reinterpret_cast<LPARAM>(lpszText)));
}

inline void CStatusBar::SetTipText(int iPane, const TCHAR* lpszText) {
	SendMessage(SB_SETTIPTEXT, iPane, reinterpret_cast<LPARAM>(lpszText));
}

inline bool CStatusBar::SetUnicodeFormat(bool bUnicode /* = true */) {
	return toBoolean(SendMessage(SB_SETUNICODEFORMAT, bUnicode));
}


#undef UNCONST_THIS

} // namespace Controls
} // namespace Windows
} // namespace Controls

#endif /* _STATUS_BAR_H_ */

/* [EOF] */