// Text.h
// (c) 2002-2004 exeal

// ̃wb_͈ȑO܂œ{ꕶR[hϊPꋫĚA
// ̕ϊȂǂ̃Cu^ĂA
// Alpha ̐ɔAVtg JIS S̃eLXgCu͎gȂȂA
// ̊֐ʂ̃wb_ɕUꂽB
// ̃wb_͊{IȌ^` UTF-16 TQ[gCupB

#ifndef _TEXT_H_
#define _TEXT_H_

#include <stdexcept>
#include <clocale>
#include <cstdlib>
#define size_t	std::size_t
#include <mbstring.h>
#include <mbctype.h>
#undef size_t


namespace Manah {
namespace Text {

	/// Shift-JIS ɂ镶̃^Cv (KȕށBgĂȂ)
	enum SJISCharType {
		CT_CONTROL				= 0x00,	///< ASCII 䕶
		CT_SPACE				= 0x01,	///<  (0x09-0x0D 0x20)
		CT_DIGIT				= 0x10,	///< 0-9
		CT_UPPERALPHA			= 0x11,	///< A-Z
		CT_LOWERALPHA			= 0x12,	///< a-z
		CT_UNDERSCORE			= 0x13,	///< _
		CT_SYMBOL				= 0x20,	///< !"#$%&'()*+,-./:;<=>?@[\]^`{|}~
		CT_KANA_HALFWIDTH		= 0x30,	///< pJi (0xA1-0xDF)
		CT_KANA_SYMBOL			= 0x40,	///< SpL (0x8140-0x81FC, 0xFA55-57)
		CT_FULLWIDTH_DIGIT		= 0x50,	///< Sp (0x824F-0x8258)
		CT_FULLWIDTH_UPPERALPHA	= 0x51,	///< SpAt@xbg啶 (0x8260-0x8270)
		CT_FULLWIDTH_LOWERALPHA	= 0x52,	///< SpAt@xbg (0x8281-0x829A)
		CT_KANA_HIRA			= 0x60,	///<  (0x829F-0x82F1) ƐL΂ (0x8154, 0x8155)
		CT_KANA_KATA			= 0x70,	///< Љ (0x8340-0x8396) ƐL΂ (0x8152, 0x8153)
		CT_GREEK_UPPER			= 0x80,	///< SpMV啶 (0x839F-0x83B6)
		CT_GREEK_LOWER			= 0x81,	///< SpMV (0x83BF-0x83D6)
		CT_CYRILLIC_UPPER		= 0x90,	///< SpL啶 (0x8440-0x8460)
		CT_CYRILLIC_LOWER		= 0x91,	///< SpL (0x8470-0x8491)
		CT_SPECIAL_BOXDRAWING	= 0xA0,	///< r (0x849F-0x84BE)
		CT_SPECIAL_CIRCLEDDIGIT	= 0xA1,	///< ې (0x8740-0x8753)
		CT_SPECIAL_ROMANNUMERAL	= 0xA2,	///< [} (0x8754-0x875D, 0xFA40-0xFA49)
		CT_SPECIAL_UNIT			= 0xA3,	///< P (0x875F-0x8775)
		CT_SPECIAL_MATHEMATICAL	= 0xA4,	///< wL (0x8793-94, 98-99)
		CT_SPECIAL_OTHER		= 0xA5,	///< ̑̓ꕶ (0x877E-0x878F)
		CT_KANJI1				= 0xB0,	///< JIS 1 (0x889F-0x9872)
		CT_KANJI2				= 0xB1,	///< JIS 2 (0x989F-0xEA9E)
		CT_KANJI3				= 0xB2,	///<  JIS  (0xFA5C-0xFC4B)
		CT_OTHER				= 0xF0	///< ̑Asȕ
	};

	/// 悭gR[h
	enum CharCode {
		CC_AUTO,		///< (ʁAftHg)
		CC_SHIFTJIS,	///< Shift-JIS
		CC_JIS,			///< JIS
		CC_EUCJP,		///< EUC-JP
		CC_ISOKR,		///< ISO-2022-KR
		CC_ISOCN,		///< ISO-2022-CN
		CC_UTF16LE,		///< UTF-16 little endian
		CC_UTF16BE,		///< UTF-16 big endian
		CC_UTF8,		///< UTF-8
		CC_UTF7,		///< UTF-7
		CC_UTF5,		///< UTF-5
		CC_UTF32LE,		///< UTF-32 little endian
		CC_UTF32BE		///< UTF-32 big endian
	};






	/* Unicode ̕ϊ */
	wchar_t			ToUpper(wchar_t ch);
	void			ToUpper(wchar_t* psz, std::size_t cch = -1);
	wchar_t			ToLower(wchar_t ch);
	void			ToLower(wchar_t* psz, std::size_t cch = -1);
	wchar_t			ToHiragana(wchar_t ch);
	void			ToHiragana(wchar_t* psz, std::size_t cch = -1);
	wchar_t			ToKatakana(wchar_t ch);
	void			ToKatakana(wchar_t* psz, std::size_t cch = -1);
	const wchar_t	ToFullWidth(wchar_t ch);
	const wchar_t	ToHalfWidth(wchar_t ch);

	/* ̃^CvƒPꋫE */
	// ̃\bh͏I[EƂ݂ȂȂ
	SJISCharType			GetCharType(const unsigned char* pszText);
	const unsigned char*	FindWordBorder(const unsigned char* pszText,
								unsigned int iBegin = 0, bool bIgnoreSpaces = true,
								bool bReverse = false, std::size_t len = -1);
	const wchar_t*			FindWordBorder(const wchar_t* pszText,
								unsigned int iBegin = 0, bool bIgnoreSpaces = true,
								bool bReverse = false, std::size_t len = -1);
	bool					HasWordBorderAt(const unsigned char* pszText, unsigned int i);
	bool					HasWordBorderAt(const wchar_t* pszText, unsigned int i);

} // namespace Text
} // namespace Manah





/**
 *	PꋫE (Shift-JIS )
 *	@param pszText		ׂ镶
 *	@param iBegin		Jnʒu
 *	@param bIgnoreSpace	󔒂𖳎
 *	@param bReverse		璲ׂ
 *	@param len			̒
 *	@return				PꋫËʒuBȂꍇ0
 */
inline const unsigned char* Manah::Text::FindWordBorder(const unsigned char* pszText,
		unsigned int iBegin /* = 0 */, bool bIgnoreSpaces /* = true */,
		bool bReverse /* = false */, std::size_t len /* = -1 */) {
	unsigned int	i;
	SJISCharType	ct, ctPrev;

	if(len == -1)
		len = strlen(reinterpret_cast<const char*>(pszText));

	if(!bReverse) {
		ctPrev = GetCharType(pszText + iBegin);
		i = iBegin + ((ctPrev <= CT_KANA_HALFWIDTH) ? 1 : 2);
		while(i < len) {
			ct = GetCharType(pszText + i);
			if(ct == CT_SPACE && bIgnoreSpaces)	// 
				++i;
			else {
				if(((ct & 0xF0) != (ctPrev & 0xF0))
						&& !(pszText[i - 0] == 0x81 && pszText[i + 1] == 0x5B && (ctPrev == CT_KANA_HIRA || ctPrev == CT_KANA_KATA))
						&& !(pszText[i - 2] == 0x81 && pszText[i - 1] == 0x5B && (ct == CT_KANA_HIRA || ct == CT_KANA_KATA))
						&& !(pszText[i - 0] == 0x81 && pszText[i + 1] == 0x58 && (ctPrev & 0xF0) == 0xA0)
						&& !(pszText[i - 2] == 0x81 && pszText[i - 1] == 0x58 && (ct & 0xF0) == 0xA0))
					return pszText + i;
				i += (ct <= CT_KANA_HALFWIDTH) ? 1 : 2;
			}
			ctPrev = ct;
		}
	} else {
		unsigned int	iLast = 0;
		if(iBegin == 0 || iBegin > len)
			return 0;
		ctPrev = GetCharType(pszText);
		i = (ctPrev <= CT_KANA_HALFWIDTH) ? 1 : 2;
		while(i < iBegin) {
			ct = GetCharType(pszText + i);
			if(ct == CT_SPACE && bIgnoreSpaces)	// 
				++i;
			else {
				if((ct & 0xF0) != (ctPrev & 0xF0)
						&& !(pszText[i - 0] == 0x81 && pszText[i + 1] == 0x5B && (ct == CT_KANA_HIRA || ct == CT_KANA_KATA))
						&& !(pszText[i - 2] == 0x81 && pszText[i - 1] == 0x5B && (ctPrev == CT_KANA_HIRA || ctPrev == CT_KANA_KATA))
						&& !(pszText[i - 0] == 0x81 && pszText[i + 1] == 0x58 && (ct & 0xF0) == 0xA0)
						&& !(pszText[i - 2] == 0x81 && pszText[i - 1] == 0x58 && (ctPrev & 0xF0) == 0xA0))
					iLast = i;
				i += (ct <= CT_KANA_HALFWIDTH) ? 1 : 2;
			}
			ctPrev = ct;
		}
		if(iLast != 0)
			return pszText + iLast;
	}
	return 0;
}

/**
 *	PꋫE (Unicode )
 *	@param pszText		ׂ镶
 *	@param iBegin		Jnʒu
 *	@param bIgnoreSpace	󔒂𖳎
 *	@param bReverse		璲ׂ
 *	@param len			̒
 *	@return				PꋫËʒuBȂꍇ0
 */
inline const wchar_t* Manah::Text::FindWordBorder(const wchar_t* pszText,
		unsigned int iBegin /* = 0 */, bool bIgnoreSpaces /* = true */,
		bool bReverse /* = false */, std::size_t len /* = -1 */) {
	unsigned int	i;
	WORD			wCharType, wPrevCharType;
	WORD			wSpace, wPrevSpace;

	if(len == -1)
		len = wcslen(pszText);

	if(!bReverse) {
		if(pszText[iBegin] == L'_')
			wPrevCharType = 0x8040;
		else if(pszText[iBegin] == 0x3005)
			wPrevCharType = 0x8100;
		else
			::GetStringTypeW(CT_CTYPE3, pszText + iBegin, 1, &wPrevCharType);
		::GetStringTypeW(CT_CTYPE1, pszText + iBegin, 1, &wPrevSpace);
		wPrevCharType &= ~(C3_DIACRITIC | C3_VOWELMARK | C3_FULLWIDTH | C3_LEXICAL | C3_ALPHA);
		i = iBegin + 1;
		while(i < len) {
			if(pszText[i] == L'_')
				wCharType = 0x8040;
			else if(pszText[i] == 0x3005)
				wCharType = 0x8100;
			else
				::GetStringTypeW(CT_CTYPE3, pszText + i, 1, &wCharType);
			::GetStringTypeW(CT_CTYPE1, pszText + i, 1, &wSpace);
			wCharType &= ~(C3_DIACRITIC | C3_VOWELMARK | C3_FULLWIDTH | C3_LEXICAL | C3_ALPHA);
			if(bIgnoreSpaces) {
				if(!(wSpace & C1_SPACE)) {
					if(((wCharType != wPrevCharType)
							|| ((wPrevSpace & C1_SPACE) && (wSpace != wPrevSpace)))
							&& !(pszText[i - 0] == 0x30FC && wPrevCharType & 0x0030)
							&& !(pszText[i - 1] == 0x30FC && wCharType & 0x0030))
						return pszText + i;
				}
			} else if(((wCharType != wPrevCharType)
					|| ((wSpace & C1_SPACE || wPrevSpace & C1_SPACE) && (wSpace != wPrevSpace)))
					&& !(pszText[i - 0] == 0x30FC && wPrevCharType & 0x0030)
					&& !(pszText[i - 1] == 0x30FC && wCharType & 0x0030)) {
				return pszText + i;
			}
			++i;
			wPrevCharType = wCharType;
			wPrevSpace = wSpace;
		}
	} else {
		if(iBegin == 0)
			return 0;
		if(pszText[iBegin - 1] == L'_')
			wPrevCharType = 0x8040;
		else if(pszText[iBegin - 1] == 0x3005)
			wPrevCharType = 0x8100;
		else
			::GetStringTypeW(CT_CTYPE3, pszText + iBegin - 1, 1, &wPrevCharType);
		::GetStringTypeW(CT_CTYPE1, pszText + iBegin - 1, 1, &wPrevSpace);
		wPrevCharType &= ~(C3_DIACRITIC | C3_VOWELMARK | C3_FULLWIDTH | C3_LEXICAL | C3_ALPHA);
		i = iBegin - 1;
		while(i != 0) {
			if(pszText[i - 1] == L'_')
				wCharType = 0x8040;
			else if(pszText[iBegin - 1] == 0x3005)
				wCharType = 0x8100;
			else
				::GetStringTypeW(CT_CTYPE3, pszText + i - 1, 1, &wCharType);
			::GetStringTypeW(CT_CTYPE1, pszText + i - 1, 1, &wSpace);
			wCharType &= ~(C3_DIACRITIC | C3_VOWELMARK | C3_FULLWIDTH | C3_LEXICAL | C3_ALPHA);
			if(bIgnoreSpaces) {
				if(!(wSpace & C1_SPACE)) {
					if(((wCharType != wPrevCharType)
							|| ((wPrevSpace & C1_SPACE) && (wSpace != wPrevSpace)))
							&& !(pszText[i - 0] == 0x30FC && wCharType & 0x0030)
							&& !(pszText[i - 1] == 0x30FC && wPrevCharType & 0x0030))
						return pszText + i;
				}
			} else if(((wCharType != wPrevCharType)
					|| ((wSpace & C1_SPACE || wPrevSpace & C1_SPACE) && (wSpace != wPrevSpace)))
					&& !(pszText[i - 0] == 0x30FC && wCharType & 0x0030)
					&& !(pszText[i - 1] == 0x30FC && wPrevCharType & 0x0030)) {
				return pszText + i;
			}
			--i;
			wPrevCharType = wCharType;
			wPrevSpace = wSpace;
		}
	}
	return 0;
}

///	Shift-JIS ̃^CvԂ
inline Manah::Text::SJISCharType Manah::Text::GetCharType(const unsigned char* pszText) {
	unsigned char	ch = pszText[0];
	unsigned char	chT = ((ch != 0) ? pszText[1] : 0);
	unsigned short	chKanji = (ch << 8) | chT;

	if((ch >= 0x09 && ch <= 0x0D) || ch == 0x20)
		return CT_SPACE;
	else if(ch < 0x20 || ch == 0x7F)
		return CT_CONTROL;
	else if(ch == 0x5F)
		return CT_UNDERSCORE;
	else if(ch < 0x30 || (ch >= 0x3A && ch <= 0x40) || (ch >= 0x5B && ch <= 0x60) || (ch >= 0x7B && ch <= 0x7E))
		return CT_SYMBOL;
	else if(ch < 0x40)
		return CT_DIGIT;
	else if(ch <= 0x5A)
		return CT_UPPERALPHA;
	else if(ch <= 0x7A)
		return CT_LOWERALPHA;
	else if(ch >= 0xA1 && ch <= 0xDF)
		return CT_KANA_HALFWIDTH;
	else if(ch == 0x81 && (chT >= 0x40 && chT <= 0xFC)) {
		if(chT == 0x52 || chT == 0x53)
			return CT_KANA_KATA;
		else if(chT == 0x54 || chT == 0x55)
			return CT_KANA_HIRA;
		else
			return CT_KANA_SYMBOL;
	}
	if(chT < 0x40 || chT > 0xFC || chT == 0x7F)
		return CT_OTHER;
	else if(ch == 0x82) {
		if(chT >= 0x4F && chT <= 0x58)	return CT_FULLWIDTH_DIGIT;
		if(chT >= 0x60 && chT <= 0x79)	return CT_FULLWIDTH_UPPERALPHA;
		if(chT >= 0x81 && chT <= 0x9A)	return CT_FULLWIDTH_LOWERALPHA;
		if(chT >= 0x9F && chT <= 0xF1)	return CT_KANA_HIRA;
	} else if(ch == 0x83) {
		if(chT >= 0x40 && chT <= 0x96)	return CT_KANA_KATA;
		if(chT >= 0x9F && chT <= 0xB6)	return CT_GREEK_UPPER;
		if(chT >= 0xBF && chT <= 0xD6)	return CT_GREEK_LOWER;
	} else if(ch == 0x84) {
		if(chT >= 0x40 && chT <= 0x60)	return CT_CYRILLIC_UPPER;
		if(chT >= 0x70 && chT <= 0x91)	return CT_CYRILLIC_LOWER;
	} else if(ch == 0x87) {
		if(chT >= 0x40 && chT <= 0x53)	return CT_SPECIAL_BOXDRAWING;
		if(chT >= 0x54 && chT <= 0x5D)	return CT_SPECIAL_ROMANNUMERAL;
		if(chT >= 0x5F && chT <= 0x75)	return CT_SPECIAL_UNIT;
		if(chT == 0x93 || chT == 0x94 || chT == 0x98 || chT == 0x99)	return CT_SPECIAL_MATHEMATICAL;
		if(chT >= 0x7E && chT <= 0x8F)	return CT_SPECIAL_OTHER;
	} else if(ch == 0xFA) {
		if(chT >= 0x55 && chT <= 0x57)	return CT_KANA_SYMBOL;
		if(chT >= 0x40 && chT <= 0x49)	return CT_SPECIAL_ROMANNUMERAL;
	}
	if(chKanji >= 0x889F && chKanji <= 0x9872)	return CT_KANJI1;
	if(chKanji >= 0x989F && chKanji <= 0xEA9E)	return CT_KANJI2;
	if(chKanji >= 0xFA5C && chKanji <= 0xFC4B)	return CT_KANJI3;
	return CT_OTHER;
}

///	w肵ʒuPꋫEǂԂ (Shift-JIS )
inline bool Manah::Text::HasWordBorderAt(const unsigned char* pszText, unsigned int i) {
	SJISCharType	ct = GetCharType(pszText + i);

	if(i == 0)
		return true;
	if(ct == CT_OTHER)
		return true;
	if(ct <= CT_KANA_HALFWIDTH)
		return (ct & 0xF0) == (GetCharType(pszText + i - 1) & 0xF0);
	else if(i != 1) {
		SJISCharType	ctPrev = GetCharType(pszText + i - 2);
		return ((ct & 0xF0) == (GetCharType(pszText + i - 2) & 0xF0))
			&& !(pszText[i - 0] == 0x81 && pszText[i + 1] == 0x5B && (ctPrev == CT_KANA_HIRA || ctPrev == CT_KANA_KATA))
			&& !(pszText[i - 2] == 0x81 && pszText[i - 1] == 0x5B && (ct == CT_KANA_HIRA || ct == CT_KANA_KATA))
			&& !(pszText[i - 0] == 0x81 && pszText[i + 1] == 0x58 && (ctPrev & 0xF0) == 0xA0)
			&& !(pszText[i - 2] == 0x81 && pszText[i - 1] == 0x58 && (ct & 0xF0) == 0xA0);
	} else
		return true;
}

///	w肵ʒuPꋫEǂԂ (Unicode )
inline bool Manah::Text::HasWordBorderAt(const wchar_t* pszText, unsigned int i) {
	WORD	wCharType, wPrevCharType;

	if(i == 0)
		return true;
	if(pszText[i] == L'_')
		wCharType = 0x0040;
	else if(pszText[i] == 0x3005)
		wCharType = 0x8100;
	else {
		::GetStringTypeW(CT_CTYPE3, pszText + i - 0, 1, &wCharType);
		wCharType &= ~(C3_DIACRITIC | C3_VOWELMARK | C3_FULLWIDTH | C3_LEXICAL | C3_ALPHA);
	}
	if(pszText[i - 1] == L'_')
		wPrevCharType = 0x0040;
	else if(pszText[i - 1] == 0x3005)
		wPrevCharType = 0x8100;
	else {
		::GetStringTypeW(CT_CTYPE3, pszText + i - 1, 1, &wPrevCharType);
		wPrevCharType &= ~(C3_DIACRITIC | C3_VOWELMARK | C3_FULLWIDTH | C3_LEXICAL | C3_ALPHA);
	}

	return (wCharType != wPrevCharType)
		&& !(pszText[i - 0] == 0x30FC && wPrevCharType & 0x0030)
		&& !(pszText[i - 1] == 0x30FC && wCharType & 0x0030);
}


///	Spɕϊ (: LCMapStringW(LCMAP_FULLWIDTH))
inline const wchar_t Manah::Text::ToFullWidth(wchar_t ch) {
	if(ch == 0xFF61)		return 0x3002;
	else if(ch == 0xFF62)	return 0x300C;
	else if(ch == 0xFF63)	return 0x300D;
	else if(ch == 0xFF64)	return 0x3001;
	else if(ch == 0xFFA0)	return 0x3164;
	else if(ch >= 0xFFA1 && ch <= 0xFFBE)
		return ch - 0xCE70;
	else if(ch >= 0xFFC2 && ch <= 0xFFC7)
		return ch - 0xCE73;
	else if(ch >= 0xFFCA && ch <= 0xFFCF)
		return ch - 0xCE75;
	else if(ch >= 0xFFD2 && ch <= 0xFFD7)
		return ch - 0xCE77;
	else if(ch >= 0xFFDA && ch <= 0xFFDC)
		return ch - 0xCE79;
}

///	pɕϊ (: LCMapStringW(LCMAP_HALFWIDTH))
inline const wchar_t Manah::Text::ToHalfWidth(wchar_t ch) {
	if(ch == 0x3000)	return 0x0020;
	else if(ch == 0x3001)	return 0xFF64;
	else if(ch == 0x3002)	return 0xFF61;
	else if(ch == 0x300C)	return 0xFF62;
	else if(ch == 0x300D)	return 0xFF63;
	else if(ch == 0x3164)	return 0xFFA0;
	else if(ch >= 0xFF01 && ch <= 0xFF5E)
		return ch - 0xFED0;
	else if(ch == 0xFF5F)	return 0x2985;
	else if(ch == 0xFF60)	return 0x2986;
	else if(ch == 0xFFE0)	return 0x00A2;
	else if(ch == 0xFFE1)	return 0x00A3;
	else if(ch == 0xFFE2)	return 0x00AC;
	else if(ch == 0xFFE3)	return 0x00AF;
	else if(ch == 0xFFE4)	return 0x00A6;
	else if(ch == 0xFFE5)	return 0x00A5;
	else if(ch == 0xFFE6)	return 0x20A9;
}

///	ɕϊ (: LCMapStringW(LCMAP_HIRAGANA))
inline wchar_t Manah::Text::ToHiragana(wchar_t ch) {
	if((ch >= 0x3041 && ch <= 0x3096) || ch == 0x309D || ch == 0x309E)
		return ch + 0x0060;
	return ch;
}

/**
 *	ɕϊ (: LCMapStringW(LCMAP_HIRAGANA))
 *	@param psz	ϊ镶
 *	@param cch	̒
 */
inline void Manah::Text::ToHiragana(wchar_t* psz, std::size_t cch /* = -1 */) {
	if(cch == -1)
		cch = wcslen(psz);
	if(cch == 0)
		return;
	do {
		psz[cch - 1] = ToHiragana(psz[cch - 1]);
	} while(--cch != 0);
}

///	Љɕϊ (: LCMapStringW(LCMAP_KATAKANA))
inline wchar_t Manah::Text::ToKatakana(wchar_t ch) {
	if((ch >= 0x30A1 && ch <= 0x30F6) || ch == 0x30FD || ch == 0x30FE)
		return ch - 0x0060;
	return ch;
}

/**
 *	Љɕϊ (: LCMapStringW(LCMAP_KATAKANA))
 *	@param psz	ϊ镶
 *	@param cch	̒
 */
inline void Manah::Text::ToKatakana(wchar_t* psz, std::size_t cch /* = -1 */) {
	if(cch == -1)
		cch = wcslen(psz);
	if(cch == 0)
		return;
	do {
		psz[cch - 1] = ToKatakana(psz[cch - 1]);
	} while(--cch != 0);
}

///	ɕϊ (: CharLowerW)
inline wchar_t Manah::Text::ToLower(wchar_t ch) {
	return ch;
}

///	ɕϊ (: CharLowerW)
inline void Manah::Text::ToLower(wchar_t* psz, std::size_t cch /* = -1 */) {
	assert(psz != 0);

	if(cch == -1) {
		wchar_t*	p = psz;
		while(*p != 0)
			*(p++) = ToLower(*p);
	} else {
		for(std::size_t i = 0; i < cch; ++i)
			*(psz + i) = ToLower(*(psz + i));
	}
}

///	啶ɕϊ (: CharUpperW)
inline wchar_t Manah::Text::ToUpper(wchar_t ch) {
	return ch;
}

///	啶ɕϊ (: CharUpperW)
inline void Manah::Text::ToUpper(wchar_t* psz, std::size_t cch /* = -1 */) {
	assert(psz != 0);

	if(cch == -1) {
		wchar_t*	p = psz;
		while(*p != 0)
			*(p++) = ToUpper(*p);
	} else {
		for(std::size_t i = 0; i < cch; ++i)
			*(psz + i) = ToUpper(*(psz + i));
	}
}


#endif /* _TEXT_CONVERTER_H_ */

/* [EOF] */