// Timer.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _TIMER_H_
#define _TIMER_H_
#include "Object.h"


// CTimer class definition and implementation
/////////////////////////////////////////////////////////////////////////////

namespace Manah {
namespace Windows {

class CTimer {
	// RXgN^
public:
	CTimer(const TCHAR* pszName = 0) {
		if(pszName == 0)
			m_pszName = 0;
		else {
			m_pszName = new TCHAR[_tcslen(pszName) + 1];
			std::_tcscpy(m_pszName, pszName);
		}
		Reset();
	}
	~CTimer() {
		if(m_pszName != 0) {
			Manah::Windows::CDumpContext	dc;
			dc << m_pszName << _T(" : ") << Read() << _T("ms\n");
			delete[] m_pszName;
		}
	}

	// \bh
public:
	DWORD Read() const {return ::GetTickCount() - m_nCount;}
	void Reset() {m_nCount = ::GetTickCount();}

	// f[^o
private:
	TCHAR*	m_pszName;	// timer's name
	DWORD	m_nCount;
};

} /* namespace Windows */
} /* namespace Manah */

#endif	/* _TIMER_H_ */

/* [EOF] */