// (c) 2003 exeal
// EditPoint.h

#ifndef _EDIT_POINT_H_
#define _EDIT_POINT_H_
#include "EditDoc.h"


#define VERIFY_VIEW()	\
	if(!IsAvailable())	\
		throw EViewIsAlreadyInavailable();


namespace Ascension {

class CCharPos;
class CEditDoc;
class CEditView;


///	͈͂̃eLXgϊ`
enum RangeConvertType {
	///	啶ɕϊ
	RCT_UPPERCASE,
	///	ɕϊ
	RCT_LOWERCASE,
	///	Ls^CY
	RCT_CAPITALIZE,
	///	ɕϊ
	RCT_HIRAGANA,
	///	Љɕϊ
	RCT_KATAKANA,
	///	Spɕϊ
	RCT_FULLWIDTH,
	///	pɕϊ
	RCT_HALFWIDTH,
	///	ꏊƂȂ폜
	RCT_REMOVENONSPACE,
	///	Ɍ
	RCT_COMPOSE,
	///	𕪉
	RCT_DECOMPOSE,
};


///	 CEditDoc ɖ CEditPoint IuWFNgLłȂƂ\O
class EViewIsAlreadyInavailable {
public:
	///	Ԃ
	std::wstring	GetDescription() const {
		return L"Target document is already inavailable. This object is no longer able to be used anyway.";
	}
};


/*
 *	.:߂:.
 *	CEditPoint NX CCharPos ɎĂ邪 CCharPos
 *	̔hNXɂȂƂɂB݈͌ʒu\ CCharPos
 *	2̃f[^oJĂ邩łB
 *	CCharPos ̃f[^oJɂĂ悢ACCharPos
 *	͌XPɈʒu\֐̗ǂf[^ɉ߂Ȃ̂ŁA
 *	CEditPoint Ƃ͈قȂZ}eBNXB
 *	ĉZqȂǂ͖ʓ|Vɒ`ȂB
 *	̃NX CCharPos ւ̈Öق̕ϊZqB
 */

/**
 *	@brief	GfB^ŕҏWAړ\ȁu_vB^Lbg
 *
 *	CEditView ̃NCAg͑I͈͂LbgʒuƂăeLXgҏWł邪A
 *	̃NXɂCӂ̏ꏊ̕ҏW\ƂȂBNCAǵu_vҏWӏɈړA
 *	CEditView ̑Ǝ@ŕҏWs
 *
 *	̃IuWFNg̕\_͑̕ҏWŕύX悤ɂ邱ƂA
 *	ύXȂ悤ɂ邱ƂoB̏ꍇłʒu
 *	(ႦΑ݂Ȃ񂩂ŏIցA폜ꂽsŏIs) ւ̈ړ͋N
 *
 *	CEditPoint CX^X̍쐬 CEditView::CreateEditPoint \bhg
 *
 *	̃NX̂قƂǂ̃\bh͑Ώۃr[ɑ݂Ȃꍇ
 *	EViewIsAlreadyInavailable X[
 *
 *	@see	CEditView, CEditDoc
 */
class CEditPoint : public Manah::CObject {
	friend class CEditView;

	// RXgN^
private:
	CEditPoint(CEditView* pView);
	CEditPoint(const CEditPoint& rhs);
public:
	virtual ~CEditPoint();

	// Zq
public:
	CEditPoint& operator =(const CCharPos& rhs);
	operator CCharPos() const;
	bool	operator ==(const CEditPoint& rhs) const;
	bool	operator !=(const CEditPoint& rhs) const;
	bool	operator <(const CEditPoint& rhs) const;
	bool	operator <=(const CEditPoint& rhs) const;
	bool	operator >(const CEditPoint& rhs) const;
	bool	operator >=(const CEditPoint& rhs) const;
private:
	operator =(const CEditPoint& rhs);

	// \bh
public:
	/*  */
	unsigned long	GetAbsoluteCharOffset() const throw(EViewIsAlreadyInavailable);
	unsigned long	GetCharNumber() const throw(EViewIsAlreadyInavailable);
	unsigned long	GetColumnNumber() const throw(EViewIsAlreadyInavailable);
	unsigned long	GetLineLength() const throw(EViewIsAlreadyInavailable);
	unsigned long	GetLineNumber() const throw(EViewIsAlreadyInavailable);
	wstring			GetText(long nChars) const throw(EViewIsAlreadyInavailable);
	wstring			GetText(const CEditPoint& pt) const throw(EViewIsAlreadyInavailable);
	bool			IsAtEndOfDocument() const throw(EViewIsAlreadyInavailable);
	bool			IsAtEndOfLine() const throw(EViewIsAlreadyInavailable);
	bool			IsAtStartOfDocument() const throw(EViewIsAlreadyInavailable);
	bool			IsAtStartOfLine() const throw(EViewIsAlreadyInavailable);
	bool			IsAvailable() const;
	bool			IsSynchronousWithOtherEdit() const throw(EViewIsAlreadyInavailable);
	void			SynchronizeWithOtherEdit(bool bSync) throw(EViewIsAlreadyInavailable);

	/*  (ړ) */
	void		CharNext(unsigned long nChars = 1) throw(EViewIsAlreadyInavailable);
	void		CharPrev(unsigned long nChars = 1) throw(EViewIsAlreadyInavailable);
	CEditPoint*	Clone() const throw(EViewIsAlreadyInavailable);
	void		EnsureCentered() throw(EViewIsAlreadyInavailable);
	void		EnsureVisible() throw(EViewIsAlreadyInavailable);
	void		MoveToAbsoluteCharOffset(unsigned long nOffset) throw(EViewIsAlreadyInavailable);
	void		MoveToEndOfDocument() throw(EViewIsAlreadyInavailable);
	void		MoveToEndOfLine() throw(EViewIsAlreadyInavailable);
	void		MoveToNextBookmark() throw(EViewIsAlreadyInavailable);
	void		MoveToPoint(const CCharPos& pos) throw(EViewIsAlreadyInavailable);
	void		MoveToPrevBookmark() throw(EViewIsAlreadyInavailable);
	void		MoveToStartOfDocument() throw(EViewIsAlreadyInavailable);
	void		MoveToStartOfLine() throw(EViewIsAlreadyInavailable);
	void		LineDown(unsigned long cLines = 1) throw(EViewIsAlreadyInavailable);
	void		LineUp(unsigned long cLines = 1) throw(EViewIsAlreadyInavailable);
	void		WordEndNext(unsigned long cWords = 1) throw(EViewIsAlreadyInavailable);
	void		WordEndPrev(unsigned long cWords = 1) throw(EViewIsAlreadyInavailable);
	void		WordNext(unsigned long cWords = 1) throw(EViewIsAlreadyInavailable);
	void		WordPrev(unsigned long cWords = 1) throw(EViewIsAlreadyInavailable);

	/*  (ҏW) */
	void	Convert(long cChars, RangeConvertType rct) throw(EViewIsAlreadyInavailable);
	void	Convert(const CEditPoint& pt, RangeConvertType rct) throw(EViewIsAlreadyInavailable);
	void	Copy(long cChars) throw(EViewIsAlreadyInavailable);
	void	Copy(const CEditPoint& pt) throw(EViewIsAlreadyInavailable);
	void	Cut(long cChars) throw(EViewIsAlreadyInavailable);
	void	Cut(const CEditPoint& pt) throw(EViewIsAlreadyInavailable);
	void	Delete(long cChars = 1) throw(EViewIsAlreadyInavailable);
	void	Delete(const CEditPoint& pt) throw(EViewIsAlreadyInavailable);
	void	Insert(const wstring& strText, OperationConcatenationFlag ocf) throw(EViewIsAlreadyInavailable);
	void	Paste(long cChars = 0) throw(EViewIsAlreadyInavailable);
	void	Paste(const CEditPoint& pt) throw(EViewIsAlreadyInavailable);
	void	SpaceIndent(const CEditPoint& pt, long nLevel = 1) throw(EViewIsAlreadyInavailable);
	void	Tabify(long cChars, bool bUntabify = false) throw(EViewIsAlreadyInavailable);
	void	Tabify(const CEditPoint& pt, bool bUntabify = false) throw(EViewIsAlreadyInavailable);
	void	TabIndent(const CEditPoint& pt, long nLevel = 1) throw(EViewIsAlreadyInavailable);

protected:
	void	OnDocumentDeleted();

private:
	void	Normalize() const;

	// f[^o
private:
	unsigned long	m_iLine;				// sԍ
	unsigned long	m_iChar;				// ԍ
	CEditView*		m_pView;				// r[
	bool			m_bSyncWithOtherEdit;	// ̕ҏWł̓_ړ邩
	unsigned long	m_cxLast;				// r[̐Ό_̋ (x W)
											// LineDown ALineUp ňړƂɕێ
};


// CEditPoint class inline implementation
/////////////////////////////////////////////////////////////////////////////

///	Zq
inline CEditPoint& CEditPoint::operator =(const CCharPos& rhs) {
	m_iLine = rhs.m_iLine;
	m_iChar = rhs.m_iChar;
	return *this;
}

///	CCharPos ւ̕ϊZq
inline CEditPoint::operator CCharPos() const {
	return CCharPos(m_iLine, m_iChar);
}

///	Zq
inline bool CEditPoint::operator ==(const CEditPoint& rhs) const {
	return m_pView == rhs.m_pView && m_iLine == rhs.m_iLine && m_iChar == rhs.m_iChar;
}

///	񓙉Zq
inline bool CEditPoint::operator !=(const CEditPoint& rhs) const {
	return m_pView == rhs.m_pView || m_iLine != rhs.m_iLine || m_iChar != rhs.m_iChar;
}

///	菬
inline bool CEditPoint::operator <(const CEditPoint& rhs) const {
	assert(m_pView == rhs.m_pView);
	return m_iLine < rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar < rhs.m_iChar);
}

///	ȉ
inline bool CEditPoint::operator <=(const CEditPoint& rhs) const {
	assert(m_pView == rhs.m_pView);
	return m_iLine <= rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar <= rhs.m_iChar);
}

///	傫
inline bool CEditPoint::operator >(const CEditPoint& rhs) const {
	assert(m_pView == rhs.m_pView);
	return m_iLine > rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar > rhs.m_iChar);
}

///	ȏ
inline bool CEditPoint::operator >=(const CEditPoint& rhs) const {
	assert(m_pView == rhs.m_pView);
	return m_iLine >= rhs.m_iLine || (m_iLine == rhs.m_iLine && m_iChar >= rhs.m_iChar);
}

///	Ώۃr[Ă true Ԃ
inline bool CEditPoint::IsAvailable() const {
	AssertValid();
	return m_pView != 0;
}

///	̕ҏWł̓_ړ邩ǂԂ
inline bool CEditPoint::IsSynchronousWithOtherEdit() const throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	return m_bSyncWithOtherEdit;
}

///	hLgj󂳂ꂽƂɌĂяo
inline void CEditPoint::OnDocumentDeleted() {
	AssertValid();
	m_pView = 0;
}

/**
 *	̕ҏWɓ
 *	@param bSync	true: Bfalse: 񓯊
 */
inline void CEditPoint::SynchronizeWithOtherEdit(bool bSync) throw(EViewIsAlreadyInavailable) {
	AssertValid();
	VERIFY_VIEW();
	m_bSyncWithOtherEdit = bSync;
}


} /* namespace Ascension */

#endif /* _EDIT_POINT_H_ */

/* [EOF] */