// CommonOptionDlg.h
// (c) 2003 exeal

#ifndef _COMMON_OPTION_DLG_H_
#define _COMMON_OPTION_DLG_H_
#include "..\Manah\PropertySheet.h"
#include "KeyboardMap.h"
#include "AlphaView.h"
#include "ScriptLanguageManager.h"


namespace Alpha {

class CAlphaApp;


// CCommonOptionSheet class definition
/////////////////////////////////////////////////////////////////////////////

///	[ʐݒ] vpeBV[g
class CCommonOptionSheet : public CPropertySheet {
	// RXgN^
public:
	CCommonOptionSheet(const wchar_t* pwszCaption, HWND hwndParent, UINT iSelectPage = 0);

	// \bh
private:
	static int CALLBACK	InitProc(HWND hWnd, UINT message, LPARAM lParam);
};


// ʐݒ_CAO̊e_CAOy[W̊ǗNX
// Jf[^o͐ݒ荀ڂ\A[OK]{^ȂĂ
// _CAOj󎞂ɍڂݒ肳
// ݒۑȂꍇ͌Jf[^ǒʂ𖳎΂悢


// CEditOptionDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[ʐݒ] _CAO [ҏW] ^u
class CEditOptionDlg : public CPropertyPage {
	// f[^o
public:
	bool			m_bCancelAfterCopy;			// [Rs[I]
	bool			m_bUseCurrentBreak;			// [݂̉sR[hg]
	bool			m_bLimitUndoHistory;		// [ȉƂ]
	bool			m_bConcatSuccessiveChars;	// [A͂1܂Ƃ߂ɂ]
	unsigned long	m_nUndoLimit;				// []

	// bZ[Wnh
protected:
	bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	void	OnDestroy();											// WM_DESTROY
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);		// WM_INITDIALOG
};


// CFileOptionDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[ʐݒ] _CAO [t@C] ^u
class CFileOptionDlg : public CPropertyPage {
	// f[^o
public:
	BYTE			m_nShareMode;			// [r]
	bool			m_bAutoSave;			// [I[gZ[ugp]
	unsigned int	m_nInterval;			// [Ԋu]
	bool			m_bWriteBOMAsUTF8;		// [UTF-8]
	bool			m_bWriteBOMAsUTF16LE;	// [UTF-16]
	bool			m_bWriteBOMAsUTF16BE;	// [UTF-16 big endian]
	bool			m_bWriteBOMAsUTF32LE;	// [UTF-32]
	bool			m_bWriteBOMAsUTF32BE;	// [UTF-32 big endian]
	bool			m_bWriteBOMAsISO2022CN;	// [ȑ̎ (ISO-2022)]
	bool			m_bWriteBOMAsISO2022KR;	// [؍ (ISO-2022)]
	bool			m_bUseSystemACP;		// [VXe` ANSI R[hy[W]
	UINT			m_nCustomCP;			// [̃R[hy[Wg]
	BreakType		m_breakType;			// [sR[h]
	BYTE			m_nMRULimit;			// [𒷂]
	bool			m_bSendAsAttachment;	// [Ytt@CƂđM]
	bool			m_bClearedMRU;			// [NA]{^ꂽ

	// RXgN^
public:
	CFileOptionDlg() : m_bClearedMRU(false)	{}

	// \bh
public:
	void	UpdateControls();

	// bZ[Wnh
protected:
	bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	void	OnDestroy();											// WM_DESTROY
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);		// WM_INITDIALOG
};


// CFindOptionDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[ʐݒ] _CAO [] ^u
class CFindOptionDlg : public CPropertyPage {
	// f[^o
public:
	bool	m_bShowMessageBox;			// [bZ[W {bNX\]
	bool	m_bInitializeFromEditor;	// [eLXgGfB^珉]

	// bZ[Wnh
protected:
	void	OnDestroy();											// WM_DESTROY
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);		// WM_INITDIALOG
};


// CViewOptionDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[ʐݒ] _CAO [\] ^u
class CViewOptionDlg : public CPropertyPage {
	// f[^o
public:
	bool			m_bVisibleToolbar;		// [c[o[\]
	bool			m_bVisibleStatusBar;	// [Xe[^Xo[\]
	unsigned int	m_nLeftMargin;			// []]
	unsigned int	m_nTopMargin;			// []]
	unsigned short	m_nStartupWindowPos;	// [N̈ʒuƃTCY]
	RECT			m_rectSpecifiedWindow;

	// bZ[Wnh
protected:
	bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	void	OnDestroy();											// WM_DESTROY
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);		// WM_INITDIALOG
};


// CKeyBindsOptionDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[ʐݒ] _CAO [L[蓖] ^u
class CKeyBindsOptionDlg : public CPropertyPage {
	// f[^o
private:
	CAlphaApp*		m_pApp;
	CKeyboardMap*	m_pKeyboardMap;

	// RXgN^
public:
	CKeyBindsOptionDlg(CAlphaApp* pApp, CKeyboardMap* pKeyBoardMap);

	// bZ[Wnh
protected:
	bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	void	OnDestroy();											// WM_DESTROY
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);		// WM_INITDIALOG
	bool	OnNotify(int idCtrl, LPNMHDR lpNMHDR);					// WM_NOTIFY
};


// CCodePageOptionDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[ʐݒ] _CAO [R[hy[W] ^u
class CCodePageOptionDlg : public CPropertyPage {
	// f[^o
public:
	set<UINT>	m_setExceptedCPs;

	// bZ[Wnh
protected:
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);	// WM_INITDIALOG
};


// CScriptOptionDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[ʐݒ] _CAO [XNvg] ^u
class CScriptOptionDlg : public CPropertyPage {
	// f[^o
private:
	CScriptLanguageManager*	m_pScriptLanguageManager;
	vector<wstring>			m_vecNotations;

	// RXgN^
public:
	CScriptOptionDlg(CScriptLanguageManager* pScriptLanguageManager);

	// bZ[Wnh
protected:
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);	// WM_INITDIALOG
	bool	OnNotify(int idCtrl, LPNMHDR lpNMHDR);				// WM_NOTIFY
};


// CStyleOptionDlg class definition
/////////////////////////////////////////////////////////////////////////////

struct TDocumentStyleType;

///	[ʐݒ] _CAO [X^C] ^u
class CStyleOptionDlg : public CPropertyPage {
	// f[^o
public:
	vector<TDocumentStyleType>	m_vecDocStyles;

	// bZ[Wnh
protected:
	bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	void	OnDrawItem(UINT idCtrl, LPDRAWITEMSTRUCT lpDrawItem);	// WM_DRAWITEM
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);		// WM_INITDIALOG
};


// CDocType1OptionDlg class definition
/////////////////////////////////////////////////////////////////////////////

struct TDocumentType1Option {
	wstring			strName;
	wstring			strExtensions;
	unsigned short	nLineSpan;
	unsigned short	nCharSpan;
	unsigned short	nTabWidth;
	LeftTabType		ltt;

	TDocumentType1Option() : nLineSpan(0), nCharSpan(0), nTabWidth(4), ltt(LTT_LINENUMBER) {
	}
};


// CKeywordOptionDlg class definition
/////////////////////////////////////////////////////////////////////////////

struct TKeywordOption {
};

///	[ʐݒ] _CAO [L[[h] ^u
class CKeywordOptionDlg : public CPropertyPage {
	// f[^o
public:
	vector<TKeywordOption>	m_vecOption;

	// bZ[Wnh
protected:
	bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);		// WM_INITDIALOG
};

}

#endif /* _COMMON_OPTION_DLG_H_ */

/* [EOF] */