// DebugThreadsDlg.h
// (c) 2003 exeal

#ifndef _DEBUG_THREADS_DLG_H_
#define _DEBUG_THREADS_DLG_H_
#include "AlphaApplicationDebugger.h"
#include "..\Manah\Dialog.h"


namespace Alpha {

// CDebugBreakPointsDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[u[N|Cg] _CAO
class CDebugBreakPointsDlg : public CDialog {
	// \bh
protected:
	void	UpdateList();

	// bZ[Wnh
protected:
	bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	void	OnDestroy();											// WM_DESTROY
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);		// WM_INITDIALOG
	bool	OnNotify(int idCtrl, LPNMHDR lpNMHDR);					// WM_NOTIFY

	// f[^o
public:
	BreakPointList	m_listBreakPoints;
};


// CDebugCallStackDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[R[X^bN] _CAO
class CDebugCallStackDlg : public CDialog {
	// RXgN^
public:
	CDebugCallStackDlg();
	~CDebugCallStackDlg();

	// \bh
public:
	void	Update(CAlphaApplicationDebugger* pDebugger);

	// bZ[Wnh
protected:
	bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);		// WM_INITDIALOG
	bool	OnNotify(int idCtrl, LPNMHDR lpNMHDR);					// WM_NOTIFY
	void	OnSize(UINT nType, int cx, int cy);						// WM_SIZE

	// f[^o
	CAlphaApplicationDebugger*	m_pDebugger;
};


// CDebugImmediateDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[C~fBGCg] _CAO
class CDebugImmediateDlg : public CDialog {
	// RXgN^
public:
	CDebugImmediateDlg();
	~CDebugImmediateDlg();

	// \bh
public:
	void	Update(CAlphaApplicationDebugger* pDebugger);
protected:
	void	OnEvaluateExpression();

	// bZ[Wnh
protected:
	bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);		// WM_INITDIALOG

	// f[^o
	CAlphaApplicationDebugger*	m_pDebugger;
};


// CDebugRunningDocumentsDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[s̃hLg] _CAO
class CDebugRunningDocumentsDlg : public CDialog {
	// \bh
public:
	void	Update();
protected:
	void	_MakeNodeTree(IDebugApplicationNode* pParentNode, HTREEITEM hParent);

	// bZ[Wnh
protected:
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);	// WM_INITDIALOG
	bool	OnNotify(int idCtrl, LPNMHDR lpNMHDR);				// WM_NOTIFY
	void	OnSize(UINT nType, int cx, int cy);					// WM_SIZE

	// f[^o
private:
	HMENU	m_hContextMenu;

	struct TDocumentNode {
		bool	bNodeIsApplication;
		union {
			IRemoteDebugApplication*	pApplication;
			IDebugApplicationNode*		pAppNode;
		} oNodeObject;

		~TDocumentNode() {
			if(bNodeIsApplication && oNodeObject.pApplication != 0)
				oNodeObject.pApplication->Release();
			else if(oNodeObject.pAppNode != 0)
				oNodeObject.pAppNode->Release();
		}
	};
};


// CDebugThreadsDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[Xbh] _CAO
class CDebugThreadsDlg : public CDialog {
	// \bh
public:
	void	Update(IRemoteDebugApplication* pApplication);

	// bZ[Wnh
protected:
	bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	bool	OnContextMenu(HWND hWnd, POINT pt);						// WM_CONTEXTMENU
	void	OnDestroy();											// WM_DESTROY
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);		// WM_INITDIALOG
	void	OnSize(UINT nType, int cx, int cy);						// WM_SIZE

	// f[^o
private:
	HMENU	m_hContextMenu;
};


// CDebugVariablesDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[ϐ] _CAO
class CDebugVariablesDlg : public CDialog {
	// RXgN^
public:
	CDebugVariablesDlg();
	~CDebugVariablesDlg();

	// \bh
public:
	void	Update(CAlphaApplicationDebugger* pDebugger);
protected:
	void	_CleanupCallStacks();
	void	_ExpandProperty(HWND hwndListView);
	void	_ShowMembers();

	// bZ[Wnh
protected:
	bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	void	OnDestroy();											// WM_DESTROY
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);		// WM_INITDIALOG
	bool	OnNotify(int idCtrl, LPNMHDR lpNMHDR);					// WM_NOTIFY
	void	OnSize(UINT nType, int cx, int cy);						// WM_SIZE

	// f[^o
private:
	CAlphaApplicationDebugger*	m_pDebugger;
	IDebugStackFrame*			m_pGlobalFrame;
	unsigned long				m_nRadix;
	list<wstring>				m_listWatchingExpressions;

	struct TPropertyItem {
		bool			bExpanded;
		unsigned int	nIndent;
		IDebugProperty*	pProperty;

		TPropertyItem() : bExpanded(false), nIndent(0), pProperty(0) {
		}
		~TPropertyItem() {
			if(pProperty != 0)
				pProperty->Release();
		}
	};
};

} /* namespace Alpha */

#endif /* _DEBUG_THREADS_DLG_H_ */

/*[EOF] */