// KeyboardMap.h
// (c) 2003 exeal

#ifndef _KEYBOARD_MAP_H_
#define _KEYBOARD_MAP_H_

#include "AlphaInterfaces.h"


// CKeyboardMap class definition
/////////////////////////////////////////////////////////////////////////////

namespace Alpha {

interface ISerializable;

enum KeyModifier {	// zL[̏CL[ (CKeyboardMap::m_arrCommands ̓YɎgp)
	KM_SHIFT	= 0x01,
	KM_CTRL		= 0x02,
	KM_ALT		= 0x04
};

///	L[oCh̊Ǘ
class CKeyboardMap : public ISerializable {
	// RXgN^
public:
	CKeyboardMap();

	// \bh
public:
	HACCEL	CreateAcceleratorTable() const;
	int		GetCommandID(short sVKey, KeyModifier km) const throw(out_of_range);
	bool	GetKeyBind(int nCommand, short& sVKey, KeyModifier& km) const;
	wstring	GetKeyString(int nCommand) const;
	void	Reset();
	void	SetOneCommand(short sVKey, KeyModifier km, int nCommand) throw(out_of_range);

	static const wchar_t*	GetKeyName(short sVKey) throw(out_of_range);

	// ISerializable \bh
	bool	IsDirty() const;
	bool	Load(const wchar_t* pwszPathName);
	bool	Save(const wchar_t* pwszPathName);

	// f[^o
private:
	int						m_arrCommands[8][0x0100];	// (CL[) * (zL[R[h) ŃR}h ID i[B
														// 0łΉo^ĂȂ
	int						m_cCommands;				// ۂɓo^ꂽR}h̐
	static const wchar_t*	m_arrKeyName[0x0100];
	bool					m_bDirty;
};

}

#endif /* _KEYBOARD_MAP_H_ */

/* [EOF] */