// MRUManager.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "MRUManager.h"
#include "..\Manah\TextConverter.h"
using Alpha::CMRUManager;


// CMRUManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CMRUManager::CMRUManager(unsigned short cLimit, int nStartID, bool bOwnerDrawMenu /* =false */)
		: m_cLimit(cLimit), m_nStartID(nStartID), m_bOwnerDraw(bOwnerDrawMenu) {
	m_pPopupMenu = new CPopupMenu();
}

///	fXgN^
CMRUManager::~CMRUManager() {
	delete m_pPopupMenu;
}

///	<code>m_listFileNames</code> 烁j[č\
void CMRUManager::_ReconstructMenu() {
	unsigned short					iItem = 0;
	list<wstring>::const_iterator	it = m_listFileNames.begin();
	wchar_t							szItem[MAX_PATH + 2];

	m_pPopupMenu->ResetContent();
	while(it != m_listFileNames.end()) {
		swprintf(szItem, L"&%x  %s", iItem, it->c_str());
		m_pPopupMenu->AppendMenuItem(m_nStartID + iItem, m_bOwnerDraw ? MF_OWNERDRAW : MF_STRING, szItem);
		++it;
		++iItem;
	}
}

/**
 *	ڂǉBɓ̂΂擪ɏo
 *	@param strFilePath	Vǉt@CpX
 */
void CMRUManager::Add(const wstring& strFilePath) {
	list<wstring>::iterator	it = m_listFileNames.begin();
	wchar_t*				psz = new wchar_t[strFilePath.length() + 1];
	wchar_t					szItem[MAX_PATH];

	// ̂邩T (啶ʂȂBۂ͂ŏ\ł͂Ȃ)
	wcscpy(psz, strFilePath.c_str());
	::CharLowerW(psz);
	while(it != m_listFileNames.end()) {
		wcscpy(szItem, it->c_str());
		::CharLowerW(szItem);
		if(wcscmp(szItem, psz) == 0) {	//  -> 擪ɏo
			wstring	strItem = *it;
			m_listFileNames.erase(it);
			m_listFileNames.push_front(strItem);
			delete[] psz;
			_ReconstructMenu();
			return;
		}
		++it;
	}
	delete[] psz;

	// 擪ɒǉBl𒴂ꍇ͈ԌÂ̂폜
	m_listFileNames.push_front(strFilePath);
	if(m_listFileNames.size() > m_cLimit)
		m_listFileNames.resize(m_cLimit);
	_ReconstructMenu();
}

///	ڂSč폜
void CMRUManager::Clear() {
	m_listFileNames.clear();
	m_pPopupMenu->ResetContent();
	_ReconstructMenu();
}

///	Xg̍ڐԂ
unsigned short CMRUManager::GetCount() const {
	return m_listFileNames.size();
}

///	w肵ʒũt@CpXԂ
const wstring& CMRUManager::GetFilePathAt(unsigned short i) const throw(out_of_range) {
	if(i >= m_listFileNames.size())
		throw out_of_range("First argument is out of range!");
	list<wstring>::const_iterator	it = m_listFileNames.begin();
	for(unsigned short j = 0; j < i; ++j)
		++it;
	return *it;
}

///	|bvAbvj[Ԃ
CPopupMenu* CMRUManager::GetPopupMenu() const {
	return m_pPopupMenu;
}

/**
 *	ڂ̍폜
 *	@param i			ڂ̔ԍ
 *	@throw out_of_range	<var>i</var> ȂƂX[
 */
void CMRUManager::Remove(unsigned short i) throw(out_of_range) {
	if(i >= m_listFileNames.size())
		throw out_of_range("First argument is out of range!");
	list<wstring>::iterator	it = m_listFileNames.begin();
	for(unsigned short j = 0; j < i; ++j)
		++it;
	m_listFileNames.erase(it);
	_ReconstructMenu();
}

///	ڐ̏l̐ݒ
void CMRUManager::SetLimit(unsigned short cLimit) {
	CPopupMenu*	pItem = 0;

	if(cLimit < 4)
		cLimit = 4;
	else if(cLimit > 16)
		cLimit = 16;

	// ӂꂽ폜
	if(m_listFileNames.size() > cLimit) {
		m_listFileNames.resize(cLimit);
		for(unsigned short i = m_listFileNames.size() - 1; i > cLimit; --i)
			m_pPopupMenu->RemoveMenuItem(i, pItem);
	}
}

/* [EOF] */