// ScriptLanguageManager.h
// (c) 2003 exeal

#ifndef _SCRIPT_LANGUAGE_MANAGER_H_
#define _SCRIPT_LANGUAGE_MANAGER_H_

#include <map>
#include <set>


namespace Alpha {

// CScriptLanguageManager class definition
/////////////////////////////////////////////////////////////////////////////

///	XNvg̊Ǘ
class CScriptLanguageManager {
	// \bh
public:
	void			Add(const wstring& strLanguageName, const set<wstring>& setExtensions);
	static CLSID	GetCLSID(const wstring& strLanguageName);
	set<wstring>	GetExtensionNames(const wstring& strLanguageName) const;
	set<wstring>	GetLanguages() const;
	wstring			LanguageNameFromExtension(const wstring& strExtensionName) const;
	static bool		QueryDebuggable(const wstring& strLanguageName);
	void			Remove(const wstring& strLanguageName);
	void			RemoveAll();

	// f[^o
private:
	map<
		wstring,
		set<wstring>
	>		m_mapLanguages;
};

}

#endif /* _SCRIPT_LANGUAGE_MANAGER_H_ */

/* [EOF] */