// DraggingTextDataObject.h
// (c) 2002-2004 exeal

#ifndef _DRAGGING_TEXT_DATA_OBJECT_H_
#define _DRAGGING_TEXT_DATA_OBJECT_H_
#include "ArmaitiImplementation.h"
#include "..\Manah\Window.h"
#include <set>


namespace Armaiti {
namespace OLE {

// CDraggingTextDataObject class definition
/////////////////////////////////////////////////////////////////////////////

/// eLXgf[^̃hbOAhhbvɎgp IDataObject B
/// ANSI AUnicode ̗ɑΉ
class CDraggingTextDataObject :
		public IUnknownImpl<CSingleThreadMemoryManageModel>,
		public IDataObject {
	// RXgN^
public:
	CDraggingTextDataObject(IDropSource* pDropSource, const TCHAR* lpszText = 0);
	virtual ~CDraggingTextDataObject();

	// \bh
public:
	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IDataObject)
	END_INTERFACE_TABLE()

	// IDataObject C^[tFCX
	STDMETHODIMP	GetData(LPFORMATETC pformatetcIn, LPSTGMEDIUM pmedium);
	STDMETHODIMP	GetDataHere(LPFORMATETC pformatetc, LPSTGMEDIUM pmedium);
	STDMETHODIMP	QueryGetData(LPFORMATETC pformatetc);
	STDMETHODIMP	GetCanonicalFormatEtc(LPFORMATETC pformatectIn, LPFORMATETC pformatetcOut);
	STDMETHODIMP	SetData(LPFORMATETC pformatetc, LPSTGMEDIUM pmedium, BOOL fRelease);
	STDMETHODIMP	EnumFormatEtc(DWORD dwDirection, LPENUMFORMATETC* ppenumFormatEtc);
	STDMETHODIMP	DAdvise(LPFORMATETC pformatetc, DWORD advf, LPADVISESINK pAdvSink, LPDWORD pdwConnection);
	STDMETHODIMP	DUnadvise(DWORD dwConnection);
	STDMETHODIMP	EnumDAdvise(LPENUMSTATDATA* ppenumAdvise);

	virtual DWORD	DoDragDrop(DWORD dwEffect);
	virtual void	SetTextData(const char* lpszText);		// holds text data (ANSI)
	virtual void	SetTextData(const wchar_t* lpszText);	// holds text data (Unicode)
	virtual void	SetAvailableFormatSet(const set<CLIPFORMAT>& setClipFormats);

	// f[^o
private:
	IDropSource*	m_pDropSource;
	set<CLIPFORMAT>	m_setClipFormats;
	HGLOBAL			m_hAnsiData;
	HGLOBAL			m_hUnicodeData;

	/// IDataObject::EnumFormatEtc ̖߂l
	class CAvailableFormatsEnumerator :
			public IUnknownImpl<CSingleThreadMemoryManageModel>,
			public IEnumFORMATETC {
		// RXgN^
	public:
		CAvailableFormatsEnumerator(const set<CLIPFORMAT>& setFormats);
		CAvailableFormatsEnumerator(const CAvailableFormatsEnumerator& rhs);

		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN()
		BEGIN_INTERFACE_TABLE()
			IMPLEMENTS_LEFTMOST_INTERFACE(IEnumFORMATETC)
		END_INTERFACE_TABLE()

		// IEnumFORMATETC C^[tFCX
        STDMETHODIMP	Next(ULONG celt, FORMATETC *rgelt, ULONG *pceltFetched);
        STDMETHODIMP	Skip(ULONG celt);
        STDMETHODIMP	Reset();
        STDMETHODIMP	Clone(IEnumFORMATETC** ppenum);

		// f[^o
	private:
		const set<CLIPFORMAT>*			m_psetClipFormats;
		set<CLIPFORMAT>::const_iterator	m_it;
	};

};

} /* namespace OLE */
} /* namespace Armaiti */

#endif /* _DATA_OBJECT_H_ */

/* [EOF] */