#!/bin/sh

TARGET="9100h"
WHICH_PATCH="patch13b"

gunzip -c anthy-${TARGET}.tar.gz | tar xf -

cd anthy-${TARGET}/

echo -n "Apply G-HAL's patch ? (Y/n): "
read U_CHOICE

case ${U_CHOICE} in
n|N)
   WHICH_PATCH="default"
   # [Anthy-dev 3707]
   bzcat ../anthy-9100h.debugpatch.bz2 |\
   patch -p1
      ;;
*)
   WHICH_PATCH="patch13b"
   echo " apply G-HAL's patch:"
   bzcat ../anthy-9100h.patch13Bptn23.iconv.2009Y15.bz2 |\
   patch -p1
   bzcat ../anthy-9100h.mkworddic_fix.tar.bz2 | tar xf -
esac

echo " apply newdep-patch:"
patch -p1 < ../anthy-${TARGET}_${WHICH_PATCH}_newdep.patch
chmod a+x depgraph/mkdepword
chmod a+x calctrans/devide.sh

echo " copying alt-cannadic:"
rm -rf ./alt-cannadic/
cp -pr ../alt-cannadic ./alt-cannadic
cp ../data/${WHICH_PATCH}/Makefile.* alt-cannadic/
cp ../data/${WHICH_PATCH}/extra/Makefile.* alt-cannadic/extra/
cp -p ../data/${WHICH_PATCH}/corpus_info calctrans/
cp -p ../data/${WHICH_PATCH}/weak_words calctrans/
cp -p ../data/mkworddic/* mkworddic/

echo " Done"
