/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import java.util.ArrayList;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLCDATA;
import jp.aonir.fuzzyxml.FuzzyXMLComment;
import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLProcessingInstruction;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyListener;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLAttributeImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLCDATAImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLCommentImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLElementImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLProcessingInstructionImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLTextImpl;

public class FuzzyXMLDocumentImpl
implements FuzzyXMLDocument {
    private FuzzyXMLElement root;
    private FuzzyXMLDocType docType;
    private ArrayList listeners = new ArrayList();

    public FuzzyXMLDocumentImpl(FuzzyXMLElement fuzzyXMLElement, FuzzyXMLDocType fuzzyXMLDocType) {
        this.root = fuzzyXMLElement;
        this.docType = fuzzyXMLDocType;
        if (this.root != null) {
            ((FuzzyXMLElementImpl)this.root).setDocument(this);
            this.setDocument(this.root);
        }
        if (this.docType != null) {
            ((AbstractFuzzyXMLNode)((Object)this.docType)).setDocument(this);
        }
    }

    private void setDocument(FuzzyXMLElement fuzzyXMLElement) {
        FuzzyXMLNode[] fuzzyXMLNodeArray = fuzzyXMLElement.getChildren();
        for (int i = 0; i < fuzzyXMLNodeArray.length; ++i) {
            ((AbstractFuzzyXMLNode)fuzzyXMLNodeArray[i]).setDocument(this);
            if (!(fuzzyXMLNodeArray[i] instanceof FuzzyXMLElement)) continue;
            this.setDocument((FuzzyXMLElement)fuzzyXMLNodeArray[i]);
        }
        FuzzyXMLAttribute[] fuzzyXMLAttributeArray = fuzzyXMLElement.getAttributes();
        for (int i = 0; i < fuzzyXMLAttributeArray.length; ++i) {
            ((AbstractFuzzyXMLNode)((Object)fuzzyXMLAttributeArray[i])).setDocument(this);
        }
    }

    public FuzzyXMLComment createComment(String string) {
        return new FuzzyXMLCommentImpl(string);
    }

    public FuzzyXMLElement createElement(String string) {
        return new FuzzyXMLElementImpl(string);
    }

    public FuzzyXMLAttribute createAttribute(String string) {
        return new FuzzyXMLAttributeImpl(string);
    }

    public FuzzyXMLText createText(String string) {
        return new FuzzyXMLTextImpl(string);
    }

    public FuzzyXMLCDATA createCDATASection(String string) {
        return new FuzzyXMLCDATAImpl(string);
    }

    public FuzzyXMLProcessingInstruction createProcessingInstruction(String string, String string2) {
        return new FuzzyXMLProcessingInstructionImpl(string, string2);
    }

    public FuzzyXMLElement getDocumentElement() {
        return this.root;
    }

    public FuzzyXMLDocType getDocumentType() {
        return this.docType;
    }

    public FuzzyXMLElement getElementByOffset(int n) {
        if (this.root == null) {
            return null;
        }
        ArrayList<FuzzyXMLElement> arrayList = new ArrayList<FuzzyXMLElement>();
        arrayList.add(this.root);
        this.matchOffsetElement(this.root, arrayList, n);
        FuzzyXMLNode fuzzyXMLNode = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            FuzzyXMLElement fuzzyXMLElement = (FuzzyXMLElement)arrayList.get(i);
            if (fuzzyXMLNode != null && fuzzyXMLNode.getLength() < fuzzyXMLElement.getLength()) continue;
            fuzzyXMLNode = fuzzyXMLElement;
        }
        return fuzzyXMLNode;
    }

    private void matchOffsetElement(FuzzyXMLElement fuzzyXMLElement, ArrayList arrayList, int n) {
        FuzzyXMLNode[] fuzzyXMLNodeArray = fuzzyXMLElement.getChildren();
        for (int i = 0; i < fuzzyXMLNodeArray.length; ++i) {
            FuzzyXMLElement fuzzyXMLElement2;
            if (!(fuzzyXMLNodeArray[i] instanceof FuzzyXMLElement) || (fuzzyXMLElement2 = (FuzzyXMLElement)fuzzyXMLNodeArray[i]).getOffset() > n || n > fuzzyXMLElement2.getOffset() + fuzzyXMLElement2.getLength()) continue;
            arrayList.add(fuzzyXMLNodeArray[i]);
            this.matchOffsetElement(fuzzyXMLElement2, arrayList, n);
        }
    }

    public void addModifyListener(FuzzyXMLModifyListener fuzzyXMLModifyListener) {
        this.listeners.add(fuzzyXMLModifyListener);
    }

    public void removeModifyListener(FuzzyXMLModifyListener fuzzyXMLModifyListener) {
        this.listeners.remove(fuzzyXMLModifyListener);
    }

    public void fireModifyEvent(String string, int n, int n2) {
        FuzzyXMLModifyEvent fuzzyXMLModifyEvent = new FuzzyXMLModifyEvent(string, n, n2);
        for (int i = 0; i < this.listeners.size(); ++i) {
            FuzzyXMLModifyListener fuzzyXMLModifyListener = (FuzzyXMLModifyListener)this.listeners.get(i);
            fuzzyXMLModifyListener.modified(fuzzyXMLModifyEvent);
        }
    }

    public void appendOffset(FuzzyXMLElement fuzzyXMLElement, int n, int n2) {
        this.appendOffsetForElement((FuzzyXMLElementImpl)this.root, n, n2);
        this.appendLengthForParent((FuzzyXMLElementImpl)fuzzyXMLElement, n2);
    }

    private void appendOffsetForElement(FuzzyXMLElementImpl fuzzyXMLElementImpl, int n, int n2) {
        FuzzyXMLNode[] fuzzyXMLNodeArray = fuzzyXMLElementImpl.getChildren();
        for (int i = 0; i < fuzzyXMLNodeArray.length; ++i) {
            if (fuzzyXMLNodeArray[i].getOffset() >= n) {
                ((AbstractFuzzyXMLNode)fuzzyXMLNodeArray[i]).setOffset(fuzzyXMLNodeArray[i].getOffset() + n2);
            }
            if (!(fuzzyXMLNodeArray[i] instanceof FuzzyXMLElementImpl)) continue;
            this.appendOffsetForElement((FuzzyXMLElementImpl)fuzzyXMLNodeArray[i], n, n2);
        }
        FuzzyXMLAttribute[] fuzzyXMLAttributeArray = fuzzyXMLElementImpl.getAttributes();
        for (int i = 0; i < fuzzyXMLAttributeArray.length; ++i) {
            if (fuzzyXMLAttributeArray[i].getOffset() < n) continue;
            ((AbstractFuzzyXMLNode)((Object)fuzzyXMLAttributeArray[i])).setOffset(fuzzyXMLAttributeArray[i].getOffset() + n2);
        }
    }

    private void appendLengthForParent(FuzzyXMLElementImpl fuzzyXMLElementImpl, int n) {
        fuzzyXMLElementImpl.setLength(fuzzyXMLElementImpl.getLength() + n);
        if (fuzzyXMLElementImpl.getParentNode() != null) {
            this.appendLengthForParent((FuzzyXMLElementImpl)fuzzyXMLElementImpl.getParentNode(), n);
        }
    }
}

