/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.sample;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.FuzzyXMLProcessingInstruction;
import jp.aonir.fuzzyxml.XPath;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorListener;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyListener;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import jp.aonir.fuzzyxml.sample.ConsoleAttrDialog;
import jp.aonir.fuzzyxml.sample.ConsoleNodeDialog;
import jp.aonir.fuzzyxml.sample.ConsolePIDialog;

public class Console
extends JFrame {
    private CustomTextArea text = new CustomTextArea();
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
    private DefaultTreeModel model = new DefaultTreeModel(this.root);
    private JTree tree = new JTree(this.model);
    private JPopupMenu popup;
    private FuzzyXMLDocument doc;
    private JFileChooser chooser = new JFileChooser();
    private JList errors = new JList(new DefaultListModel());
    private Action addNodeAction = new AddNodeAction();
    private Action insertBeforeAction = new InsertBeforeAction();
    private Action replaceNodeAction = new ReplaceNodeAction();
    private Action addAttrAction = new AddAttrAction();
    private Action editAttrAction = new EditAttrAction();
    private Action editPIAction = new EditPIAction();
    private Action removeAction = new RemoveAction();
    static /* synthetic */ Class class$jp$aonir$fuzzyxml$sample$Console;

    public Console() throws Exception {
        super("FuzzyXML Sample");
        this.popup = new JPopupMenu();
        this.popup.add(this.addNodeAction);
        this.popup.add(this.insertBeforeAction);
        this.popup.add(this.replaceNodeAction);
        this.popup.add(new JSeparator());
        this.popup.add(this.addAttrAction);
        this.popup.add(this.editAttrAction);
        this.popup.add(new JSeparator());
        this.popup.add(this.editPIAction);
        this.popup.add(new JSeparator());
        this.popup.add(this.removeAction);
        Container container = this.getContentPane();
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.add(new JScrollPane(this.text));
        jSplitPane.add(new JScrollPane(this.errors));
        jSplitPane.setDividerLocation(250);
        this.errors.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ErrorInfo errorInfo = (ErrorInfo)Console.this.errors.getSelectedValue();
                if (errorInfo != null) {
                    Console.this.text.setSelectionStart(errorInfo.offset);
                    Console.this.text.setSelectionEnd(errorInfo.offset + errorInfo.length);
                    Console.this.text.requestFocus();
                }
            }
        });
        JSplitPane jSplitPane2 = new JSplitPane(1);
        jSplitPane2.add(new JScrollPane(this.tree));
        jSplitPane2.add(jSplitPane);
        jSplitPane2.setDividerLocation(180);
        JToolBar jToolBar = new JToolBar();
        JButton jButton = new JButton("Open");
        this.chooser.setFileSelectionMode(0);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Console.this.chooser.showOpenDialog(Console.this) == 0) {
                    File file = Console.this.chooser.getSelectedFile();
                    try {
                        Console.this.text.setText(Console.this.readFile(file));
                        FuzzyXMLParser fuzzyXMLParser = new FuzzyXMLParser();
                        fuzzyXMLParser.addErrorListener(new SampleErrorListener());
                        FuzzyXMLDocument fuzzyXMLDocument = fuzzyXMLParser.parse(file);
                        Console.this.text.setCaretPosition(0);
                        Console.this.setTree(fuzzyXMLDocument);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        jToolBar.add(jButton);
        JButton jButton2 = new JButton("Parse");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FuzzyXMLParser fuzzyXMLParser = new FuzzyXMLParser();
                fuzzyXMLParser.addErrorListener(new SampleErrorListener());
                FuzzyXMLDocument fuzzyXMLDocument = fuzzyXMLParser.parse(Console.this.text.getText());
                Console.this.setTree(fuzzyXMLDocument);
            }
        });
        jToolBar.add(jButton2);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel("XPath:"));
        final JTextField jTextField = new JTextField();
        jToolBar.add(jTextField);
        JButton jButton3 = new JButton("Select");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FuzzyXMLNode fuzzyXMLNode = XPath.selectSingleNode(Console.this.doc.getDocumentElement(), jTextField.getText());
                    Console.this.text.setSelectionStart(fuzzyXMLNode.getOffset());
                    Console.this.text.setSelectionEnd(fuzzyXMLNode.getOffset() + fuzzyXMLNode.getLength());
                    Console.this.text.requestFocus();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(Console.this, exception, "Error", 0);
                }
            }
        });
        jToolBar.add(jButton3);
        JButton jButton4 = new JButton("Value");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = XPath.getValue(Console.this.doc.getDocumentElement(), jTextField.getText());
                    JOptionPane.showMessageDialog(Console.this, object, "XPath", 1);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(Console.this, exception, "Error", 0);
                }
            }
        });
        jToolBar.add(jButton4);
        container.add((Component)jToolBar, "North");
        container.add((Component)jSplitPane2, "Center");
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                try {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent();
                    FuzzyXMLNode fuzzyXMLNode = (FuzzyXMLNode)defaultMutableTreeNode.getUserObject();
                    Console.this.text.fire = false;
                    Console.this.text.setSelectionStart(fuzzyXMLNode.getOffset());
                    Console.this.text.setSelectionEnd(fuzzyXMLNode.getOffset() + fuzzyXMLNode.getLength());
                    Console.this.text.requestFocus();
                }
                catch (Exception exception) {
                }
                finally {
                    Console.this.text.fire = true;
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Console.this.showPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Console.this.showPopup(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Console.this.showPopup(mouseEvent);
            }
        });
        this.tree.setSelectionModel(new CustomTreeSelectionModel());
        this.text.setText(this.readFile("sample.xml"));
        this.text.setCaretPosition(0);
        this.text.addCaretListener(new CaretListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void caretUpdate(CaretEvent caretEvent) {
                if (Console.this.doc != null) {
                    TreePath treePath;
                    FuzzyXMLElement fuzzyXMLElement = Console.this.doc.getElementByOffset(Console.this.text.getCaretPosition());
                    if (Console.this.getSelectedNode() != fuzzyXMLElement && (treePath = Console.this.getPath(fuzzyXMLElement)) != null) {
                        try {
                            ((CustomTreeSelectionModel)Console.this.tree.getSelectionModel()).fire = false;
                            Console.this.tree.expandPath(treePath);
                            Console.this.tree.setSelectionPath(treePath);
                            Console.this.tree.scrollPathToVisible(treePath);
                            Console.this.tree.repaint();
                        }
                        finally {
                            ((CustomTreeSelectionModel)Console.this.tree.getSelectionModel()).fire = true;
                        }
                    }
                }
            }
        });
        FuzzyXMLParser fuzzyXMLParser = new FuzzyXMLParser();
        fuzzyXMLParser.addErrorListener(new SampleErrorListener());
        FuzzyXMLDocument fuzzyXMLDocument = fuzzyXMLParser.parse(this.text.getText());
        this.setTree(fuzzyXMLDocument);
    }

    private TreePath getPath(FuzzyXMLNode fuzzyXMLNode) {
        if (this.doc == null) {
            return null;
        }
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        arrayList.add(this.root);
        if (this.searchNode(arrayList, this.root, fuzzyXMLNode)) {
            return new TreePath(arrayList.toArray());
        }
        return null;
    }

    private boolean searchNode(ArrayList arrayList, DefaultMutableTreeNode defaultMutableTreeNode, FuzzyXMLNode fuzzyXMLNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            arrayList.add(defaultMutableTreeNode2);
            if (defaultMutableTreeNode2.getUserObject() == fuzzyXMLNode) {
                return true;
            }
            if (this.searchNode(arrayList, defaultMutableTreeNode2, fuzzyXMLNode)) {
                return true;
            }
            arrayList.remove(defaultMutableTreeNode2);
        }
        return false;
    }

    private void showPopup(MouseEvent mouseEvent) {
        this.updateActions();
        Component component = (Component)mouseEvent.getSource();
        if (mouseEvent.isPopupTrigger()) {
            this.popup.show(component, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void updateActions() {
        FuzzyXMLNode fuzzyXMLNode = this.getSelectedNode();
        this.addNodeAction.setEnabled(false);
        this.insertBeforeAction.setEnabled(false);
        this.addAttrAction.setEnabled(false);
        this.editAttrAction.setEnabled(false);
        this.editPIAction.setEnabled(false);
        this.removeAction.setEnabled(false);
        if (fuzzyXMLNode == null) {
            return;
        }
        if (fuzzyXMLNode.getParentNode() != null) {
            this.removeAction.setEnabled(true);
        }
        if (fuzzyXMLNode instanceof FuzzyXMLElement) {
            this.addNodeAction.setEnabled(true);
            this.addAttrAction.setEnabled(true);
        }
        if (fuzzyXMLNode instanceof FuzzyXMLAttribute) {
            this.editAttrAction.setEnabled(true);
        } else if (fuzzyXMLNode.getParentNode() != null) {
            this.insertBeforeAction.setEnabled(true);
        }
        if (fuzzyXMLNode instanceof FuzzyXMLProcessingInstruction) {
            this.editPIAction.setEnabled(true);
        }
    }

    private void reload(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.model.reload();
        if (defaultMutableTreeNode != null) {
            this.tree.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
        } else if (this.root.getChildCount() > 0) {
            this.tree.expandPath(new TreePath(new Object[]{this.root, this.root.getChildAt(0)}));
        }
    }

    private DefaultMutableTreeNode getSelectionTreeNode() {
        return (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    private FuzzyXMLNode getSelectedNode() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        if (defaultMutableTreeNode.getUserObject() instanceof FuzzyXMLNode) {
            return (FuzzyXMLNode)defaultMutableTreeNode.getUserObject();
        }
        return null;
    }

    private void setTree(FuzzyXMLDocument fuzzyXMLDocument) {
        this.root.removeAllChildren();
        this.doc = fuzzyXMLDocument;
        if (fuzzyXMLDocument != null) {
            FuzzyXMLDocType fuzzyXMLDocType = fuzzyXMLDocument.getDocumentType();
            if (fuzzyXMLDocType != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(fuzzyXMLDocType);
                this.root.add(defaultMutableTreeNode);
            }
            fuzzyXMLDocument.addModifyListener(new SampleListener());
            this.setElement(this.root, fuzzyXMLDocument.getDocumentElement());
        }
        this.reload(null);
    }

    private void setElement(DefaultMutableTreeNode defaultMutableTreeNode, FuzzyXMLElement fuzzyXMLElement) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(fuzzyXMLElement);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        FuzzyXMLAttribute[] fuzzyXMLAttributeArray = fuzzyXMLElement.getAttributes();
        for (int i = 0; i < fuzzyXMLAttributeArray.length; ++i) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(fuzzyXMLAttributeArray[i]));
        }
        FuzzyXMLNode[] fuzzyXMLNodeArray = fuzzyXMLElement.getChildren();
        for (int i = 0; i < fuzzyXMLNodeArray.length; ++i) {
            if (fuzzyXMLNodeArray[i] instanceof FuzzyXMLElement) {
                this.setElement(defaultMutableTreeNode2, (FuzzyXMLElement)fuzzyXMLNodeArray[i]);
                continue;
            }
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(fuzzyXMLNodeArray[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) throws Exception {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = FuzzyXMLUtil.readStream(fileInputStream);
            String string = FuzzyXMLUtil.getEncoding(byArray);
            if (string == null) {
                String string2 = new String(byArray);
                return string2;
            }
            String string3 = new String(byArray, string);
            return string3;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String string) throws Exception {
        URL uRL = (class$jp$aonir$fuzzyxml$sample$Console == null ? (class$jp$aonir$fuzzyxml$sample$Console = Console.class$("jp.aonir.fuzzyxml.sample.Console")) : class$jp$aonir$fuzzyxml$sample$Console).getResource(string);
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            byte[] byArray = FuzzyXMLUtil.readStream(inputStream);
            String string2 = FuzzyXMLUtil.getEncoding(byArray);
            if (string2 == null) {
                String string3 = new String(byArray);
                return string3;
            }
            String string4 = new String(byArray, string2);
            return string4;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Console console = new Console();
        console.setDefaultCloseOperation(3);
        console.setSize(640, 450);
        console.show();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ErrorInfo {
        private String message;
        private int offset;
        private int length;

        public ErrorInfo(String string, int n, int n2) {
            this.message = string;
            this.offset = n;
            this.length = n2;
        }

        public String toString() {
            return "[offset]" + this.offset + " [message]" + this.message;
        }
    }

    private class SampleErrorListener
    implements FuzzyXMLErrorListener {
        public SampleErrorListener() {
            ((DefaultListModel)Console.this.errors.getModel()).removeAllElements();
        }

        public void error(FuzzyXMLErrorEvent fuzzyXMLErrorEvent) {
            ((DefaultListModel)Console.this.errors.getModel()).addElement(new ErrorInfo(fuzzyXMLErrorEvent.getMessage(), fuzzyXMLErrorEvent.getOffset(), fuzzyXMLErrorEvent.getLength()));
        }
    }

    private class SampleListener
    implements FuzzyXMLModifyListener {
        private SampleListener() {
        }

        public void modified(FuzzyXMLModifyEvent fuzzyXMLModifyEvent) {
            Console.this.text.setSelectionStart(fuzzyXMLModifyEvent.getOffset());
            Console.this.text.setSelectionEnd(fuzzyXMLModifyEvent.getOffset() + fuzzyXMLModifyEvent.getLength());
            Console.this.text.replaceSelection(fuzzyXMLModifyEvent.getNewText());
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super("Remove");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FuzzyXMLNode fuzzyXMLNode = Console.this.getSelectedNode();
            if (fuzzyXMLNode != null && Console.this.doc != null) {
                ((FuzzyXMLElement)fuzzyXMLNode.getParentNode()).removeChild(fuzzyXMLNode);
                DefaultMutableTreeNode defaultMutableTreeNode = Console.this.getSelectionTreeNode();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                defaultMutableTreeNode.removeFromParent();
                if (defaultMutableTreeNode2.getChildCount() == 0) {
                    Console.this.reload(defaultMutableTreeNode2);
                } else {
                    Console.this.reload((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0));
                }
            }
        }
    }

    private class EditPIAction
    extends AbstractAction {
        public EditPIAction() {
            super("Edit processing instruction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = Console.this.getSelectionTreeNode();
            FuzzyXMLNode fuzzyXMLNode = Console.this.getSelectedNode();
            if (fuzzyXMLNode != null && fuzzyXMLNode instanceof FuzzyXMLProcessingInstruction) {
                FuzzyXMLProcessingInstruction fuzzyXMLProcessingInstruction = (FuzzyXMLProcessingInstruction)fuzzyXMLNode;
                ConsolePIDialog consolePIDialog = new ConsolePIDialog((Frame)Console.this, "Edit processing instriction");
                consolePIDialog.setData(fuzzyXMLProcessingInstruction.getData());
                if (consolePIDialog.openDialog()) {
                    String string = consolePIDialog.getData();
                    fuzzyXMLProcessingInstruction.setData(string);
                    Console.this.reload(defaultMutableTreeNode);
                }
            }
        }
    }

    private class EditAttrAction
    extends AbstractAction {
        public EditAttrAction() {
            super("Edit attribute");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = Console.this.getSelectionTreeNode();
            FuzzyXMLNode fuzzyXMLNode = Console.this.getSelectedNode();
            if (fuzzyXMLNode != null && fuzzyXMLNode instanceof FuzzyXMLAttribute) {
                FuzzyXMLAttribute fuzzyXMLAttribute = (FuzzyXMLAttribute)fuzzyXMLNode;
                ConsoleAttrDialog consoleAttrDialog = new ConsoleAttrDialog((Frame)Console.this, "Edit attribute");
                consoleAttrDialog.setName(fuzzyXMLAttribute.getName());
                consoleAttrDialog.setValue(fuzzyXMLAttribute.getValue());
                if (consoleAttrDialog.openDialog()) {
                    String string = consoleAttrDialog.getValue();
                    fuzzyXMLAttribute.setValue(string);
                    Console.this.reload(defaultMutableTreeNode);
                }
            }
        }
    }

    private class AddAttrAction
    extends AbstractAction {
        public AddAttrAction() {
            super("Add attribute");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConsoleAttrDialog consoleAttrDialog;
            FuzzyXMLNode fuzzyXMLNode = Console.this.getSelectedNode();
            if (fuzzyXMLNode != null && fuzzyXMLNode instanceof FuzzyXMLElement && (consoleAttrDialog = new ConsoleAttrDialog((Frame)Console.this, "Add attribute")).openDialog()) {
                String string = consoleAttrDialog.getName();
                String string2 = consoleAttrDialog.getValue();
                FuzzyXMLAttribute fuzzyXMLAttribute = Console.this.doc.createAttribute(string);
                fuzzyXMLAttribute.setValue(string2);
                ((FuzzyXMLElement)fuzzyXMLNode).setAttribute(fuzzyXMLAttribute);
                DefaultMutableTreeNode defaultMutableTreeNode = Console.this.getSelectionTreeNode();
                int n = defaultMutableTreeNode.getChildCount();
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                    Object object = defaultMutableTreeNode2.getUserObject();
                    if (object instanceof FuzzyXMLAttribute) continue;
                    n2 = i;
                    break;
                }
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(fuzzyXMLAttribute);
                defaultMutableTreeNode.insert(defaultMutableTreeNode3, n2);
                Console.this.reload(defaultMutableTreeNode3);
            }
        }
    }

    private class ReplaceNodeAction
    extends AbstractAction {
        public ReplaceNodeAction() {
            super("Replace node");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConsoleNodeDialog consoleNodeDialog;
            FuzzyXMLNode fuzzyXMLNode = Console.this.getSelectedNode();
            if (fuzzyXMLNode != null && (consoleNodeDialog = new ConsoleNodeDialog((Frame)Console.this, "Replace node")).openDialog()) {
                String string = consoleNodeDialog.getNodeType();
                String string2 = consoleNodeDialog.getValue();
                int n = Console.this.model.getIndexOfChild(Console.this.getSelectionTreeNode().getParent(), Console.this.getSelectionTreeNode());
                FuzzyXMLNode fuzzyXMLNode2 = null;
                if (string.equals("Element")) {
                    fuzzyXMLNode2 = Console.this.doc.createElement(string2);
                } else if (string.equals("Comment")) {
                    fuzzyXMLNode2 = Console.this.doc.createComment(string2);
                } else if (string.equals("CDATA")) {
                    fuzzyXMLNode2 = Console.this.doc.createCDATASection(string2);
                } else if (string.equals("Text")) {
                    fuzzyXMLNode2 = Console.this.doc.createText(string2);
                }
                ((FuzzyXMLElement)fuzzyXMLNode.getParentNode()).replaceChild(fuzzyXMLNode2, fuzzyXMLNode);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(fuzzyXMLNode2);
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)Console.this.getSelectionTreeNode().getParent();
                defaultMutableTreeNode2.remove(n);
                defaultMutableTreeNode2.insert(defaultMutableTreeNode, n);
                Console.this.reload(defaultMutableTreeNode);
            }
        }
    }

    private class InsertBeforeAction
    extends AbstractAction {
        public InsertBeforeAction() {
            super("Insert node before");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConsoleNodeDialog consoleNodeDialog;
            FuzzyXMLNode fuzzyXMLNode = Console.this.getSelectedNode();
            if (fuzzyXMLNode != null && (consoleNodeDialog = new ConsoleNodeDialog((Frame)Console.this, "Add node")).openDialog()) {
                String string = consoleNodeDialog.getNodeType();
                String string2 = consoleNodeDialog.getValue();
                int n = Console.this.model.getIndexOfChild(Console.this.getSelectionTreeNode().getParent(), Console.this.getSelectionTreeNode());
                FuzzyXMLNode fuzzyXMLNode2 = null;
                if (string.equals("Element")) {
                    fuzzyXMLNode2 = Console.this.doc.createElement(string2);
                } else if (string.equals("Comment")) {
                    fuzzyXMLNode2 = Console.this.doc.createComment(string2);
                } else if (string.equals("CDATA")) {
                    fuzzyXMLNode2 = Console.this.doc.createCDATASection(string2);
                } else if (string.equals("Text")) {
                    fuzzyXMLNode2 = Console.this.doc.createText(string2);
                }
                ((FuzzyXMLElement)fuzzyXMLNode.getParentNode()).insertBefore(fuzzyXMLNode2, fuzzyXMLNode);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(fuzzyXMLNode2);
                ((DefaultMutableTreeNode)Console.this.getSelectionTreeNode().getParent()).insert(defaultMutableTreeNode, n);
                Console.this.reload(defaultMutableTreeNode);
            }
        }
    }

    private class AddNodeAction
    extends AbstractAction {
        public AddNodeAction() {
            super("Add node");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConsoleNodeDialog consoleNodeDialog;
            FuzzyXMLNode fuzzyXMLNode = Console.this.getSelectedNode();
            if (fuzzyXMLNode != null && fuzzyXMLNode instanceof FuzzyXMLElement && (consoleNodeDialog = new ConsoleNodeDialog((Frame)Console.this, "Add node")).openDialog()) {
                String string = consoleNodeDialog.getNodeType();
                String string2 = consoleNodeDialog.getValue();
                FuzzyXMLNode fuzzyXMLNode2 = null;
                if (string.equals("Element")) {
                    fuzzyXMLNode2 = Console.this.doc.createElement(string2);
                } else if (string.equals("Comment")) {
                    fuzzyXMLNode2 = Console.this.doc.createComment(string2);
                } else if (string.equals("CDATA")) {
                    fuzzyXMLNode2 = Console.this.doc.createCDATASection(string2);
                } else if (string.equals("Text")) {
                    fuzzyXMLNode2 = Console.this.doc.createText(string2);
                }
                ((FuzzyXMLElement)fuzzyXMLNode).appendChild(fuzzyXMLNode2);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(fuzzyXMLNode2);
                Console.this.getSelectionTreeNode().add(defaultMutableTreeNode);
                Console.this.reload(defaultMutableTreeNode);
            }
        }
    }

    private class CustomTreeSelectionModel
    extends DefaultTreeSelectionModel {
        private boolean fire = true;

        private CustomTreeSelectionModel() {
        }

        protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (this.fire) {
                super.fireValueChanged(treeSelectionEvent);
            }
        }
    }

    private class CustomTextArea
    extends JTextArea {
        private boolean fire = true;

        private CustomTextArea() {
        }

        protected void fireCaretUpdate(CaretEvent caretEvent) {
            if (this.fire) {
                super.fireCaretUpdate(caretEvent);
            }
        }
    }
}

