/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.xpath;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.xpath.FuzzyXMLNodePointer;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class FuzzyXMLNodeIterator
implements NodeIterator {
    private NodePointer parent;
    private NodeTest nodeTest;
    private boolean reverse;
    private int position = 0;
    private int index = 0;
    private List children;
    private Object child;

    public FuzzyXMLNodeIterator(NodePointer nodePointer, NodeTest nodeTest, boolean bl, NodePointer nodePointer2) {
        Object object;
        this.parent = nodePointer;
        if (nodePointer2 != null) {
            this.child = nodePointer2.getNode();
        }
        this.children = (object = nodePointer.getNode()) instanceof FuzzyXMLDocument ? Arrays.asList(((FuzzyXMLDocument)object).getDocumentElement()) : (object instanceof FuzzyXMLElement ? Arrays.asList(((FuzzyXMLElement)object).getChildren()) : Collections.EMPTY_LIST);
        this.nodeTest = nodeTest;
        this.reverse = bl;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int n) {
        while (this.position < n) {
            if (this.next()) continue;
            return false;
        }
        while (this.position > n) {
            if (this.previous()) continue;
            return false;
        }
        return true;
    }

    public NodePointer getNodePointer() {
        if (this.child == null) {
            if (!this.setPosition(1)) {
                return null;
            }
            this.position = 0;
        }
        return new FuzzyXMLNodePointer(this.parent, this.child);
    }

    private boolean previous() {
        --this.position;
        if (!this.reverse) {
            while (--this.index >= 0) {
                this.child = this.children.get(this.index);
                if (!this.testChild()) continue;
                return true;
            }
        } else {
            while (this.index < this.children.size()) {
                this.child = this.children.get(this.index);
                if (this.testChild()) {
                    return true;
                }
                ++this.index;
            }
        }
        return false;
    }

    private boolean next() {
        ++this.position;
        if (!this.reverse) {
            if (this.position == 1) {
                this.index = 0;
                if (this.child != null) {
                    this.index = this.children.indexOf(this.child) + 1;
                }
            } else {
                ++this.index;
            }
            while (this.index < this.children.size()) {
                this.child = this.children.get(this.index);
                if (this.testChild()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }
        if (this.position == 1) {
            this.index = this.children.size() - 1;
            if (this.child != null) {
                this.index = this.children.indexOf(this.child) - 1;
            }
        } else {
            --this.index;
        }
        while (this.index >= 0) {
            this.child = this.children.get(this.index);
            if (this.testChild()) {
                return true;
            }
            --this.index;
        }
        return false;
    }

    private boolean testChild() {
        return FuzzyXMLNodePointer.testNode(this.parent, this.child, this.nodeTest);
    }
}

