/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.csseditor.editors;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Display;
import tk.eclipse.plugin.csseditor.editors.CSSAssistProcessor;
import tk.eclipse.plugin.csseditor.editors.CSSBlockScanner;
import tk.eclipse.plugin.htmleditor.ColorProvider;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class CSSConfiguration
extends SourceViewerConfiguration {
    private ColorProvider colorProvider;
    private RuleBasedScanner commentScanner;
    private CSSBlockScanner blockScanner;
    private RuleBasedScanner defaultScanner;

    public CSSConfiguration(ColorProvider colorProvider) {
        this.colorProvider = colorProvider;
    }

    private RuleBasedScanner getCommentScanner() {
        if (this.commentScanner == null) {
            this.commentScanner = new RuleBasedScanner();
            this.commentScanner.setDefaultReturnToken(this.colorProvider.getToken("_pref_color_comment"));
        }
        return this.commentScanner;
    }

    private CSSBlockScanner getBlockScanner() {
        if (this.blockScanner == null) {
            this.blockScanner = new CSSBlockScanner(this.colorProvider);
            this.blockScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(Display.getDefault().getSystemColor(2))));
        }
        return this.blockScanner;
    }

    private RuleBasedScanner getDefaultScanner() {
        if (this.defaultScanner == null) {
            this.defaultScanner = new RuleBasedScanner();
            this.defaultScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(Display.getDefault().getSystemColor(2))));
        }
        return this.defaultScanner;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__css_comment", "__css_block"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.enableAutoInsert(true);
        CSSAssistProcessor processor = new CSSAssistProcessor();
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__css_block");
        assistant.install((ITextViewer)sourceViewer);
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        assistant.enableAutoActivation(store.getBoolean("_pref_assist_auto"));
        assistant.setAutoActivationDelay(store.getInt("_pref_assist_times"));
        return assistant;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = null;
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getBlockScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__css_block");
        reconciler.setRepairer((IPresentationRepairer)dr, "__css_block");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__css_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__css_comment");
        return reconciler;
    }
}

