/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.csseditor.editors;

import com.steadystate.css.parser.CSSOMParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import tk.eclipse.plugin.csseditor.editors.CSSEditor;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class CSSOutlinePage
extends ContentOutlinePage {
    private CSSEditor editor;
    private ArrayList selectors = new ArrayList();

    public CSSOutlinePage(CSSEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new CSSContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new CSSLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)new CSSSelectionChangedListener());
        viewer.setInput((Object)this.selectors);
        this.update();
    }

    public void update() {
        try {
            CSSOMParser parser = new CSSOMParser();
            InputSource is = new InputSource((Reader)new StringReader(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get()));
            CSSStyleSheet stylesheet = parser.parseStyleSheet(is);
            this.selectors.clear();
            CSSRuleList list = stylesheet.getCssRules();
            int i = 0;
            while (i < list.getLength()) {
                CSSRule rule = list.item(i);
                if (rule instanceof CSSStyleRule) {
                    CSSStyleRule styleRule = (CSSStyleRule)rule;
                    String selector = styleRule.getSelectorText();
                    this.selectors.add(selector);
                }
                ++i;
            }
            this.getTreeViewer().refresh();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class CSSContentProvider
    implements ITreeContentProvider {
        CSSContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ArrayList) {
                return ((ArrayList)parentElement).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof String) {
                return CSSOutlinePage.this.selectors;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class CSSSelectionChangedListener
    implements ISelectionChangedListener {
        private Object prev = null;

        CSSSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            String element = (String)sel.getFirstElement();
            element = element.replaceAll("\\*", "");
            String text = CSSOutlinePage.this.editor.getDocumentProvider().getDocument((Object)CSSOutlinePage.this.editor.getEditorInput()).get();
            int offset = text.indexOf(element);
            if (offset >= 0) {
                CSSOutlinePage.this.editor.selectAndReveal(offset, 0);
            }
        }
    }

    private class CSSLabelProvider
    extends LabelProvider {
        CSSLabelProvider() {
        }

        public Image getImage(Object element) {
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_css_rule");
        }
    }
}

