/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.ui.UpdateUI;
import org.osgi.framework.BundleContext;
import tk.eclipse.plugin.htmleditor.ColorProvider;
import tk.eclipse.plugin.htmleditor.ICustomTagAttributeAssist;
import tk.eclipse.plugin.htmleditor.ICustomTagConverterContributer;
import tk.eclipse.plugin.htmleditor.IFileAssistProcessor;
import tk.eclipse.plugin.htmleditor.IHyperlinkProvider;
import tk.eclipse.plugin.htmleditor.views.IPaletteContributer;

public class HTMLPlugin
extends AbstractUIPlugin {
    private static HTMLPlugin plugin;
    private ResourceBundle resourceBundle;
    private ColorProvider colorProvider;
    public static final String PLUGIN_ID = "tk.eclipse.plugin.htmleditor";
    public static final String ICON_HTML = "_icon_html";
    public static final String ICON_XML = "_icon_xml";
    public static final String ICON_JSP = "_icon_jsp";
    public static final String ICON_CSS = "_icon_css";
    public static final String ICON_WEB = "_icon_web";
    public static final String ICON_FILE = "_icon_file";
    public static final String ICON_TAG = "_icon_tag";
    public static final String ICON_ATTR = "_icon_attribute";
    public static final String ICON_VALUE = "_icon_value";
    public static final String ICON_FOLDER = "_icon_folder";
    public static final String ICON_BUTTON = "_icon_button";
    public static final String ICON_TEXT = "_icon_text";
    public static final String ICON_RADIO = "_icon_radio";
    public static final String ICON_CHECK = "_icon_check";
    public static final String ICON_SELECT = "_icon_select";
    public static final String ICON_TEXTAREA = "_icon_textarea";
    public static final String ICON_FORM = "_icon_form";
    public static final String ICON_TABLE = "_icon_table";
    public static final String ICON_COLUMN = "_icon_column";
    public static final String ICON_LABEL = "_icon_label";
    public static final String ICON_PASS = "_icon_pass";
    public static final String ICON_LIST = "_icon_list";
    public static final String ICON_PANEL = "_icon_panel";
    public static final String ICON_LINK = "_icon_link";
    public static final String ICON_HIDDEN = "_icon_hidden";
    public static final String ICON_OUTPUT = "_icon_output";
    public static final String ICON_CSS_RULE = "_icon_css_rule";
    public static final String ICON_CSS_PROP = "_icon_css_prop";
    public static final String PREF_COLOR_TAG = "_pref_color_tag";
    public static final String PREF_COLOR_COMMENT = "_pref_color_comment";
    public static final String PREF_COLOR_STRING = "_pref_color_string";
    public static final String PREF_COLOR_DOCTYPE = "_pref_color_doctype";
    public static final String PREF_COLOR_SCRIPT = "_pref_color_scriptlet";
    public static final String PREF_COLOR_CSSPROP = "_pref_color_cssprop";
    public static final String PREF_EDITOR_TYPE = "_pref_editor_type";
    public static final String PREF_DTD_URI = "_pref_dtd_uri";
    public static final String PREF_DTD_PATH = "_pref_dtd_path";
    public static final String PREF_DTD_CACHE = "_pref_dtd_cache";
    public static final String PREF_ASSIST_AUTO = "_pref_assist_auto";
    public static final String PREF_ASSIST_CHARS = "_pref_assist_chars";
    public static final String PREF_ASSIST_TIMES = "_pref_assist_times";
    public static final String PREF_ASSIST_CLOSE = "_pref_assist_close";
    public static final String[] SUPPORTED_IMAGE_TYPES;
    private static final String FCK_EDITOR_VERSION = "2.0rc2";
    private String[] noValidationNatureIds;
    private HashMap converterContributers = null;
    private ArrayList customTagAttrAssists = null;
    private ArrayList hyperlinkProviders = null;
    private HashMap palette = null;

    static {
        SUPPORTED_IMAGE_TYPES = new String[]{"gif", "png", "jpg", "jpeg", "bmp"};
    }

    public HTMLPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("tk.eclipse.plugin.htmleditor.HTMLPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public ColorProvider getColorProvider() {
        return this.colorProvider;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.colorProvider = new ColorProvider(this.getPreferenceStore());
        UpdateCore.getPlugin();
        UpdateUI.getDefault();
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(ICON_HTML, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/html.png")));
        reg.put(ICON_XML, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/xml.png")));
        reg.put(ICON_JSP, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/jsp.png")));
        reg.put(ICON_CSS, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/css.png")));
        reg.put(ICON_WEB, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/web.gif")));
        reg.put(ICON_FILE, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/file.gif")));
        reg.put(ICON_TAG, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/tag.gif")));
        reg.put(ICON_ATTR, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/attribute.gif")));
        reg.put(ICON_VALUE, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/value.gif")));
        reg.put(ICON_FOLDER, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/folder.gif")));
        reg.put(ICON_BUTTON, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/button.gif")));
        reg.put(ICON_TEXT, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/text.gif")));
        reg.put(ICON_RADIO, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/radio.gif")));
        reg.put(ICON_CHECK, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/checkbox.gif")));
        reg.put(ICON_SELECT, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/select.gif")));
        reg.put(ICON_TEXTAREA, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/textarea.gif")));
        reg.put(ICON_FORM, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/form.gif")));
        reg.put(ICON_TABLE, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/table.gif")));
        reg.put(ICON_COLUMN, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/column.gif")));
        reg.put(ICON_LABEL, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/label.gif")));
        reg.put(ICON_PASS, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/password.gif")));
        reg.put(ICON_LIST, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/list.gif")));
        reg.put(ICON_PANEL, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/panel.gif")));
        reg.put(ICON_LINK, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/link.gif")));
        reg.put(ICON_HIDDEN, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/hidden.gif")));
        reg.put(ICON_OUTPUT, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/output.gif")));
        reg.put(ICON_CSS_RULE, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/css_rule.gif")));
        reg.put(ICON_CSS_PROP, ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("/icons/css_prop.gif")));
    }

    public void stop(BundleContext context) throws Exception {
        this.colorProvider.dispose();
        super.stop(context);
    }

    public static HTMLPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = HTMLPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void openAlertDialog(String message) {
        MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 1);
        box.setMessage(message);
        box.setText(HTMLPlugin.getResourceString("ErrorDialog.Caption"));
        box.open();
    }

    public static String createMessage(String message, String[] params) {
        int i = 0;
        while (i < params.length) {
            message = message.replaceAll("\\{" + i + "\\}", params[i]);
            ++i;
        }
        return message;
    }

    public static void logDebug(String message) {
        ILog log = HTMLPlugin.getDefault().getLog();
        Status status = new Status(1, PLUGIN_ID, 0, message, null);
        log.log((IStatus)status);
    }

    public static void logError(String message) {
        ILog log = HTMLPlugin.getDefault().getLog();
        Status status = new Status(4, PLUGIN_ID, 0, message, null);
        log.log((IStatus)status);
    }

    public static void logException(Throwable ex) {
        ILog log = HTMLPlugin.getDefault().getLog();
        Object status = null;
        status = ex instanceof CoreException ? ((CoreException)ex).getStatus() : new Status(4, PLUGIN_ID, 0, ex.toString(), ex);
        log.log(status);
        ex.printStackTrace();
    }

    public String[] getNoValidationNatureId() {
        if (this.noValidationNatureIds == null) {
            ArrayList<String> list = new ArrayList<String>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("tk.eclipse.plugin.htmleditor.noValidationNatures");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if ("noValidationNature".equals(elements[j].getName())) {
                        String natureId = elements[j].getAttribute("natureId");
                        list.add(natureId);
                    }
                    ++j;
                }
                ++i;
            }
            this.noValidationNatureIds = list.toArray(new String[list.size()]);
        }
        return this.noValidationNatureIds;
    }

    public IFileAssistProcessor[] getFileAssistProcessors() {
        try {
            ArrayList<IFileAssistProcessor> list = new ArrayList<IFileAssistProcessor>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("tk.eclipse.plugin.htmleditor.fileAssistProcessor");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IFileAssistProcessor assist = (IFileAssistProcessor)elements[j].createExecutableExtension("class");
                    list.add(assist);
                    ++j;
                }
                ++i;
            }
            return list.toArray(new IFileAssistProcessor[list.size()]);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
            return new IFileAssistProcessor[0];
        }
    }

    public ICustomTagConverterContributer getCustomTagContributer(String uri) {
        try {
            if (this.converterContributers == null) {
                this.converterContributers = new HashMap();
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint point = registry.getExtensionPoint("tk.eclipse.plugin.htmleditor.customTagConverter");
                IExtension[] extensions = point.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        if ("contributer".equals(elements[j].getName())) {
                            String contributerUri = elements[j].getAttribute("uri");
                            ICustomTagConverterContributer contributer = (ICustomTagConverterContributer)elements[j].createExecutableExtension("class");
                            this.converterContributers.put(contributerUri, contributer);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return (ICustomTagConverterContributer)this.converterContributers.get(uri);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
            return null;
        }
    }

    public ICustomTagAttributeAssist[] getCustomTagAttributeAssists() {
        try {
            if (this.customTagAttrAssists == null) {
                this.customTagAttrAssists = new ArrayList();
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint point = registry.getExtensionPoint("tk.eclipse.plugin.htmleditor.customTagAttributeAssist");
                IExtension[] extensions = point.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        if ("customTagAttributeAssist".equals(elements[j].getName())) {
                            ICustomTagAttributeAssist loader = (ICustomTagAttributeAssist)elements[j].createExecutableExtension("class");
                            this.customTagAttrAssists.add(loader);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return this.customTagAttrAssists.toArray(new ICustomTagAttributeAssist[this.customTagAttrAssists.size()]);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
            return new ICustomTagAttributeAssist[0];
        }
    }

    public IHyperlinkProvider[] getHyperlinkProviders() {
        try {
            if (this.hyperlinkProviders == null) {
                this.hyperlinkProviders = new ArrayList();
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint point = registry.getExtensionPoint("tk.eclipse.plugin.htmleditor.hyperlinkProvider");
                IExtension[] extensions = point.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        if ("provider".equals(elements[j].getName())) {
                            IHyperlinkProvider provider = (IHyperlinkProvider)elements[j].createExecutableExtension("class");
                            this.hyperlinkProviders.add(provider);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return this.hyperlinkProviders.toArray(new IHyperlinkProvider[this.hyperlinkProviders.size()]);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
            return new IHyperlinkProvider[0];
        }
    }

    public IPaletteContributer getPaletteContributer(String group) {
        if (this.palette == null) {
            this.loadPalleteContributer();
        }
        return (IPaletteContributer)this.palette.get(group);
    }

    public String[] getPaletteContributerGroups() {
        if (this.palette == null) {
            this.loadPalleteContributer();
        }
        return this.palette.keySet().toArray(new String[0]);
    }

    private void loadPalleteContributer() {
        try {
            this.palette = new HashMap();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("tk.eclipse.plugin.htmleditor.paletteItem");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if ("contributer".equals(elements[j].getName())) {
                        String group = elements[j].getAttribute("name");
                        IPaletteContributer contributer = (IPaletteContributer)elements[j].createExecutableExtension("class");
                        this.palette.put(group, contributer);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }
}

