/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.util.ArrayList;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.IHyperlinkProvider;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;

public class HTMLHyperlinkSupport
implements KeyListener,
MouseListener,
MouseMoveListener,
FocusListener,
PaintListener,
IDocumentListener,
ITextInputListener,
ITextPresentationListener {
    private boolean active;
    private IRegion activeRegion;
    private Cursor cursor;
    private Color color;
    private Object open;
    private Position fRememberedPosition;
    private IProject project;
    private HTMLSourceEditor editor;
    private ArrayList providers = new ArrayList();

    public HTMLHyperlinkSupport(HTMLSourceEditor editor) {
        this.editor = editor;
    }

    public void addHyperlinkProvider(IHyperlinkProvider provider) {
        this.providers.add(provider);
    }

    public void install() {
        ISourceViewer sourceViewer = this.editor.getViewer();
        if (sourceViewer == null) {
            return;
        }
        StyledText text = sourceViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        this.color = Display.getCurrent().getSystemColor(9);
        sourceViewer.addTextInputListener((ITextInputListener)this);
        IDocument document = sourceViewer.getDocument();
        if (document != null) {
            document.addDocumentListener((IDocumentListener)this);
        }
        text.addKeyListener((KeyListener)this);
        text.addMouseListener((MouseListener)this);
        text.addMouseMoveListener((MouseMoveListener)this);
        text.addFocusListener((FocusListener)this);
        text.addPaintListener((PaintListener)this);
        ((ITextViewerExtension4)sourceViewer).addTextPresentationListener((ITextPresentationListener)this);
    }

    public void uninstall() {
        IDocument document;
        IDocumentProvider documentProvider;
        ISourceViewer sourceViewer;
        if (this.color != null) {
            this.color.dispose();
            this.color = null;
        }
        if (this.cursor != null) {
            this.cursor.dispose();
            this.cursor = null;
        }
        if ((sourceViewer = this.editor.getViewer()) != null) {
            sourceViewer.removeTextInputListener((ITextInputListener)this);
        }
        if ((documentProvider = this.editor.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)this.editor.getEditorInput())) != null) {
            document.removeDocumentListener((IDocumentListener)this);
        }
        if (sourceViewer == null) {
            return;
        }
        StyledText text = sourceViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        text.removeKeyListener((KeyListener)this);
        text.removeMouseListener((MouseListener)this);
        text.removeMouseMoveListener((MouseMoveListener)this);
        text.removeFocusListener((FocusListener)this);
        text.removePaintListener((PaintListener)this);
        ((ITextViewerExtension4)sourceViewer).removeTextPresentationListener((ITextPresentationListener)this);
    }

    public void deactivate() {
        this.deactivate(false);
    }

    public void deactivate(boolean redrawAll) {
        if (!this.active) {
            return;
        }
        this.repairRepresentation(redrawAll);
        this.active = false;
    }

    private void resetCursor(ISourceViewer viewer) {
        StyledText text = viewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.setCursor(null);
        }
        if (this.cursor != null) {
            this.cursor.dispose();
            this.cursor = null;
        }
    }

    private void repairRepresentation() {
        this.repairRepresentation(false);
    }

    private void repairRepresentation(boolean redrawAll) {
        if (this.activeRegion == null) {
            return;
        }
        int offset = this.activeRegion.getOffset();
        int length = this.activeRegion.getLength();
        this.activeRegion = null;
        ISourceViewer viewer = this.editor.getViewer();
        if (viewer != null) {
            this.resetCursor(viewer);
            if (!redrawAll && viewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)viewer).invalidateTextPresentation(offset, length);
            } else {
                viewer.invalidateTextPresentation();
            }
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                offset = extension.modelOffset2WidgetOffset(offset);
            } else {
                offset -= viewer.getVisibleRegion().getOffset();
            }
            try {
                StyledText text = viewer.getTextWidget();
                text.redrawRange(offset, length, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.active) {
            this.deactivate();
            return;
        }
        if (e.keyCode != 262144) {
            this.deactivate();
            return;
        }
        this.active = true;
    }

    public void keyReleased(KeyEvent event) {
        if (!this.active) {
            return;
        }
        this.deactivate();
    }

    public void mouseUp(MouseEvent e) {
        if (!this.active) {
            return;
        }
        if (e.button != 1) {
            this.deactivate();
            return;
        }
        boolean wasActive = this.cursor != null;
        this.deactivate();
        if (wasActive) {
            try {
                if (this.open instanceof IFile) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)((IFile)this.open), (boolean)true);
                } else if (this.open instanceof IJavaElement) {
                    OpenActionUtil.open((Object)this.open, (boolean)true);
                }
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent event) {
        if (!this.active) {
            return;
        }
        if (event.stateMask != 262144) {
            this.deactivate();
            return;
        }
        if (event.button != 1) {
            this.deactivate();
            return;
        }
    }

    public void mouseMove(MouseEvent event) {
        ISourceViewer viewer;
        if (event.widget instanceof Control && !((Control)event.widget).isFocusControl()) {
            this.deactivate();
            return;
        }
        if (!this.active) {
            if (event.stateMask != 262144) {
                return;
            }
            this.active = true;
        }
        if ((viewer = this.editor.getViewer()) == null) {
            this.deactivate();
            return;
        }
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            this.deactivate();
            return;
        }
        if ((event.stateMask & 0x80000) != 0 && text.getSelectionCount() != 0) {
            this.deactivate();
            return;
        }
        IRegion region = this.getCurrentTextRegion(viewer);
        if (region == null || region.getLength() == 0) {
            this.repairRepresentation();
            return;
        }
        this.highlightRegion(viewer, region);
        this.activateCursor(viewer);
    }

    private void activateCursor(ISourceViewer viewer) {
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        Display display = text.getDisplay();
        if (this.cursor == null) {
            this.cursor = new Cursor((Device)display, 21);
        }
        text.setCursor(this.cursor);
    }

    private IRegion selectWord(IDocument doc, int offset) {
        FuzzyXMLDocument document = new FuzzyXMLParser().parse(this.editor.getHTMLSource());
        FuzzyXMLElement element = document.getElementByOffset(offset);
        if (element == null) {
            return null;
        }
        FuzzyXMLAttribute[] attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i].getOffset() < offset && offset < attrs[i].getOffset() + attrs[i].getLength()) {
                int attrOffset = this.getAttributeValueOffset(doc.get(), attrs[i]);
                int attrLength = attrs[i].getValue().length();
                if (attrOffset >= 0 && attrLength >= 0 && attrOffset <= offset) {
                    this.open = this.getOpenFileInfo(document, element, attrs[i].getName(), attrs[i].getValue());
                    if (this.open != null) {
                        return new Region(attrOffset, attrLength);
                    }
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    private Object getOpenFileInfo(FuzzyXMLDocument doc, FuzzyXMLElement element, String attrName, String attrValue) {
        try {
            if (this.project == null) {
                return null;
            }
            IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
            int i = 0;
            while (i < this.providers.size()) {
                IHyperlinkProvider provider = (IHyperlinkProvider)this.providers.get(i);
                Object obj = provider.getObject(file, doc, element, attrName, attrValue);
                if (obj != null) {
                    return obj;
                }
                ++i;
            }
            if (attrName.equalsIgnoreCase("href")) {
                IPath path;
                IResource resource;
                String href = attrValue;
                if (href.indexOf("#") > 0) {
                    href = href.substring(0, href.indexOf("#"));
                }
                if ((resource = this.project.findMember((path = file.getParent().getProjectRelativePath()).append(href))) != null && resource.exists() && resource instanceof IFile) {
                    return resource;
                }
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
        return null;
    }

    private int getAttributeValueOffset(String source, FuzzyXMLAttribute attr) {
        int offset = source.indexOf(61, attr.getOffset());
        if (offset == -1) {
            return -1;
        }
        int c = 32;
        while (c == 32 || c == 9 || c == 13 || c == 10 || c == 34 || c == 39) {
            if (source.length() == ++offset + 1) break;
            c = source.charAt(offset);
        }
        return offset;
    }

    private IRegion getCurrentTextRegion(ISourceViewer viewer) {
        int offset = this.getCurrentTextOffset(viewer);
        if (offset == -1) {
            return null;
        }
        return this.selectWord(viewer.getDocument(), offset);
    }

    private int getCurrentTextOffset(ISourceViewer viewer) {
        try {
            StyledText text = viewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return -1;
            }
            Display display = text.getDisplay();
            Point absolutePosition = display.getCursorLocation();
            Point relativePosition = text.toControl(absolutePosition);
            int widgetOffset = text.getOffsetAtLocation(relativePosition);
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                return extension.widgetOffset2ModelOffset(widgetOffset);
            }
            return widgetOffset + viewer.getVisibleRegion().getOffset();
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    private void highlightRegion(ISourceViewer viewer, IRegion region) {
        if (region.equals(this.activeRegion)) {
            return;
        }
        this.repairRepresentation();
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int offset = 0;
        int length = 0;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            IRegion widgetRange = extension.modelRange2WidgetRange(region);
            if (widgetRange == null) {
                return;
            }
            offset = widgetRange.getOffset();
            length = widgetRange.getLength();
        } else {
            offset = region.getOffset() - viewer.getVisibleRegion().getOffset();
            length = region.getLength();
        }
        text.redrawRange(offset, length, false);
        this.activeRegion = region;
        if (viewer instanceof ITextViewerExtension2) {
            ((ITextViewerExtension2)viewer).invalidateTextPresentation(region.getOffset(), region.getLength());
        } else {
            viewer.invalidateTextPresentation();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent event) {
        this.deactivate();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        if (this.active && this.activeRegion != null) {
            this.fRememberedPosition = new Position(this.activeRegion.getOffset(), this.activeRegion.getLength());
            try {
                event.getDocument().addPosition(this.fRememberedPosition);
            }
            catch (BadLocationException x) {
                this.fRememberedPosition = null;
            }
        }
    }

    public void documentChanged(DocumentEvent event) {
        if (this.fRememberedPosition != null) {
            if (!this.fRememberedPosition.isDeleted()) {
                StyledText widget;
                event.getDocument().removePosition(this.fRememberedPosition);
                this.activeRegion = new Region(this.fRememberedPosition.getOffset(), this.fRememberedPosition.getLength());
                this.fRememberedPosition = null;
                ISourceViewer viewer = this.editor.getViewer();
                if (viewer != null && (widget = viewer.getTextWidget()) != null && !widget.isDisposed()) {
                    widget.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            HTMLHyperlinkSupport.this.deactivate();
                        }
                    });
                }
            } else {
                this.activeRegion = null;
                this.fRememberedPosition = null;
                this.deactivate();
            }
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (oldInput == null) {
            return;
        }
        this.deactivate();
        oldInput.removeDocumentListener((IDocumentListener)this);
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput == null) {
            return;
        }
        newInput.addDocumentListener((IDocumentListener)this);
    }

    public void applyTextPresentation(TextPresentation textPresentation) {
        if (this.activeRegion == null) {
            return;
        }
        IRegion region = textPresentation.getExtent();
        if (this.activeRegion.getOffset() + this.activeRegion.getLength() >= region.getOffset() && region.getOffset() + region.getLength() > this.activeRegion.getOffset()) {
            textPresentation.mergeStyleRange(new StyleRange(this.activeRegion.getOffset(), this.activeRegion.getLength(), this.color, null));
        }
    }

    public void paintControl(PaintEvent event) {
        if (this.activeRegion == null) {
            return;
        }
        ISourceViewer viewer = this.editor.getViewer();
        if (viewer == null) {
            return;
        }
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int offset = 0;
        int length = 0;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            IRegion widgetRange = extension.modelRange2WidgetRange(this.activeRegion);
            if (widgetRange == null) {
                return;
            }
            offset = widgetRange.getOffset();
            length = widgetRange.getLength();
        } else {
            IRegion region = viewer.getVisibleRegion();
            if (!this.includes(region, this.activeRegion)) {
                return;
            }
            offset = this.activeRegion.getOffset() - region.getOffset();
            length = this.activeRegion.getLength();
        }
        Point minLocation = this.getMinimumLocation(text, offset, length);
        Point maxLocation = this.getMaximumLocation(text, offset, length);
        int x1 = minLocation.x;
        int x2 = minLocation.x + maxLocation.x - minLocation.x - 1;
        int y = minLocation.y + text.getLineHeight() - 1;
        GC gc = event.gc;
        if (this.color != null && !this.color.isDisposed()) {
            gc.setForeground(this.color);
        }
        gc.drawLine(x1, y, x2, y);
    }

    private boolean includes(IRegion region, IRegion position) {
        return position.getOffset() >= region.getOffset() && position.getOffset() + position.getLength() <= region.getOffset() + region.getLength();
    }

    private Point getMinimumLocation(StyledText text, int offset, int length) {
        Point minLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        int i = 0;
        while (i <= length) {
            Point location = text.getLocationAtOffset(offset + i);
            if (location.x < minLocation.x) {
                minLocation.x = location.x;
            }
            if (location.y < minLocation.y) {
                minLocation.y = location.y;
            }
            ++i;
        }
        return minLocation;
    }

    private Point getMaximumLocation(StyledText text, int offset, int length) {
        Point maxLocation = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        int i = 0;
        while (i <= length) {
            Point location = text.getLocationAtOffset(offset + i);
            if (location.x > maxLocation.x) {
                maxLocation.x = location.x;
            }
            if (location.y > maxLocation.y) {
                maxLocation.y = location.y;
            }
            ++i;
        }
        return maxLocation;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

