/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.editors.HTMLEditor;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;

public class HTMLOutlinePage
extends ContentOutlinePage
implements IHTMLOutlinePage {
    private HTMLNode root;
    private HTMLSourceEditor editor;
    private static Pattern regexHead = Pattern.compile("<[hH]([1-6]).*?>(.+?)</[hH]([1-6])>");

    public HTMLOutlinePage(HTMLSourceEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        this.root = new RootNode();
        viewer.setContentProvider((IContentProvider)new HTMLContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new HTMLLabelProvider());
        viewer.setInput((Object)this.root);
        viewer.addSelectionChangedListener((ISelectionChangedListener)new HTMLSelectionChangedListener());
        this.update();
        viewer.expandAll();
    }

    public void update() {
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        Object obj = sel.getFirstElement();
        this.setSelection(null);
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            viewer.getTree().setRedraw(false);
            viewer.refresh();
            viewer.expandAll();
            if (obj != null) {
                this.setSelection((ISelection)new StructuredSelection(obj));
            }
            viewer.getTree().setRedraw(true);
        }
    }

    public void dispose() {
        super.dispose();
    }

    private abstract class HTMLNode {
        HTMLNode() {
        }

        public HTMLNode[] getChildren() {
            return new HTMLNode[0];
        }

        public HTMLNode getParent() {
            return null;
        }
    }

    private class RootNode
    extends HTMLNode {
        public HTMLNode[] getChildren() {
            IFile file = ((FileEditorInput)HTMLOutlinePage.this.editor.getEditorInput()).getFile();
            return new HTMLNode[]{new FileNode(file.getName())};
        }
    }

    private class FileNode
    extends HTMLNode {
        private String fileName;

        public FileNode(String fileName) {
            this.fileName = fileName;
        }

        public HTMLNode[] getChildren() {
            ArrayList<HeadNode> children = new ArrayList<HeadNode>();
            String html = HTMLUtil.comment2space(HTMLOutlinePage.this.editor.getDocumentProvider().getDocument((Object)HTMLOutlinePage.this.editor.getEditorInput()).get(), false);
            Matcher matcher = regexHead.matcher(html);
            while (matcher.find()) {
                children.add(new HeadNode(this, matcher.group(2).trim(), matcher.start()));
            }
            return children.toArray(new HTMLNode[children.size()]);
        }

        public HTMLNode getParent() {
            return null;
        }

        public String toString() {
            return this.fileName;
        }

        public boolean equals(Object obj) {
            return obj instanceof FileNode;
        }
    }

    private class HeadNode
    extends HTMLNode {
        private String text;
        private int offset;
        private FileNode parent;

        public HeadNode(FileNode parent, String text, int offset) {
            this.text = text;
            this.offset = offset;
            this.parent = parent;
        }

        public HTMLNode getParent() {
            return this.parent;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return this.text;
        }

        public boolean equals(Object obj) {
            HeadNode node;
            return obj instanceof HeadNode && ((node = (HeadNode)obj).toString().equals(this.text) || node.getOffset() == this.offset);
        }
    }

    private class HTMLContentProvider
    implements ITreeContentProvider {
        HTMLContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return ((HTMLNode)parentElement).getChildren();
        }

        public Object getParent(Object element) {
            return ((HTMLNode)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class HTMLLabelProvider
    extends LabelProvider {
        HTMLLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof FileNode) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_html");
            }
            if (element instanceof HeadNode) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_tag");
            }
            return null;
        }
    }

    private class HTMLSelectionChangedListener
    implements ISelectionChangedListener {
        private Object prev = null;

        HTMLSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IWorkbenchPage page;
            IEditorPart editorPart;
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            HTMLNode element = (HTMLNode)sel.getFirstElement();
            if (element == null || element instanceof FileNode || element.equals(this.prev)) {
                return;
            }
            int offset = 0;
            if (element instanceof HeadNode) {
                offset = ((HeadNode)element).getOffset();
            }
            if ((editorPart = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).getActiveEditor()) instanceof HTMLEditor) {
                ((HTMLEditor)editorPart).setOffset(offset);
            }
            this.prev = element;
        }
    }
}

