/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jrcs.diff.AddDelta;
import org.apache.commons.jrcs.diff.ChangeDelta;
import org.apache.commons.jrcs.diff.DeleteDelta;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.Revision;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import tk.eclipse.plugin.htmleditor.ColorProvider;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.editors.HTMLConfiguration;
import tk.eclipse.plugin.htmleditor.editors.HTMLDocumentProvider;
import tk.eclipse.plugin.htmleditor.editors.HTMLHyperlinkSupport;
import tk.eclipse.plugin.htmleditor.editors.HTMLOutlinePage;
import tk.eclipse.plugin.htmleditor.editors.HTMLValidator;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;

public class HTMLSourceEditor
extends TextEditor {
    private ColorProvider colorProvider;
    private IHTMLOutlinePage outlinePage;
    private HTMLHyperlinkSupport hyperlink;
    public static final String GROUP_HTML = "_html";
    public static final String ACTION_ESCAPE_HTML = "_escape_html";
    public static final String ACTION_COMMENT = "_comment";
    private ProjectionSupport fProjectionSupport;
    private Pattern tagPattern = Pattern.compile("<([^<]*?)>");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public HTMLSourceEditor(HTMLConfiguration config) {
        config.setEditorPart((IEditorPart)this);
        this.colorProvider = HTMLPlugin.getDefault().getColorProvider();
        this.setSourceViewerConfiguration(config);
        this.setDocumentProvider((IDocumentProvider)new HTMLDocumentProvider());
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), HTMLPlugin.getDefault().getPreferenceStore()}));
        this.setAction(ACTION_ESCAPE_HTML, (IAction)new EscapeHTMLAction());
        this.setAction(ACTION_COMMENT, (IAction)new CommentAction());
        this.outlinePage = this.createOutlinePage();
    }

    protected IHTMLOutlinePage createOutlinePage() {
        return new HTMLOutlinePage(this);
    }

    protected HTMLHyperlinkSupport createHyperlinkSupport() {
        return new HTMLHyperlinkSupport(this);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.fOverviewRuler, true, styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.hyperlink = this.createHyperlinkSupport();
        this.hyperlink.install();
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.install();
        projectionViewer.doOperation(19);
        this.update();
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return super.affectsTextPresentation(event) || this.colorProvider.affectsTextPresentation(event);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        this.colorProvider.handlePreferenceStoreChanged(event);
        this.updateAssistProperties(event);
        super.handlePreferenceStoreChanged(event);
    }

    private void updateAssistProperties(PropertyChangeEvent event) {
        String key = event.getProperty();
        try {
            if (key.equals("_pref_assist_times")) {
                ContentAssistant assistant = (ContentAssistant)this.getSourceViewerConfiguration().getContentAssistant(null);
                assistant.setAutoActivationDelay(Integer.parseInt((String)event.getNewValue()));
            } else if (key.equals("_pref_assist_chars")) {
                ContentAssistant assistant = (ContentAssistant)this.getSourceViewerConfiguration().getContentAssistant(null);
                HTMLAssistProcessor processor = (HTMLAssistProcessor)assistant.getContentAssistProcessor("__dftl_partition_content_type");
                processor.setAutoAssistChars(((String)event.getNewValue()).toCharArray());
            } else if (key.equals("_pref_assist_close")) {
                ContentAssistant assistant = (ContentAssistant)this.getSourceViewerConfiguration().getContentAssistant(null);
                HTMLAssistProcessor processor = (HTMLAssistProcessor)assistant.getContentAssistProcessor("__dftl_partition_content_type");
                processor.setAssistCloseTag((Boolean)event.getNewValue());
            } else if (key.equals("_pref_assist_auto")) {
                ContentAssistant assistant = (ContentAssistant)this.getSourceViewerConfiguration().getContentAssistant(null);
                assistant.enableAutoActivation(((Boolean)event.getNewValue()).booleanValue());
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add((IContributionItem)new Separator(GROUP_HTML));
        this.addAction(menu, GROUP_HTML, ACTION_ESCAPE_HTML);
        this.addAction(menu, GROUP_HTML, ACTION_COMMENT);
    }

    protected void updateSelectionDependentActions() {
        super.updateSelectionDependentActions();
        ITextSelection sel = (ITextSelection)this.getSelectionProvider().getSelection();
        if (sel.getText().equals("")) {
            this.getAction(ACTION_COMMENT).setEnabled(false);
            this.getAction(ACTION_ESCAPE_HTML).setEnabled(false);
        } else {
            this.getAction(ACTION_COMMENT).setEnabled(true);
            this.getAction(ACTION_ESCAPE_HTML).setEnabled(true);
        }
    }

    protected void doValidate() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        IFileEditorInput input = (IFileEditorInput)HTMLSourceEditor.this.getEditorInput();
                        new HTMLValidator(input.getFile()).doValidate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public String getHTMLSource() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
    }

    protected void update() {
        this.updateFolding();
        this.updateAssist();
        this.outlinePage.update();
        if (this.hyperlink != null) {
            this.hyperlink.setProject(((IFileEditorInput)this.getEditorInput()).getFile().getProject());
        }
        this.doValidate();
    }

    protected void updateAssist() {
        String html = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
        HTMLAssistProcessor processor = ((HTMLConfiguration)this.getSourceViewerConfiguration()).getAssistProcessor();
        processor.update((IFileEditorInput)this.getEditorInput(), html);
    }

    public void dispose() {
        this.hyperlink.uninstall();
        this.fProjectionSupport.dispose();
        super.dispose();
    }

    public File getFile() {
        IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
        return file.getLocation().makeAbsolute().toFile();
    }

    public File getTempFile() {
        IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
        return new File(file.getLocation().makeAbsolute().toFile().getParentFile(), "." + file.getName());
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(HTMLPlugin.getDefault().getResourceBundle(), "ContentAssistProposal", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
    }

    public Object getAdapter(Class adapter) {
        Object obj;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.outlinePage;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter) && this.fProjectionSupport != null && (obj = this.fProjectionSupport.getAdapter(this.getSourceViewer(), adapter)) != null) {
            return obj;
        }
        return super.getAdapter(adapter);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.update();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.update();
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.update();
    }

    public void setDiff(String text) {
        IEditorInput input = this.getEditorInput();
        IDocument doc = this.getDocumentProvider().getDocument((Object)input);
        this.getSourceViewer().getTextWidget().setRedraw(false);
        Object[] text1 = doc.get().split("\n");
        Object[] text2 = text.split("\n");
        try {
            Revision rev = Diff.diff((Object[])text1, (Object[])text2);
            int count1 = 0;
            int count2 = 0;
            int index = 0;
            int i = 0;
            while (i < rev.size()) {
                Delta delta = rev.getDelta(i);
                Range orgRange = new Range(delta.getOriginal().rangeString());
                Range revRange = new Range(delta.getRevised().rangeString());
                while (count1 != orgRange.getFrom() - 1) {
                    index = index + ((String)text1[count1]).length() + 1;
                    ++count1;
                }
                count1 = orgRange.getFrom() - 1;
                count2 = revRange.getFrom() - 1;
                if (delta instanceof AddDelta) {
                    while (count2 != revRange.getTo()) {
                        doc.replace(index, 0, String.valueOf(text2[count2]) + "\n");
                        index = index + ((String)text2[count2]).length() + 1;
                        ++count2;
                    }
                } else if (delta instanceof DeleteDelta) {
                    while (count1 != orgRange.getTo()) {
                        doc.replace(index, ((String)text1[count1]).length() + 1, "");
                        ++count1;
                    }
                } else if (delta instanceof ChangeDelta) {
                    while (count1 != orgRange.getTo()) {
                        doc.replace(index, ((String)text1[count1]).length() + 1, "");
                        ++count1;
                    }
                    while (count2 != revRange.getTo()) {
                        doc.replace(index, 0, String.valueOf(text2[count2]) + "\n");
                        index = index + ((String)text2[count2]).length() + 1;
                        ++count2;
                    }
                }
                count1 = orgRange.getTo();
                count2 = revRange.getTo();
                ++i;
            }
        }
        catch (Exception ex) {
            doc.set(text);
        }
        this.getSourceViewer().getTextWidget().setRedraw(true);
    }

    private void updateFolding() {
        try {
            ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
            if (viewer == null) {
                return;
            }
            ProjectionAnnotationModel model = viewer.getProjectionAnnotationModel();
            if (model == null) {
                return;
            }
            ArrayList<FoldingInfo> list = new ArrayList<FoldingInfo>();
            Stack<FoldingInfo> stack = new Stack<FoldingInfo>();
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            String xml = HTMLUtil.scriptlet2space(HTMLUtil.comment2space(doc.get(), true), true);
            Matcher matcher = this.tagPattern.matcher(xml);
            block2: while (matcher.find()) {
                FoldingInfo info;
                String text = matcher.group(1).trim();
                if (text.startsWith("?")) continue;
                if (text.startsWith("!DOCTYPE")) {
                    if (doc.getLineOfOffset(matcher.start()) == doc.getLineOfOffset(matcher.end())) continue;
                    info = new FoldingInfo(matcher.start(), matcher.end(), "!DOCTYPE");
                    info.end += this.countUpReturn(xml, matcher.end());
                    list.add(info);
                    continue;
                }
                if (text.startsWith("%")) {
                    if (doc.getLineOfOffset(matcher.start()) == doc.getLineOfOffset(matcher.end())) continue;
                    info = new FoldingInfo(matcher.start(), matcher.end(), "%");
                    info.end += this.countUpReturn(xml, matcher.end());
                    list.add(info);
                    continue;
                }
                if (text.startsWith("!--")) {
                    if (doc.getLineOfOffset(matcher.start()) == doc.getLineOfOffset(matcher.end())) continue;
                    info = new FoldingInfo(matcher.start(), matcher.end(), "!--");
                    info.end += this.countUpReturn(xml, matcher.end());
                    list.add(info);
                    continue;
                }
                if (text.startsWith("/")) {
                    text = text.substring(1, text.length());
                    while (stack.size() != 0) {
                        info = (FoldingInfo)stack.pop();
                        if (!info.tagName.toLowerCase().equals(text.toLowerCase())) continue;
                        info.end = matcher.end();
                        if (doc.getLineOfOffset(info.start) == doc.getLineOfOffset(info.end)) continue block2;
                        info.end += this.countUpReturn(xml, matcher.end());
                        list.add(info);
                        continue block2;
                    }
                    continue;
                }
                if (text.endsWith("/")) {
                    if (doc.getLineOfOffset(matcher.start()) == doc.getLineOfOffset(matcher.end())) continue;
                    text.substring(0, text.length() - 1);
                    if (text.indexOf(" ") != -1) {
                        text = text.substring(0, text.indexOf(" "));
                    }
                    info = new FoldingInfo(matcher.start(), matcher.end(), text);
                    info.end += this.countUpReturn(xml, matcher.end());
                    list.add(info);
                    continue;
                }
                if (text.indexOf(" ") != -1) {
                    text = text.substring(0, text.indexOf(" "));
                }
                stack.push(new FoldingInfo(matcher.start(), 0, text));
            }
            Iterator ite = model.getAnnotationIterator();
            while (ite.hasNext()) {
                ProjectionAnnotation annotation = (ProjectionAnnotation)ite.next();
                Position pos = model.getPosition((Annotation)annotation);
                boolean remove = true;
                int i = 0;
                while (i < list.size()) {
                    FoldingInfo info = (FoldingInfo)list.get(i);
                    if (info.start == pos.offset && info.end == pos.offset + pos.length) {
                        remove = false;
                        list.remove(info);
                        break;
                    }
                    ++i;
                }
                if (!remove) continue;
                model.removeAnnotation((Annotation)annotation);
            }
            int i = 0;
            while (i < list.size()) {
                FoldingInfo info = (FoldingInfo)list.get(i);
                Position pos = new Position(info.start, info.end - info.start);
                model.addAnnotation((Annotation)new ProjectionAnnotation(), pos);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private int countUpReturn(String text, int pos) {
        char c1;
        int count = 0;
        if (text.length() - 1 > pos && ((c1 = text.charAt(pos)) == '\r' || c1 == '\n')) {
            ++count;
            if (c1 == '\r' && text.length() - 1 > pos + 1 && text.charAt(pos + 1) == '\n') {
                ++count;
            }
        }
        return count;
    }

    private class Range {
        private int from;
        private int to;

        public Range(String rangeString) {
            if (rangeString.indexOf(",") != -1) {
                String[] dim = rangeString.split(",");
                this.from = Integer.parseInt(dim[0]);
                this.to = Integer.parseInt(dim[1]);
            } else {
                this.from = Integer.parseInt(rangeString);
                this.to = Integer.parseInt(rangeString);
            }
        }

        public int getFrom() {
            return this.from;
        }

        public int getTo() {
            return this.to;
        }
    }

    private class FoldingInfo {
        public int start;
        public int end;
        public String tagName;

        public FoldingInfo(int start, int end, String tagName) {
            this.start = start;
            this.end = end;
            this.tagName = tagName;
        }
    }

    private class EscapeHTMLAction
    extends Action {
        public EscapeHTMLAction() {
            super(HTMLPlugin.getResourceString("HTMLEditor.EscapeHTMLAction"));
            this.setEnabled(false);
        }

        public void run() {
            ITextSelection sel = (ITextSelection)HTMLSourceEditor.this.getSelectionProvider().getSelection();
            IDocument doc = HTMLSourceEditor.this.getDocumentProvider().getDocument((Object)HTMLSourceEditor.this.getEditorInput());
            try {
                doc.replace(sel.getOffset(), sel.getLength(), HTMLUtil.escapeHTML(sel.getText()));
            }
            catch (BadLocationException e) {
                HTMLPlugin.logException(e);
            }
        }
    }

    private class CommentAction
    extends Action {
        public CommentAction() {
            super(HTMLPlugin.getResourceString("HTMLEditor.CommentAction"));
            this.setEnabled(false);
        }

        public void run() {
            ITextSelection sel = (ITextSelection)HTMLSourceEditor.this.getSelectionProvider().getSelection();
            IDocument doc = HTMLSourceEditor.this.getDocumentProvider().getDocument((Object)HTMLSourceEditor.this.getEditorInput());
            try {
                doc.replace(sel.getOffset(), sel.getLength(), "<!--" + sel.getText() + "-->");
            }
            catch (BadLocationException e) {
                HTMLPlugin.logException(e);
            }
        }
    }
}

