/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.views;

import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.views.IPaletteItem;
import tk.eclipse.plugin.jspeditor.editors.JSPInfo;
import tk.eclipse.plugin.jspeditor.editors.TLDInfo;

public class JSPTaglibPaletteItem
implements IPaletteItem {
    private ArrayList uri = new ArrayList();
    private String name;
    private ImageDescriptor image;
    private String content;
    private String prefix;

    public JSPTaglibPaletteItem(String name, ImageDescriptor image, String content) {
        this.name = name;
        this.image = image;
        this.content = content;
    }

    public void addUri(String uri) {
        this.uri.add(uri);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void execute(HTMLSourceEditor editor) {
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        String prefix = null;
        JSPInfo info = new JSPInfo(((IFileEditorInput)editor.getEditorInput()).getFile(), doc.get());
        TLDInfo[] tlds = info.getTLDInfo();
        int i = 0;
        while (i < tlds.length) {
            if (this.uri.contains(tlds[i].getTaglibUri())) {
                prefix = tlds[i].getPrefix();
                break;
            }
            ++i;
        }
        if (prefix == null) {
            prefix = this.prefix;
            info.addTaglibDirective(doc, prefix, (String)this.uri.get(0));
        }
        String content = this.content.replaceAll("\\?", prefix);
        int caret = content.length();
        if (content.indexOf("></") != -1) {
            caret = content.indexOf("></") + 1;
        }
        ITextSelection sel = (ITextSelection)editor.getSelectionProvider().getSelection();
        try {
            doc.replace(sel.getOffset(), sel.getLength(), content);
            editor.selectAndReveal(sel.getOffset() + caret, 0);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return this.image;
    }

    public String getLabel() {
        return this.name;
    }
}

