/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import org.eclipse.gef.Tool;
import org.eclipse.gef.internal.ui.palette.editparts.ToolEntryEditPart;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.views.DefaultPaletteItem;
import tk.eclipse.plugin.htmleditor.views.IPaletteContributer;
import tk.eclipse.plugin.htmleditor.views.IPaletteItem;
import tk.eclipse.plugin.htmleditor.views.IPaletteTarget;

public class PaletteView
extends ViewPart {
    private PaletteViewer viewer;
    private TreeMap items = new TreeMap();
    private HashMap tools = new HashMap();

    public PaletteView() {
        this.addPaletteItem("HTML", new DefaultPaletteItem("form", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_form"), "<form action=\"\" method=\"\"></form>"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("text", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_text"), "<input type=\"text\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("textarea", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_textarea"), "<textarea name=\"\" rows=\"\" cols=\"\"></textarea>"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("password", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_pass"), "<input type=\"password\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("radio", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_radio"), "<input type=\"radio\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("checkbox", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_check"), "<input type=\"checkbox\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("button", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_button"), "<input type=\"button\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("submit", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_button"), "<input type=\"submit\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("reset", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_button"), "<input type=\"reset\" value=\"\" />"));
        this.addPaletteItem("JSP", new DefaultPaletteItem("jsp:useBean", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_tag"), "<jsp:useBean id=\"\" class=\"\" scope=\"\" />"));
        this.addPaletteItem("JSP", new DefaultPaletteItem("jsp:include", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_tag"), "<jsp:include />"));
        this.addPaletteItem("JSP", new DefaultPaletteItem("jsp:forward", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_tag"), "<jsp:forward />"));
        String[] groups = HTMLPlugin.getDefault().getPaletteContributerGroups();
        int i = 0;
        while (i < groups.length) {
            IPaletteContributer contributer = HTMLPlugin.getDefault().getPaletteContributer(groups[i]);
            IPaletteItem[] items = contributer.getPaletteItems();
            int j = 0;
            while (j < items.length) {
                this.addPaletteItem(groups[i], items[j]);
                ++j;
            }
            ++i;
        }
    }

    public void createPartControl(Composite parent) {
        this.viewer = new PaletteViewer();
        this.viewer.createControl(parent);
        PaletteRoot root = new PaletteRoot();
        String[] category = this.getCategories();
        int i = 0;
        while (i < category.length) {
            PaletteDrawer group = new PaletteDrawer(category[i]);
            IPaletteItem[] items = this.getPaletteItems(category[i]);
            int j = 0;
            while (j < items.length) {
                HTMLPaletteEntry entry = new HTMLPaletteEntry(items[j].getLabel(), null, items[j].getImageDescriptor());
                this.tools.put(entry, items[j]);
                group.add((PaletteEntry)entry);
                ++j;
            }
            root.add((PaletteEntry)group);
            ++i;
        }
        this.viewer.setPaletteRoot(root);
        this.viewer.addPaletteListener(new PaletteListener(){

            public void activeToolChanged(PaletteViewer palette, ToolEntry tool) {
                ToolEntryEditPart part = (ToolEntryEditPart)palette.getEditPartRegistry().get(tool);
                if (part != null) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorPart editorPart = page.getActiveEditor();
                    if (editorPart != null) {
                        if (editorPart instanceof HTMLSourceEditor) {
                            IPaletteItem item = (IPaletteItem)PaletteView.this.tools.get(tool);
                            item.execute((HTMLSourceEditor)editorPart);
                        } else if (editorPart instanceof IPaletteTarget) {
                            IPaletteItem item = (IPaletteItem)PaletteView.this.tools.get(tool);
                            item.execute(((IPaletteTarget)editorPart).getPaletteTarget());
                        }
                    }
                    part.setToolSelected(false);
                }
            }
        });
        this.viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = page.getActiveEditor();
                if (editorPart != null) {
                    editorPart.setFocus();
                }
            }
        });
    }

    private void addPaletteItem(String category, IPaletteItem item) {
        ArrayList list;
        if (this.items.get(category) == null) {
            list = new ArrayList();
            this.items.put(category, list);
        }
        list = (ArrayList)this.items.get(category);
        list.add(item);
    }

    private IPaletteItem[] getPaletteItems(String category) {
        ArrayList list = (ArrayList)this.items.get(category);
        return list.toArray(new IPaletteItem[list.size()]);
    }

    private String[] getCategories() {
        return this.items.keySet().toArray(new String[0]);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private class HTMLPaletteEntry
    extends ToolEntry {
        public HTMLPaletteEntry(String label, String shortDescription, ImageDescriptor icon) {
            super(label, shortDescription, icon, icon);
        }

        public Tool createTool() {
            return null;
        }
    }
}

