/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class XMLNewWizardPage
extends WizardNewFileCreationPage {
    private String publicID = "";
    private String systemID = "";
    private String documentRoot = "";
    private boolean useDTD = false;

    public XMLNewWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    public void setDTDInfo(boolean useDTD, String publicID, String systemID, String documentRoot) {
        this.useDTD = useDTD;
        this.publicID = publicID;
        this.systemID = systemID;
        this.documentRoot = documentRoot;
    }

    protected InputStream getInitialContents() {
        String charset = null;
        try {
            String projectName = this.getContainerFullPath().segment(0);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            charset = project.getDefaultCharset();
        }
        catch (CoreException projectName) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"");
        if (charset != null) {
            sb.append(" encoding=\"" + charset + "\"");
        }
        sb.append("?>\n");
        if (!(!this.useDTD || this.publicID.equals("") && this.systemID.equals(""))) {
            sb.append("<!DOCTYPE ");
            sb.append(this.documentRoot);
            sb.append(" PUBLIC");
            sb.append(" \"" + this.publicID + "\"");
            sb.append(" \"" + this.systemID + "\"");
            sb.append(">\n");
        }
        if (this.useDTD && !this.documentRoot.equals("")) {
            sb.append("<").append(this.documentRoot).append(">\n");
            sb.append("</").append(this.documentRoot).append(">\n");
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }
}

