/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jspeditor.editors.TLDInfo;

public class JSPInfo {
    int taglibInsertIndex = 0;
    private ArrayList tldInfoList = new ArrayList();
    private Pattern pagePattern = Pattern.compile("<%@\\s*page\\s+(.+?)%>");
    private Pattern taglibPattern = Pattern.compile("<%@\\s*taglib\\s+(.+?)%>");
    private Pattern uriPattern = Pattern.compile("uri\\s*=\\s*\"(.+?)\"");
    private Pattern prefixPattern = Pattern.compile("prefix\\s*=\\s*\"(.+?)\"");
    private Pattern includePattern = Pattern.compile("<%@\\s*include\\s+(.+?)%>");
    private Pattern filePattern = Pattern.compile("file\\s*=\\s*\"(.+?)\"");

    public JSPInfo(IFile file, String source) {
        try {
            HTMLProjectParams params = new HTMLProjectParams(file.getProject());
            String root = params.getRoot();
            IProject basedir = file.getProject();
            if (!root.equals("") && !root.equals("/")) {
                basedir = basedir.getFolder((IPath)new Path(root));
            }
            Matcher matcher = this.includePattern.matcher(source);
            while (matcher.find()) {
                String content = matcher.group(1);
                String fileInc = this.getAttribute(content, this.filePattern);
                this.taglibInsertIndex = this.getInsertIndex(source, matcher.end());
                IFile incJspFile = basedir.getFile((IPath)new Path(fileInc));
                try {
                    String contents = new String(HTMLUtil.readStream(incJspFile.getContents()));
                    JSPInfo info = new JSPInfo(incJspFile, contents);
                    TLDInfo[] tldInfos = info.getTLDInfo();
                    int i = 0;
                    while (i < tldInfos.length) {
                        this.tldInfoList.add(tldInfos[i]);
                        ++i;
                    }
                }
                catch (IOException ioe) {
                    HTMLPlugin.logException(ioe);
                }
                catch (CoreException ce) {
                    HTMLPlugin.logException(ce);
                }
            }
        }
        catch (CoreException ce) {
            HTMLPlugin.logException(ce);
        }
        Matcher matcher = this.pagePattern.matcher(source);
        while (matcher.find()) {
            this.taglibInsertIndex = this.getInsertIndex(source, matcher.end());
        }
        matcher = this.taglibPattern.matcher(source);
        while (matcher.find()) {
            String content = matcher.group(1);
            String uri = this.getAttribute(content, this.uriPattern);
            String prefix = this.getAttribute(content, this.prefixPattern);
            this.taglibInsertIndex = this.getInsertIndex(source, matcher.end());
            TLDInfo info = TLDInfo.getTLDInfo(file, prefix, uri);
            if (info == null) continue;
            this.tldInfoList.add(info);
        }
        try {
            FuzzyXMLDocument doc = new FuzzyXMLParser().parse(HTMLUtil.scriptlet2space(source, false));
            FuzzyXMLElement root = (FuzzyXMLElement)XPath.selectSingleNode((FuzzyXMLElement)doc.getDocumentElement(), (String)"*");
            if (root != null) {
                FuzzyXMLAttribute[] attrs = root.getAttributes();
                int i = 0;
                while (i < attrs.length) {
                    TLDInfo info;
                    String[] dim;
                    if (attrs[i].getName().startsWith("xmlns:") && (dim = attrs[i].getName().split(":")).length > 1 && (info = TLDInfo.getTLDInfo(file, dim[1], attrs[i].getValue())) != null) {
                        this.tldInfoList.add(info);
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private int getInsertIndex(String source, int index) {
        ++index;
        while (source.length() - 1 < index) {
            char c = source.charAt(index + 1);
            if (c != '\r' && c != '\n') break;
            ++index;
        }
        return index;
    }

    private String getAttribute(String source, Pattern pattern) {
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public void addTaglibDirective(IDocument doc, String prefix, String uri) {
        try {
            doc.replace(this.taglibInsertIndex, 0, "<%@ taglib uri=\"" + uri + "\" prefix=\"" + prefix + "\" %>\n");
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public String getTaglibUri(String prefix) {
        String uri = null;
        TLDInfo[] tlds = this.getTLDInfo();
        int i = 0;
        while (i < tlds.length) {
            if (tlds[i].getPrefix().equals(prefix)) {
                uri = tlds[i].getTaglibUri();
                break;
            }
            ++i;
        }
        return uri;
    }

    public TLDInfo[] getTLDInfo() {
        return this.tldInfoList.toArray(new TLDInfo[this.tldInfoList.size()]);
    }
}

