/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.IHyperlinkProvider;
import tk.eclipse.plugin.htmleditor.editors.HTMLConfiguration;
import tk.eclipse.plugin.htmleditor.editors.HTMLHyperlinkSupport;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.jspeditor.editors.JSPHyperlinkProvider;
import tk.eclipse.plugin.jspeditor.editors.JSPValidator;

public class JSPSourceEditor
extends HTMLSourceEditor {
    public JSPSourceEditor(HTMLConfiguration config) {
        super(config);
    }

    protected void doValidate() {
        try {
            String[] natureIds = HTMLPlugin.getDefault().getNoValidationNatureId();
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            int i = 0;
            while (i < natureIds.length) {
                if (file.getProject().hasNature(natureIds[i])) {
                    return;
                }
                ++i;
            }
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        IFileEditorInput input = (IFileEditorInput)JSPSourceEditor.this.getEditorInput();
                        new JSPValidator(input.getFile()).doValidate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    protected HTMLHyperlinkSupport createHyperlinkSupport() {
        HTMLHyperlinkSupport hyperlink = super.createHyperlinkSupport();
        hyperlink.addHyperlinkProvider(new JSPHyperlinkProvider());
        IHyperlinkProvider[] providers = HTMLPlugin.getDefault().getHyperlinkProviders();
        int i = 0;
        while (i < providers.length) {
            hyperlink.addHyperlinkProvider(providers[i]);
            ++i;
        }
        return hyperlink;
    }

    public String getHTMLSource() {
        String source = super.getHTMLSource();
        source = HTMLUtil.scriptlet2space(source, false);
        return source;
    }
}

