/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

public class TLDLoader {
    private static HashMap cache = new HashMap();

    public static InputStream get(File basedir, String uri) throws Exception {
        byte[] bytes;
        if (cache.get(uri) == null) {
            bytes = TLDLoader.getTLDFromWebXML(basedir, uri);
            if (bytes != null) {
                cache.put(uri, bytes);
                return new ByteArrayInputStream(bytes);
            }
            if (uri.startsWith("http://")) {
                bytes = TLDLoader.getTLDFromJars(basedir, uri);
                if (bytes != null) {
                    cache.put(uri, bytes);
                    return new ByteArrayInputStream(bytes);
                }
                URL url = new URL(uri);
                InputStream in = url.openStream();
                cache.put(uri, HTMLUtil.readStream(in));
            } else {
                File file = new File(basedir, uri);
                FileInputStream in = new FileInputStream(file);
                cache.put(uri, HTMLUtil.readStream(in));
            }
        }
        bytes = (byte[])cache.get(uri);
        return new ByteArrayInputStream(bytes);
    }

    private static byte[] getTLDFromWebXML(File basedir, String uri) {
        File webXML = new File(basedir, "/WEB-INF/web.xml");
        if (webXML.exists() && webXML.isFile()) {
            try {
                FuzzyXMLDocument doc = new FuzzyXMLParser().parse((InputStream)new FileInputStream(webXML));
                FuzzyXMLNode[] nodes = XPath.selectNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"/web-app/taglib");
                int i = 0;
                while (i < nodes.length) {
                    FuzzyXMLElement element = (FuzzyXMLElement)nodes[i];
                    String taglibUri = HTMLUtil.getXPathValue(element, "/taglib-uri/child::text()");
                    String taglibLoc = HTMLUtil.getXPathValue(element, "/taglib-location/child::text()");
                    if (uri.equals(taglibUri)) {
                        if (taglibLoc != null && taglibLoc.endsWith(".tld")) {
                            File file = new File(basedir, taglibLoc);
                            return HTMLUtil.readStream(new FileInputStream(file));
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
        return null;
    }

    private static byte[] getTLDFromJars(File basedir, String uri) {
        File lib = new File(basedir, "/WEB-INF/lib");
        if (lib.exists() && lib.isDirectory()) {
            File[] files = lib.listFiles();
            try {
                int i = 0;
                while (i < files.length) {
                    if (files[i].getName().endsWith(".jar")) {
                        JarFile jarFile = new JarFile(files[i]);
                        Enumeration<JarEntry> e = jarFile.entries();
                        while (e.hasMoreElements()) {
                            JarEntry entry = e.nextElement();
                            if (!entry.getName().endsWith(".tld")) continue;
                            byte[] bytes = HTMLUtil.readStream(jarFile.getInputStream(entry));
                            try {
                                FuzzyXMLDocument doc = new FuzzyXMLParser().parse((InputStream)new ByteArrayInputStream(bytes));
                                String nodeURI = HTMLUtil.getXPathValue(doc.getDocumentElement(), "/taglib/uri/child::text()");
                                if (nodeURI == null || !uri.equals(nodeURI)) continue;
                                return bytes;
                            }
                            catch (Exception ex) {
                                HTMLPlugin.logException(ex);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
        return null;
    }
}

