/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.xmleditor.editors.IDTDResolver;

public class DTDResolver
implements EntityResolver {
    private HashMap map = new HashMap();
    private IDTDResolver[] resolvers = null;

    public DTDResolver(IDTDResolver[] resolvers) {
        this.resolvers = resolvers;
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String[] uri = store.getString("_pref_dtd_uri").split("\n");
        String[] path = store.getString("_pref_dtd_path").split("\n");
        int i = 0;
        while (i < uri.length) {
            if (!uri[i].trim().equals("") && !path[i].trim().equals("")) {
                this.map.put(uri[i].trim(), path[i].trim());
            }
            ++i;
        }
    }

    public InputStream getInputStream(String url) {
        File file;
        InputStream in = null;
        int i = 0;
        while (i < this.resolvers.length) {
            in = this.resolvers[i].getInputStream(url);
            if (in != null) {
                return in;
            }
            ++i;
        }
        String path = (String)this.map.get(url);
        if (path != null && (file = new File(path)).exists() && file.isFile()) {
            try {
                return new FileInputStream(file);
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
        try {
            return this.getStreamFromURL(url);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private InputStream getStreamFromURL(String url) {
        String home;
        File cacheDir;
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        if (!store.getBoolean("_pref_dtd_cache")) {
            try {
                return new URL(url).openStream();
            }
            catch (Exception exception) {
                return null;
            }
        }
        String name = url.substring(url.lastIndexOf("/") + 1);
        if (name.indexOf("\\") > 0) {
            name = name.substring(name.lastIndexOf("\\") + 1);
        }
        if (!(cacheDir = new File(home = System.getProperty("user.home"), "tk.eclipse.plugin.htmleditor/dtd")).exists() || !cacheDir.isDirectory()) {
            cacheDir.mkdirs();
        }
        File cacheFile = new File(cacheDir, name);
        try {
            if (cacheFile.exists()) {
                return new FileInputStream(cacheFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            InputStream in = new URL(url).openStream();
            byte[] buf = HTMLUtil.readStream(in);
            FileOutputStream out = new FileOutputStream(cacheFile);
            out.write(buf);
            out.close();
            in.close();
            return new ByteArrayInputStream(buf);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream in;
        if (systemId != null && (in = this.getInputStream(systemId)) != null) {
            return new InputSource(in);
        }
        return null;
    }
}

