/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDEnumeration;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDParser;
import com.wutka.dtd.DTDSequence;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;

public class XMLAssistProcessor
extends HTMLAssistProcessor {
    private List tagList = new ArrayList();
    private TagInfo root = null;

    public void update(IFileEditorInput input, String source) {
    }

    public void updateDTDInfo(Reader in) {
        this.tagList.clear();
        this.root = null;
        try {
            DTDParser parser = new DTDParser(in);
            DTD dtd = parser.parse();
            Object[] obj = dtd.getItems();
            int i = 0;
            while (i < obj.length) {
                if (obj[i] instanceof DTDElement) {
                    DTDElement element = (DTDElement)obj[i];
                    String name = element.getName();
                    DTDItem item = element.getContent();
                    boolean hasBody = true;
                    if (item instanceof DTDEmpty) {
                        hasBody = false;
                    }
                    TagInfo tagInfo = new TagInfo(name, hasBody);
                    Iterator ite = element.attributes.keySet().iterator();
                    if (item instanceof DTDSequence) {
                        DTDSequence seq = (DTDSequence)item;
                        this.setChildTagName(tagInfo, seq.getItem());
                    } else {
                        boolean cfr_ignored_0 = item instanceof DTDMixed;
                    }
                    while (ite.hasNext()) {
                        String attrName = (String)ite.next();
                        DTDAttribute attr = element.getAttribute(attrName);
                        DTDDecl decl = attr.getDecl();
                        boolean required = false;
                        if (decl == DTDDecl.REQUIRED) {
                            required = true;
                        }
                        AttributeInfo attrInfo = new AttributeInfo(attrName, true, 0, required);
                        tagInfo.addAttributeInfo(attrInfo);
                        Object attrType = attr.getType();
                        if (!(attrType instanceof DTDEnumeration)) continue;
                        DTDEnumeration dTDEnumeration = (DTDEnumeration)attrType;
                        String[] items = dTDEnumeration.getItems();
                        int j = 0;
                        while (j < items.length) {
                            attrInfo.addValue(items[j]);
                            ++j;
                        }
                    }
                    this.tagList.add(tagInfo);
                    if (this.root == null) {
                        this.root = tagInfo;
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private void setChildTagName(TagInfo tagInfo, DTDItem[] items) {
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof DTDName) {
                DTDName dtdName = (DTDName)items[i];
                tagInfo.addChildTagName(dtdName.getValue());
            } else if (items[i] instanceof DTDChoice) {
                DTDChoice dtdChoise = (DTDChoice)items[i];
                this.setChildTagName(tagInfo, dtdChoise.getItem());
            }
            ++i;
        }
    }

    protected boolean supportTagRelation() {
        return true;
    }

    protected TagInfo getRootTagInfo() {
        return this.root;
    }

    protected AssistInfo[] getAttributeValues(String tagName, String value, AttributeInfo info) {
        String[] values = info.getValues();
        AssistInfo[] infos = new AssistInfo[values.length];
        int i = 0;
        while (i < infos.length) {
            infos[i] = new AssistInfo(values[i]);
            ++i;
        }
        return infos;
    }

    protected List getTagList() {
        return this.tagList;
    }

    protected TagInfo getTagInfo(String name) {
        int i = 0;
        while (i < this.tagList.size()) {
            TagInfo info = (TagInfo)this.tagList.get(i);
            if (info.getTagName().equals(name)) {
                return info;
            }
            ++i;
        }
        return null;
    }
}

