/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IFileEditorInput;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.editors.HTMLConfiguration;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;
import tk.eclipse.plugin.xmleditor.editors.DTDResolver;
import tk.eclipse.plugin.xmleditor.editors.IDTDResolver;
import tk.eclipse.plugin.xmleditor.editors.XMLAssistProcessor;
import tk.eclipse.plugin.xmleditor.editors.XMLConfiguration;
import tk.eclipse.plugin.xmleditor.editors.XMLOutlinePage;
import tk.eclipse.plugin.xmleditor.editors.XMLValidationHandler;

public class XMLEditor
extends HTMLSourceEditor {
    private boolean validation = true;
    private ArrayList resolvers = new ArrayList();
    private Pattern patternDoctypePublic = Pattern.compile("<!DOCTYPE(.|\r|\n)+?PUBLIC(\\s|\r|\n)*?\"(.+?)\"(\\s|\r|\n)*?\"(.+?)\"");
    private Pattern patternDoctypeSystem = Pattern.compile("<!DOCTYPE(.|\r|\n)+?SYSTEM(\\s|\r|\n)*?\"(.+?)\"");

    public XMLEditor() {
        super(new XMLConfiguration(HTMLPlugin.getDefault().getColorProvider()));
    }

    protected IHTMLOutlinePage createOutlinePage() {
        return new XMLOutlinePage(this);
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    public boolean getValidation() {
        return this.validation;
    }

    public void addDTDResolver(IDTDResolver resolver) {
        this.resolvers.add(resolver);
    }

    public IDTDResolver[] getDTDResolvers() {
        return this.resolvers.toArray(new IDTDResolver[this.resolvers.size()]);
    }

    protected void update() {
        super.update();
        this.doValidate();
    }

    protected void doValidate() {
        if (!this.validation) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        IFileEditorInput input = (IFileEditorInput)XMLEditor.this.getEditorInput();
                        String xml = XMLEditor.this.getDocumentProvider().getDocument((Object)input).get();
                        IFile resource = input.getFile();
                        String charset = resource.getCharset();
                        HTMLProjectParams params = new HTMLProjectParams(resource.getProject());
                        if (!params.getUseDTD()) {
                            Matcher matcher = XMLEditor.this.patternDoctypePublic.matcher(xml);
                            StringBuffer sb = new StringBuffer();
                            if (matcher.find()) {
                                xml = XMLEditor.this.removeMatched(xml, matcher.start(), matcher.end());
                            }
                            if ((matcher = XMLEditor.this.patternDoctypeSystem.matcher(xml)).find()) {
                                xml = XMLEditor.this.removeMatched(xml, matcher.start(), matcher.end());
                            }
                        }
                        SAXParserFactory spfactory = SAXParserFactory.newInstance();
                        spfactory.setValidating(true);
                        if (XMLEditor.this.getDTD(xml) == null) {
                            spfactory.setValidating(false);
                        } else {
                            spfactory.setValidating(true);
                        }
                        SAXParser parser = spfactory.newSAXParser();
                        XMLReader reader = parser.getXMLReader();
                        reader.setEntityResolver(new DTDResolver(XMLEditor.this.getDTDResolvers()));
                        reader.setErrorHandler(new XMLValidationHandler((IResource)resource));
                        reader.parse(new InputSource(new ByteArrayInputStream(xml.getBytes(charset))));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private String removeMatched(String source, int start, int end) {
        StringBuffer sb = new StringBuffer();
        sb.append(source.substring(0, start));
        int i = start;
        while (i < end + 1) {
            char c = source.charAt(i);
            if (c == '\r' || c == '\n') {
                sb.append(c);
            } else {
                sb.append(" ");
            }
            ++i;
        }
        sb.append(source.substring(end + 1, source.length()));
        return sb.toString();
    }

    public String getDTD(String xml) {
        Matcher matcher = this.patternDoctypePublic.matcher(xml);
        if (matcher.find()) {
            return matcher.group(5);
        }
        matcher = this.patternDoctypeSystem.matcher(xml);
        if (matcher.find()) {
            return matcher.group(3);
        }
        return null;
    }

    protected void updateAssist() {
        try {
            IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
            HTMLProjectParams params = new HTMLProjectParams(input.getFile().getProject());
            if (!params.getUseDTD()) {
                return;
            }
            String xml = this.getDocumentProvider().getDocument((Object)input).get();
            String dtd = this.getDTD(xml);
            InputStream in = null;
            if (dtd != null) {
                DTDResolver resolver = new DTDResolver(this.getDTDResolvers());
                in = resolver.getInputStream(dtd);
            }
            if (in != null) {
                InputStreamReader reader = new InputStreamReader(in);
                XMLAssistProcessor assistProcessor = (XMLAssistProcessor)((HTMLConfiguration)this.getSourceViewerConfiguration()).getAssistProcessor();
                assistProcessor.updateDTDInfo(reader);
                ((Reader)reader).close();
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }
}

