/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.struts.editors.models.AbstractEntityModel;
import tk.eclipse.plugin.struts.editors.models.ActionMappingsModel;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.ControllerModel;
import tk.eclipse.plugin.struts.editors.models.DataSourceModel;
import tk.eclipse.plugin.struts.editors.models.DataSourcesModel;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;
import tk.eclipse.plugin.struts.editors.models.FormBeanModel;
import tk.eclipse.plugin.struts.editors.models.FormBeansModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionModel;
import tk.eclipse.plugin.struts.editors.models.GlobalExceptionsModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardModel;
import tk.eclipse.plugin.struts.editors.models.GlobalForwardsModel;
import tk.eclipse.plugin.struts.editors.models.MessageResourcesModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.editors.models.PluginModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;
import tk.eclipse.plugin.struts.properties.FormProperties;
import tk.eclipse.plugin.struts.properties.Properties;

public class StrutsConfigSAXHandler
extends DefaultHandler {
    private RootModel root;
    private Stack stack = new Stack();
    private HashMap pages = new HashMap();
    private HashMap actions = new HashMap();
    private List actionForwards = new ArrayList();
    private List oldModels;
    private IJavaProject project;
    private IResource resource;
    private boolean controller = false;
    private int actionCount = 0;
    private int pageCount = 0;

    public StrutsConfigSAXHandler(IResource resource, List oldModels) {
        this.root = new RootModel();
        this.project = JavaCore.create((IProject)resource.getProject());
        this.resource = resource;
        this.oldModels = oldModels;
    }

    private Object getPrevObject() {
        if (this.stack.size() == 0) {
            return null;
        }
        return this.stack.get(this.stack.size() - 1);
    }

    public void endDocument() throws SAXException {
        int i = 0;
        while (i < this.actionForwards.size()) {
            Object[] obj = (Object[])this.actionForwards.get(i);
            String path = (String)obj[0];
            AbstractConnectionModel model = (AbstractConnectionModel)obj[1];
            AbstractEntityModel target = (AbstractEntityModel)this.actions.get(path);
            if (target != null) {
                model.setTarget(target);
                model.attachTarget();
            }
            ++i;
        }
        if (!this.controller) {
            ControllerModel model = new ControllerModel();
            this.root.addChild(model);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("action")) {
            this.handleAction(attributes);
        } else if (qName.equals("forward")) {
            this.handleForward(attributes);
        } else if (qName.equals("global-forwards")) {
            this.handleGlobalForwards(attributes);
        } else if (qName.equals("form-bean")) {
            this.handleFormBean(attributes);
        } else if (qName.equals("controller")) {
            this.handleController(attributes);
        } else if (qName.equals("message-resources")) {
            this.handleMessageResources(attributes);
        } else if (qName.equals("plug-in")) {
            this.handlePlugin(attributes);
        } else if (qName.equals("set-property")) {
            this.handleSetProperty(attributes);
        } else if (qName.equals("global-exceptions")) {
            this.handleGlobalExceptions(attributes);
        } else if (qName.equals("exception")) {
            this.handleException(attributes);
        } else if (qName.equals("data-source")) {
            this.handleDataSource(attributes);
        } else if (qName.equals("form-property")) {
            this.handleFormProperty(attributes);
        } else if (qName.equals("action-mappings")) {
            this.handleActionMappings(attributes);
        } else if (qName.equals("data-sources")) {
            this.handleDataSources(attributes);
        } else if (qName.equals("form-beans")) {
            this.handleFormBeans(attributes);
        } else if (qName.equals("struts-config")) {
            this.handlerStrutsConfig(attributes);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("action")) {
            this.handleAction(null);
        } else if (qName.equals("forward")) {
            this.handleForward(null);
        } else if (qName.equals("global-forwards")) {
            this.handleGlobalForwards(null);
        } else if (qName.equals("form-bean")) {
            this.handleFormBean(null);
        } else if (qName.equals("controller")) {
            this.handleController(null);
        } else if (qName.equals("message-resources")) {
            this.handleMessageResources(null);
        } else if (qName.equals("plug-in")) {
            this.handlePlugin(null);
        } else if (qName.equals("set-property")) {
            this.handleSetProperty(null);
        } else if (qName.equals("global-exceptions")) {
            this.handleGlobalExceptions(null);
        } else if (qName.equals("exception")) {
            this.handleException(null);
        } else if (qName.equals("data-source")) {
            this.handleDataSource(null);
        } else if (qName.equals("form-property")) {
            this.handleFormProperty(null);
        } else if (qName.equals("action-mappings")) {
            this.handleActionMappings(null);
        } else if (qName.equals("data-sources")) {
            this.handleDataSources(null);
        } else if (qName.equals("form-beans")) {
            this.handleFormBeans(null);
        } else if (qName.equals("struts-config")) {
            this.handlerStrutsConfig(null);
        }
    }

    private Rectangle getConstraint(AbstractEntityModel model) {
        int i = 0;
        while (i < this.oldModels.size()) {
            Object obj = this.oldModels.get(i);
            if (obj.equals(model)) {
                return ((AbstractEntityModel)obj).getConstraint();
            }
            ++i;
        }
        if (model instanceof ActionModel) {
            ++this.actionCount;
            return new Rectangle(100, (this.actionCount - 1) * 64, -1, -1);
        }
        if (model instanceof PageModel) {
            ++this.pageCount;
            return new Rectangle(300, (this.pageCount - 1) * 64, -1, -1);
        }
        return null;
    }

    private List getBendpoints(AbstractConnectionModel model) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < this.oldModels.size()) {
            Object obj = this.oldModels.get(i);
            if (obj instanceof ActionModel) {
                List conns = ((ActionModel)obj).getModelSourceConnections();
                int j = 0;
                while (j < conns.size()) {
                    Object conn = conns.get(j);
                    if (conn.equals(model)) {
                        return ((AbstractConnectionModel)conn).getBendpoints();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private void handlerStrutsConfig(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        String id = attributes.getValue("id");
        if (id != null) {
            this.root.setId(id);
        }
    }

    private void handleFormBeans(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        String id = attributes.getValue("id");
        String type = attributes.getValue("type");
        FormBeansModel model = this.root.getFormBeansModel();
        if (id != null) {
            model.setId(id);
        }
        if (type != null) {
            model.setType(type);
        }
    }

    private void handleDataSources(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        String id = attributes.getValue("id");
        DataSourcesModel model = this.root.getDataSourcesModel();
        if (id != null) {
            model.setId(id);
        }
    }

    private void handleFormProperty(Attributes attributes) {
        if (attributes == null) {
            this.stack.pop();
            return;
        }
        String name = attributes.getValue("name");
        String type = attributes.getValue("type");
        String size = attributes.getValue("size");
        String initial = attributes.getValue("initial");
        String className = attributes.getValue("className");
        if (name == null) {
            name = "";
        }
        if (type == null) {
            type = "";
        }
        if (size == null) {
            size = "";
        }
        if (initial == null) {
            initial = "";
        }
        if (className == null) {
            className = "";
        }
        Object prevObj = this.getPrevObject();
        FormProperties model = ((FormBeanModel)prevObj).getFormProperties();
        model.addProperty(name, type, size, initial, className, new Properties());
        this.stack.push(model);
    }

    private void handleDataSource(Attributes attributes) {
        if (attributes == null) {
            this.stack.pop();
            return;
        }
        String id = attributes.getValue("id");
        String type = attributes.getValue("type");
        String className = attributes.getValue("className");
        String key = attributes.getValue("key");
        DataSourceModel model = new DataSourceModel();
        if (id != null) {
            model.setId(id);
        }
        if (type != null) {
            model.setType(type);
        }
        if (className != null) {
            model.setClassName(className);
        }
        if (key != null) {
            model.setKey(key);
        }
        this.root.addChild(model);
        this.stack.push(model);
    }

    private void handleException(Attributes attributes) {
        if (attributes == null) {
            this.stack.pop();
            return;
        }
        String id = attributes.getValue("id");
        String bundle = attributes.getValue("bundle");
        String type = attributes.getValue("type");
        String path = attributes.getValue("path");
        String key = attributes.getValue("key");
        String className = attributes.getValue("className");
        String handler = attributes.getValue("handler");
        String scope = attributes.getValue("scope");
        Object prevObj = this.getPrevObject();
        if (prevObj instanceof ActionModel) {
            ExceptionModel model = new ExceptionModel();
            if (id != null) {
                model.setId(id);
            }
            if (bundle != null) {
                model.setBundle(bundle);
            }
            if (type != null) {
                model.setType(type);
            }
            if (key != null) {
                model.setKey(key);
            }
            if (className != null) {
                model.setClassName(className);
            }
            if (scope != null) {
                model.setScope(scope);
            }
            if (handler != null) {
                model.setHandler(handler);
            }
            if (path != null) {
                String noquery = Util.getNoQueryPath(path);
                if (noquery.endsWith(".jsp")) {
                    AbstractEntityModel page;
                    if (this.pages.get(path) != null) {
                        page = (AbstractEntityModel)this.pages.get(path);
                        model.setTarget(page);
                        model.attachTarget();
                    } else {
                        page = new PageModel();
                        ((PageModel)page).setPath(path);
                        this.pages.put(path, page);
                        model.setTarget(page);
                        model.attachTarget();
                        page.setConstraint(this.getConstraint(page));
                        this.root.addChild(page);
                    }
                } else if (noquery.endsWith(".do")) {
                    this.actionForwards.add(new Object[]{path, model});
                }
            }
            if (prevObj != null) {
                model.setSource((AbstractEntityModel)prevObj);
                model.attachSource();
                List bendpoints = this.getBendpoints(model);
                if (bendpoints != null) {
                    int i = 0;
                    while (i < bendpoints.size()) {
                        model.addBendpoint(i, (Point)bendpoints.get(i));
                        ++i;
                    }
                }
            }
            this.stack.push(model);
        } else if (prevObj.equals("global-exceptions")) {
            GlobalExceptionModel model = new GlobalExceptionModel();
            if (id != null) {
                model.setId(id);
            }
            if (bundle != null) {
                model.setBundle(bundle);
            }
            if (type != null) {
                model.setType(type);
            }
            if (path != null) {
                model.setPath(path);
            }
            if (key != null) {
                model.setKey(key);
            }
            if (className != null) {
                model.setClassName(className);
            }
            if (scope != null) {
                model.setScope(scope);
            }
            if (handler != null) {
                model.setHandler(handler);
            }
            this.root.addChild(model);
            if (path != null && Util.getNoQueryPath(path).endsWith(".jsp") && this.pages.get(path) == null) {
                PageModel page = new PageModel();
                page.setPath(path);
                this.pages.put(path, page);
                page.setConstraint(this.getConstraint(page));
                this.root.addChild(page);
            }
            this.stack.push(model);
        }
    }

    private void handleSetProperty(Attributes attributes) {
        Object prevObj;
        if (attributes == null) {
            return;
        }
        String id = attributes.getValue("id");
        String property = attributes.getValue("property");
        String value = attributes.getValue("value");
        if (id == null) {
            id = "";
        }
        if (property == null) {
            property = "";
        }
        if (value == null) {
            value = "";
        }
        if ((prevObj = this.getPrevObject()) instanceof PluginModel) {
            ((PluginModel)prevObj).getProperties().addProperty(property, value, id);
        } else if (prevObj instanceof DataSourceModel) {
            ((DataSourceModel)prevObj).getProperties().addProperty(property, value, id);
        } else if (prevObj instanceof ControllerModel) {
            ((ControllerModel)prevObj).getProperties().addProperty(property, value, id);
        } else if (prevObj instanceof MessageResourcesModel) {
            ((MessageResourcesModel)prevObj).getProperties().addProperty(property, value, id);
        } else if (prevObj instanceof ExceptionModel) {
            ((ExceptionModel)prevObj).getProperties().addProperty(property, value, id);
        } else if (prevObj instanceof ActionModel) {
            ((ActionModel)prevObj).getProperties().addProperty(property, value, id);
        } else if (prevObj instanceof ForwardModel) {
            ((ForwardModel)prevObj).getProperties().addProperty(property, value, id);
        } else if (prevObj instanceof GlobalForwardModel) {
            ((GlobalForwardModel)prevObj).getProperties().addProperty(property, value, id);
        } else if (prevObj instanceof GlobalExceptionModel) {
            ((GlobalExceptionModel)prevObj).getProperties().addProperty(property, value, id);
        } else if (prevObj instanceof FormProperties) {
            FormProperties formProps = (FormProperties)prevObj;
            formProps.getProperties(formProps.size() - 1).addProperty(property, value, id);
        }
    }

    private void handlePlugin(Attributes attributes) {
        if (attributes == null) {
            this.stack.pop();
            return;
        }
        PluginModel model = new PluginModel();
        String id = attributes.getValue("id");
        String className = attributes.getValue("className");
        if (id != null) {
            model.setId(id);
        }
        if (className != null) {
            model.setClassName(className);
        }
        this.root.addChild(model);
        this.stack.push(model);
    }

    private void handleMessageResources(Attributes attributes) {
        if (attributes == null) {
            this.stack.pop();
            return;
        }
        MessageResourcesModel model = new MessageResourcesModel();
        String id = attributes.getValue("id");
        String parameter = attributes.getValue("parameter");
        String key = attributes.getValue("key");
        String className = attributes.getValue("className");
        String factory = attributes.getValue("factory");
        String nullVal = attributes.getValue("null");
        if (id != null) {
            model.setId(id);
        }
        if (parameter != null) {
            model.setParameter(parameter);
        }
        if (key != null) {
            model.setKey(key);
        }
        if (className != null) {
            model.setClassName(className);
        }
        if (factory != null) {
            model.setFactory(factory);
        }
        if (nullVal != null) {
            model.setNull(nullVal);
        }
        this.root.addChild(model);
        this.stack.push(model);
    }

    private void handleController(Attributes attributes) {
        if (attributes == null) {
            this.stack.pop();
            return;
        }
        ControllerModel model = new ControllerModel();
        String id = attributes.getValue("id");
        String bufferSize = attributes.getValue("bufferSize");
        String className = attributes.getValue("className");
        String contentType = attributes.getValue("contentType");
        String debug = attributes.getValue("debug");
        String forwardPattern = attributes.getValue("forwardPattern");
        String inputForward = attributes.getValue("inputForward");
        String locale = attributes.getValue("locale");
        String maxFileSize = attributes.getValue("maxFileSize");
        String memFileSize = attributes.getValue("memFileSize");
        String multipartClass = attributes.getValue("multipartClass");
        String nocache = attributes.getValue("nocache");
        String pagePattern = attributes.getValue("pagePattern");
        String processorClass = attributes.getValue("processorClass");
        String tempDir = attributes.getValue("tempDir");
        if (id != null) {
            model.setId(id);
        }
        if (bufferSize != null) {
            model.setBufferSize(bufferSize);
        }
        if (className != null) {
            model.setClassName(className);
        }
        if (contentType != null) {
            model.setContentType(contentType);
        }
        if (debug != null) {
            model.setId(debug);
        }
        if (forwardPattern != null) {
            model.setForwardPattern(forwardPattern);
        }
        if (inputForward != null) {
            model.setInputForward(inputForward);
        }
        if (locale != null) {
            model.setLocale(locale);
        }
        if (maxFileSize != null) {
            model.setMaxFileSize(maxFileSize);
        }
        if (memFileSize != null) {
            model.setId(memFileSize);
        }
        if (multipartClass != null) {
            model.setMultipartClass(multipartClass);
        }
        if (nocache != null) {
            model.setNocache(nocache);
        }
        if (pagePattern != null) {
            model.setPagePattern(pagePattern);
        }
        if (processorClass != null) {
            model.setProcessorClass(processorClass);
        }
        if (tempDir != null) {
            model.setTempDir(tempDir);
        }
        this.root.addChild(model);
        this.controller = true;
        this.stack.push(model);
    }

    private void handleAction(Attributes attributes) {
        if (attributes == null) {
            this.stack.pop();
            return;
        }
        ActionModel model = new ActionModel();
        String id = attributes.getValue("id");
        String className = attributes.getValue("className");
        String forward = attributes.getValue("forward");
        String path = attributes.getValue("path");
        String type = attributes.getValue("type");
        String input = attributes.getValue("input");
        String name = attributes.getValue("name");
        String scope = attributes.getValue("scope");
        String validate = attributes.getValue("validate");
        String parameter = attributes.getValue("parameter");
        String include = attributes.getValue("include");
        String prefix = attributes.getValue("prefix");
        String suffix = attributes.getValue("suffix");
        String attribute = attributes.getValue("attribute");
        String roles = attributes.getValue("roles");
        String unknown = attributes.getValue("unknown");
        if (id != null) {
            model.setId(id);
        }
        if (className != null) {
            model.setClassName(className);
        }
        if (forward != null) {
            model.setForward(forward);
        }
        if (path != null) {
            model.setPath(path);
        }
        if (type != null) {
            model.setType(type);
        }
        if (input != null) {
            model.setInput(input);
        }
        if (name != null) {
            model.setName(name);
        }
        if (scope != null) {
            model.setScope(scope);
        }
        if (validate != null) {
            model.setValidate(validate);
        }
        if (parameter != null) {
            model.setParameter(parameter);
        }
        if (include != null) {
            model.setInclude(include);
        }
        if (prefix != null) {
            model.setPrefix(prefix);
        }
        if (suffix != null) {
            model.setSuffix(suffix);
        }
        if (attribute != null) {
            model.setAttribute(attribute);
        }
        if (roles != null) {
            model.setRoles(roles);
        }
        if (unknown != null) {
            model.setUnknown(unknown);
        }
        model.setConstraint(this.getConstraint(model));
        this.root.addChild(model);
        this.stack.push(model);
        this.actions.put(String.valueOf(path) + ".do", model);
    }

    private void handleForward(Attributes attributes) {
        if (attributes == null) {
            this.stack.pop();
            return;
        }
        String id = attributes.getValue("id");
        String name = attributes.getValue("name");
        String path = attributes.getValue("path");
        String className = attributes.getValue("className");
        String contextRelative = attributes.getValue("contextRelative");
        String redirect = attributes.getValue("redirect");
        Object prevObj = this.getPrevObject();
        if (prevObj.equals("global-forwards")) {
            GlobalForwardModel model = new GlobalForwardModel();
            if (name != null) {
                model.setName(name);
            }
            if (path != null) {
                model.setPath(path);
            }
            if (className != null) {
                model.setClassName(className);
            }
            if (id != null) {
                model.setId(id);
            }
            if (contextRelative != null) {
                model.setContextRelative(contextRelative);
            }
            if (redirect != null) {
                model.setRedirect(redirect);
            }
            this.root.addChild(model);
            if (path != null && !Util.getNoQueryPath(path).endsWith(".do") && this.pages.get(path) == null) {
                PageModel page = new PageModel();
                page.setPath(path);
                this.pages.put(path, page);
                page.setConstraint(this.getConstraint(page));
                this.root.addChild(page);
            }
            this.stack.push(model);
            return;
        }
        ForwardModel model = new ForwardModel();
        if (name != null) {
            model.setName(name);
        }
        if (className != null) {
            model.setClassName(className);
        }
        if (id != null) {
            model.setId(id);
        }
        if (contextRelative != null) {
            model.setContextRelative(contextRelative);
        }
        if (redirect != null) {
            model.setRedirect(redirect);
        }
        if (path != null) {
            String noquery = Util.getNoQueryPath(path);
            if (!noquery.endsWith(".do")) {
                AbstractEntityModel page;
                if (this.pages.get(path) != null) {
                    page = (AbstractEntityModel)this.pages.get(path);
                    model.setTarget(page);
                    model.attachTarget();
                } else {
                    page = new PageModel();
                    ((PageModel)page).setPath(path);
                    this.pages.put(path, page);
                    model.setTarget(page);
                    model.attachTarget();
                    page.setConstraint(this.getConstraint(page));
                    this.root.addChild(page);
                }
            } else if (noquery.endsWith(".do")) {
                this.actionForwards.add(new Object[]{path, model});
            }
        }
        if (prevObj != null) {
            model.setSource((AbstractEntityModel)prevObj);
            model.attachSource();
            List bendpoints = this.getBendpoints(model);
            if (bendpoints != null) {
                int i = 0;
                while (i < bendpoints.size()) {
                    model.addBendpoint(i, (Point)bendpoints.get(i));
                    ++i;
                }
            }
        }
        this.stack.push(model);
    }

    private void handleGlobalForwards(Attributes attributes) {
        if (attributes == null) {
            this.stack.pop();
            return;
        }
        this.stack.push("global-forwards");
        String type = attributes.getValue("type");
        String id = attributes.getValue("id");
        GlobalForwardsModel model = this.root.getGlobalForwardsModel();
        if (type != null) {
            model.setType(type);
        }
        if (id != null) {
            model.setId(id);
        }
    }

    private void handleGlobalExceptions(Attributes attributes) {
        if (attributes == null) {
            this.stack.pop();
            return;
        }
        this.stack.push("global-exceptions");
        String id = attributes.getValue("id");
        GlobalExceptionsModel model = this.root.getGlobalExceptionsModel();
        if (id != null) {
            model.setId(id);
        }
    }

    private void handleActionMappings(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        String type = attributes.getValue("type");
        ActionMappingsModel model = this.root.getActionMappingsModel();
        if (type != null) {
            model.setType(type);
        }
    }

    private void handleFormBean(Attributes attributes) {
        if (attributes == null) {
            this.stack.pop();
            return;
        }
        FormBeanModel model = new FormBeanModel();
        String id = attributes.getValue("id");
        String name = attributes.getValue("name");
        String type = attributes.getValue("type");
        String dynamic = attributes.getValue("dynamic");
        String className = attributes.getValue("className");
        if (id != null) {
            model.setId(id);
        }
        if (name != null) {
            model.setName(name);
        }
        if (type != null) {
            model.setType(type);
        }
        if (dynamic != null) {
            model.setDynamic(dynamic);
        }
        if (className != null) {
            model.setClassName(className);
        }
        this.root.addChild(model);
        this.stack.push(model);
    }

    public RootModel getModel() {
        return this.root;
    }
}

