/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts;

import java.util.ArrayList;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

public class Tiles {
    private IProject project;
    private HTMLProjectParams params;
    private List tilesPages = new ArrayList();

    public Tiles(IProject project) {
        try {
            this.project = project;
            this.params = new HTMLProjectParams(project);
            IFile file = project.getFile(new Path(this.params.getRoot()).append("/WEB-INF/struts-config.xml"));
            if (file.exists()) {
                FuzzyXMLDocument doc = new FuzzyXMLParser().parse(file.getContents());
                this.initializeTiles(doc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initializeTiles(FuzzyXMLDocument doc) {
        FuzzyXMLNode node = XPath.selectSingleNode((FuzzyXMLElement)doc.getDocumentElement(), (String)"/struts-config/plug-in[@className='org.apache.struts.tiles.TilesPlugin']");
        if (node != null) {
            String config = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)node), (String)"/set-property[@property='definitions-config']/@value");
            String[] files = config.split(",");
            int i = 0;
            while (i < files.length) {
                this.parseTilesDefs(files[i].trim());
                ++i;
            }
        }
    }

    private void parseTilesDefs(String fileName) {
        IFile file = this.project.getFile(new Path(this.params.getRoot()).append(fileName));
        if (file.exists()) {
            try {
                FuzzyXMLDocument doc = new FuzzyXMLParser().parse(file.getContents());
                FuzzyXMLNode[] nodes = XPath.selectNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"/tiles-definitions/definition");
                int i = 0;
                while (i < nodes.length) {
                    FuzzyXMLElement element = (FuzzyXMLElement)nodes[i];
                    FuzzyXMLAttribute attr = element.getAttributeNode("name");
                    if (attr != null) {
                        this.tilesPages.add(attr.getValue());
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List getTilesPathList() {
        return this.tilesPages;
    }
}

