/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import tk.eclipse.plugin.struts.StrutsConfigResolver;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.wizards.ActionFormWizard;
import tk.eclipse.plugin.struts.wizards.ActionWizard;
import tk.eclipse.plugin.struts.wizards.JSPWizard;

public class Util {
    public static int getIndex(String[] array, String value) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(value)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static IEditorPart getActiveEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        return editorPart;
    }

    public static List copyList(List from) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < from.size()) {
            list.add(from.get(i));
            ++i;
        }
        return list;
    }

    public static List filtering(List list, Class clazz) {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (clazz.isInstance(obj)) {
                result.add(obj);
            }
            ++i;
        }
        return result;
    }

    public static void openJSPWizard(Object container, String fileName) {
        JSPWizard wizard = new JSPWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(container));
        wizard.setFileName(Util.getNoQueryPath(fileName));
        Shell shell = Display.getCurrent().getActiveShell();
        WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        dialog.open();
    }

    public static void openActionWizard(Object container, String className) {
        ActionWizard wizard = new ActionWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(container));
        wizard.setClassName(className);
        Shell shell = Display.getCurrent().getActiveShell();
        WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        dialog.open();
    }

    public static void openActionFormWizard(Object container, String className) {
        ActionFormWizard wizard = new ActionFormWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(container));
        wizard.setClassName(className);
        Shell shell = Display.getCurrent().getActiveShell();
        WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        dialog.open();
    }

    public static void openErrorDialog(Throwable ex) {
        Object status = null;
        status = ex instanceof CoreException ? ((CoreException)ex).getStatus() : new Status(4, "tk.eclipse.plugin.struts.StrutsPlugin", 0, ex.toString(), ex);
        ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
        Shell shell = Display.getCurrent().getActiveShell();
        ErrorDialog.openError((Shell)shell, (String)resource.getString("errorDialog.caption"), (String)resource.getString("errorDialog.message"), (IStatus)status);
        Util.logException(ex);
    }

    public static void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "tk.eclipse.plugin.struts.StrutsPlugin", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public static void logDebug(String message) {
        ILog log = StrutsPlugin.getDefault().getLog();
        Status status = new Status(1, "tk.eclipse.plugin.struts.StrutsPlugin", 0, message, null);
        log.log((IStatus)status);
    }

    public static void logError(String message) {
        ILog log = StrutsPlugin.getDefault().getLog();
        Status status = new Status(4, "tk.eclipse.plugin.struts.StrutsPlugin", 0, message, null);
        log.log((IStatus)status);
    }

    public static void logException(Throwable ex) {
        ILog log = StrutsPlugin.getDefault().getLog();
        Object status = null;
        status = ex instanceof CoreException ? ((CoreException)ex).getStatus() : new Status(4, "tk.eclipse.plugin.struts.StrutsPlugin", 0, ex.toString(), ex);
        log.log(status);
        ex.printStackTrace();
    }

    public static void openAlertDialog(String message) {
        ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
        MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 1);
        box.setMessage(message);
        box.setText(resource.getString("errorDialog.caption"));
        box.open();
    }

    public static String createMessage(String message, String[] params) {
        int i = 0;
        while (i < params.length) {
            message = message.replaceAll("\\{" + i + "\\}", params[i]);
            ++i;
        }
        return message;
    }

    public static Document createXMLDocument(String xml) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        builder.setEntityResolver(new StrutsConfigResolver());
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        Document doc = builder.parse(in);
        in.close();
        return doc;
    }

    public static Document createXMLDocument(InputStream in) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        builder.setEntityResolver(new StrutsConfigResolver());
        Document doc = builder.parse(in);
        in.close();
        return doc;
    }

    public static String createXMLSource(Document doc) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DocumentType doctype = doc.getDoctype();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "false");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-system", doctype.getSystemId());
        transformer.setOutputProperty("doctype-public", doctype.getPublicId());
        transformer.transform(new DOMSource(doc), new StreamResult(out));
        out.flush();
        String xml = new String(out.toByteArray());
        out.close();
        return xml;
    }

    public static String getNoQueryPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.indexOf("?") != -1) {
            path = path.substring(0, path.indexOf("?"));
        }
        return path;
    }
}

