/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.editors.editparts.AbstractEntityEditPart;
import tk.eclipse.plugin.struts.editors.models.ActionModel;

public class ActionEditPart
extends AbstractEntityEditPart {
    public ActionEditPart(IFile file) {
        super(file);
    }

    protected IFigure createFigure() {
        ActionModel model = (ActionModel)this.getModel();
        String path = model.getPath();
        if (path.equals("")) {
            path = "<action>";
        }
        Label label = new Label();
        label.setText(path);
        if (this.exists(model.getType())) {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_action"));
        } else {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_action_warn"));
        }
        label.setTextPlacement(4);
        return label;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        Label label = (Label)this.getFigure();
        ActionModel model = (ActionModel)this.getModel();
        if (this.exists(model.getType())) {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_action"));
        } else {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_action_warn"));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        ActionModel model;
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        Label label = (Label)this.getFigure();
        if (propName.equals("_path")) {
            String path = (String)evt.getNewValue();
            if (path.equals("")) {
                path = "<action>";
            }
            label.setText(path);
        }
        if (this.exists((model = (ActionModel)this.getModel()).getType())) {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_action"));
        } else {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_action_warn"));
        }
    }

    public boolean exists(String className) {
        try {
            if (className == null || className.equals("")) {
                return false;
            }
            IJavaProject javaProject = JavaCore.create((IProject)this.getFile().getProject());
            IType type = javaProject.findType(className);
            if (type.isClass() && type.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

