/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.tools.ConnectionEndpointTracker;
import org.eclipse.swt.widgets.Display;
import tk.eclipse.plugin.struts.editors.editparts.AbstractStrutsConnectionEditPart;
import tk.eclipse.plugin.struts.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;

public class ExceptionEditPart
extends AbstractStrutsConnectionEditPart {
    public ExceptionEditPart() {
        new ConnectionEndpointTracker((ConnectionEditPart)this);
    }

    protected IFigure createFigure() {
        ExceptionModel model = (ExceptionModel)this.getModel();
        String name = model.getType();
        if (name.equals("")) {
            name = "<exception>";
        }
        LabelConnection connection = new LabelConnection();
        connection.setText(name);
        connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        return connection;
    }

    protected void refreshBendpoints() {
        List bendpoints = ((AbstractConnectionModel)this.getModel()).getBendpoints();
        ArrayList<AbsoluteBendpoint> constraint = new ArrayList<AbsoluteBendpoint>();
        int i = 0;
        while (i < bendpoints.size()) {
            constraint.add(new AbsoluteBendpoint((Point)bendpoints.get(i)));
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(constraint);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        if (propName.equals("__bend_point")) {
            this.refreshBendpoints();
            return;
        }
        if (propName.equals("_type")) {
            String type = (String)evt.getNewValue();
            if (type.equals("")) {
                type = "<exception>";
            }
            LabelConnection connection = (LabelConnection)this.getFigure();
            connection.setText(type);
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        this.refreshBendpoints();
        super.refreshVisuals();
    }

    private class LabelConnection
    extends PolylineConnection {
        private Label label = new Label();

        public LabelConnection() {
            this.add((IFigure)this.label, new ConnectionLocator((Connection)this, 4));
            this.setForegroundColor(Display.getCurrent().getSystemColor(3));
            this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        }

        public void setText(String text) {
            this.label.setText(text);
        }
    }
}

