/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Tiles;
import tk.eclipse.plugin.struts.editors.editparts.AbstractEntityEditPart;
import tk.eclipse.plugin.struts.editors.models.PageModel;

public class PageEditPart
extends AbstractEntityEditPart {
    public PageEditPart(IFile file) {
        super(file);
    }

    protected IFigure createFigure() {
        PageModel model = (PageModel)this.getModel();
        String path = model.getPath();
        if (path.equals("")) {
            path = "<page>";
        }
        Label label = new Label();
        label.setText(path);
        if (this.exists(model.getPath())) {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_webpage"));
        } else {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_webpage_warn"));
        }
        label.setTextPlacement(4);
        return label;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        Label label = (Label)this.getFigure();
        PageModel model = (PageModel)this.getModel();
        if (this.exists(model.getPath())) {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_webpage"));
        } else {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_webpage_warn"));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        PageModel model;
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        Label label = (Label)this.getFigure();
        if (propName.equals("_path")) {
            String path = (String)evt.getNewValue();
            if (path.equals("")) {
                path = "<page>";
            }
            label.setText(path);
        }
        if (this.exists((model = (PageModel)this.getModel()).getPath())) {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_webpage"));
        } else {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_webpage_warn"));
        }
    }

    public boolean exists(String path) {
        try {
            IProject project;
            List tilesPages;
            if (path == null || path.equals("")) {
                return false;
            }
            if (path.indexOf("?") > 0) {
                path = path.substring(0, path.indexOf("?"));
            }
            if ((tilesPages = new Tiles(project = this.getFile().getProject()).getTilesPathList()).contains(path)) {
                return true;
            }
            HTMLProjectParams params = new HTMLProjectParams(project);
            if (project.getFile(new Path(params.getRoot()).append(path)).exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

