/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.properties;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.MultiPageStrutsConfigEditor;

public class ClassSelectPropertyDescriptor
extends PropertyDescriptor {
    public ClassSelectPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        ClassSelectCellEditor editor = new ClassSelectCellEditor(parent);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    private class ClassSelectCellEditor
    extends CellEditor {
        private Composite editor;
        private Button button;
        private Text text;
        private boolean isSelection = false;
        private boolean isDeleteable = false;
        private boolean isSelectable = false;
        private Object value = null;

        protected ClassSelectCellEditor(Composite parent) {
            super(parent, 0);
        }

        protected Control createControl(Composite parent) {
            Font font = parent.getFont();
            Color bg = parent.getBackground();
            this.editor = new Composite(parent, this.getStyle());
            this.editor.setFont(font);
            this.editor.setBackground(bg);
            this.editor.setLayout((Layout)new DialogCellLayout());
            this.text = new Text(this.editor, 0);
            this.text.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ ClassSelectCellEditor this$1;
                {
                    this.this$1 = classSelectCellEditor;
                }

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        ClassSelectCellEditor.access$2(this.this$1);
                    } else if (e.character == '\r') {
                        String newValue = ClassSelectCellEditor.access$1(this.this$1).getText();
                        ClassSelectCellEditor.access$3(this.this$1, newValue);
                    }
                }

                public void keyPressed(KeyEvent e) {
                    ClassSelectCellEditor.access$4(this.this$1);
                    ClassSelectCellEditor.access$5(this.this$1);
                    ClassSelectCellEditor.access$6(this.this$1);
                }
            });
            this.text.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ ClassSelectCellEditor this$1;
                {
                    this.this$1 = classSelectCellEditor;
                }

                public void mouseUp(MouseEvent e) {
                    ClassSelectCellEditor.access$4(this.this$1);
                    ClassSelectCellEditor.access$5(this.this$1);
                    ClassSelectCellEditor.access$6(this.this$1);
                }
            });
            this.text.addFocusListener((FocusListener)new FocusAdapter(this){
                final /* synthetic */ ClassSelectCellEditor this$1;
                {
                    this.this$1 = classSelectCellEditor;
                }

                public void focusLost(FocusEvent e) {
                    String newValue = ClassSelectCellEditor.access$1(this.this$1).getText();
                    ClassSelectCellEditor.access$3(this.this$1, newValue);
                }
            });
            this.text.setFont(parent.getFont());
            this.text.setBackground(parent.getBackground());
            this.button = new Button(this.editor, 1024);
            this.button.setText("...");
            this.button.setFont(font);
            this.button.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ ClassSelectCellEditor this$1;
                {
                    this.this$1 = classSelectCellEditor;
                }

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        ClassSelectCellEditor.access$2(this.this$1);
                    }
                }
            });
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ClassSelectCellEditor this$1;
                {
                    this.this$1 = classSelectCellEditor;
                }

                public void widgetSelected(SelectionEvent event) {
                    Object newValue = this.this$1.openDialogBox((Control)ClassSelectCellEditor.access$7(this.this$1));
                    if (newValue != null) {
                        boolean newValidState = ClassSelectCellEditor.access$8(this.this$1, newValue);
                        ClassSelectCellEditor.access$3(this.this$1, newValue);
                    }
                }
            });
            this.setValueValid(true);
            this.updateContents(this.value);
            return this.editor;
        }

        private void updateValue(Object newValue) {
            if (newValue != null) {
                boolean newValidState = this.isCorrect(newValue);
                if (newValidState) {
                    this.markDirty();
                    this.doSetValue(newValue);
                } else {
                    this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), newValue.toString()));
                }
                this.fireApplyEditorValue();
            }
        }

        protected Object doGetValue() {
            return this.value;
        }

        protected void doSetFocus() {
            this.button.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }

        protected void doSetValue(Object value) {
            this.value = value;
            this.updateContents(value);
        }

        private void checkDeleteable() {
            boolean oldIsDeleteable = this.isDeleteable;
            this.isDeleteable = this.isDeleteEnabled();
            if (oldIsDeleteable != this.isDeleteable) {
                this.fireEnablementChanged("delete");
            }
        }

        private void checkSelectable() {
            boolean oldIsSelectable = this.isSelectable;
            this.isSelectable = this.isSelectAllEnabled();
            if (oldIsSelectable != this.isSelectable) {
                this.fireEnablementChanged("selectall");
            }
        }

        private void checkSelection() {
            boolean oldIsSelection = this.isSelection;
            boolean bl = this.isSelection = this.text.getSelectionCount() > 0;
            if (oldIsSelection != this.isSelection) {
                this.fireEnablementChanged("copy");
                this.fireEnablementChanged("cut");
            }
        }

        public boolean isCopyEnabled() {
            if (this.text == null || this.text.isDisposed()) {
                return false;
            }
            return this.text.getSelectionCount() > 0;
        }

        public boolean isCutEnabled() {
            if (this.text == null || this.text.isDisposed()) {
                return false;
            }
            return this.text.getSelectionCount() > 0;
        }

        public boolean isDeleteEnabled() {
            if (this.text == null || this.text.isDisposed()) {
                return false;
            }
            return this.text.getSelectionCount() > 0 || this.text.getCaretPosition() < this.text.getCharCount();
        }

        public boolean isPasteEnabled() {
            return this.text != null && !this.text.isDisposed();
        }

        public boolean isSaveAllEnabled() {
            return this.text != null && !this.text.isDisposed();
        }

        public boolean isSelectAllEnabled() {
            if (this.text == null || this.text.isDisposed()) {
                return false;
            }
            return this.text.getCharCount() > 0;
        }

        public void performCopy() {
            this.text.copy();
        }

        public void performCut() {
            this.text.cut();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }

        public void performDelete() {
            if (this.text.getSelectionCount() > 0) {
                this.text.insert("");
            } else {
                int pos = this.text.getCaretPosition();
                if (pos < this.text.getCharCount()) {
                    this.text.setSelection(pos, pos + 1);
                    this.text.insert("");
                }
            }
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }

        public void performPaste() {
            this.text.paste();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }

        public void performSelectAll() {
            this.text.selectAll();
            this.checkSelection();
            this.checkDeleteable();
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            try {
                IEditorPart editorPart = Util.getActiveEditor();
                if (editorPart != null && editorPart instanceof MultiPageStrutsConfigEditor) {
                    IFileEditorInput input = (IFileEditorInput)editorPart.getEditorInput();
                    IJavaProject project = JavaCore.create((IProject)input.getFile().getProject());
                    Shell shell = this.getControl().getShell();
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}), (int)2, (boolean)false);
                    if (dialog.open() == 0) {
                        Object[] result = dialog.getResult();
                        return ((IType)result[0]).getFullyQualifiedName();
                    }
                }
            }
            catch (Exception ex) {
                Util.logException(ex);
            }
            return null;
        }

        protected void updateContents(Object value) {
            if (this.text == null) {
                return;
            }
            String text = "";
            if (value != null) {
                text = value.toString();
            }
            this.text.setText(text);
        }

        static /* synthetic */ void access$2(ClassSelectCellEditor classSelectCellEditor) {
            classSelectCellEditor.fireCancelEditor();
        }

        static /* synthetic */ void access$3(ClassSelectCellEditor classSelectCellEditor, Object object) {
            classSelectCellEditor.updateValue(object);
        }

        static /* synthetic */ void access$4(ClassSelectCellEditor classSelectCellEditor) {
            classSelectCellEditor.checkSelection();
        }

        static /* synthetic */ void access$5(ClassSelectCellEditor classSelectCellEditor) {
            classSelectCellEditor.checkDeleteable();
        }

        static /* synthetic */ void access$6(ClassSelectCellEditor classSelectCellEditor) {
            classSelectCellEditor.checkSelectable();
        }

        static /* synthetic */ Composite access$7(ClassSelectCellEditor classSelectCellEditor) {
            return classSelectCellEditor.editor;
        }

        static /* synthetic */ boolean access$8(ClassSelectCellEditor classSelectCellEditor, Object object) {
            return classSelectCellEditor.isCorrect(object);
        }

        private class DialogCellLayout
        extends Layout {
            DialogCellLayout() {
            }

            public void layout(Composite editor, boolean force) {
                Rectangle bounds = editor.getClientArea();
                Point size = ClassSelectCellEditor.this.button.computeSize(-1, -1, force);
                if (ClassSelectCellEditor.this.text != null) {
                    ClassSelectCellEditor.this.text.setBounds(0, 0, bounds.width - size.x, bounds.height);
                }
                ClassSelectCellEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
            }

            public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
                if (wHint != -1 && hHint != -1) {
                    return new Point(wHint, hHint);
                }
                Point contentsSize = ClassSelectCellEditor.this.text.computeSize(-1, -1, force);
                Point buttonSize = ClassSelectCellEditor.this.button.computeSize(-1, -1, force);
                Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
                return result;
            }
        }
    }
}

